<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Commercial Vehicle Checklists</title>
    <style>
        /* General body styling for better typography */
        body {
            font-family: Arial, sans-serif;
            margin: 20px;
            background-color: #f4f4f9;
            color: #333;
        }

        /* Main container for the checklists */
        .checklist-container {
            max-width: 1000px;
            margin: auto;
            background: #fff;
            padding: 20px 30px 30px 30px;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
            border-radius: 8px;
        }
        
        /* Title styling */
        h2 {
            text-align: center;
            color: #444;
            font-size: 1.5em;
            margin-bottom: 20px;
            text-transform: uppercase;
        }

        /* Subtitle styling */
        .subtitle {
            text-align: center;
            margin-top: -15px;
            margin-bottom: 25px;
            color: #666;
        }
        
        /* Horizontal rule for separating tables */
        hr {
            border: none;
            height: 1px;
            background-color: #e0e0e0;
            margin: 40px 0;
        }

        /* Table styling */
        .checklist-table {
            width: 100%;
            border-collapse: collapse;
            font-size: 14px;
        }

        /* Table header and cell styling */
        .checklist-table th,
        .checklist-table td {
            border: 1px solid #ddd;
            padding: 12px;
            text-align: left;
            vertical-align: middle; /* Important for rowspan cells */
        }

        /* Table header specific styles */
        .checklist-table thead th {
            background-color: #f2f2f2;
            font-weight: bold;
            text-align: center;
        }

        /* Style for the first column (Category) */
        .checklist-table td:first-child {
            font-weight: bold;
            background-color: #fafafa;
        }
        
        /* Centering the Pass/Fail columns for alignment */
        .pass-fail-col {
            width: 60px;
            text-align: center;
        }

        /* --- Tick Box Styling --- */

        /* The container for our custom checkbox */
        .tick-box {
            display: inline-block;
            width: 22px;
            height: 22px;
            border: 2px solid #ccc;
            border-radius: 4px;
            cursor: pointer;
            position: relative;
            transition: border-color 0.2s;
        }
        
        /* Change border color on hover for better UX */
        .tick-box:hover {
            border-color: #5cb85c;
        }

        /* The checkmark itself, created using a pseudo-element */
        .tick-box.ticked::after {
            content: '';
            position: absolute;
            left: 6px;
            top: 2px;
            width: 6px;
            height: 12px;
            border: solid #5cb85c; /* Green color for the tick */
            border-width: 0 3px 3px 0;
            transform: rotate(45deg); /* Rotates the shape into a checkmark */
        }
        
        /* Change the box border when ticked */
        .tick-box.ticked {
            border-color: #5cb85c;
        }

    </style>
</head>
<body>

<div class="checklist-container">
    <h2>Daily Pre-operation Checklist for Commercial Vehicles</h2>
    <p class="subtitle">Visual Inspection (Before Starting the Engine)</p>

    <table class="checklist-table">
        <thead>
            <tr>
                <th>Category</th>
                <th>Check Item</th>
                <th>Recommended Status / Standard</th>
                <th class="pass-fail-col">Pass</th>
                <th class="pass-fail-col">Fail</th>
            </tr>
        </thead>
        <tbody>
            <tr>
                <td rowspan="3">Documentation</td>
                <td>Driver's license, PT license</td>
                <td>available and valid</td>
                <td class="pass-fail-col"><span class="tick-box"></span></td>
                <td class="pass-fail-col"><span class="tick-box"></span></td>
            </tr>
            <tr>
                <td>Vehicle permit, revenue license, insurance, roadworthiness certificate</td>
                <td>available and valid, not expired</td>
                <td class="pass-fail-col"><span class="tick-box"></span></td>
                <td class="pass-fail-col"><span class="tick-box"></span></td>
            </tr>
            <tr>
                <td>Previous day's report of defects</td>
                <td>All critical issues rectified</td>
                <td class="pass-fail-col"><span class="tick-box"></span></td>
                <td class="pass-fail-col"><span class="tick-box"></span></td>
            </tr>
            <tr><td rowspan="4">Exterior condition</td><td>Visible body damage, loose components (footboard, guard rail etc.)</td><td>Clean and proper</td><td class="pass-fail-col"><span class="tick-box"></span></td><td class="pass-fail-col"><span class="tick-box"></span></td></tr>
            <tr><td>Leaks (engine oil, Transmission, differential oil, hub grease / oil, hydraulic / air suspension, shocks)</td><td>No</td><td class="pass-fail-col"><span class="tick-box"></span></td><td class="pass-fail-col"><span class="tick-box"></span></td></tr>
            <tr><td>Side mirrors</td><td>No cracks, properly adjusted</td><td class="pass-fail-col"><span class="tick-box"></span></td><td class="pass-fail-col"><span class="tick-box"></span></td></tr>
            <tr><td>Windows, windscreen, and wipers</td><td>In good condition without streaking or rubber cracks</td><td class="pass-fail-col"><span class="tick-box"></span></td><td class="pass-fail-col"><span class="tick-box"></span></td></tr>
            <tr><td rowspan="5">Tires & Wheels</td><td>Aftermarket Modifications</td><td>No / as per authorization</td><td class="pass-fail-col"><span class="tick-box"></span></td><td class="pass-fail-col"><span class="tick-box"></span></td></tr>
            <tr><td>Tire pressure</td><td>As per value of tire manufacturer</td><td class="pass-fail-col"><span class="tick-box"></span></td><td class="pass-fail-col"><span class="tick-box"></span></td></tr>
            <tr><td>Tread depth</td><td>Uneven worn out / not below TWI - Tread wear indicator</td><td class="pass-fail-col"><span class="tick-box"></span></td><td class="pass-fail-col"><span class="tick-box"></span></td></tr>
            <tr><td>Sidewalls</td><td>No cuts, bulges, exposed cords</td><td class="pass-fail-col"><span class="tick-box"></span></td><td class="pass-fail-col"><span class="tick-box"></span></td></tr>
            <tr><td>Wheel nuts</td><td>All fixed, tight, no rust streaks</td><td class="pass-fail-col"><span class="tick-box"></span></td><td class="pass-fail-col"><span class="tick-box"></span></td></tr>
            <tr><td rowspan="4">Interior condition</td><td>Passenger Seats</td><td>Clean, Secure, no sharp edges</td><td class="pass-fail-col"><span class="tick-box"></span></td><td class="pass-fail-col"><span class="tick-box"></span></td></tr>
            <tr><td>Driver Seats</td><td>Freely Adjustable</td><td class="pass-fail-col"><span class="tick-box"></span></td><td class="pass-fail-col"><span class="tick-box"></span></td></tr>
            <tr><td>HVAC/ Ventilation (if applicable)</td><td>when unloaded temp < 20°C at seat level</td><td class="pass-fail-col"><span class="tick-box"></span></td><td class="pass-fail-col"><span class="tick-box"></span></td></tr>
            <tr><td>Handrails, grab bars, floor board</td><td>Clean, no trip hazards</td><td class="pass-fail-col"><span class="tick-box"></span></td><td class="pass-fail-col"><span class="tick-box"></span></td></tr>
            <tr><td rowspan="6">Safety</td><td>Fire extinguisher</td><td>Charged, gauge in green zone, valid expiry, accessible</td><td class="pass-fail-col"><span class="tick-box"></span></td><td class="pass-fail-col"><span class="tick-box"></span></td></tr>
            <tr><td>Aftermarket Modifications</td><td>No / as per authorization</td><td class="pass-fail-col"><span class="tick-box"></span></td><td class="pass-fail-col"><span class="tick-box"></span></td></tr>
            <tr><td>Emergency exits/ Emergency hammers (if fitted)</td><td>Operation condition / availability</td><td class="pass-fail-col"><span class="tick-box"></span></td><td class="pass-fail-col"><span class="tick-box"></span></td></tr>
            <tr><td>Safety belts</td><td>No frays, buckle locks</td><td class="pass-fail-col"><span class="tick-box"></span></td><td class="pass-fail-col"><span class="tick-box"></span></td></tr>
            <tr><td>Function of wheelchair lift / ramp (if fitted)</td><td>Smooth operation, no jerks</td><td class="pass-fail-col"><span class="tick-box"></span></td><td class="pass-fail-col"><span class="tick-box"></span></td></tr>
            <tr><td>Clear gangways and exit routes</td><td>No obstruction</td><td class="pass-fail-col"><span class="tick-box"></span></td><td class="pass-fail-col"><span class="tick-box"></span></td></tr>
        </tbody>
    </table>
    
    <hr>

    <h2>Test Run Inspection</h2>
    <p class="subtitle">Engine On & During Short Drive</p>

    <table class="checklist-table">
        <thead>
            <tr>
                <th>Category</th>
                <th>Check Item</th>
                <th>Recommended status / Standard</th>
                <th class="pass-fail-col">Pass</th>
                <th class="pass-fail-col">Fail</th>
            </tr>
        </thead>
        <tbody>
            <tr>
                <td rowspan="2">Driver's Control</td>
                <td>Driver seat adjustment</td>
                <td>Freely adjustable</td>
                <td class="pass-fail-col"><span class="tick-box"></span></td>
                <td class="pass-fail-col"><span class="tick-box"></span></td>
            </tr>
            <tr>
                <td>Dashboard warning indicators</td>
                <td>No active warning lights</td>
                <td class="pass-fail-col"><span class="tick-box"></span></td>
                <td class="pass-fail-col"><span class="tick-box"></span></td>
            </tr>
            <tr>
                <td rowspan="4">Steering & Suspension</td>
                <td>Steering free play</td>
                <td>Within limit</td>
                <td class="pass-fail-col"><span class="tick-box"></span></td>
                <td class="pass-fail-col"><span class="tick-box"></span></td>
            </tr>
            <tr>
                <td>Power steering function at rest</td>
                <td>Smooth / no unusual noise</td>
                <td class="pass-fail-col"><span class="tick-box"></span></td>
                <td class="pass-fail-col"><span class="tick-box"></span></td>
            </tr>
            <tr>
                <td>Steering at low speed</td>
                <td>Smooth response</td>
                <td class="pass-fail-col"><span class="tick-box"></span></td>
                <td class="pass-fail-col"><span class="tick-box"></span></td>
            </tr>
            <tr>
                <td>Suspension springs, air balloons, Shock absorbers</td>
                <td>Stable, no sagging, no bouncing</td>
                <td class="pass-fail-col"><span class="tick-box"></span></td>
                <td class="pass-fail-col"><span class="tick-box"></span></td>
            </tr>
            <tr>
                <td rowspan="4">Brakes</td>
                <td>Service (pedal) brake</td>
                <td>Pedal firm, no excessive free play</td>
                <td class="pass-fail-col"><span class="tick-box"></span></td>
                <td class="pass-fail-col"><span class="tick-box"></span></td>
            </tr>
            <tr>
                <td>Parking brake</td>
                <td>Holds on slope</td>
                <td class="pass-fail-col"><span class="tick-box"></span></td>
                <td class="pass-fail-col"><span class="tick-box"></span></td>
            </tr>
            <tr>
                <td>Fail-safe / exhaust brake</td>
                <td>Working properly</td>
                <td class="pass-fail-col"><span class="tick-box"></span></td>
                <td class="pass-fail-col"><span class="tick-box"></span></td>
            </tr>
            <tr>
                <td>Air brake system</td>
                <td>Gauge in safe range, acceptable cutoff time</td>
                <td class="pass-fail-col"><span class="tick-box"></span></td>
                <td class="pass-fail-col"><span class="tick-box"></span></td>
            </tr>
            <tr>
                <td>Transmission</td>
                <td>Clutch, gearshift</td>
                <td>Smooth, no grinding</td>
                <td class="pass-fail-col"><span class="tick-box"></span></td>
                <td class="pass-fail-col"><span class="tick-box"></span></td>
            </tr>
            <tr>
                <td>Smoke</td>
                <td>Exhaust smoke or unusual noise</td>
                <td>No excessive smoke in snap acceleration</td>
                <td class="pass-fail-col"><span class="tick-box"></span></td>
                <td class="pass-fail-col"><span class="tick-box"></span></td>
            </tr>
            <tr>
                <td rowspan="5">Lights & Electrical Systems</td>
                <td>Battery and starter motor</td>
                <td>working condition in crank starting</td>
                <td class="pass-fail-col"><span class="tick-box"></span></td>
                <td class="pass-fail-col"><span class="tick-box"></span></td>
            </tr>
            <tr>
                <td>Headlamps (low, high beam)</td>
                <td>Illuminating</td>
                <td class="pass-fail-col"><span class="tick-box"></span></td>
                <td class="pass-fail-col"><span class="tick-box"></span></td>
            </tr>
            <tr>
                <td>Brake lights, tail lights, Turn Indicators, hazard lights, Reverse lights, warning buzzer</td>
                <td>Illuminating</td>
                <td class="pass-fail-col"><span class="tick-box"></span></td>
                <td class="pass-fail-col"><span class="tick-box"></span></td>
            </tr>
            <tr>
                <td>Horn, Reverse buzzer</td>
                <td>Functioning and single tone</td>
                <td class="pass-fail-col"><span class="tick-box"></span></td>
                <td class="pass-fail-col"><span class="tick-box"></span></td>
            </tr>
            <tr>
                <td>Interior cabin and step lights functioning</td>
                <td>Illuminating</td>
                <td class="pass-fail-col"><span class="tick-box"></span></td>
                <td class="pass-fail-col"><span class="tick-box"></span></td>
            </tr>
        </tbody>
    </table>

</div>

<script>
    // Get all the tick boxes from the document
    const tickBoxes = document.querySelectorAll('.tick-box');

    // Add a click event listener to each tick box
    tickBoxes.forEach(box => {
        box.addEventListener('click', function() {
            // Find the parent table row (tr) of the clicked box
            const parentRow = this.closest('tr');
            
            // Find all tick boxes within that same row
            const boxesInRow = parentRow.querySelectorAll('.tick-box');
            
            // Remove the 'ticked' class from all boxes in the row first
            // This ensures only one box (Pass or Fail) can be ticked at a time
            boxesInRow.forEach(b => b.classList.remove('ticked'));
            
            // Add the 'ticked' class only to the box that was clicked
            this.classList.add('ticked');
        });
    });
</script>

</body>
</html>