<?php

// --- 1. Database Connection Details ---
// මෙම තොරතුරු ඔබගේ database එකට ගැලපෙන පරිදි වෙනස් කරන්න
$db_host = 'localhost:4306';        // ඔබගේ host එක
$db_name = 'mmc';                   // ඔබගේ database නම
$db_user = 'root';                  // ඔබගේ database username
$db_pass = '';                      // ඔබගේ database password

// --- 2. ඇතුළත් කළ යුතු User ගේ තොරතුරු ---
$username = 'admin@gmail.com';
$plainPassword = 'Admin@#1'; // සාමාන්‍ය text ලෙස password එක
$user_role = 'admin';        // User ගේ role එක ('admin', 'operator', 'manager')

// --- 3. Password එක ආරක්ෂිතව Hash කිරීම ---
// මෙමගින් password එක encrypt කර, ආරක්ෂිත hash එකක් බවට පත් කරයි
$hashedPassword = password_hash($plainPassword, PASSWORD_DEFAULT);


// --- 4. Database එකට සම්බන්ධ වී User ව ඇතුළත් කිරීම ---
try {
    // PDO භාවිතයෙන් database සම්බන්ධතාවය සාදාගැනීම
    $pdo = new PDO("mysql:host=$db_host;dbname=$db_name;charset=utf8mb4", $db_user, $db_pass);
    
    // Error පෙන්වීම සඳහා PDO attribute එක set කිරීම
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    // SQL Injection වලින් ආරක්ෂා වීමට Prepared Statement එක සකස් කිරීම
    // අපගේ users table එකේ තීරු වලට ගැලපෙන පරිදි query එක වෙනස් කර ඇත
    $sql = "INSERT INTO users (username, password_hash, user_role) VALUES (?, ?, ?)";
    $stmt = $pdo->prepare($sql);
    
    // Statement එක execute කිරීම
    // අපි database එකට යවන්නේ hash කළ password එකයි
    $stmt->execute([$username, $hashedPassword, $user_role]);

    echo "✅ පරිශීලකයා සාර්ථකව ඇතුළත් කරන ලදී! (Admin user created successfully!)";

} catch (PDOException $e) {
    // ඇතිවිය හැකි error හැසිරවීම
    if ($e->errorInfo[1] == 1062) { // 1062 යනු MySQL හි duplicate entry error code එකයි
        die("❌ දෝෂයකි: මෙම username එක දැනටමත් පවතී. (Error: User with that username already exists.)");
    } else {
        die("❌ Database දෝෂයකි: " . $e->getMessage());
    }
}

?>