<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Submission Successful</title>
    
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;600;700&display=swap" rel="stylesheet">

    <style>
        /* --- Root Variables --- */
        :root {
            --brand-yellow: #f7b731;
            --primary-blue: #007BFF;
            --primary-blue-dark: #0056b3;
            --text-color-dark: #333;
            --text-color-light: #888;
            --white: #ffffff;
            --card-bg: rgba(253, 253, 253, 0.95);
            --card-shadow: 0 15px 35px rgba(0, 0, 0, 0.15);
            --footer-bg: #232B38;
            --footer-text: #B0B0B0;
        }

        /* --- Global Reset & Body Styles --- */
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Poppins', sans-serif;
            color: var(--text-color-dark);
            min-height: 100vh;
            display: flex;
            flex-direction: column;
            
            /* --- Background Image Setup --- */
            background: linear-gradient(rgba(35, 43, 56, 0.4), rgba(35, 43, 56, 0.4)), url('images/slider01.png') no-repeat center center;
            background-size: cover;
            background-attachment: fixed;
        }

        /* --- Main Card Container --- */
        .card-container {
            flex-grow: 1;
            display: flex;
            justify-content: center;
            align-items: center;
            padding: 20px;
        }

        .success-card {
            position: relative;
            background-color: var(--card-bg);
            width: 100%;
            max-width: 500px;
            padding: 80px 40px 50px 40px;
            border-radius: 25px;
            box-shadow: var(--card-shadow);
            text-align: center;
        }

        /* --- Icon Styling --- */
        .icon-circle {
            position: absolute;
            top: -50px;
            left: 50%;
            transform: translateX(-50%);
            width: 100px;
            height: 100px;
            background-color: var(--brand-yellow);
            border-radius: 50%;
            box-shadow: 0 5px 15px rgba(247, 183, 49, 0.4);
            display: flex;
            justify-content: center;
            align-items: center;
        }

        .icon-circle svg {
            stroke: var(--white);
        }

        /* --- Text Styling --- */
        .success-card h1 {
            font-size: 1.8rem;
            font-weight: 700;
            margin-bottom: 10px;
            color: var(--text-color-dark);
        }

        .success-card p {
            font-size: 1rem;
            color: var(--text-color-light);
        }

        /* --- NEW: Home Button Styling --- */
        .home-button {
            display: inline-block; /* Allows for margin and padding */
            margin-top: 30px; /* Space above the button */
            padding: 12px 30px;
            background-color: var(--primary-blue);
            color: var(--white);
            font-weight: 600;
            text-decoration: none;
            border-radius: 8px;
            transition: background-color 0.3s, transform 0.2s;
        }

        .home-button:hover {
            background-color: var(--primary-blue-dark);
            transform: translateY(-2px);
        }

        /* --- Footer --- */
        .footer {
            width: 100%;
            background-color: var(--footer-bg);
            color: var(--footer-text);
            text-align: center;
            padding: 15px 0;
            font-size: 0.85rem;
        }

        /* --- Responsive Adjustments --- */
        @media (max-width: 600px) {
            .success-card {
                padding: 70px 25px 40px 25px;
            }

            .icon-circle {
                width: 80px;
                height: 80px;
                top: -40px;
            }
            
            .icon-circle svg {
                width: 36px;
                height: 36px;
            }

            .success-card h1 {
                font-size: 1.5rem;
            }
            
            .success-card p {
                font-size: 0.9rem;
            }
        }
    </style>
</head>
<body>

    <main class="card-container">
        <div class="success-card">
            <div class="icon-circle">
                <svg xmlns="http://www.w3.org/2000/svg" width="48" height="48" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="4" stroke-linecap="round" stroke-linejoin="round">
                    <polyline points="20 6 9 17 4 12"></polyline>
                </svg>
            </div>

            <h1>Successfully Submitted</h1>
            <p>Thank you for sharing your Details</p>

            <a href="entry.php" class="home-button">Go to Home</a>
        </div>
    </main>

    <footer class="footer">
        <p>COPYRIGHT © 2025 SLTDIGITAL</p>
    </footer>

</body>
</html>