<?php
session_start();
// db.php ෆයිල් එක මෙතනට require කරගන්න.
// login.php සහ db.php එකම ෆෝල්ඩරයේ ඇති බවට වග බලා ගන්න.
require_once __DIR__ . '/db.php';

$loginError = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Form එකෙන් එවන 'username' එක ලබාගැනීම
    $username = isset($_POST['username']) ? trim($_POST['username']) : '';
    $password = isset($_POST['password']) ? $_POST['password'] : '';

    if ($username !== '' && $password !== '') {
        try {
            $pdo = getPDO();

            // Database එකෙන් username එකට අදාළ user ව සෙවීම
            // තීරු නම් (user_id, password_hash) නිවැරදි කර ඇත
            $stmt = $pdo->prepare('SELECT user_id, username, password_hash FROM users WHERE username = ? LIMIT 1');
            $stmt->execute([$username]);
            $user = $stmt->fetch();

            // User සිටී නම් සහ password එක නිවැරදි නම්
            // password_verify() මගින් hash එක සමඟ සසඳනු ලැබේ
            if ($user && password_verify($password, $user['password_hash'])) {
                
                // Session වලට user ගේ තොරතුරු ඇතුළත් කිරීම
                // තීරු නම 'user_id' ලෙස නිවැරදි කර ඇත
                $_SESSION['user_id'] = $user['user_id'];
                $_SESSION['username'] = $user['username'];
                
                // සාර්ථකව login වූ පසු entry.php පිටුවට යොමු කිරීම
                header('Location: entry.php');
                exit;
            } else {
                // Username හෝ password වැරදි නම් පණිවිඩය පෙන්වීම
                $loginError = 'Invalid username or password.';
            }
        } catch (Throwable $e) {
            // Database සම්බන්ධතා දෝෂයක් ඇති වුවහොත්
            // error_log($e->getMessage()); // error එක log කිරීම වඩාත් සුදුසුය
            $loginError = 'Database connection error.';
        }
    } else {
        // Username සහ password ඇතුළත් කර නොමැති නම්
        $loginError = 'Please enter username and password.';
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>MMC Kottawa - Login</title>
    
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;500;600&display=swap" rel="stylesheet">

    <!-- Favicon -->
    <link rel="icon" type="image/png" href="images/logo1.png">
    <link rel="shortcut icon" type="image/png" href="images/fav.png">
    
    <style>
        /* --- CSS styles --- */
        /* (ඔබගේ CSS කේතයේ වෙනසක් අවශ්‍ය නැත, එබැවින් එය මෙහි без змін bel оставляю) */
        :root {
            --primary-blue: #007BFF;
            --primary-blue-dark: #0056b3;
            --primary-purple: #6a11cb;
            --text-color-dark: #333;
            --text-color-light: #777;
            --border-color: #ddd;
            --white: #ffffff;
            --box-shadow: 0 10px 30px rgba(0, 0, 0, 0.15);
        }
        * { margin: 0; padding: 0; box-sizing: border-box; }
        body {
            font-family: 'Poppins', sans-serif;
            color: var(--text-color-dark);
            background: linear-gradient(rgba(35, 43, 56, 0.6), rgba(35, 43, 56, 0.6)), url('images/slider01.png') no-repeat center center;
            background-size: cover;
            display: flex;
            justify-content: flex-end;
            align-items: center;
            min-height: 100vh;
        }
        .login-card {
            width: 100%;
            max-width: 450px;
            background: linear-gradient(to bottom, #F8FFED, #FFFFFF, #FFF8E8); 
            padding: 40px;
            border-radius: 0px;
            box-shadow: var(--box-shadow);
            height: 100vh;
            margin: 0;
        }
        .form-content { width: 100%; text-align: center; }
        .logo-container img { max-width: 180px; margin-bottom: 20px; }
        .form-content h1 { font-size: 2.2rem; font-weight: 600; margin-bottom: 5px; }
        .form-content .subtitle { font-size: 0.95rem; color: var(--text-color-light); margin-bottom: 30px; }
        .input-group { margin-bottom: 20px; text-align: left; }
        .input-group label { display: none; }
        .input-group input {
            width: 100%;
            padding: 14px 16px;
            border: 1px solid var(--border-color);
            border-radius: 8px;
            font-size: 1rem;
            font-family: 'Poppins', sans-serif;
            transition: border-color 0.3s, box-shadow 0.3s;
        }
        .input-group input::placeholder { color: #aaa; }
        .input-group input:focus {
            outline: none;
            border-color: var(--primary-blue);
            box-shadow: 0 0 0 3px rgba(0, 123, 255, 0.2);
        }
        .options-row { display: flex; justify-content: space-between; align-items: center; margin-bottom: 25px; font-size: 0.9rem; }
        .checkbox-group { display: flex; align-items: center; gap: 8px; color: var(--text-color-light); }
        .checkbox-group input[type="checkbox"] { width: 16px; height: 16px; accent-color: var(--primary-purple); cursor: pointer; }
        .forgot-password { color: var(--primary-blue); text-decoration: none; transition: color 0.3s; }
        .forgot-password:hover { color: var(--primary-blue-dark); text-decoration: underline; }
        .login-button {
            width: 100%;
            padding: 14px;
            border: none;
            border-radius: 8px;
            background: linear-gradient(90deg, var(--primary-blue), var(--primary-blue-dark));
            color: var(--white);
            font-size: 1.1rem;
            font-weight: 600;
            cursor: pointer;
            transition: transform 0.2s, box-shadow 0.2s;
        }
        .login-button:hover { transform: translateY(-2px); box-shadow: 0 4px 15px rgba(0, 123, 255, 0.3); }
        .signup-link { margin-top: 30px; font-size: 0.9rem; color: var(--text-color-light); }
        .signup-link a { color: var(--primary-blue); text-decoration: none; font-weight: 500; }
        .signup-link a:hover { text-decoration: underline; }
        .error-message {
            background-color: rgba(220, 53, 69, 0.08);
            color: #dc3545;
            border: 1px solid rgba(220, 53, 69, 0.35);
            padding: 10px 12px;
            border-radius: 8px;
            margin-bottom: 18px;
            text-align: left;
            font-size: 0.95rem;
        }
    </style>
</head>
<body>

    <div class="login-card">
        <div class="form-content">
            <div class="logo-container">
                <img src="images/logo1.png" alt="MMC Kottawa Logo">
            </div>
            <h1>Login</h1>
            <p class="subtitle">Login your account in a seconds</p>

            <?php if ($loginError !== ''): ?>
                <div class="error-message"><?php echo htmlspecialchars($loginError); ?></div>
            <?php endif; ?>

            <form action="login.php" method="POST">
                
                <div class="input-group">
                    <label for="username">Username</label>
                    <input type="text" id="username" name="username" placeholder="Username" required>
                </div>

                <div class="input-group">
                    <label for="password">Password</label>
                    <input type="password" id="password" name="password" placeholder="Password" required>
                </div>

                <div class="options-row">
                    <div class="checkbox-group">
                        <input type="checkbox" id="keep-logged-in" name="keep-logged-in">
                        <label for="keep-logged-in">Keep me logged in</label>
                    </div>
                    <a href="#" class="forgot-password">Forgot password?</a>
                </div>

                <button type="submit" class="login-button">Log in</button>
            </form>

            <p class="signup-link">
                Don't have an account? <a href="#">Sign up</a>
            </p>
        </div>
    </div>

</body>
</html>