<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Golden Wings - Foreign Employment Agency</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <!-- Add Anime.js CDN -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/animejs/3.2.1/anime.min.js"></script>
    <!-- AOS Library CSS -->
    <link href="https://cdn.jsdelivr.net/npm/aos@2.3.4/dist/aos.css" rel="stylesheet">
    <link rel="stylesheet" href="index.css">
    <link rel="shortcut icon" href="favicon.ico" type="image/x-icon">
</head>
<body>
<!-- Loader -->
    <div id="page-loader">
    <div class="loader-container">
        <div class="circle circle-1"></div>
        <div class="circle circle-2"></div>
        <div class="circle circle-3"></div>
        <div class="circle circle-4"></div>
        <div class="circle circle-5"></div>
    </div>
    </div>

    <!-- Overlay -->
    <div class="site-overlay"></div>
    <!-- Whatsapp fload-->
     <a href="https://wa.me/94773529697" class="whatsapp-float" target="_blank">
        <i class="fab fa-whatsapp"></i>
     </a>

     <!-- Navigation Bar -->
      <nav class="navbar navbar-expand-lg navbar dark bg-gradient-blue fixed-top">
        <div class="container">
            <a class="navbar-band d-flex align-items-center" href="index.php">
                <img src="logo.png" alt="logo" class="logo me-2">
            </a>
            <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav">
                <span class="navbar-toggler-icon"></span>
            </button>
            <div class="collapse navbar-collapse" id="navbarNav">
                <ul class="navbar-nav ms-auto">
                    <li class="nav-item">
                        <a class="nav-link active" aria-current="page" href="#home">Home</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="#about">About Us</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="#jobs">Jobs</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="#process">Process</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="#contact">Contact Us</a>
                    </li>
                </ul>
            </div>
        </div>
      </nav>

    <!-- Hero Section -->
    <section class="hero-section" id="home">
        <!-- Desktop Slider (Hidden on Mobile) -->
        <div class="hero-slider-images d-none d-md-block">
            <!-- Slide 1 -->
            <div class="slide-img active" style="background-image: url('images/hero-bg.png');"></div>
            <!-- Slide 2 -->
            <div class="slide-img" style="background-image: url('images/hero-bg4.png');"></div>
            <!-- Slide 3 -->
            <div class="slide-img" style="background-image: url('images/hero-bg3.png');"></div>
        </div>

        <!-- Mobile Static Image (Hidden on Desktop) -->
        <div class="mobile-hero-image d-block d-md-none" style="background-image: url('images/hero-bg-2.png');"></div>

        <div class="container position-relative" data-aos="fade-right" data-aos-mirror="bg-lighttrue" data-aos-once="false">
            <div class="row align-items-center">
                <h1 class="line text-white mb-5" id="animated-heading"><span class="line">Your Gateway to</span><br><span class="line text-gold">Global Opportunities</span></h1>
                <p class="text-white mb-5">Golden Wings Foreign Employment Agency is your trusted partner for overseas employment opportunities in the Middle East.
                    <br> We specialize in connecting Sri Lankan talent with international employers. 
                </p>
                <div class="d-flex flex-wrap gap-3">
                    <a href="#jobs" class="btn btn-gold btn-lg">Find Jobs Abroad</a>
                    <a href="#contact" class="btn btn-outline-gold btn-lg">Hire Workers</a>
                </div>
            </div>
        </div>
    </section>

    <!-- About Section -->
    <section class="py-5 bg-light" id="about">
        <div class="container py-5">
            <div class="row align-items-center">
                <div class="col-lg-6 mb-4 mb-lg-0">
                    <h2 class="section-title" data-aos="fade-up" data-aos-mirror="true" data-aos-once="false">About <span class="text-gold">Golden Wings</span></h2>
                    <p class="lead about-content">Golden Wings Foreign Employment Agency is a licensed and authorized recruitment agency based in Kurunegala, Sri Lanka, specializing in overseas employment opportunities.</p>
                    <p class="about-content">With over 10 years of experience in the industry, we have successfully placed hundreds of skilled and unskilled workers in Middle Eastern countries, particularly in Dubai, UAE. Our team understands the complexities of international recruitment and provides comprehensive support throughout the entire process.</p>
                    
                    <h4 class="mt-5">Our Services</h4>
                    <div class="row mt-3">
                        <div class="col-md-6">
                            <div class="d-flex align-items-start mb-3">
                                <i class="fas fa-check-circle text-gold mt-1 me-2"></i>
                                <div>
                                    <h6>For Job Seekers</h6>
                                    <p class="small">Job matching, visa processing, pre-departure training, and full support</p>
                                </div>
                            </div>
                            <div class="d-flex align-items-start mb-3">
                                <i class="fas fa-check-circle text-gold mt-1 me-2"></i>
                                <div>
                                    <h6>For Employers</h6>
                                    <p class="small">Reliable worker recruitment, documentation, and replacement guarantee</p>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="d-flex align-items-start mb-3">
                                <i class="fas fa-check-circle text-gold mt-1 me-2"></i>
                                <div>
                                    <h6>Specializations</h6>
                                    <p class="small">Cleaners, domestic workers, construction staff, and skilled technicians</p>
                                </div>
                            </div>
                            <div class="d-flex align-items-start mb-3">
                                <i class="fas fa-check-circle text-gold mt-1 me-2"></i>
                                <div>
                                    <h6>Destinations</h6>
                                    <p class="small">Dubai, Saudi Arabia, Qatar, Oman, and Kuwait</p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-6">
                    <div class="position-relative">
                        <img src="images/about-image.jpg" alt="About Golden Wings" class="img-fluid rounded shadow mb-5">
                    </div>
                    <div class="mission-box" data-aos="zoom-out" data-aos-mirror="true" data-aos-once="false">
                        <h5 class="text-gold mb-0">Our Mission</h5>
                        <p class="mb-0">To provide ethical and professional foreign employment services</p>
                    </div>
                </div>
            </div>
            
            <!-- Testimonial section -->
            <div class="row mt-5">
                <div class="col-12">
                    <h4 class="section-title text-center" data-aos="fade-up" data-aos-mirror="true" data-aos-once="false" style="color: black;">Client <span class="text-gold">Testimonials</span></h4>
                </div>
                <div class="col-lg-8 mx-auto mt-4">
                    <div id="testimonialCarousel" class="carousel slide" data-bs-ride="carousel">
                        <div class="carousel-inner">
                            <div class="carousel-item active">
                                <div class="testimonial-card">
                                    <div class="row align-items-center">
                                        <div class="col-md-3 text-center mb-3 mb-md-0">
                                            <img src="images/testimonial1.jpg" alt="Client" class="testimonial-img">
                                            <h5 class="mt-3 mb-0">Nimal Perera</h5>
                                            <small class="text-gold">Cleaner in Dubai</small>
                                        </div>
                                        <div class="col-md-9">
                                            <p>"Golden Wings helped me secure a good cleaning job in Dubai with proper visa and accommodation. Their staff guided me through every step of the process. I've been working here for 2 years now and able to support my family back home."</p>
                                            <div class="text-gold">
                                                <i class="fas fa-star"></i>
                                                <i class="fas fa-star"></i>
                                                <i class="fas fa-star"></i>
                                                <i class="fas fa-star"></i>
                                                <i class="fas fa-star"></i>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="carousel-item">
                                <div class="testimonial-card">
                                    <div class="row align-items-center">
                                        <div class="col-md-3 text-center mb-3 mb-md-0">
                                            <img src="images/testimonial2.png" alt="Client" class="testimonial-img">
                                            <h5 class="mt-3 mb-0">Rashid Hotel Management</h5>
                                            <small class="text-gold">Employer in UAE</small>
                                        </div>
                                        <div class="col-md-9">
                                            <p>"We have been working with Golden Wings for 5 years to recruit cleaning and kitchen staff for our hotel chain. They provide well-trained, reliable workers and handle all the visa processing efficiently. Their replacement guarantee gives us peace of mind."</p>
                                            <div class="text-gold">
                                                <i class="fas fa-star"></i>
                                                <i class="fas fa-star"></i>
                                                <i class="fas fa-star"></i>
                                                <i class="fas fa-star"></i>
                                                <i class="fas fa-star"></i>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <button class="carousel-control-prev" type="button" data-bs-target="#testimonialCarousel" data-bs-slide="prev">
                            <span class="carousel-control-prev-icon bg-dark rounded-circle"></span>
                        </button>
                        <button class="carousel-control-next" type="button" data-bs-target="#testimonialCarousel" data-bs-slide="next">
                            <span class="carousel-control-next-icon bg-dark rounded-circle"></span>
                        </button>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Counter Section -->
    <section class="py-5 counter-bg text-white">
        <div class="container py-4">
            <div class="row text-center">
                <div class="col-md-3">
                    <div class="counter-item">
                        <div class="counter-number" data-count="1000">0</div>
                        <p>Successful Placements</p>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="counter-item">
                        <div class="counter-number" data-count="50">0</div>
                        <p>Partner Companies</p>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="counter-item">
                        <div class="counter-number" data-count="10">0</div>
                        <p>Years Experience</p>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="counter-item">
                        <div class="counter-number" data-count="5">0</div>
                        <p>Destination Countries</p>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Job Categories Section -->
    <section class="py-5" id="jobs">
        <div class="container py-5">
            <h2 class="section-title text-center" data-aos="fade-up" data-aos-mirror="true" data-aos-once="false">Available <span class="text-gold">Job Categories</span></h2>
            <p class="text-center mb-5 lead">We specialize in placing workers in these high-demand categories</p>
            
            <div class="row">
                <div class="col-md-4 mb-4" data-aos="zoom-in" data-aos-mirror="true" data-aos-once="false">
                    <div class="job-category">
                        <i class="fas fa-broom"></i>
                        <h4>Cleaners & Helpers</h4>
                        <p>Hotel, office, and industrial cleaning positions with work visa</p>
                        <a href="#contact" class="btn btn-sm btn-gold">Apply Now</a>
                    </div>
                </div>
                <div class="col-md-4 mb-4" data-aos="zoom-in" data-aos-mirror="true" data-aos-once="false">
                    <div class="job-category">
                        <i class="fas fa-home"></i>
                        <h4>Domestic Workers</h4>
                        <p>Maids, nannies, cooks, and drivers for households</p>
                        <a href="#contact" class="btn btn-sm btn-gold">Apply Now</a>
                    </div>
                </div>
                <div class="col-md-4 mb-4" data-aos="zoom-in" data-aos-mirror="true" data-aos-once="false">
                    <div class="job-category">
                        <i class="fas fa-hammer"></i>
                        <h4>Construction Workers</h4>
                        <p>Laborers, masons, carpenters, and other skilled trades</p>
                        <a href="#contact" class="btn btn-sm btn-gold">Apply Now</a>
                    </div>
                </div>
                <div class="col-md-4 mb-4" data-aos="zoom-in" data-aos-mirror="true" data-aos-once="false">
                    <div class="job-category">
                        <i class="fas fa-utensils"></i>
                        <h4>Restaurant Staff</h4>
                        <p>Chefs, waiters, kitchen helpers for hotels and restaurants</p>
                        <a href="#contact" class="btn btn-sm btn-gold">Apply Now</a>
                    </div>
                </div>
                <div class="col-md-4 mb-4" data-aos="zoom-in" data-aos-mirror="true" data-aos-once="false">
                    <div class="job-category">
                        <i class="fas fa-tools"></i>
                        <h4>Technicians</h4>
                        <p>Electricians, plumbers, AC technicians, and mechanics</p>
                        <a href="#contact" class="btn btn-sm btn-gold">Apply Now</a>
                    </div>
                </div>
                <div class="col-md-4 mb-4" data-aos="zoom-in" data-aos-mirror="true" data-aos-once="false">
                    <div class="job-category">
                        <i class="fas fa-user-tie"></i>
                        <h4>Office Staff</h4>
                        <p>Receptionists, clerks, accountants, and admin staff</p>
                        <a href="#contact" class="btn btn-sm btn-gold">Apply Now</a>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Destination Countries -->
    <section class="py-5 flag-section section-bg">
        <div class="container py-5">
            <h2 class="section-title text-center" data-aos="fade-up" data-aos-mirror="true" data-aos-once="false" style="color:white">Our <span class="text-gold">Destination Countries</span></h2>
            <p class="text-center mb-5 lead">We specialize in placements to these countries</p>
            
            <div class="row justify-content-center">
                <div class="col-auto text-center" data-aos="fade-right" data-aos-mirror="true" data-aos-once="false">
                    <img src="images/uae-flag.png" alt="UAE" class="country-flag mb-2">
                    <p>United Arab Emirates</p>
                </div>
                <div class="col-auto text-center" data-aos="fade-right" data-aos-mirror="true" data-aos-once="false">
                    <img src="images/saudi-flag.png" alt="Saudi Arabia" class="country-flag mb-2">
                    <p>Saudi Arabia</p>
                </div>
                <div class="col-auto text-center" data-aos="fade-right" data-aos-mirror="true" data-aos-once="false">
                    <img src="images/qatar-flag.jpeg" alt="Qatar" class="country-flag mb-2">
                    <p>Qatar</p>
                </div>
                <div class="col-auto text-center" data-aos="fade-right" data-aos-mirror="true" data-aos-once="false">
                    <img src="images/oman-flag.png" alt="Oman" class="country-flag mb-2">
                    <p>Oman</p>
                </div>
                <div class="col-auto text-center" data-aos="fade-right" data-aos-mirror="true" data-aos-once="false">
                    <img src="images/kuwait-flag.png" alt="Kuwait" class="country-flag mb-2">
                    <p>Kuwait</p>
                </div>
            </div>
        </div>
    </section>

    <!-- Process Section -->
    <section class="py-5" id="process">
        <div class="container py-5">
            <h2 class="section-title text-center" data-aos="fade-up" data-aos-mirror="true" data-aos-once="false">Our <span class="text-gold">Recruitment Process</span></h2>
            <p class="text-center mb-5 lead">Simple and transparent steps to your overseas employment</p>
            <div class="row align-items-start">
                <!-- Image Column -->
                <div class="col-lg-4 mb-4 mb-lg-0" data-aos="fade-right">
                    <img src="images/processImg.png" class="recruitment-img" style="top: 100px;" alt="Recruitment Process">
                </div>
                <div class="col-lg-8 mx-auto">
                    <div class="process-step" data-aos="fade-left" data-aos-mirror="true" data-aos-once="false">
                        <div class="process-step-number">1</div>
                        <h4>Initial Consultation</h4>
                        <p>Visit our office or contact us to discuss your employment needs and available opportunities.</p>
                    </div>
                    <div class="process-step" data-aos="fade-left" data-aos-mirror="true" data-aos-once="false">
                        <div class="process-step-number">2</div>
                        <h4>Documentation</h4>
                        <p>Submit required documents (CV, certificates, photos) and complete SLBFE registration.</p>
                    </div>
                    <div class="process-step" data-aos="fade-left" data-aos-mirror="true" data-aos-once="false">
                        <div class="process-step-number">3</div>
                        <h4>Job Matching</h4>
                        <p>We match your skills and experience with suitable overseas employers.</p>
                    </div>
                    <div class="process-step" data-aos="fade-left" data-aos-mirror="true" data-aos-once="false">
                        <div class="process-step-number">4</div>
                        <h4>Interview</h4>
                        <p>Attend interview (in-person or online) with potential employer.</p>
                    </div>
                    <div class="process-step" data-aos="fade-left" data-aos-mirror="true" data-aos-once="false">
                        <div class="process-step-number">5</div>
                        <h4>Visa Processing</h4>
                        <p>We handle all visa paperwork and approvals with the employer.</p>
                    </div>
                    <div class="process-step" data-aos="fade-left" data-aos-mirror="true" data-aos-once="false">
                        <div class="process-step-number">6</div>
                        <h4>Pre-Departure</h4>
                        <p>Orientation, medical tests, ticket booking, and final preparations.</p>
                    </div>
                    <div class="process-step" data-aos="fade-left" data-aos-mirror="true" data-aos-once="false">
                        <div class="process-step-number">7</div>
                        <h4>Deployment</h4>
                        <p>Travel to your new job with our support for airport pickup and settling in.</p>
                    </div>
                    <div class="process-step" data-aos="fade-left" data-aos-mirror="true" data-aos-once="false">
                        <div class="process-step-number">8</div>
                        <h4>Ongoing Support</h4>
                        <p>We stay in touch to assist with any issues and ensure your well-being abroad.</p>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Contact Section -->
    <section class="py-5 contact-section-bg" id="contact">
        <div class="container py-5">
            <h2 class="section-title text-center" data-aos="fade-up" data-aos-mirror="true" data-aos-once="false">Contact <span class="text-gold">Us</span></h2>
            <p class="text-center mb-5 pb-4 lead">Get in touch for your overseas employment needs</p>
            
            <div class="row">
                <div class="col-lg-5 mb-5 mb-lg-0 contact-section">
                    <h4 class="mb-4">Our Office</h4>
                    <div class="contact-info-container text-center text-md-start">
                    <div class="d-flex mb-3 contact-section-info justify-content-center justify-content-md-start">
                        <i class="fas fa-map-marker-alt text-gold mt-1 me-3"></i>
                        <p class="mb-0">10/1/1 G Suratissa Mawatha, Kurunegala, Sri Lanka</p>
                    </div>
                    <div class="d-flex mb-3 contact-section-info justify-content-center justify-content-md-start">
                        <i class="fas fa-phone-alt text-gold mt-1 me-3"></i>
                        <p class="mb-0">+94 77 352 9697</p>
                    </div>
                    <div class="d-flex mb-3 contact-section-info justify-content-center justify-content-md-start">
                        <i class="fas fa-envelope text-gold mt-1 me-3"></i>
                        <p class="mb-0">info@goldenwings.lk</p>
                    </div>
                    <div class="d-flex mb-3 contact-section-info justify-content-center justify-content-md-start">
                        <i class="fab fa-whatsapp text-gold mt-1 me-3"></i>
                        <p class="mb-0">+94 75 974 5000</p>
                    </div>
                </div>
                    <div class="office-hours text-center text-md-start">
                        <h4 class="mt-5 mb-4">Office Hours</h4>
                        <p>Monday - Friday: 8:00 AM - 5:30 PM</p>
                        <p>Saturday: 8:00 AM - 1:30 PM</p>
                        <p>Sunday: Closed</p>
                    </div>
                    
                </div>
                <div class="col-lg-7">
                    <div class="card shadow-sm">
                        <div class="card-body p-4">
                            <h4 class="mb-4">Send Us a Message</h4>
                            <form id="contactForm">
                                <div class="row">
                                    <div class="col-md-6 mb-3">
                                        <label for="name" class="form-label">Your Name</label>
                                        <input type="text" class="form-control" id="name" required>
                                    </div>
                                    <div class="col-md-6 mb-3">
                                        <label for="phone" class="form-label">Phone Number</label>
                                        <input type="tel" class="form-control" id="phone" required>
                                    </div>
                                </div>
                                <div class="mb-3">
                                    <label for="email" class="form-label">Email Address</label>
                                    <input type="email" class="form-control" id="email">
                                </div>
                                <div class="mb-3">
                                    <label for="subject" class="form-label">Subject</label>
                                    <select class="form-select" id="subject" required>
                                        <option value="" selected disabled>Select a subject</option>
                                        <option value="job-seeker">I'm looking for a job abroad</option>
                                        <option value="employer">I want to hire workers</option>
                                        <option value="general">General inquiry</option>
                                    </select>
                                </div>
                                <div class="mb-3">
                                    <label for="message" class="form-label">Message</label>
                                    <textarea class="form-control" id="message" rows="4" required></textarea>
                                </div>
                                <button type="submit" class="btn btn-gold">Send Message</button>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Footer -->
    <footer class="py-4 text-white">
        <div class="container py-3">
            <div class="row text-center text-lg-start"> <!-- Added text-center for mobile -->
                <!-- Logo Column -->
                <div class="col-lg-4 mb-4 mb-lg-0">
                    <div class="d-flex flex-column align-items-center align-items-lg-start">
                        <img src="logo.png" alt="footer-logo" class="footer-logo mb-3">
                        <p class="text-center text-lg-start">Licensed foreign employment agency specializing in Middle East placements from Sri Lanka.</p>
                        <div class="d-flex gap-3 mt-4 icon-list-unstyled justify-content-center justify-content-lg-start">
                            <a href="#" class="text-white"><i class="fab fa-facebook-f"></i></a>
                            <a href="#" class="text-white"><i class="fab fa-whatsapp"></i></a>
                            <a href="#" class="text-white"><i class="fab fa-linkedin-in"></i></a>
                        </div>
                    </div>
                </div>
                
                <!-- Quick Links Column -->
                <div class="col-lg-4 mb-4 mb-lg-0">
                    <h4 class="text-gold mb-4 text-center text-lg-start">Quick Links</h4>
                    <ul class="list-unstyled text-center text-lg-start">
                        <li class="mb-2"><a href="#home" class="text-white text-decoration-none">Home</a></li>
                        <li class="mb-2"><a href="#about" class="text-white text-decoration-none">About Us</a></li>
                        <li class="mb-2"><a href="#jobs" class="text-white text-decoration-none">Job Categories</a></li>
                        <li class="mb-2"><a href="#process" class="text-white text-decoration-none">Process</a></li>
                        <li class="mb-2"><a href="#contact" class="text-white text-decoration-none">Contact</a></li>
                    </ul>
                </div>
                
                <!-- Newsletter Column -->
                <div class="col-lg-4">
                    <div class="d-flex flex-column align-items-center align-items-lg-start">
                        <h4 class="text-gold mb-4 text-center text-lg-start">Newsletter</h4>
                        <p class="text-center text-lg-start">Subscribe to get updates on new job opportunities.</p>
                        <form class="mt-4 w-100">
                            <div class="input-group">
                                <input type="email" class="form-control" placeholder="Your Email">
                                <button class="btn btn-gold" type="submit">Subscribe</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
            
            <hr class="my-4">
            
            <div class="row">
                <div class="col-md-6 text-center text-md-start">
                    <p class="small mb-0">© 2023 Golden Wings Foreign Employment Agency. All rights reserved.</p>
                </div>
                <div class="col-md-6 text-center text-md-end">
                    <p class="small mb-0">License No: 3585</p>
                </div>
            </div>
        </div>
    </footer>

    <!-- Back to Top Button -->
    <div class="back-to-top">
        <i class="fas fa-arrow-up"></i>
    </div>

    <!-- AOS Library JS -->
    <script src="https://cdn.jsdelivr.net/npm/aos@2.3.4/dist/aos.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script src="index.js"></script>
</body>
</html>