// Scroll to top on page refresh
window.onload = function() {
    window.scrollTo(0, 0);
};

// Initialize AOS
document.addEventListener('DOMContentLoaded', function() {
    AOS.init({
        duration: 800,
        easing: 'ease-in-out',
        once: true,
        mirror: false,
        anchorPlacement: 'top-bottom',
        offset: 120,
        delay: 0,
    });
});

// Refresh AOS on dynamic content changes
document.addEventListener('DOMContentLoaded', function() {
    AOS.refresh();
});

// Counter Animation
document.addEventListener('DOMContentLoaded', function () {
    const counters = document.querySelectorAll('.counter-number');
    const speed = 200;

    counters.forEach(counter => {
        const target = +counter.getAttribute('data-count');
        const count = +counter.innerText;
        const increment = target / speed;

        function updateCount() {
            const current = +counter.innerText;
            if (current < target) {
                counter.innerText = Math.ceil(current + increment);
                setTimeout(updateCount, 20);
            } else {
                counter.innerText = target + '+';
            }
        }

        updateCount();
    });

    // Form submission
    const contactForm = document.getElementById('contactForm');
    if (contactForm) {
        contactForm.addEventListener('submit', function (e) {
            e.preventDefault();
            alert('Thank you for your message! We will contact you soon.');
            this.reset();
        });
    }

    // Back to top button
    const backToTopButton = document.querySelector('.back-to-top');
    if (backToTopButton) {
        window.addEventListener('scroll', function () {
            if (window.pageYOffset > 300) {
                backToTopButton.classList.add('active');
            } else {
                backToTopButton.classList.remove('active');
            }
        });

        backToTopButton.addEventListener('click', function (e) {
            e.preventDefault();
            window.scrollTo({ top: 0, behavior: 'smooth' });
        });
    }

    // Navbar scroll effect
    const navbar = document.querySelector('.navbar');
    if (navbar) {
        window.addEventListener('scroll', function() {
            if (window.pageYOffset > 50) {
                navbar.classList.add('scrolled');
            } else {
                navbar.classList.remove('scrolled');
            }
        });
        
        // Initialize on load in case page starts scrolled
        if (window.pageYOffset > 50) {
            navbar.classList.add('scrolled');
        }
    }

    // Smooth scrolling for navigation links
    document.querySelectorAll('a[href^="#"]').forEach(anchor => {
        anchor.addEventListener('click', function (e) {
            e.preventDefault();

            const targetId = this.getAttribute('href');
            const targetElement = document.querySelector(targetId);

            if (targetElement) {
                window.scrollTo({
                    top: targetElement.offsetTop - 70,
                    behavior: 'smooth'
                });

                document.querySelectorAll('.nav-link').forEach(link => {
                    link.classList.remove('active');
                });
                this.classList.add('active');
            }
        });
    });

    // Set active nav link based on scroll position
    const sections = document.querySelectorAll('section');
    window.addEventListener('scroll', function () {
        let current = '';

        sections.forEach(section => {
            const sectionTop = section.offsetTop;
            if (pageYOffset >= sectionTop - 100) {
                current = section.getAttribute('id');
            }
        });

        document.querySelectorAll('.nav-link').forEach(link => {
            link.classList.remove('active');
            if (link.getAttribute('href') === `#${current}`) {
                link.classList.add('active');
            }
        });
    });
});

// Hero Slider with Text Changes
document.addEventListener('DOMContentLoaded', function() {
    const slides = document.querySelectorAll('.slide-img');
    const headings = [
        "<span class='line'>Your Gateway to</span><br><span class='text-gold line'>Global Opportunities</span>",
        "<span class='line'>Connecting Talent to</span><br><span class='text-gold line'>International Markets</span>",
        "<span class='line'>Building Careers Across</span><br><span class='text-gold line'>The Middle East</span>"
    ];
    
    const paragraphs = [
        "Golden Wings Foreign Employment Agency is your trusted partner for overseas employment opportunities in the Middle East. <br> We specialize in connecting Sri Lankan talent with international employers.",
        "With our extensive network of international employers, we open doors to rewarding careers abroad. <br> Let us guide you through every step of the employment process.",
        "Trusted by thousands of job seekers and employers alike. <br> Our expertise in international recruitment ensures successful placements every time."
    ];
    
    let currentSlide = 0;
    const headingElement = document.querySelector('#animated-heading');
    const paragraphElement = document.querySelector('.hero-section p');

    function nextSlide() {
        // Fade out current slide
        slides[currentSlide].classList.remove('active');
        
        // Move to next slide
        currentSlide = (currentSlide + 1) % slides.length;
        
        // Fade in next slide
        slides[currentSlide].classList.add('active');
        
        // Update text content with animation
        animateTextChange(headingElement, headings[currentSlide]);
        animateTextChange(paragraphElement, paragraphs[currentSlide]);
    }

    function animateTextChange(element, newContent) {
        anime({
            targets: element,
            opacity: [1, 0],
            duration: 500,
            easing: 'easeInOutQuad',
            complete: function() {
                element.innerHTML = newContent;
                anime({
                    targets: element,
                    opacity: [0, 1],
                    duration: 500,
                    easing: 'easeInOutQuad'
                });
                
                // Re-apply letter animation for headings
                if (element === headingElement) {
                    applyLetterAnimation();
                }
            }
        });
    }

    function applyLetterAnimation() {
        headingElement.querySelectorAll('.line').forEach(line => {
            line.innerHTML = line.textContent.split('').map(letter => 
                `<span class="letter">${letter === ' ' ? '&nbsp;' : letter}</span>`
            ).join('');
        });

        anime.timeline({ loop: false })
            .add({
                targets: '#animated-heading .letter',
                opacity: [0, 1],
                translateY: [20, 0],
                duration: 100,
                delay: (el, i) => 50 * i,
                easing: 'easeOutExpo'
            });
    }

    // Initialize
    applyLetterAnimation();
    
    // Change slide every 5 seconds
    setInterval(nextSlide, 5000);
});

 window.addEventListener("load", function () {
    const loader = document.getElementById("page-loader");
    if (loader) {
      loader.style.transition = "opacity 0.5s ease";
      loader.style.opacity = 0;
      setTimeout(() => {
        loader.style.display = "none";
      }, 500);
    }
});