﻿<!DOCTYPE html>
<html lang="en">

<head>
   <title>Fleethub - Welcome to Fleethub</title>
   <?php
   include('./includes/headerscripts.php');
   ?>

   <style>
      .ca-about-3 {
         position: relative;
         background: url('assets/img/cstm/onenew.jpg') no-repeat right;
         background-size: 30%;
         padding: 100px 0;
         background-position: top right;
         background-size: auto 600px;
      }

      .ca-about-3::before {
         content: "";
         position: absolute;
         top: 0;
         left: 0;
         width: 100%;
         height: 100%;
         background: rgba(255, 255, 255, 0.9);
         z-index: 2;
      }


      .ca-about-3 .container {
         position: relative;
         z-index: 2;
      }

      .ca-portfilo-2 {
         position: relative;
         background-color: #f7f7f7;
         padding: 50px 0;
         overflow: hidden;
      }

      .ca-portfilo-2::before {
         content: "";
         position: absolute;
         top: 0;
         left: 0;
         width: 100%;
         height: 25%;
         background: url('assets/img/cstm/testnew.jpg') no-repeat top right;
         background-size: contain;
         opacity: 0.1;
         z-index: 1;
      }

      .ca-service-3 {
         position: relative;
         background-color: #f7f7f7;
         padding: 100px 0;
         overflow: hidden;
      }

      .ca-service-3::before {
         content: "";
         position: absolute;
         top: 0;
         left: 0;
         width: 100%;
         height: 40%;
         background: url('assets/img/cstm/tyre2.png') no-repeat top left;
         background-size: contain;
         opacity: 0.9;
         z-index: 1;
      }

      @media screen and (max-width: 768px) {
         .ca-service-3::before {
            display: none;
         }
      }
      @media screen and (max-width: 768px) {
         .ca-portfilo-2::before {
            display: none;
         }
      }

      @media screen and (max-width: 1360px) {
         .ca-slider-active-3 .slick-dots {
            left: -76%;
            top: -3%;
         }
      }
   </style>
</head>

<body>
   <!-- preloader -->
   <?php
   include('./includes/preloader.php');
   ?>
   <!-- preloader end -->

   <!-- Header Area Start-->
   <?php

   include('./includes/header.php');
   ?>
   <!-- Header area end -->

   <!-- offcanvas start -->
   <?php

   include('./includes/offcanvas.php');
   ?>
   <!-- offcanvas end -->

   <main>
      <!-- slider start -->
      <?php

      include('./includes/slider.php');
      ?>
      <!-- slider end -->

      <!-- about section start -->
      <section class="ca-about-3 pt-100 pb-70">
         <div class="container">
            <!-- <img class="top-right-image" src="assets/img/cstm/tyre.jpg" alt="Top Right Image"> -->
            <div class="row align-items-center">
               <div class="col-lg-6">
                  <div class="ca-abo-item-1">
                     <div class="row">
                        <div class="col-lg-6 col-md-6">
                           <!-- single about item -->
                           <div class="ca-abo-single-item mb-30">
                              <img class="w-100 lar-img-1" src="assets/img/cstm/lorries.jpg" alt="">
                              <div class="ca-abo-hover-item">
                                 <div class="ca-abo-content">
                                    <div class="ca-abo-icon">
                                       <span><img src="assets/img/icon/ca-delivery3.1.svg" alt=""></span>
                                    </div>
                                    <h3 class="ca-abo-hover-title"><span class="counter">1000</span>+</h3>
                                    <p>Vehicles / Assets</p>
                                 </div>
                              </div>
                           </div>

                           <!-- single about item -->
                           <div class="ca-abo-single-item mb-30">
                              <img class="w-100 sm-img-1" src="assets/img/cstm/gps.jpg" alt="">
                              <div class="ca-abo-hover-item">
                                 <div class="ca-abo-content">
                                    <div class="ca-abo-icon">
                                       <span><img src="assets/img/icon/ca-delivery3.1.svg" alt=""></span>
                                    </div>
                                    <h3 class="ca-abo-hover-title"><span class="counter">3500</span>+</h3>
                                    <p>GPS Integration</p>
                                 </div>
                              </div>
                           </div>
                        </div>

                        <div class="col-lg-6 col-md-6">
                           <!-- single about item -->
                           <div class="ca-abo-single-item mb-30">
                              <img class="w-100 sm-img-2" src="assets/img/cstm/cstmsprt.jpg" alt="">
                              <div class="ca-abo-hover-item">
                                 <div class="ca-abo-content">
                                    <div class="ca-abo-icon">
                                       <span><img src="assets/img/icon/ca-delivery3.1.svg" alt=""></span>
                                    </div>
                                    <h3 class="ca-abo-hover-title"><span class="counter">24</span>x7</h3>
                                    <p>Support Service</p>
                                 </div>
                              </div>
                           </div>
                           <!-- single about item -->
                           <div class="ca-abo-single-item mb-30">
                              <img class="w-100 lar-img-2" src="assets/img/cstm/product.png" alt="">
                              <div class="ca-abo-hover-item">
                                 <div class="ca-abo-content">
                                    <div class="ca-abo-icon">
                                       <span><img src="assets/img/icon/ca-delivery3.1.svg" alt=""></span>
                                    </div>
                                    <h3 class="ca-abo-hover-title">High Quality</h3>
                                    <p>Products</p>
                                 </div>
                              </div>
                           </div>


                        </div>
                     </div>
                  </div>
               </div>
               <div class="col-xl-6 mb-30">
                  <div class="ca-ab-content3">
                     <div class="ca-about-content-3 ca-sec-content-3">
                        <h5 class="ca-section-subtitle subtitle-bg-6 p-relative theme-color-3 br-50">Why We Are</h5>
                        <h2 class="ca-section-title theme-black-3 fnw-600 pt-16 ca-text-cap">Our Commitment: Reliable <br> and Efficient Solutions</h2>
                        <p class="pt-16 pb-32"> With years of industry experience and a commitment to innovation, we have <br> become leaders in providing comprehensive, reliable, and efficient Fleet Management solutions. Our dedicated team of experts works tirelessly to ensure.</p>

                     </div>
                     <div class="ca-ab-item-check">
                        <!-- single-item -->
                        <div class="ca-ab-sngle-item">
                           <div class="ca-ab-sngle-item-ic">
                              <span><i class="fa-solid fa-check"></i></span>
                           </div>
                           <div class="ca-ab-sngle-item-content">
                              <h4 class="ca-item-ch-title">10000+ Vehicles / Assets</h4>
                           </div>
                        </div>
                        <!-- single-item -->
                        <div class="ca-ab-sngle-item">
                           <div class="ca-ab-sngle-item-ic">
                              <span><i class="fa-solid fa-check"></i></span>
                           </div>
                           <div class="ca-ab-sngle-item-content">
                              <h4 class="ca-item-ch-title">Integrated with 3500+ GPS</h4>
                           </div>
                        </div>
                        <!-- single-item -->
                        <div class="ca-ab-sngle-item">
                           <div class="ca-ab-sngle-item-ic">
                              <span><i class="fa-solid fa-check"></i></span>
                           </div>
                           <div class="ca-ab-sngle-item-content">
                              <h4 class="ca-item-ch-title">24x7 Customer Support</h4>
                           </div>
                        </div>
                        <!-- single-item -->
                        <div class="ca-ab-sngle-item">
                           <div class="ca-ab-sngle-item-ic">
                              <span><i class="fa-solid fa-check"></i></span>
                           </div>
                           <div class="ca-ab-sngle-item-content">
                              <h4 class="ca-item-ch-title">Business Partners</h4>
                           </div>
                        </div>
                     </div>
                     <div class="ca-about-item3 cream-bg-3 p-relative">
                        <p>We are driving success and creating opportunities for growth. Discover <br>difference with a fleet solutions that is truly invested in your success.</p>
                     </div>
                     <div class="ca-about-3-btn">
                        <a href="about.php" class="ca-btn-primary-3 theme-bg-3 text-white br-50">About Us<span><i class="fa-solid fa-angle-right"></i></span></a>
                     </div>
                  </div>
               </div>
            </div>
         </div>
      </section>
      <!-- about section end -->

      <!-- service section start -->
      <section class="ca-service-3 cream-bg-3 pt-100 pb-70">
         <div class="container">
            <div class="ca-portfolio-content-3 ca-sec-content-3 text-center mb-60 aos-init aos-animate" data-aos="fade-up" data-aos-duration="800">
               <h5 class="ca-section-subtitle subtitle-bg-6 p-relative theme-color-3 br-50">Our Service</h5>
               <h2 class="ca-section-title theme-black-3 fnw-600 pt-16 ca-text-cap">Our Range of Fleet Management Services</h2>
               <p class="pt-16">Our state-of-the-art fleet management solutions, powered by innovative technology,<br> optimize vehicle tracking, fuel efficiency, and route planning—ensuring <br>seamless logistics and cost savings tailored to your needs.</p>
            </div>
         </div>
         <!-- expand gallery start -->
         <div class="expand-container">
            <!-- single item -->
            <div class="slide">
               <img class="expand-slide-img" src="assets/img/cstm/vehicletrack.jpg" alt="">
               <div class="expand-slide-ic-box">
                  <div class="ca-expand-ic">
                     <span><img src="assets/img/icon/ca-expand-ic3.1.svg" alt=""></span>
                  </div>
                  <h2 class="ca-expand-title"><a href="#">Live Tracking</a></h2>
                  <p>Track the movement of any vehicle with a hawk-eye view of the entire fleet. Analyze routes, traffic patterns, and idle time with customizable time and date settings.</p>
               </div>
            </div>
            <!-- single item -->
            <div class="slide">
               <img class="expand-slide-img" src="assets/img/cstm/documentmgt.jpg" alt="">
               <div class="expand-slide-ic-box">
                  <div class="ca-expand-ic">
                     <span><img src="assets/img/icon/ca-expand-ic3.1.svg" alt=""></span>
                  </div>
                  <h2 class="ca-expand-title"><a href="#">Managing Documents & Records</a></h2>
                  <p>Maintain an online database of vehicles and view the entire fleet’s requisite legal permits. Easily upload documents via the app and receive renewal reminders via phone or email.</p>

               </div>
            </div>
            <!-- single item -->
            <div class="slide">
               <img class="expand-slide-img" src="assets/img/cstm/profiledrv.jpg" alt="">
               <div class="expand-slide-ic-box">
                  <div class="ca-expand-ic">
                     <span><img src="assets/img/icon/ca-expand-ic3.1.svg" alt=""></span>
                  </div>
                  <h2 class="ca-expand-title"><a href="#">Managing Drivers and Transporters</a></h2>
                  <p>Assign drivers to vehicles and group them based on usage. Easily make bulk edits and changes while comparing vendor performance for optimized fleet management.</p>

               </div>
            </div>
            <!-- single item -->
            <div class="slide active">
               <img class="expand-slide-img" src="assets/img/cstm/realtime.jpg" alt="">
               <div class="expand-slide-ic-box">
                  <div class="ca-expand-ic">
                     <span><img src="assets/img/icon/ca-expand-ic3.1.svg" alt=""></span>
                  </div>
                  <h2 class="ca-expand-title"><a href="#">Real-Time Alerts</a></h2>
                  <p>Maintain a log of all actions completed by a vehicle. Easily sort alerts by type, vehicle number, or time period for efficient monitoring and quick decision-making.</p>
               </div>
            </div>
            <!-- single item -->
            <div class="slide">
               <img class="expand-slide-img" src="assets/img/cstm/routes.jpg" alt="">
               <div class="expand-slide-ic-box">
                  <div class="ca-expand-ic">
                     <span><img src="assets/img/icon/ca-expand-ic3.1.svg" alt=""></span>
                  </div>
                  <h2 class="ca-expand-title"><a href="#">Trip Management</a></h2>
                  <p>Create and edit routes effortlessly while adding checkpoints within a journey. Get a complete overview of all trips and visualize them on an interactive map for better tracking.</p>

               </div>
            </div>

         </div>
         <div style="text-align: center;" class="ca-about-3-btn">
            <a href="service.php" class="ca-btn-primary-3 theme-bg-3 text-white br-50">All Services<span><i class="fa-solid fa-angle-right"></i></span></a>
         </div>
         <!-- expand gallery end -->
      </section>
      <!-- service section end -->

      <!-- portfolio section start -->
      <section class="ca-portfilo-2 pt-100 pb-70">
         <div class="container">
            <div class="ca-portfolio-content-3 ca-sec-content-3 text-center mb-60 aos-init aos-animate" data-aos="fade-up" data-aos-duration="800">
               <h5 class="ca-section-subtitle subtitle-bg-6 p-relative theme-color-3 br-50">Our Projects</h5>
               <h2 class="ca-section-title theme-black-3 fnw-600 pt-16">Showcasing Our Expertise</h2>
               <p class="pt-16"> From real-time vehicle tracking to efficient fleet management, <br>our success stories showcase our commitment to optimizing operations and ensuring reliability across every journey.</p>
            </div>

            <div class="row">

               <!-- single project item -->
               <div class="col-lg-3 col-md-6">
                  <div class="ca-single-pro-img-3 mb-30">
                     <img class="w-100" src="assets/img/cstm/ambulances.jpg" alt="">
                     <div class="ca-project-hover-item1">
                        <a href="project-single.html" class="ca-project-hover-item1-icon">
                           <span><img src="assets/img/icon/ca-arow-3.1.svg" alt=""></span>
                        </a>
                        <div class="ca-project-hover-item-content">
                           <h4 class="ca-project-hov-sub-title">GPS & Fuel Configuration</h4>
                           <h3 class="ca-project-hov-title"><a href="project-single.html">RDHS Matale</a></h3>
                           <!-- <p>Explore our case studies achievements<br> to see how we have transformed.</p> -->
                        </div>
                     </div>
                  </div>
               </div>

               <!-- single project item -->
               <div class="col-lg-4 col-md-6">
                  <div class="ca-single-pro-img-3 mb-30">
                     <img class="w-100" src="assets/img/cstm/slambulance.jpg" alt="">
                     <div class="ca-project-hover-item1">
                        <a href="project-single.html" class="ca-project-hover-item1-icon">
                           <span><img src="assets/img/icon/ca-arow-3.1.svg" alt=""></span>
                        </a>
                        <div class="ca-project-hover-item-content">
                           <h4 class="ca-project-hov-sub-title">GPS & Fuel Configuration</h4>
                           <h3 class="ca-project-hov-title"><a href="project-single.html">RDHS Matara</a></h3>
                           <!-- <p>Explore our case studies achievements<br> to see how we have transformed.</p> -->
                        </div>
                     </div>
                  </div>
               </div>

               <!-- single project item -->
               <div class="col-lg-5 col-md-6">
                  <div class="ca-single-pro-img-3 mb-30">
                     <img class="w-100" src="assets/img/cstm/ctb.webp" alt="">
                     <div class="ca-project-hover-item1">
                        <a href="project-single.html" class="ca-project-hover-item1-icon">
                           <span><img src="assets/img/icon/ca-arow-3.1.svg" alt=""></span>
                        </a>
                        <div class="ca-project-hover-item-content">
                           <h4 class="ca-project-hov-sub-title">GPS Configuration</h4>
                           <h3 class="ca-project-hov-title"><a href="project-single.html">Ceylon Transport Board</a></h3>
                           <!-- <p>Explore our case studies achievements<br> to see how we have transformed.</p> -->
                        </div>
                     </div>
                  </div>
               </div>

               <!-- single project item -->
               <div class="col-lg-6 col-md-6">
                  <div class="ca-single-pro-img-3 mb-30">
                     <img class="w-100 pro-lar-img-1" src="assets/img/cstm/ceypetco.jpg" alt="">
                     <div class="ca-project-hover-item1">
                        <a href="project-single.html" class="ca-project-hover-item1-icon">
                           <span><img src="assets/img/icon/ca-arow-3.1.svg" alt=""></span>
                        </a>
                        <div class="ca-project-hover-item-content">
                           <h4 class="ca-project-hov-sub-title">GPS Configuration</h4>
                           <h3 class="ca-project-hov-title"><a href="project-single.html">Ceylon Petroleum Corporation</a></h3>
                           <!-- <p>Explore our case studies achievements<br> to see how we have transformed.</p> -->
                        </div>
                     </div>
                  </div>
               </div>

               <!-- single project item -->
               <div class="col-lg-6 col-md-6">
                  <div class="ca-single-pro-img-3 mb-30">
                     <img class="w-100 pro-lar-img-1" src="assets/img/cstm/ctb_badulla.png" alt="">
                     <div class="ca-project-hover-item1">
                        <a href="project-single.html" class="ca-project-hover-item1-icon">
                           <span><img src="assets/img/icon/ca-arow-3.1.svg" alt=""></span>
                        </a>
                        <div class="ca-project-hover-item-content">
                           <h4 class="ca-project-hov-sub-title">GPS Configuration</h4>
                           <h3 class="ca-project-hov-title"><a href="project-single.html">Uva Transport Board</a></h3>
                           <!-- <p>Explore our case studies achievements<br> to see how we have transformed.</p> -->
                        </div>
                     </div>
                  </div>
               </div>

            </div>
         </div>
      </section>


      <!-- portfolio section end -->


      <!-- video area start -->
      <section class="video-play-section">
         <div class="container">
            <div class="ca-video-img br-7 p-relative z-index-1">
               <img class="w-100" src="assets/img/cstm/1920730.jpg" alt="">
               <a href="../watch.html" class="video-play-button popup-video">
                  <span><i class="fa-solid fa-play"></i></span>
               </a>
               <div class="ca-counter-3 p-absolute">
                  <!-- single counter area -->
                  <div class="ca-counter-area-3">
                     <h3 class="ca-counter-title text-white fnw-700 pb-12"><span class="counter">100</span>%</h3>
                     <p>GPS Tracking</p>
                  </div>
                  <!-- single counter area -->
                  <div class="ca-counter-area-3">
                     <h3 class="ca-counter-title text-white fnw-700 pb-12"><span class="counter">100</span>%</h3>
                     <p>Fuel Monitoring</p>
                  </div>
                  <!-- single counter area -->
                  <div class="ca-counter-area-3">
                     <h3 class="ca-counter-title text-white fnw-700 pb-12"><span class="counter">100</span>%</h3>
                     <p>Document Management</p>
                  </div>
               </div>
            </div>
         </div>
      </section>
      <!-- video area end -->


      <!-- working section start -->
      <div class="ca-working-section theme-black-bg-3 pt-390 pb-70">
         <div class="container">
            <div class="ca-working-section-3 ca-sec-content-3 text-center mb-60 aos-init aos-animate" data-aos="fade-up" data-aos-duration="800">
               <h5 class="ca-section-subtitle subtitle-bg-7 p-relative text-white br-50">Working Process</h5>
               <h2 class="ca-section-title theme-black-3 fnw-600 text-white pt-16">Efficient Fleet Management Process</h2>
               <p class="pt-16">Our working process is designed to deliver efficient, reliable, and tailored fleet management solutions. From the vehicle assignment to real-time monitoring, we ensure smooth operations at every step.</p>
            </div>
            <div class="row">
               <!-- working icon box -->
               <div class="col-xl-3 col-lg-4 col-md-6 mb-30">
                  <div class="ca-work-ic-box br-7 aos-init aos-animate" data-aos="fade-up" data-aos-duration="800">
                     <div class="ca-work-ic-box-img">
                        <span>
                           <img src="assets/img/icon/ca-work-1.1.svg" alt="">
                        </span>
                     </div>
                     <div class="ca-work-ic-box-content">
                        <h4 class="ca-title fnw-600 text-white pt-24 pb-16"><a href="service-single.html">Driver and Vehicle Assignment</a></h4>
                        <p>We coordinate and assign the right drivers to the vehicles, ensuring optimized usage and performance.</p>
                     </div>
                  </div>
               </div>
               <!-- working icon box -->
               <div class="col-xl-3 col-lg-4 col-md-6 mb-30">
                  <div class="ca-work-ic-box br-7 aos-init aos-animate" data-aos="fade-up" data-aos-duration="1000">
                     <div class="ca-work-ic-box-img">
                        <span>
                           <img src="assets/img/icon/ca-work-1.2.svg" alt="">
                        </span>
                     </div>
                     <div class="ca-work-ic-box-content">
                        <h4 class="ca-title fnw-600 text-white pt-24 pb-16"><a href="service-single.html">Real-Time Tracking</a></h4>
                        <p>Track the location of your fleet in real-time, ensuring that each trip is monitored efficiently.</p>
                     </div>
                  </div>
               </div>
               <!-- working icon box -->
               <div class="col-xl-3 col-lg-4 col-md-6 mb-30">
                  <div class="ca-work-ic-box br-7 aos-init aos-animate" data-aos="fade-up" data-aos-duration="1200">
                     <div class="ca-work-ic-box-img">
                        <span>
                           <img src="assets/img/icon/ca-work1.3.svg" alt="">
                        </span>
                     </div>
                     <div class="ca-work-ic-box-content">
                        <h4 class="ca-title fnw-600 text-white pt-24 pb-16"><a href="service-single.html">Route Optimization</a></h4>
                        <p>Analyze and optimize routes to minimize idle time and reduce delays, ensuring timely deliveries.</p>
                     </div>
                  </div>
               </div>
               <!-- working icon box -->
               <div class="col-xl-3 col-lg-4 col-md-6 mb-30">
                  <div class="ca-work-ic-box br-7 aos-init aos-animate" data-aos="fade-up" data-aos-duration="1400">
                     <div class="ca-work-ic-box-img">
                        <span>
                           <img src="assets/img/icon/ca-work1.4.svg" alt="">
                        </span>
                     </div>
                     <div class="ca-work-ic-box-content">
                        <h4 class="ca-title fnw-600 text-white pt-24 pb-16"><a href="service-single.html">Performance Monitoring</a></h4>
                        <p>Monitor driver and vehicle performance, ensuring each trip runs smoothly and identifying potential improvements.</p>
                     </div>
                  </div>
               </div>
            </div>
         </div>
      </div>

      <!-- working section End -->

      <!-- testimonial section start -->
      <section class="ca-testimonial3  pt-100">
         <div class="container">
            <div class="ca-testimonial-content-3 ca-sec-content-3 text-center mb-60 aos-init aos-animate" data-aos="zoom-out-down" data-aos-duration="800">
               <h5 class="ca-section-subtitle subtitle-bg-6 p-relative theme-color-3 br-50">Client Testimonials</h5>
               <h2 class="ca-section-title theme-black-3 fnw-600 pt-16 ca-text-cap">Trusted by Fleet Managers and Transporters</h2>
               <p class="pt-16">Our clients' feedback underscores our dedication to delivering seamless fleet management solutions. Read how we’ve helped businesses optimize their operations and achieve efficiency.</p>
            </div>

            <div class="row">
               <div class="ca-testimonials">
                  <div class="ca-testimonial-3">
                     <!-- Testimonial 1 -->
                     <div class="ca-testimonial-card-3 br-7">
                        <div class="ca-test-3-rating">
                           <div class="ca-ratings-3">
                              <span><i class="fa-solid fa-star"></i></span>
                              <span><i class="fa-solid fa-star"></i></span>
                              <span><i class="fa-solid fa-star"></i></span>
                              <span><i class="fa-solid fa-star"></i></span>
                              <span><i class="fa-solid fa-star"></i></span>
                           </div>
                           <div class="ca-rating-num-3">
                              <h4 class="ca-rating-title-3">(5) <span>Rating</span></h4>
                           </div>
                        </div>
                        <div class="ca-test-3-content">
                           <h4 class="ca-test-title-3">“Our logistics services helped streamline their operations.”</h4>
                           <p>We take immense pride in providing solutions that help businesses like X Transporters achieve smooth logistics operations and satisfied customers.</p>
                        </div>
                        <div class="ca-test-3-user">
                           <div class="ca-test-3-user-img">
                              <span><img src="assets/img/testimonial/ca-testi3.1.png" alt=""></span>
                           </div>
                           <div class="ca-test-3-user-name">
                              <h4 class="test-3-title"><a href="#">Tharindu Perera</a></h4>
                              <span>Managing Director - X Transporters</span>
                           </div>
                        </div>
                     </div>
                     <!-- Testimonial 2 -->
                     <div class="ca-testimonial-card-3 br-7">
                        <div class="ca-test-3-rating">
                           <div class="ca-ratings-3">
                              <span><i class="fa-solid fa-star"></i></span>
                              <span><i class="fa-solid fa-star"></i></span>
                              <span><i class="fa-solid fa-star"></i></span>
                              <span><i class="fa-solid fa-star"></i></span>
                              <span><i class="fa-solid fa-star"></i></span>
                           </div>
                           <div class="ca-rating-num-3">
                              <h4 class="ca-rating-title-3">(5) <span>Rating</span></h4>
                           </div>
                        </div>
                        <div class="ca-test-3-content">
                           <h4 class="ca-test-title-3">“Seamless logistics for industry leaders in Sri Lanka.”</h4>
                           <p>Our clients, like ABC Logistics, value our commitment to on-time deliveries and efficient solutions, providing top-notch service in the transportation sector.</p>
                        </div>
                        <div class="ca-test-3-user">
                           <div class="ca-test-3-user-img">
                              <span><img src="assets/img/testimonial/testimonial-2.1.png" alt=""></span>
                           </div>
                           <div class="ca-test-3-user-name">
                              <h4 class="test-3-title"><a href="#">Ruwan Fernando</a></h4>
                              <span>Co-Founder - ABC Logistics</span>
                           </div>
                        </div>
                     </div>
                     <!-- Testimonial 3 -->
                     <div class="ca-testimonial-card-3 br-7">
                        <div class="ca-test-3-rating">
                           <div class="ca-ratings-3">
                              <span><i class="fa-solid fa-star"></i></span>
                              <span><i class="fa-solid fa-star"></i></span>
                              <span><i class="fa-solid fa-star"></i></span>
                              <span><i class="fa-solid fa-star"></i></span>
                              <span><i class="fa-solid fa-star"></i></span>
                           </div>
                           <div class="ca-rating-num-3">
                              <h4 class="ca-rating-title-3">(5) <span>Rating</span></h4>
                           </div>
                        </div>
                        <div class="ca-test-3-content">
                           <h4 class="ca-test-title-3">“Helping Sri Lankan businesses reach new heights with logistics solutions.”</h4>
                           <p>With our services, we've helped numerous Sri Lankan businesses, like Colombo Freight Services, manage their supply chains efficiently, ensuring seamless operations.</p>
                        </div>
                        <div class="ca-test-3-user">
                           <div class="ca-test-3-user-img">
                              <span><img src="assets/img/testimonial/ca-testi3.2.png" alt=""></span>
                           </div>
                           <div class="ca-test-3-user-name">
                              <h4 class="test-3-title"><a href="#">Saman Perera</a></h4>
                              <span>Founder - Colombo Freight Services</span>
                           </div>
                        </div>
                     </div>
                     <!-- Testimonial 4 -->
                     <div class="ca-testimonial-card-3 br-7">
                        <div class="ca-test-3-rating">
                           <div class="ca-ratings-3">
                              <span><i class="fa-solid fa-star"></i></span>
                              <span><i class="fa-solid fa-star"></i></span>
                              <span><i class="fa-solid fa-star"></i></span>
                              <span><i class="fa-solid fa-star"></i></span>
                              <span><i class="fa-solid fa-star"></i></span>
                           </div>
                           <div class="ca-rating-num-3">
                              <h4 class="ca-rating-title-3">(5) <span>Rating</span></h4>
                           </div>
                        </div>
                        <div class="ca-test-3-content">
                           <h4 class="ca-test-title-3">“Logistics solutions that streamline operations and drive success.”</h4>
                           <p>Our work with businesses like Jaya Transport is a testament to our ability to provide high-quality logistics services, making sure deliveries are on time and without hassle.</p>
                        </div>
                        <div class="ca-test-3-user">
                           <div class="ca-test-3-user-img">
                              <span><img src="assets/img/testimonial/ca-testi3.1.png" alt=""></span>
                           </div>
                           <div class="ca-test-3-user-name">
                              <h4 class="test-3-title"><a href="#">Janaka Silva</a></h4>
                              <span>Operations Manager - Jaya Transport</span>
                           </div>
                        </div>
                     </div>
                  </div>
               </div>
            </div>

         </div>
      </section>
      <!-- testimonial section end -->

      <!-- contact-section start -->
      <section class="contact-3-area cream-bg-3 pt-100 pb-70">
         <div class="container">
            <div class="ca-blog-content-3 ca-sec-content-3 text-center mb-60 aos-init aos-animate" data-aos="zoom-out-down" data-aos-duration="1000">
               <h5 class="ca-section-subtitle subtitle-bg-6 p-relative theme-color-3 br-50">Get in Touch</h5>
               <h2 class="ca-section-title theme-black-3 fnw-600 pt-16 ca-text-cap">Partnered with Industry Leaders</h2>
               <p class="pt-16">Explore how our fleet management solutions can optimize your operations, improve vehicle performance, and ensure the safety and efficiency of your fleet.</p>
            </div>

            <div class="row align-items-center">
               <div class="col-xl-6 mb-30">
                  <div class="ca-contact-from w-bg ca-contact-from-3 aos-init aos-animate" data-aos="fade-right" data-aos-duration="1200">
                     <div class="ca-contact-content-3">
                        <h4 class="ca-contact-title-2 theme-black-2 fnw-600">Send Us A Message</h4>
                        <p class="pt-16 pb-24">As a fellow small business owner, we know the fulfillment that an a best to comes from running & own business contact our service to Cargon.</p>
                     </div>
                     <form action="#">
                        <div class="row">
                           <div class="col-md-6 mb-20">
                              <input type="text" placeholder="First Name">
                           </div>
                           <div class="col-md-6 mb-20">
                              <input type="text" placeholder="Last Name">
                           </div>
                           <div class="col-md-6 mb-20">
                              <input type="tel" placeholder="Phone Number">
                           </div>
                           <div class="col-md-6 mb-20">
                              <input type="email" placeholder="Email Address">
                           </div>
                           <div class="col-md-12 mb-20">
                              <select class="nice-select wide ca-select">
                                 <option data-display="Service Type">General</option>
                                 <option value="1">GPS Configuration</option>
                                 <option value="2">Fuel Monitoring</option>
                                 <option value="3">GPS + Fuel Configuration</option>
                              </select>
                           </div>
                           <div class="col-md-12 mb-20">
                              <textarea name="message" id="message" placeholder="Message"></textarea>
                           </div>
                           <div class="submit-btn">
                              <button class="ca-btn-primary-3 theme-bg-3 text-white br-50" type="submit" value="submit"> Send Message<span><i class="fa-solid fa-angle-right"></i></span></button>
                           </div>
                        </div>
                     </form>
                  </div>
               </div>
               <div class="col-xl-6 mb-30">
                  <div class="ca-form-loca-3 ml-50 aos-init aos-animate" data-aos="fade-left" data-aos-duration="1400">
                     <!-- single box item -->
                     <div class="ca-location-3 mb-20">
                        <div class="ca-location-icbox">
                           <div class="ca-location-icbox-img">
                              <span><img src="assets/img/icon/ca-location3.1.svg" alt=""></span>
                           </div>
                           <div class="ca-location-icbox-text">
                              <h4 class="ca-title fnw-600 theme-black-3 pb-12">Contact Us</h4>
                              <p>17 H K Dharmadasa Mawatha, Colombo 00200<br>Sri Lanka</p>
                           </div>
                        </div>
                     </div>
                     <!-- single box item -->
                     <div class="ca-location-3 mb-20">
                        <div class="ca-location-icbox">
                           <div class="ca-location-icbox-img">
                              <span><img src="assets/img/icon/ca-location3.2.svg" alt=""></span>
                           </div>
                           <div class="ca-location-icbox-text">
                              <h4 class="ca-title fnw-600 theme-black-3 pb-12">Call or Text</h4>
                              <a href="tel:0112 399 399">0112 399 399</a>
                           </div>
                        </div>
                     </div>
                     <!-- single box item -->
                     <div class="ca-location-3 mb-20">
                        <div class="ca-location-icbox">
                           <div class="ca-location-icbox-img">
                              <span><img src="assets/img/icon/ca-location3.3.svg" alt=""></span>
                           </div>
                           <div class="ca-location-icbox-text">
                              <h4 class="ca-title fnw-600 theme-black-3 pb-12">Send Email</h4>
                              <a href="mailto:infotransportlogistics@gmail.com">info@fleethub.lk</a>
                           </div>
                        </div>
                     </div>
                  </div>
               </div>
            </div>
         </div>
      </section>
      <!-- contact-section end -->

      <!-- blog section start -->
      <section class="ca-blog pt-100 pb-70">
         <div class="container">
            <div class="ca-blog-content-3 ca-sec-content-3 text-center mb-60 aos-init aos-animate" data-aos="fade-up" data-aos-duration="800">
               <h5 class="ca-section-subtitle subtitle-bg-6 p-relative theme-color-3 br-50">Our Blog</h5>
               <h2 class="ca-section-title theme-black-3 fnw-600 pt-16 ca-text-cap"> Best Practices and Strategies</h2>
               <p class="pt-16">Gain insights into effective warehouse management strategies that<br> maximize space, improve accuracy, and boost productivity. </p>
            </div>
            <div class="row">
               <!-- single-blog-item -->
               <div class="col-xl-4 col-md-6 mb-30">
                  <div class="ca-team-box ca-blog-box-3 cream-bg-3 br-7 fix p-relative z-index-1 aos-init aos-animate" data-aos="fade-right" data-aos-duration="800">
                     <div class="ca-team-img">
                        <a href="blog-single.html"><img class="w-100" src="assets/img/blog/ca-blog-1.2.png" alt=""></a>
                     </div>
                     <div class="ca-blog-date-3">
                        <a href="#" class="blg-date-3">March 21, 2024</a>
                     </div>
                     <div class="ca-blog-box-content ca-blog-box-content-3">
                        <div class="ca-b-meta">
                           <!-- blog meta box -->
                           <a href="#" class="ca-blog-meta ca-blog-meta-3">
                              <div class="ca-meta-icon">
                                 <span><img src="assets/img/icon/user-1.1.svg" alt=""></span>
                              </div>
                              <div class="ca-meta-title">
                                 <span>Henry Nicolls</span>
                              </div>
                           </a>
                           <!-- blog meta box -->
                           <a href="#" class="ca-blog-meta ca-blog-meta-3">
                              <div class="ca-meta-icon">
                                 <span><img src="assets/img/icon/tag-1.1.svg" alt=""></span>
                              </div>
                              <div class="ca-meta-title">
                                 <span>Transport & Logistics</span>
                              </div>
                           </a>
                        </div>
                        <h4 class="ca-blog-title ca-blog-title-3 fnw-600"><a href="blog-single.html">Optimizing Last-Mile Delivery: Strategies for Success</a></h4>
                        <p class="pt-16 pb-18">Delve into the challenges of last-mile delivery <br>and explore strategies to overcome them.</p>
                        <div class="blog-3-rearmore">
                           <a href="blog-single.html" class="read-more3">Read More <span><i class="fa-solid fa-angle-right"></i></span></a>
                        </div>
                     </div>
                  </div>
               </div>
               <!-- single-blog-item -->
               <div class="col-xl-4 col-md-6 mb-30">
                  <div class="ca-team-box ca-blog-box-3 cream-bg-3 br-7 fix p-relative z-index-1  aos-init aos-animate" data-aos="fade-up" data-aos-duration="1000">
                     <div class="ca-team-img">
                        <a href="blog-single.html"><img class="w-100" src="assets/img/blog/ca-blog-1.3.png" alt=""></a>
                     </div>
                     <div class="ca-blog-date-3">
                        <a href="#" class="blg-date-3">March 20, 2024</a>
                     </div>
                     <div class="ca-blog-box-content ca-blog-box-content-3">
                        <div class="ca-b-meta">
                           <!-- blog meta box -->
                           <a href="#" class="ca-blog-meta ca-blog-meta-3">
                              <div class="ca-meta-icon">
                                 <span><img src="assets/img/icon/user-1.1.svg" alt=""></span>
                              </div>
                              <div class="ca-meta-title">
                                 <span>Henry Nicolls</span>
                              </div>
                           </a>
                           <!-- blog meta box -->
                           <a href="#" class="ca-blog-meta ca-blog-meta-3">
                              <div class="ca-meta-icon">
                                 <span><img src="assets/img/icon/tag-1.1.svg" alt=""></span>
                              </div>
                              <div class="ca-meta-title">
                                 <span>Transport & Logistics</span>
                              </div>
                           </a>
                        </div>
                        <h4 class="ca-blog-title ca-blog-title-3 fnw-600"><a href="blog-single.html">Handling Project Cargo: Expert<br> Tips and Strategies</a></h4>
                        <p class="pt-16 pb-18">Get expert tips on managing project cargo <br> logistics. From planning and coordination.</p>
                        <div class="blog-3-rearmore">
                           <a href="blog-single.html" class="read-more3">Read More <span><i class="fa-solid fa-angle-right"></i></span></a>
                        </div>
                     </div>
                  </div>
               </div>
               <!-- single-blog-item -->
               <div class="col-xl-4 col-md-6 mb-30">
                  <div class="ca-team-box ca-blog-box-3 cream-bg-3 br-7 fix p-relative z-index-1 aos-init aos-animate" data-aos="fade-left" data-aos-duration="1200">
                     <div class="ca-team-img">
                        <a href="blog-single.html"> <img class="w-100" src="assets/img/blog/ca-blog-1.1.png" alt=""></a>
                     </div>
                     <div class="ca-blog-date-3">
                        <a href="#" class="blg-date-3">March 18, 2024</a>
                     </div>
                     <div class="ca-blog-box-content ca-blog-box-content-3">
                        <div class="ca-b-meta">
                           <!-- blog meta box -->
                           <a href="#" class="ca-blog-meta ca-blog-meta-3">
                              <div class="ca-meta-icon">
                                 <span><img src="assets/img/icon/user-1.1.svg" alt=""></span>
                              </div>
                              <div class="ca-meta-title">
                                 <span>Henry Nicolls</span>
                              </div>
                           </a>
                           <!-- blog meta box -->
                           <a href="#" class="ca-blog-meta ca-blog-meta-3">
                              <div class="ca-meta-icon">
                                 <span><img src="assets/img/icon/tag-1.1.svg" alt=""></span>
                              </div>
                              <div class="ca-meta-title">
                                 <span>Transport & Logistics</span>
                              </div>
                           </a>
                        </div>
                        <h4 class="ca-blog-title ca-blog-title-3 fnw-600"><a href="blog-single.html">The Importance of Reliable Freight Forwarding Services</a></h4>
                        <p class="pt-16 pb-18">Learn practical strategies for optimizing your<br> supply chain operations, improve delivery.</p>
                        <div class="blog-3-rearmore">
                           <a href="blog-single.html" class="read-more3">Read More <span><i class="fa-solid fa-angle-right"></i></span></a>
                        </div>
                     </div>
                  </div>
               </div>
            </div>
         </div>
      </section>
      <!-- blog section end -->

   </main>
   <!-- footer section start-->
   <?php
   include('./includes/footer.php');
   include('./includes/footerscripts.php');
   ?>
   <!-- footer section end-->

</body>

</html>