<?php

/**
 * Load woocommerce styles follow theme skin actived
 *
 * @static
 * @access public
 * @since Wpopal_Themer 1.0
 */

/// put your code here 

add_action('init', 'allegro_element_kingcomposer_map', 99 );

function allegro_element_kingcomposer_map(){
	global $kc;
	$maps = array();

	$maps['element_faq'] =array(
		'name' =>esc_html__('FAQ', 'allegro'),
		'icon' => 'sl-paper-plane',
		'class' => '',
		'description' => '',
		'category' =>esc_html__('Elements', 'allegro'),
		'params' => array(
			array(
				'type' => 'textfield',
				'label' =>esc_html__('Title', 'allegro'),
				'name' => 'title',
				'value' => '',
				'admin_label' => true
			),
			array(
				'type'			=> 'group',
				'label'			=>esc_html__('Options', 'allegro'),
				'name'			=> 'options',
				'description'	=>esc_html__( 'Repeat this fields with each item created, Each item corresponding element.', 'allegro' ),
				'options'		=> array('add_text' =>esc_html__('Add new item', 'allegro')),
				'value' => '',
				'params' => array(
					array(
						"type"        => "textfield",
						"label"       => esc_html__("Question", 'allegro'),
						"name"        => "question",
						"value"       => '',
						"admin_label" => true
					),
					array(
						"type"        => "textarea",
						"label"       => esc_html__("Answer", 'allegro'),
						"name"        => "answer",
						"value"       => '',
						"admin_label" => true
					),
				),
			),
		)
	);

	$option_menu  = array(); 
	if( is_admin() ){
		$menus = wp_get_nav_menus( array( 'orderby' => 'name' ) );
	    $option_menu = array('---Select Menu---'=>'');
	    foreach ($menus as $menu) {
	    	$option_menu[$menu->slug]=$menu->name;
	    }
	}    


	//Add element Vertical menu
	$maps['element_menuvertical'] =array(
		'name' =>esc_html__("Menu Vertical", 'allegro'),
		'icon' => 'sl-paper-plane',
		"class" => "",
		"description" => 'Set up menu vertical for page',
		"category" =>esc_html__('Elements', 'allegro'),
		"params" => array(
			array(
				"type" => "textfield",
				"label" =>esc_html__("Title", 'allegro'),
				"name" => "title",
				"value" => '',
			),

			array(
				'type' => 'select',
				'label' =>esc_html__( 'Menu select', 'allegro' ),
				'name' => 'menu',
				"options" => $option_menu,
				'description' =>esc_html__('Select menu.', 'allegro'),
			),

			array(
				"type" => "select",
				"label" => esc_html__("Position", 'allegro'),
				'name' => 'position',
				"options" => array(
					'left'=>'left',	
					'right'=>'right'
				),
				"description" => esc_html__("Postion Menu Vertical.", 'allegro')
			),
			array(
				"type" => "textfield",
				"label" => esc_html__("Extra class name", 'allegro'),
				"name" => "el_class",
				"description" => esc_html__("If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.", 'allegro')
			),
		)
	);

	

	 

	$maps = apply_filters( 'allegro_element_kingcomposer_map', $maps ); 
    $kc->add_map( $maps );
} // end class

// add map param
add_action('init', 'allegro_kc_single_image_add_map_param', 99 );
function allegro_kc_single_image_add_map_param(){
    global $kc;
    $kc->add_map_param(
     'element_blog_posts',
        array(
		    'name' => 'rows_count',
		    'label' => 'Rows column',
		    'type' => 'number_slider',
		    'options' => array(
				'min' => 1,
				'max' => 4,
				'unit' => '',
				'show_input' => true
			),

			"admin_label" => true,
			'description' => 'Display number rows of post'
		   )
 	, 2);

	$kc->add_map_param(
		'element_featured_box',
		array(
			'name' => 'show_image',
			'label' => 'Show image ?',
			'type' => 'checkbox',
			'description' => esc_html__('Show Image.', 'allegro'),
			'value' => 'yes',
			'options' => array(
				'yes' => 'Yes, Please!'
			),
		)
	, 5);

	$kc->add_map_param(
		'element_featured_box',
		array(
			"type" => "attach_image",
			"label" => esc_html__("Photo", 'allegro'),
			"name" => "featured_image",
			"value" => '',
			'description' => ''
		)
	, 5);
}



//add element Products
if( in_array( 'woocommerce/woocommerce.php', apply_filters( 'active_plugins', get_option( 'active_plugins' ) ) ) ){
	add_action('init', 'allegro_kc_woo_carousel_products_add_map_param', 99 );
}
function allegro_kc_woo_carousel_products_add_map_param(){
	global $kc;

	$product_layouts = array(
    	'grid' 	=> esc_html__('Grid', 'allegro') ,
    	'list' => esc_html__('List', 'allegro') 
	);


	$kc->remove_map_param( 'woo_carousel_products', 'columns');

	$kc->add_map_param(
		'woo_carousel_products',
			array(
		        'name' => 'position',
		        'label' => esc_html__( 'Product main position' ,'allegro' ),
		        'type' => 'select',
		        'value' => 'left',
		        'options' => array(
		            'left'   	=> esc_html__( 'Left', 'allegro' ),
		            'right'   	=> esc_html__( 'Right', 'allegro' ),
		            'top'   	=> esc_html__( 'top', 'allegro' ),

		        ),
		        'description' => 'Select position for main product'
		    ),
	5);

	$kc->add_map_param(
		'woo_grid_products',
			array(
				"type" => "select",
				"label" => esc_html__("Style",'allegro'),
				"name" => "style",
				"options" => $product_layouts
			)
		, 3);

	$kc->add_map(
	         array(
	            'woo_shop_category' => array(
	                'name' => 'Shop by Category',
	                'description' => esc_html__('Display Shop Category', 'allegro'),
	                'icon' => 'sl-paper-plane',
	                'category' => 'Woocommerce',

	                "params" => array(
			    
				    	 		array(
									"type" => "textfield",
									"label" => esc_html__("Title", 'allegro'),
									"name" => "title",
									"value" => 'Shop by Category',
									"admin_label" => true
								),
								array(
							        'name' => 'number_cats',
							        'label' => esc_html__( 'Number categories' ,'allegro' ),
							        'type' => 'number_slider',
							        'value' => 8,
							        'options' => array(
							            'min' => 1,
							            'max' => 20,
							            'unit' => '',
							            'show_input' => true
							        ),
							        'description' => 'Display number of category'
							    ),
								array(
							        'name' => 'columns',
							        'label' => esc_html__( 'Grid Column' ,'allegro' ),
							        'type' => 'number_slider',
							        'value' => 6,
							        'options' => array(
							            'min' => 1,
							            'max' => 6,
							            'unit' => '',
							            'show_input' => true
							        ),
							        'description' => 'Display culumn of category'
							    ),

								array(
									"type"        => "textfield",
									"label"     => esc_html__("Extra class name",'allegro'),
									"name"  => "el_class",
									"description" => esc_html__("If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.",'allegro')
								)
			   		) 
	              		 
	        ) )
	    );



	$kc->add_map(
	         array(
	            'woo_carousel_products_v2' => array(
	                'name' => 'Carousel Products 2',
	                'description' => esc_html__('Display Bestseller, Latest, Most Review ... in grid', 'allegro'),
	                'icon' => 'sl-paper-plane',
	                'category' => 'Woocommerce',

	                'params' => array(
	                    array(
	                        'name' => 'type',
	                        'label' => 'Product Type',
	                        'type' => 'select',
	                        'admin_label' => true,
                            'options' => array(  // THIS FIELD REQUIRED THE PARAM OPTIONS
						        'recent_products'   	=> esc_html__( 'Recent Products', 'allegro' ),
						        'sale_products' 		=> esc_html__( 'Sale Products', 'allegro' ),
						        'featured_products' 	=> esc_html__( 'Featured Products', 'allegro' ),
						        'best_selling_products'	=> esc_html__( 'Best Selling Products', 'allegro' ),
						        'products'				=> esc_html__( 'Products', 'allegro' ),
						    )
	                    ),
                        array(
							'type'           => 'autocomplete',
							'label'          => esc_html__( 'Select Category', 'allegro' ),
							'name'           => 'woocategory',
							'description'    => esc_html__( 'Select Category to display', 'allegro' ),
							'admin_label'    => true,
							'options' => array( 'taxonomy' => 'product_cat' )

	                    ),

	                    array(
	                        'name' => 'number_post',
	                        'label' => 'Number post show',
	                        'type' => 'number_slider',
	                        'options' => array(
	                            'min' => 1,
	                            'max' => 24,
	                            'unit' => '',
	                            'show_input' => true
	                        ),
	                        'description' => 'Display number of post'
	                    ),
	                    array(
	                        'name' => 'columns',
	                        'label' => esc_html__( 'Grid Column' ,'allegro' ),
	                        'type' => 'number_slider',
	                        'options' => array(
	                            'min' => 1,
	                            'max' => 6,
	                            'unit' => '',
	                            'show_input' => true
	                        ),
	                        'description' => 'Display number of post'
	                    ),
	                )
	            )
	        )
	    );
		///

	
}


