<?php

function allegro_fnc_import_remote_demos() { 
	return array(
		'allegro' => array( 
			'name' 		=> 'allegro', 
		 	'source'	=> 'http://wpsampledemo.com/allegro/allegro.zip',
		 	'preview'   => 'http://wpsampledemo.com/allegro/screenshot.png'
		),
	);
}

add_filter( 'wpopal_themer_import_remote_demos', 'allegro_fnc_import_remote_demos' );



function allegro_fnc_import_theme() {
	return 'allegro';
}
add_filter( 'wpopal_themer_import_theme', 'allegro_fnc_import_theme' );

function allegro_fnc_import_demos() {
	$folderes = glob( get_template_directory() .'/inc/import/*', GLOB_ONLYDIR ); 

	$output = array(); 

	foreach( $folderes as $folder ){
		$output[basename( $folder )] = basename( $folder );
	}
 	
 	return $output;
}
add_filter( 'wpopal_themer_import_demos', 'allegro_fnc_import_demos' );

function allegro_fnc_import_types() {
	return array(
			'all'          => esc_html__( 'All' , 'allegro' ),
			'content'      =>  esc_html__( 'Content', 'allegro' ),
			'widgets'      => esc_html__( 'Widgets', 'allegro' ) ,
			'page_options' => esc_html__( 'Theme + Page Options', 'allegro' ) ,
			'menus'        => esc_html__( 'Menus', 'allegro' ),
			'rev_slider'   => esc_html__( 'Revolution Slider', 'allegro' ),
			'vc_templates' => esc_html__( 'VC Templates', 'allegro' )
		);
}
add_filter( 'wpopal_themer_import_types', 'allegro_fnc_import_types' );

/**
 * Matching and resizing images with url.
 *
 *  $ouput = array(
 *        'allowed' => 1, // allow resize images via using GD Lib php to generate image
 *        'height'  => 900,
 *        'width'   => 800,
 *        'file_name' => 'blog_demo.jpg'
 *   ); 
 */
function allegro_import_attachment_image_size( $url ){  

   $name = basename( $url );   
 
   $ouput = array(
         'allowed' => 0
   );     
   
   if( preg_match("#product#", $name) ) {
      $ouput = array(
         'allowed' => 1,
         'height'  => 1027,
         'width'   => 1000,
         'file_name' => 'product_demo.jpg'
      ); 
   }
   elseif( preg_match("#blog#", $name) ){
      $ouput = array(
         'allowed' => 1,
         'height'  => 690,
         'width'   => 1280,
         'file_name' => 'blog_demo.jpg'
      ); 
   }
   return $ouput;
}

add_filter( 'pbrthemer_import_attachment_image_size', 'allegro_import_attachment_image_size' , 1 , 999 );