<?php
/**
 * Implement Custom Header functionality for allegro
 *
 * @package WpOpal
 * @subpackage allegro
 * @since allegro 1.0
 */

/**
 * Set up the WordPress core custom header settings.
 *
 * @since allegro 1.0
 *
 * @uses allegro_fnc_header_style()
 * @uses allegro_fnc_admin_header_style()
 * @uses allegro_fnc_admin_header_image()
 */
function allegro_fnc_custom_header_setup() {
	/**
	 * Filter allegro custom-header support arguments.
	 *
	 * @since allegro 1.0
	 *
	 * @param array $args {
	 *     An array of custom-header support arguments.
	 *
	 *     @type bool   $header_text            Whether to display custom header text. Default false.
	 *     @type int    $width                  Width in pixels of the custom header image. Default 1260.
	 *     @type int    $height                 Height in pixels of the custom header image. Default 240.
	 *     @type bool   $flex_height            Whether to allow flexible-height header images. Default true.
	 *     @type string $admin_head_callback    Callback function used to style the image displayed in
	 *                                          the Appearance > Header screen.
	 *     @type string $admin_preview_callback Callback function used to create the custom header markup in
	 *                                          the Appearance > Header screen.
	 * }
	 */
	add_theme_support( 'custom-header', apply_filters( 'allegro_fnc_custom_header_args', array(
		'default-text-color'     => 'fff',
		'width'                  => 1260,
		'height'                 => 240,
		'flex-height'            => true,
		'wp-head-callback'       => 'allegro_fnc_header_style',
		'admin-head-callback'    => 'allegro_fnc_admin_header_style',
		'admin-preview-callback' => 'allegro_fnc_admin_header_image',
	) ) );
}
add_action( 'after_setup_theme', 'allegro_fnc_custom_header_setup' );

if ( ! function_exists( 'allegro_fnc_header_style' ) ) :
/**
 * Styles the header image and text displayed on the blog
 *
 * @see allegro_fnc_custom_header_setup().
 *
 */
function allegro_fnc_header_style() {  
    ?>
    <style type="text/css" id="allegro-header-css">
        
        <?php
        $topbar_bg = get_option('allegro_color_topbar_bg');
        if( !empty($topbar_bg) && preg_match("#\##", $topbar_bg) ) : ?>
            #opal-topbar, .opal-topbar.style-2 .container{
                background-color:<?php echo trim($topbar_bg); ?>;
            }
        <?php endif; ?>

        <?php
        $topbar_color = get_option('allegro_color_topbar_color');
        if( !empty($topbar_color) && preg_match("#\##", $topbar_color) ) : ?>
            #opal-topbar a, #opal-topbar{
                color:<?php echo trim($topbar_color); ?>;
            }
        <?php endif; ?>

        <?php
        $topbar_hover_color = get_option('allegro_color_topbar_hover_color');
        if( !empty($topbar_hover_color) && preg_match("#\##", $topbar_hover_color) ) : ?>
            #opal-topbar a:hover{
                color:<?php echo trim($topbar_hover_color); ?>;
            }
        <?php endif; ?>

        <?php
        $header_bg = get_option('allegro_color_header_bg');
        if( !empty($header_bg) && preg_match("#\##", $header_bg) ) : ?>
            #opal-masthead .header-main, #opal-masthead .header-main.style-2 .container{
                background-color:<?php echo trim($header_bg); ?>;
            }
        <?php endif; ?>

        <?php
        $header_color = get_option('allegro_color_header_color');
        if( !empty($header_color) && preg_match("#\##", $header_color) ) : ?>
            #cart .mini-cart .amount, .opal-btn-wishlist, #cart .mini-cart i{
                color:<?php echo trim($header_color); ?>;
            }
        <?php endif; ?>

        <?php
        $btn_search_bg = get_option('allegro_color_btn_search_bg');
        if( !empty($btn_search_bg) && preg_match("#\##", $btn_search_bg) ) : ?>
            .toggle-overlay-container .search-box .input-group-btn{
                background-color:<?php echo trim($btn_search_bg); ?>;
            }
            .toggle-overlay-container .search-box .input-group-btn{
                border-color:<?php echo trim($btn_search_bg); ?>;
            }
        <?php endif; ?>

        <?php
        $keep_header_bg = get_option('allegro_color_keep_header_bg');
        if( !empty($keep_header_bg) && preg_match("#\##", $keep_header_bg) ) : ?>
            #opal-masthead .has-sticky.keeptop{
                background-color:<?php echo trim($keep_header_bg); ?>;
            }
        <?php endif; ?>

        <?php
        $menu_bg = get_option('allegro_color_menu_bg');
        if( !empty($menu_bg) && preg_match("#\##", $menu_bg) ) : ?>
            #opal-mainmenu,.opal-mainmenu.style-2 .container{
                background-color:<?php echo trim($menu_bg); ?>;
            }
        <?php endif; ?>

        <?php
        $menu_color = get_option('allegro_color_menu_color');
        if( !empty($menu_color) && preg_match("#\##", $menu_color) ) : ?>
            .navbar-mega .navbar-nav > li > a, .navbar-mega .navbar-nav > li > a .caret{
                color:<?php echo trim($menu_color); ?>;
            }
        <?php endif; ?>

        <?php
        $menu_hover_bg = get_option('allegro_color_menu_hover_bg');
        if( !empty($menu_hover_bg) && preg_match("#\##", $menu_hover_bg) ) : ?>
            .navbar-mega .navbar-nav > li.active > a, .navbar-mega .navbar-nav > li > a:hover, .navbar-mega .navbar-nav > li > a:focus{
                background-color:<?php echo trim($menu_hover_bg); ?>;
            }
        <?php endif; ?>

        <?php
        $menu_hover_color = get_option('allegro_color_menu_hover_color');
        if( !empty($menu_hover_color) && preg_match("#\##", $menu_hover_color) ) : ?>
            .navbar-mega .navbar-nav li.active > a, .navbar-mega .navbar-nav > li > a:hover, .navbar-mega .navbar-nav > li > a:focus,.navbar-mega .navbar-nav > li > a:hover .caret, .navbar-mega .navbar-nav > li > a:focus .caret,.navbar-mega .navbar-nav li.active > a .caret{
                color:<?php echo trim($menu_hover_color); ?>;
            }
        <?php endif; ?>

        <?php
        $footer_bg = get_option('allegro_color_footer_bg');
        if( !empty($footer_bg) && preg_match("#\##", $footer_bg) ) : ?>
            .opal-footer{
                background-color:<?php echo trim($footer_bg); ?>;
            }
        <?php endif; ?>

        <?php
        $footer_color = get_option('allegro_color_footer_color');
        if( !empty($footer_color) && preg_match("#\##", $footer_color) ) : ?>
            .opal-footer, .opal-footer a, .opal-footer a span, .opal-footer .text{
                color:<?php echo trim($footer_color); ?>;
            }
        <?php endif; ?>

        <?php
        $heading_color = get_option('allegro_color_heading_color');
        if( !empty($heading_color) && preg_match("#\##", $heading_color) ) : ?>
            .opal-footer .widget .widget-title, .opal-footer .widget .widgettitle{
                color:<?php echo trim($heading_color); ?>;
            }
        <?php endif; ?>

        <?php
        $newsletter_bg = get_option('allegro_color_newsletter_bg');
        if( !empty($newsletter_bg) && preg_match("#\##", $newsletter_bg) ) : ?>
            .widget_mc4wp_form_widget .input-group .form-control{
                background-color:<?php echo trim($newsletter_bg); ?>;
            }
        <?php endif; ?>

        <?php
        $copyright_bg = get_option('allegro_color_copyright_bg');
        if( !empty($copyright_bg) && preg_match("#\##", $copyright_bg) ) : ?>
            .opal-copyright{
                background-color:<?php echo trim($copyright_bg); ?>;
            }
        <?php endif; ?>

        <?php
        $copyright_color = get_option('allegro_color_copyright_color');
        if( !empty($copyright_color) && preg_match("#\##", $copyright_color) ) : ?>
            .opal-copyright{
                color:<?php echo trim($copyright_color); ?>;
            }
        <?php endif; ?>

    </style>
    <?php
    /* OpalTool: inject code */
    
    $allegro_maincolor_primary_color = get_option('allegro_maincolor_primary_color');
    if( (!empty($allegro_maincolor_primary_color) && preg_match("#\##", $allegro_maincolor_primary_color)) || is_customize_preview() ) : ?>
        <?php if(is_customize_preview()) $allegro_maincolor_primary_color = $allegro_maincolor_primary_color?$allegro_maincolor_primary_color:'__none_color__'; ?>
        <style type="text/css" id="allegro_maincolor_primary_color-header-css"<?php if(is_customize_preview()){ ?> data-color="<?php echo esc_attr($allegro_maincolor_primary_color); ?>"<?php } ?>>
            

.text-primary,.btn.focus,.btn:focus,.btn:hover,.btn-default,.btn-default.active,.btn-default.active.focus,.btn-default.active:focus,.btn-default.active:hover,.btn-default.focus,.btn-default:active,.btn-default:active.focus,.btn-default:active:focus,.btn-default:active:hover,.btn-default:focus,.btn-default:hover,.open>.btn-default.dropdown-toggle,.open>.btn-default.dropdown-toggle.focus,.open>.btn-default.dropdown-toggle:focus,.open>.btn-default.dropdown-toggle:hover,.btn-primary .badge,.nav-tabs>li.active>a,.nav-tabs>li.active>a:focus,.nav-tabs>li.active>a:hover,.breadcrumb>.active,a.label:focus,a.label:hover,.panel-primary>.panel-heading .badge,#opal-topbar .info>div.telephone,#opal-topbar a:hover,.active-mobile .btn-search:hover .fa,.box-user span:hover,.opal-breadscrumb .breadcrumb a:hover,.opal-breadscrumb .breadcrumb li:last-child,.opal-footer .widget ul li:hover a,.opal-footer .email,.opal-footer a:hover,.opal-copyright a:active,.opal-copyright a:focus,.opal-copyright a:hover,.widget_archive a:before,.widget_categories a:before,.widget_layered_nav a:before,.widget_recent_comments a:first-child:before,.widget_recent_entries a:before,.widget_recent_comments .comment-author-link,.widget.widget_categories ul li a:hover,.widget.widget_layered_nav_filters ul li a:hover,.widget.widget_layered_nav ul li a:hover,.widget.widget_pages ul li a:hover,.widget_nav_menu ul li a:hover,.widget_recent_entries .post-date,.widget_wpopal_recent_post .post-stick-layout .item-post.media .post-date,.navbar-mega .navbar-nav li.open>a,.navbar-mega .navbar-nav li a:active,.navbar-mega .navbar-nav li a:focus,.navbar-mega .navbar-nav li a:hover,.navbar-mega .navbar-nav>li .dropdown-menu li a:hover,.navbar-mega .navbar-nav>li .sub-menu li a:hover,.navbar-topmenu>li.active a,.vertical-menu.navbar-collapse .navbar-nav>li:focus>a,.vertical-menu.navbar-collapse .navbar-nav>li:focus>a .caret:before,.vertical-menu.navbar-collapse .navbar-nav>li:focus>a:before,.vertical-menu.navbar-collapse .navbar-nav>li:hover>a,.vertical-menu.navbar-collapse .navbar-nav>li:hover>a .caret:before,.vertical-menu.navbar-collapse .navbar-nav>li:hover>a:before,.vertical-menu.navbar-collapse .navbar-nav li a .caret:before,.vertical-menu.navbar-collapse .navbar-nav li a:focus,.vertical-menu.navbar-collapse .navbar-nav li a:hover,.vertical-menu.navbar-collapse .navbar-nav li .dropdown-menu .widget-title,.vertical-menu.navbar-collapse .navbar-nav li:focus>a .caret:before,.vertical-menu.navbar-collapse .navbar-nav li:hover>a .caret:before,.vertical-menu.navbar-collapse .widget_nav_menu ul li a:hover,.pagination span.current,.author a:hover,.comments-link a:hover,.edit-link a:hover,.entry-category a:hover,.entry-date a:hover,.meta-sep a:hover,.entry-content .edit-link a,article .entry-title a:hover,article .post-content span a,article .post-content a,.comments .comment-author,.comments a,.single-portfolio .format-infomation .single-body .portfolio-info a:hover,.ih-item .info h3:hover,.btn-inverse-light,.btn-outline.btn-primary,.btn-outline.btn-success,.btn-inverse.btn-primary:hover,.btn-inverse.btn-success:hover,.pricing.pricing-v2.pricing-highlight .btn-block:active,.pricing.pricing-v2.pricing-highlight .btn-block:focus,.pricing.pricing-v2.pricing-highlight .btn-block:hover,.pricing.pricing-v3.pricing-highlight .btn-block:active,.pricing.pricing-v3.pricing-highlight .btn-block:focus,.pricing.pricing-v3.pricing-highlight .btn-block:hover,.blogv1 .comments-link a:hover,.blogv1 .readmore a:hover,.scrollup,.style .icon,.kc_wrap_twitter .result_twitter_feed .screen_name,.kc_wrap_twitter .result_twitter_feed a,.kc_wrap_twitter .result_twitter_feed a:hover,#accordion .panel a i.fa-minus,.category-tabs .widget_nav_menu ul li:hover a,.testimonials .testimonials-body .testimonials-name,.kc-pie-chart-wrapper .pie_chart_text h3,.btn-offcanvas:hover,.offcanvas-showright .showright .fa,.navbar-offcanvas ul#main-menu-offcanvas li.active>a,.text-primary,.btn.focus,.btn:focus,.btn:hover,.btn-default,.btn-default.active,.btn-default.active.focus,.btn-default.active:focus,.btn-default.active:hover,.btn-default.focus,.btn-default:active,.btn-default:active.focus,.btn-default:active:focus,.btn-default:active:hover,.btn-default:focus,.btn-default:hover,.open>.btn-default.dropdown-toggle,.open>.btn-default.dropdown-toggle.focus,.open>.btn-default.dropdown-toggle:focus,.open>.btn-default.dropdown-toggle:hover,.btn-primary .badge,.nav-tabs>li.active>a,.nav-tabs>li.active>a:focus,.nav-tabs>li.active>a:hover,.breadcrumb>.active,a.label:focus,a.label:hover,.panel-primary>.panel-heading .badge,#opal-topbar .info>div.telephone,#opal-topbar a:hover,.active-mobile .btn-search:hover .fa,.box-user span:hover,.opal-breadscrumb .breadcrumb a:hover,.opal-breadscrumb .breadcrumb li:last-child,.opal-footer .widget ul li:hover a,.opal-footer .email,.opal-footer a:hover,.opal-copyright a:active,.opal-copyright a:focus,.opal-copyright a:hover,.widget_archive a:before,.widget_categories a:before,.widget_layered_nav a:before,.widget_recent_comments a:first-child:before,.widget_recent_entries a:before,.widget_recent_comments .comment-author-link,.widget.widget_categories ul li a:hover,.widget.widget_layered_nav_filters ul li a:hover,.widget.widget_layered_nav ul li a:hover,.widget.widget_pages ul li a:hover,.widget_nav_menu ul li a:hover,.widget_recent_entries .post-date,.widget_wpopal_recent_post .post-stick-layout .item-post.media .post-date,.navbar-mega .navbar-nav li.open>a,.navbar-mega .navbar-nav li a:active,.navbar-mega .navbar-nav li a:focus,.navbar-mega .navbar-nav li a:hover,.navbar-mega .navbar-nav>li .dropdown-menu li a:hover,.navbar-mega .navbar-nav>li .sub-menu li a:hover,.navbar-topmenu>li.active a,.vertical-menu.navbar-collapse .navbar-nav>li:focus>a,.vertical-menu.navbar-collapse .navbar-nav>li:focus>a .caret:before,.vertical-menu.navbar-collapse .navbar-nav>li:focus>a:before,.vertical-menu.navbar-collapse .navbar-nav>li:hover>a,.vertical-menu.navbar-collapse .navbar-nav>li:hover>a .caret:before,.vertical-menu.navbar-collapse .navbar-nav>li:hover>a:before,.vertical-menu.navbar-collapse .navbar-nav li a .caret:before,.vertical-menu.navbar-collapse .navbar-nav li a:focus,.vertical-menu.navbar-collapse .navbar-nav li a:hover,.vertical-menu.navbar-collapse .navbar-nav li .dropdown-menu .widget-title,.vertical-menu.navbar-collapse .navbar-nav li:focus>a .caret:before,.vertical-menu.navbar-collapse .navbar-nav li:hover>a .caret:before,.vertical-menu.navbar-collapse .widget_nav_menu ul li a:hover,.pagination span.current,.author a:hover,.comments-link a:hover,.edit-link a:hover,.entry-category a:hover,.entry-date a:hover,.meta-sep a:hover,.entry-content .edit-link a,article .entry-title a:hover,article .post-content span a,article .post-content a,.comments .comment-author,.comments a,.single-portfolio .format-infomation .single-body .portfolio-info a:hover,.ih-item .info h3:hover,.btn-inverse-light,.btn-outline.btn-primary,.btn-outline.btn-success,.btn-inverse.btn-primary:hover,.btn-inverse.btn-success:hover,.pricing.pricing-v2.pricing-highlight .btn-block:active,.pricing.pricing-v2.pricing-highlight .btn-block:focus,.pricing.pricing-v2.pricing-highlight .btn-block:hover,.pricing.pricing-v3.pricing-highlight .btn-block:active,.pricing.pricing-v3.pricing-highlight .btn-block:focus,.pricing.pricing-v3.pricing-highlight .btn-block:hover,.blogv1 .comments-link a:hover,.blogv1 .readmore a:hover,.scrollup,.style .icon,.kc_wrap_twitter .result_twitter_feed .screen_name,.kc_wrap_twitter .result_twitter_feed a,.kc_wrap_twitter .result_twitter_feed a:hover,#accordion .panel a i.fa-minus,.category-tabs .widget_nav_menu ul li:hover a,.testimonials .testimonials-body .testimonials-name,.kc-pie-chart-wrapper .pie_chart_text h3,.btn-offcanvas:hover,.offcanvas-showright .showright .fa,.navbar-offcanvas ul#main-menu-offcanvas li.active>a,.text-primary,.btn.focus,.btn:focus,.btn:hover,.btn-default,.btn-default.active,.btn-default.active.focus,.btn-default.active:focus,.btn-default.active:hover,.btn-default.focus,.btn-default:active,.btn-default:active.focus,.btn-default:active:focus,.btn-default:active:hover,.btn-default:focus,.btn-default:hover,.open>.btn-default.dropdown-toggle,.open>.btn-default.dropdown-toggle.focus,.open>.btn-default.dropdown-toggle:focus,.open>.btn-default.dropdown-toggle:hover,.btn-primary .badge,.nav-tabs>li.active>a,.nav-tabs>li.active>a:focus,.nav-tabs>li.active>a:hover,.breadcrumb>.active,a.label:focus,a.label:hover,.panel-primary>.panel-heading .badge,#opal-topbar .info>div.telephone,.widget_archive a:before,.widget_categories a:before,.widget_layered_nav a:before,.widget_recent_comments a:first-child:before,.widget_recent_entries a:before,.widget_recent_comments .comment-author-link,.btn-inverse-light,.btn-outline.btn-primary,.btn-inverse.btn-primary:hover,.kc_wrap_twitter .result_twitter_feed .screen_name,.kc_wrap_twitter .result_twitter_feed a,.product-info .product-nav a,.product-block .price>*,.products-top-wrap .display-mode .btn.active,#opal-quickview-modal .product-info .product_title,#opal-quickview-modal .close:hover .fa,#opal-quickview-modal .close:hover .icon,.woocommerce #respond input#submit .badge,.woocommerce button.button .badge,.woocommerce input.button .badge,.woocommerce #respond input#submit.alt .badge,.woocommerce a.button.alt .badge,.woocommerce button.button.alt .badge,.woocommerce input.button.alt .badge,.text-primary,.btn.focus,.btn:focus,.btn:hover,.btn-default,.btn-default.active,.btn-default.active.focus,.btn-default.active:focus,.btn-default.active:hover,.btn-default.focus,.btn-default:active,.btn-default:active.focus,.btn-default:active:focus,.btn-default:active:hover,.btn-default:focus,.btn-default:hover,.open>.btn-default.dropdown-toggle,.open>.btn-default.dropdown-toggle.focus,.open>.btn-default.dropdown-toggle:focus,.open>.btn-default.dropdown-toggle:hover,.btn-primary .badge,.nav-tabs>li.active>a,.nav-tabs>li.active>a:focus,.nav-tabs>li.active>a:hover,.breadcrumb>.active,a.label:focus,a.label:hover,.panel-primary>.panel-heading .badge,#opal-topbar .info>div.telephone,#opal-topbar a:hover,.active-mobile .btn-search:hover .fa,.box-user span:hover,.opal-breadscrumb .breadcrumb a:hover,.opal-breadscrumb .breadcrumb li:last-child,.opal-footer .widget ul li:hover a,.opal-footer .email,.opal-footer a:hover,.opal-copyright a:active,.opal-copyright a:focus,.opal-copyright a:hover,.widget_archive a:before,.widget_categories a:before,.widget_layered_nav a:before,.widget_recent_comments a:first-child:before,.widget_recent_entries a:before,.widget_recent_comments .comment-author-link,.widget.widget_categories ul li a:hover,.widget.widget_layered_nav_filters ul li a:hover,.widget.widget_layered_nav ul li a:hover,.widget.widget_pages ul li a:hover,.widget_nav_menu ul li a:hover,.widget_recent_entries .post-date,.widget_wpopal_recent_post .post-stick-layout .item-post.media .post-date,.navbar-mega .navbar-nav li.open>a,.navbar-mega .navbar-nav li a:active,.navbar-mega .navbar-nav li a:focus,.navbar-mega .navbar-nav li a:hover,.navbar-mega .navbar-nav>li .dropdown-menu li a:hover,.navbar-mega .navbar-nav>li .sub-menu li a:hover,.navbar-topmenu>li.active a,.vertical-menu.navbar-collapse .navbar-nav>li:focus>a,.vertical-menu.navbar-collapse .navbar-nav>li:focus>a .caret:before,.vertical-menu.navbar-collapse .navbar-nav>li:focus>a:before,.vertical-menu.navbar-collapse .navbar-nav>li:hover>a,.vertical-menu.navbar-collapse .navbar-nav>li:hover>a .caret:before,.vertical-menu.navbar-collapse .navbar-nav>li:hover>a:before,.vertical-menu.navbar-collapse .navbar-nav li a .caret:before,.vertical-menu.navbar-collapse .navbar-nav li a:focus,.vertical-menu.navbar-collapse .navbar-nav li a:hover,.vertical-menu.navbar-collapse .navbar-nav li .dropdown-menu .widget-title,.vertical-menu.navbar-collapse .navbar-nav li:focus>a .caret:before,.vertical-menu.navbar-collapse .navbar-nav li:hover>a .caret:before,.vertical-menu.navbar-collapse .widget_nav_menu ul li a:hover,.pagination span.current,.author a:hover,.comments-link a:hover,.edit-link a:hover,.entry-category a:hover,.entry-date a:hover,.meta-sep a:hover,.entry-content .edit-link a,article .entry-title a:hover,article .post-content span a,article .post-content a,.comments .comment-author,.comments a,.single-portfolio .format-infomation .single-body .portfolio-info a:hover,.ih-item .info h3:hover,.btn-inverse-light,.btn-outline.btn-primary,.btn-outline.btn-success,.btn-inverse.btn-primary:hover,.btn-inverse.btn-success:hover,.pricing.pricing-v2.pricing-highlight .btn-block:active,.pricing.pricing-v2.pricing-highlight .btn-block:focus,.pricing.pricing-v2.pricing-highlight .btn-block:hover,.pricing.pricing-v3.pricing-highlight .btn-block:active,.pricing.pricing-v3.pricing-highlight .btn-block:focus,.pricing.pricing-v3.pricing-highlight .btn-block:hover,.blogv1 .comments-link a:hover,.blogv1 .readmore a:hover,.scrollup,.style .icon,.kc_wrap_twitter .result_twitter_feed .screen_name,.kc_wrap_twitter .result_twitter_feed a,.kc_wrap_twitter .result_twitter_feed a:hover,#accordion .panel a i.fa-minus,.category-tabs .widget_nav_menu ul li:hover a,.testimonials .testimonials-body .testimonials-name,.kc-pie-chart-wrapper .pie_chart_text h3,.btn-offcanvas:hover,.offcanvas-showright .showright .fa,.navbar-offcanvas ul#main-menu-offcanvas li.active>a,.text-primary,.btn.focus,.btn:focus,.btn:hover,.btn-default,.btn-default.active,.btn-default.active.focus,.btn-default.active:focus,.btn-default.active:hover,.btn-default.focus,.btn-default:active,.btn-default:active.focus,.btn-default:active:focus,.btn-default:active:hover,.btn-default:focus,.btn-default:hover,.open>.btn-default.dropdown-toggle,.open>.btn-default.dropdown-toggle.focus,.open>.btn-default.dropdown-toggle:focus,.open>.btn-default.dropdown-toggle:hover,.btn-primary .badge,.nav-tabs>li.active>a,.nav-tabs>li.active>a:focus,.nav-tabs>li.active>a:hover,.breadcrumb>.active,a.label:focus,a.label:hover,.panel-primary>.panel-heading .badge,#opal-topbar .info>div.telephone,.widget_archive a:before,.widget_categories a:before,.widget_layered_nav a:before,.widget_recent_comments a:first-child:before,.widget_recent_entries a:before,.widget_recent_comments .comment-author-link,.btn-inverse-light,.btn-outline.btn-primary,.btn-inverse.btn-primary:hover,.kc_wrap_twitter .result_twitter_feed .screen_name,.kc_wrap_twitter .result_twitter_feed a,.product-info .product-nav a,.product-block .price>*,.products-top-wrap .display-mode .btn.active,#opal-quickview-modal .product-info .product_title,#opal-quickview-modal .close:hover .fa,#opal-quickview-modal .close:hover .icon,.woocommerce #respond input#submit .badge,.woocommerce button.button .badge,.woocommerce input.button .badge,.woocommerce #respond input#submit.alt .badge,.woocommerce a.button.alt .badge,.woocommerce button.button.alt .badge,.woocommerce input.button.alt .badge,.text-primary,.btn.focus,.btn:focus,.btn:hover,.btn-default,.btn-default.active,.btn-default.active.focus,.btn-default.active:focus,.btn-default.active:hover,.btn-default.focus,.btn-default:active,.btn-default:active.focus,.btn-default:active:focus,.btn-default:active:hover,.btn-default:focus,.btn-default:hover,.open>.btn-default.dropdown-toggle,.open>.btn-default.dropdown-toggle.focus,.open>.btn-default.dropdown-toggle:focus,.open>.btn-default.dropdown-toggle:hover,.btn-primary .badge,.nav-tabs>li.active>a,.nav-tabs>li.active>a:focus,.nav-tabs>li.active>a:hover,.breadcrumb>.active,a.label:focus,a.label:hover,.panel-primary>.panel-heading .badge,#opal-topbar .info>div.telephone,#opal-topbar a:hover,.active-mobile .btn-search:hover .fa,.box-user span:hover,.opal-breadscrumb .breadcrumb a:hover,.opal-breadscrumb .breadcrumb li:last-child,.opal-footer .widget ul li:hover a,.opal-footer .email,.opal-footer a:hover,.opal-copyright a:active,.opal-copyright a:focus,.opal-copyright a:hover,.widget_archive a:before,.widget_categories a:before,.widget_layered_nav a:before,.widget_recent_comments a:first-child:before,.widget_recent_entries a:before,.widget_recent_comments .comment-author-link,.widget.widget_categories ul li a:hover,.widget.widget_layered_nav_filters ul li a:hover,.widget.widget_layered_nav ul li a:hover,.widget.widget_pages ul li a:hover,.widget_nav_menu ul li a:hover,.widget_recent_entries .post-date,.widget_wpopal_recent_post .post-stick-layout .item-post.media .post-date,.navbar-mega .navbar-nav li.open>a,.navbar-mega .navbar-nav li a:active,.navbar-mega .navbar-nav li a:focus,.navbar-mega .navbar-nav li a:hover,.navbar-mega .navbar-nav>li .dropdown-menu li a:hover,.navbar-mega .navbar-nav>li .sub-menu li a:hover,.navbar-topmenu>li.active a,.vertical-menu.navbar-collapse .navbar-nav>li:focus>a,.vertical-menu.navbar-collapse .navbar-nav>li:focus>a .caret:before,.vertical-menu.navbar-collapse .navbar-nav>li:focus>a:before,.vertical-menu.navbar-collapse .navbar-nav>li:hover>a,.vertical-menu.navbar-collapse .navbar-nav>li:hover>a .caret:before,.vertical-menu.navbar-collapse .navbar-nav>li:hover>a:before,.vertical-menu.navbar-collapse .navbar-nav li a .caret:before,.vertical-menu.navbar-collapse .navbar-nav li a:focus,.vertical-menu.navbar-collapse .navbar-nav li a:hover,.vertical-menu.navbar-collapse .navbar-nav li .dropdown-menu .widget-title,.vertical-menu.navbar-collapse .navbar-nav li:focus>a .caret:before,.vertical-menu.navbar-collapse .navbar-nav li:hover>a .caret:before,.vertical-menu.navbar-collapse .widget_nav_menu ul li a:hover,.pagination span.current,.author a:hover,.comments-link a:hover,.edit-link a:hover,.entry-category a:hover,.entry-date a:hover,.meta-sep a:hover,.entry-content .edit-link a,article .entry-title a:hover,article .post-content span a,article .post-content a,.comments .comment-author,.comments a,.single-portfolio .format-infomation .single-body .portfolio-info a:hover,.ih-item .info h3:hover,.btn-inverse-light,.btn-outline.btn-primary,.btn-outline.btn-success,.btn-inverse.btn-primary:hover,.btn-inverse.btn-success:hover,.pricing.pricing-v2.pricing-highlight .btn-block:active,.pricing.pricing-v2.pricing-highlight .btn-block:focus,.pricing.pricing-v2.pricing-highlight .btn-block:hover,.pricing.pricing-v3.pricing-highlight .btn-block:active,.pricing.pricing-v3.pricing-highlight .btn-block:focus,.pricing.pricing-v3.pricing-highlight .btn-block:hover,.blogv1 .comments-link a:hover,.blogv1 .readmore a:hover,.scrollup,.style .icon,.kc_wrap_twitter .result_twitter_feed .screen_name,.kc_wrap_twitter .result_twitter_feed a,.kc_wrap_twitter .result_twitter_feed a:hover,#accordion .panel a i.fa-minus,.category-tabs .widget_nav_menu ul li:hover a,.testimonials .testimonials-body .testimonials-name,.kc-pie-chart-wrapper .pie_chart_text h3,.btn-offcanvas:hover,.offcanvas-showright .showright .fa,.navbar-offcanvas ul#main-menu-offcanvas li.active>a,.text-primary,.btn.focus,.btn:focus,.btn:hover,.btn-default,.btn-default.active,.btn-default.active.focus,.btn-default.active:focus,.btn-default.active:hover,.btn-default.focus,.btn-default:active,.btn-default:active.focus,.btn-default:active:focus,.btn-default:active:hover,.btn-default:focus,.btn-default:hover,.open>.btn-default.dropdown-toggle,.open>.btn-default.dropdown-toggle.focus,.open>.btn-default.dropdown-toggle:focus,.open>.btn-default.dropdown-toggle:hover,.btn-primary .badge,.nav-tabs>li.active>a,.nav-tabs>li.active>a:focus,.nav-tabs>li.active>a:hover,.breadcrumb>.active,a.label:focus,a.label:hover,.panel-primary>.panel-heading .badge,#opal-topbar .info>div.telephone,.widget_archive a:before,.widget_categories a:before,.widget_layered_nav a:before,.widget_recent_comments a:first-child:before,.widget_recent_entries a:before,.widget_recent_comments .comment-author-link,.btn-inverse-light,.btn-outline.btn-primary,.btn-inverse.btn-primary:hover,.kc_wrap_twitter .result_twitter_feed .screen_name,.kc_wrap_twitter .result_twitter_feed a,.product-info .product-nav a,.product-block .price>*,.products-top-wrap .display-mode .btn.active,#opal-quickview-modal .product-info .product_title,#opal-quickview-modal .close:hover .fa,#opal-quickview-modal .close:hover .icon,.woocommerce #respond input#submit .badge,.woocommerce button.button .badge,.woocommerce input.button .badge,.woocommerce #respond input#submit.alt .badge,.woocommerce a.button.alt .badge,.woocommerce button.button.alt .badge,.woocommerce input.button.alt .badge,.text-primary,.btn.focus,.btn:focus,.btn:hover,.btn-default,.btn-default.active,.btn-default.active.focus,.btn-default.active:focus,.btn-default.active:hover,.btn-default.focus,.btn-default:active,.btn-default:active.focus,.btn-default:active:focus,.btn-default:active:hover,.btn-default:focus,.btn-default:hover,.open>.btn-default.dropdown-toggle,.open>.btn-default.dropdown-toggle.focus,.open>.btn-default.dropdown-toggle:focus,.open>.btn-default.dropdown-toggle:hover,.btn-primary .badge,.nav-tabs>li.active>a,.nav-tabs>li.active>a:focus,.nav-tabs>li.active>a:hover,.breadcrumb>.active,a.label:focus,a.label:hover,.panel-primary>.panel-heading .badge,#opal-topbar .info>div.telephone,#opal-topbar a:hover,.active-mobile .btn-search:hover .fa,.box-user span:hover,.opal-breadscrumb .breadcrumb a:hover,.opal-breadscrumb .breadcrumb li:last-child,.opal-footer .widget ul li:hover a,.opal-footer .email,.opal-footer a:hover,.opal-copyright a:active,.opal-copyright a:focus,.opal-copyright a:hover,.widget_archive a:before,.widget_categories a:before,.widget_layered_nav a:before,.widget_recent_comments a:first-child:before,.widget_recent_entries a:before,.widget_recent_comments .comment-author-link,.widget.widget_categories ul li a:hover,.widget.widget_layered_nav_filters ul li a:hover,.widget.widget_layered_nav ul li a:hover,.widget.widget_pages ul li a:hover,.widget_nav_menu ul li a:hover,.widget_recent_entries .post-date,.widget_wpopal_recent_post .post-stick-layout .item-post.media .post-date,.navbar-mega .navbar-nav li.open>a,.navbar-mega .navbar-nav li a:active,.navbar-mega .navbar-nav li a:focus,.navbar-mega .navbar-nav li a:hover,.navbar-mega .navbar-nav>li .dropdown-menu li a:hover,.navbar-mega .navbar-nav>li .sub-menu li a:hover,.navbar-topmenu>li.active a,.vertical-menu.navbar-collapse .navbar-nav>li:focus>a,.vertical-menu.navbar-collapse .navbar-nav>li:focus>a .caret:before,.vertical-menu.navbar-collapse .navbar-nav>li:focus>a:before,.vertical-menu.navbar-collapse .navbar-nav>li:hover>a,.vertical-menu.navbar-collapse .navbar-nav>li:hover>a .caret:before,.vertical-menu.navbar-collapse .navbar-nav>li:hover>a:before,.vertical-menu.navbar-collapse .navbar-nav li a .caret:before,.vertical-menu.navbar-collapse .navbar-nav li a:focus,.vertical-menu.navbar-collapse .navbar-nav li a:hover,.vertical-menu.navbar-collapse .navbar-nav li .dropdown-menu .widget-title,.vertical-menu.navbar-collapse .navbar-nav li:focus>a .caret:before,.vertical-menu.navbar-collapse .navbar-nav li:hover>a .caret:before,.vertical-menu.navbar-collapse .widget_nav_menu ul li a:hover,.pagination span.current,.author a:hover,.comments-link a:hover,.edit-link a:hover,.entry-category a:hover,.entry-date a:hover,.meta-sep a:hover,.entry-content .edit-link a,article .entry-title a:hover,article .post-content span a,article .post-content a,.comments .comment-author,.comments a,.single-portfolio .format-infomation .single-body .portfolio-info a:hover,.ih-item .info h3:hover,.btn-inverse-light,.btn-outline.btn-primary,.btn-outline.btn-success,.btn-inverse.btn-primary:hover,.btn-inverse.btn-success:hover,.pricing.pricing-v2.pricing-highlight .btn-block:active,.pricing.pricing-v2.pricing-highlight .btn-block:focus,.pricing.pricing-v2.pricing-highlight .btn-block:hover,.pricing.pricing-v3.pricing-highlight .btn-block:active,.pricing.pricing-v3.pricing-highlight .btn-block:focus,.pricing.pricing-v3.pricing-highlight .btn-block:hover,.blogv1 .comments-link a:hover,.blogv1 .readmore a:hover,.scrollup,.style .icon,.kc_wrap_twitter .result_twitter_feed .screen_name,.kc_wrap_twitter .result_twitter_feed a,.kc_wrap_twitter .result_twitter_feed a:hover,#accordion .panel a i.fa-minus,.category-tabs .widget_nav_menu ul li:hover a,.testimonials .testimonials-body .testimonials-name,.kc-pie-chart-wrapper .pie_chart_text h3,.btn-offcanvas:hover,.offcanvas-showright .showright .fa,.navbar-offcanvas ul#main-menu-offcanvas li.active>a,.widget_price_filter .price_slider_amount .price_label,.widget_tag_cloud .tagcloud>a:hover,ul.product-categories li.current-cat-parent>a,ul.product-categories li.current-cat>a,ul.product-categories li.cat-parent .children>li.current-cat>a,ul.product-categories li .closed:hover,ul.product-categories li .opened:hover,ul.product-categories li a:hover,ul.product-categories li li a:hover,.opal-category-list #opal-accordion-categories .category-title a:hover,.cart_list .cart-main-content .remove:hover,.opal-topcart .name a:hover,.opal-btn-wishlist:hover,.product-info .product-nav a,.single-product-summary .yith-wcwl-add-to-wishlist a:hover,.single-product-summary .yith-wcwl-add-button a.add_to_wishlist:hover,.single-product-summary .yith-wcwl-add-button a:hover,.single-product-summary .yith-wcwl-wishlistaddedbrowse a.add_to_wishlist:hover,.single-product-summary .yith-wcwl-wishlistaddedbrowse a:hover,.single-product-summary .yith-wcwl-wishlistexistsbrowse a.add_to_wishlist:hover,.single-product-summary .yith-wcwl-wishlistexistsbrowse a:hover,.single-product-summary a.compare:hover,.single-product-summary a.compare:hover:before,.single-product-summary .yith-wcwl-wishlistaddedbrowse .feedback,.single-product-summary .yith-wcwl-wishlistexistsbrowse .feedback,.product-block .price>*,.product-block .name:hover a,.product-block .category a:hover,.button-action>div.yith-compare .compare.added:hover,.list .product-block a.compare.added,.list .product-block a.quickview.added,.products-list .product-block a.compare.added,.products-list .product-block a.quickview.added,.single-product.woocommerce div.product p.price,.wc-tabs-wrapper .tabs-title:hover a,.products-top-wrap .display-mode .btn.active,#opal-quickview-modal .product-info .product_title,#opal-quickview-modal .close:hover .fa,#opal-quickview-modal .close:hover .icon,#opal-quickview-modal #quickview-carousel:hover .carousel-control:hover,.opal-category-shop .cats-item .title-category:hover a,.woocommerce #respond input#submit .badge,.woocommerce button.button .badge,.woocommerce input.button .badge,.woocommerce #respond input#submit.alt .badge,.woocommerce a.button.alt .badge,.woocommerce button.button.alt .badge,.woocommerce input.button.alt .badge,#main-container .woocommerce button.button.single_add_to_cart_button:hover:hover,.woocommerce a.add_to_cart_button:hover:hover,.woocommerce a.product_type_external:hover:hover{
                color:<?php echo esc_html($allegro_maincolor_primary_color); ?>;
            }
            

.modal-content,.owl-controls .owl-page.active span,.owl-carousel-play .carousel-controls-v2 .carousel-control:focus,.owl-carousel-play .carousel-controls-v2 .carousel-control:hover,#accordion .panel a i.fa-minus,.modal-content,.owl-controls .owl-page.active span,.owl-carousel-play .carousel-controls-v2 .carousel-control:focus,.owl-carousel-play .carousel-controls-v2 .carousel-control:hover,#accordion .panel a i.fa-minus,.modal-content,.modal-content,.owl-controls .owl-page.active span,.owl-carousel-play .carousel-controls-v2 .carousel-control:focus,.owl-carousel-play .carousel-controls-v2 .carousel-control:hover,#accordion .panel a i.fa-minus,.modal-content,.modal-content,.owl-controls .owl-page.active span,.owl-carousel-play .carousel-controls-v2 .carousel-control:focus,.owl-carousel-play .carousel-controls-v2 .carousel-control:hover,#accordion .panel a i.fa-minus,.modal-content,.modal-content,.owl-controls .owl-page.active span,.owl-carousel-play .carousel-controls-v2 .carousel-control:focus,.owl-carousel-play .carousel-controls-v2 .carousel-control:hover,#accordion .panel a i.fa-minus,.opal-topcart .dropdown-menu{
                border-color:<?php echo esc_html($allegro_maincolor_primary_color); ?>;
            }
            
    .panel-primary>.panel-heading+.panel-collapse>.panel-body,.navbar-mega .text-label.text-featured:after,.nav-tabs .kc_tabs_nav li.ui-tabs-active:before,.rev_slider_wrapper .style2:before,.panel-primary>.panel-heading+.panel-collapse>.panel-body,.navbar-mega .text-label.text-featured:after,.nav-tabs .kc_tabs_nav li.ui-tabs-active:before,.rev_slider_wrapper .style2:before,.panel-primary>.panel-heading+.panel-collapse>.panel-body,.navbar-mega .text-label.text-featured:after,.panel-primary>.panel-heading+.panel-collapse>.panel-body,.navbar-mega .text-label.text-featured:after,.nav-tabs .kc_tabs_nav li.ui-tabs-active:before,.rev_slider_wrapper .style2:before,.panel-primary>.panel-heading+.panel-collapse>.panel-body,.navbar-mega .text-label.text-featured:after,.panel-primary>.panel-heading+.panel-collapse>.panel-body,.navbar-mega .text-label.text-featured:after,.nav-tabs .kc_tabs_nav li.ui-tabs-active:before,.rev_slider_wrapper .style2:before,.panel-primary>.panel-heading+.panel-collapse>.panel-body,.navbar-mega .text-label.text-featured:after,.panel-primary>.panel-heading+.panel-collapse>.panel-body,.navbar-mega .text-label.text-featured:after,.nav-tabs .kc_tabs_nav li.ui-tabs-active:before,.rev_slider_wrapper .style2:before{
                border-top-color:<?php echo esc_html($allegro_maincolor_primary_color); ?>;
            }
            
  .panel-primary>.panel-footer+.panel-collapse>.panel-body,.feature-box.feature-box-v4,.rev_slider_wrapper .style2,.panel-primary>.panel-footer+.panel-collapse>.panel-body,.feature-box.feature-box-v4,.rev_slider_wrapper .style2,.panel-primary>.panel-footer+.panel-collapse>.panel-body,.panel-primary>.panel-footer+.panel-collapse>.panel-body,.feature-box.feature-box-v4,.rev_slider_wrapper .style2,.panel-primary>.panel-footer+.panel-collapse>.panel-body,.panel-primary>.panel-footer+.panel-collapse>.panel-body,.feature-box.feature-box-v4,.rev_slider_wrapper .style2,.panel-primary>.panel-footer+.panel-collapse>.panel-body,.panel-primary>.panel-footer+.panel-collapse>.panel-body,.feature-box.feature-box-v4,.rev_slider_wrapper .style2{
                border-bottom-color:<?php echo trim($allegro_maincolor_primary_color); ?>;
            }
            

.bg-primary,.btn-default .badge,.btn-primary,.btn-primary.disabled,.btn-primary.disabled.active,.btn-primary.disabled.focus,.btn-primary.disabled:active,.btn-primary.disabled:focus,.btn-primary.disabled:hover,.btn-primary[disabled],.btn-primary[disabled].active,.btn-primary[disabled].focus,.btn-primary[disabled]:active,.btn-primary[disabled]:focus,.btn-primary[disabled]:hover,fieldset[disabled] .btn-primary,fieldset[disabled] .btn-primary.active,fieldset[disabled] .btn-primary.focus,fieldset[disabled] .btn-primary:active,fieldset[disabled] .btn-primary:focus,fieldset[disabled] .btn-primary:hover,.dropdown-menu>.active>a,.dropdown-menu>.active>a:focus,.dropdown-menu>.active>a:hover,.nav-pills>li.active>a,.nav-pills>li.active>a:focus,.nav-pills>li.active>a:hover,.pagination>.active>a,.pagination>.active>a:focus,.pagination>.active>a:hover,.pagination>.active>span,.pagination>.active>span:focus,.pagination>.active>span:hover,.label-primary,.progress-bar,.list-group-item.active,.list-group-item.active:focus,.list-group-item.active:hover,.panel-primary>.panel-heading,.active-mobile .input-group-btn,.search-box-wrapper.style-2 .search-box .input-group-btn,.searchform .opal-search .btn-search,.widget_calendar tbody a,.widget_calendar #today,.widget_mc4wp_form_widget .input-group .btn,.navbar-mega .navbar-toggle .icon-bar,.navbar-mega .navbar-nav>.open>a,.navbar-mega .navbar-nav>li>a:focus,.navbar-mega .navbar-nav>li>a:hover,.navbar-mega .navbar-nav>li.active>a,.navbar-mega .navbar-nav>.active,.navbar-mega .text-label.text-featured,.navbar-mega-theme,.vertical-menu.navbar-collapse .navbar-nav li.dropdown,.vertical-menu.navbar-collapse .navbar-nav li .dropdown-menu,.nav-tabs .kc_tabs_nav li:hover a,.nav-tabs .kc_tabs_nav li.ui-tabs-active>a,.tag-links a,.ih-item.square.effect16 .info,.bg-primary,.btn-outline-light.active,.btn-outline-light:active,.btn-outline-light:focus,.btn-outline-light:hover,.open .btn-outline-light.dropdown-toggle,.btn-outline-dark.active,.btn-outline-dark:active,.btn-outline-dark:focus,.btn-outline-dark:hover,.open .btn-outline-dark.dropdown-toggle,.btn-inverse-light .badge,.owl-controls .owl-page span,.dropcap.dropcap-v2,.pricing.pricing-v2 .plan-price,.pricing.pricing-v2 .plan-price .plan-price-body,.pricing.pricing-v2.pricing-highlight .plan-price-body,.pricing.pricing-v2.pricing-highlight .btn-block,.pricing.pricing-v3.pricing-highlight .plan-price,.pricing.pricing-v3.pricing-highlight .plan-title,.pricing.pricing-v3.pricing-highlight .btn-block,.pricing.pricing-highlight .plan-title,.pbr-team.other-team,.feature-box-v3 .fbox-icon i,.kc-element-category-link-wrapper .items .team-header:before,.testimonial-collection.v1 .owl-carousel-play .owl-controls .owl-page.active span,.bg-primary,.btn-default .badge,.btn-primary,.btn-primary.disabled,.btn-primary.disabled.active,.btn-primary.disabled.focus,.btn-primary.disabled:active,.btn-primary.disabled:focus,.btn-primary.disabled:hover,.btn-primary[disabled],.btn-primary[disabled].active,.btn-primary[disabled].focus,.btn-primary[disabled]:active,.btn-primary[disabled]:focus,.btn-primary[disabled]:hover,fieldset[disabled] .btn-primary,fieldset[disabled] .btn-primary.active,fieldset[disabled] .btn-primary.focus,fieldset[disabled] .btn-primary:active,fieldset[disabled] .btn-primary:focus,fieldset[disabled] .btn-primary:hover,.dropdown-menu>.active>a,.dropdown-menu>.active>a:focus,.dropdown-menu>.active>a:hover,.nav-pills>li.active>a,.nav-pills>li.active>a:focus,.nav-pills>li.active>a:hover,.pagination>.active>a,.pagination>.active>a:focus,.pagination>.active>a:hover,.pagination>.active>span,.pagination>.active>span:focus,.pagination>.active>span:hover,.label-primary,.progress-bar,.list-group-item.active,.list-group-item.active:focus,.list-group-item.active:hover,.panel-primary>.panel-heading,.active-mobile .input-group-btn,.search-box-wrapper.style-2 .search-box .input-group-btn,.searchform .opal-search .btn-search,.widget_calendar tbody a,.widget_calendar #today,.widget_mc4wp_form_widget .input-group .btn,.navbar-mega .navbar-toggle .icon-bar,.navbar-mega .navbar-nav>.open>a,.navbar-mega .navbar-nav>li>a:focus,.navbar-mega .navbar-nav>li>a:hover,.navbar-mega .navbar-nav>li.active>a,.navbar-mega .navbar-nav>.active,.navbar-mega .text-label.text-featured,.navbar-mega-theme,.vertical-menu.navbar-collapse .navbar-nav li.dropdown,.vertical-menu.navbar-collapse .navbar-nav li .dropdown-menu,.nav-tabs .kc_tabs_nav li:hover a,.nav-tabs .kc_tabs_nav li.ui-tabs-active>a,.tag-links a,.ih-item.square.effect16 .info,.bg-primary,.btn-outline-light.active,.btn-outline-light:active,.btn-outline-light:focus,.btn-outline-light:hover,.open .btn-outline-light.dropdown-toggle,.btn-outline-dark.active,.btn-outline-dark:active,.btn-outline-dark:focus,.btn-outline-dark:hover,.open .btn-outline-dark.dropdown-toggle,.btn-inverse-light .badge,.owl-controls .owl-page span,.dropcap.dropcap-v2,.pricing.pricing-v2 .plan-price,.pricing.pricing-v2 .plan-price .plan-price-body,.pricing.pricing-v2.pricing-highlight .plan-price-body,.pricing.pricing-v2.pricing-highlight .btn-block,.pricing.pricing-v3.pricing-highlight .plan-price,.pricing.pricing-v3.pricing-highlight .plan-title,.pricing.pricing-v3.pricing-highlight .btn-block,.pricing.pricing-highlight .plan-title,.pbr-team.other-team,.feature-box-v3 .fbox-icon i,.kc-element-category-link-wrapper .items .team-header:before,.testimonial-collection.v1 .owl-carousel-play .owl-controls .owl-page.active span,.bg-primary,.btn-default .badge,.btn-primary,.btn-primary.disabled,.btn-primary.disabled.active,.btn-primary.disabled.focus,.btn-primary.disabled:active,.btn-primary.disabled:focus,.btn-primary.disabled:hover,.btn-primary[disabled],.btn-primary[disabled].active,.btn-primary[disabled].focus,.btn-primary[disabled]:active,.btn-primary[disabled]:focus,.btn-primary[disabled]:hover,fieldset[disabled] .btn-primary,fieldset[disabled] .btn-primary.active,fieldset[disabled] .btn-primary.focus,fieldset[disabled] .btn-primary:active,fieldset[disabled] .btn-primary:focus,fieldset[disabled] .btn-primary:hover,.dropdown-menu>.active>a,.dropdown-menu>.active>a:focus,.dropdown-menu>.active>a:hover,.nav-pills>li.active>a,.nav-pills>li.active>a:focus,.nav-pills>li.active>a:hover,.pagination>.active>a,.pagination>.active>a:focus,.pagination>.active>a:hover,.pagination>.active>span,.pagination>.active>span:focus,.pagination>.active>span:hover,.label-primary,.progress-bar,.list-group-item.active,.list-group-item.active:focus,.list-group-item.active:hover,.panel-primary>.panel-heading,.searchform .opal-search .btn-search,.navbar-mega .text-label.text-featured,.vertical-menu.navbar-collapse .navbar-nav li.dropdown,.vertical-menu.navbar-collapse .navbar-nav li .dropdown-menu,.bg-primary,.btn-inverse-light .badge,.dropcap.dropcap-v2,.pricing.pricing-v2 .plan-price,.pricing.pricing-v2 .plan-price .plan-price-body,.kc-element-category-link-wrapper .items .team-header:before,.widget_price_filter .ui-slider .ui-slider-handle,.product-block span.onsale,.product-block span.sale-off,.product-block .add_to_cart_button,.single-product.woocommerce div.product form.cart .button,.products-bottom-wrap nav.woocommerce-pagination ul li span.current,.products-bottom-wrap nav.woocommerce-pagination ul span.current,.products-bottom-wrap nav.woocommerce-pagination ul a:hover,.products-bottom-wrap nav.woocommerce-pagination ul li a:hover,#opal-quickview-modal .product-info a.add_to_cart_button,#opal-quickview-modal .product-info a.product_type_external,.woocommerce #respond input#submit,.woocommerce button.button,.woocommerce input.button,.woocommerce #respond input#submit.disabled,.woocommerce #respond input#submit.disabled.active,.woocommerce #respond input#submit.disabled.focus,.woocommerce #respond input#submit.disabled:active,.woocommerce #respond input#submit.disabled:focus,.woocommerce #respond input#submit.disabled:hover,.woocommerce #respond input#submit[disabled],.woocommerce #respond input#submit[disabled].active,.woocommerce #respond input#submit[disabled].focus,.woocommerce #respond input#submit[disabled]:active,.woocommerce #respond input#submit[disabled]:focus,.woocommerce #respond input#submit[disabled]:hover,.woocommerce button.button.disabled,.woocommerce button.button.disabled.active,.woocommerce button.button.disabled.focus,.woocommerce button.button.disabled:active,.woocommerce button.button.disabled:focus,.woocommerce button.button.disabled:hover,.woocommerce button.button[disabled],.woocommerce button.button[disabled].active,.woocommerce button.button[disabled].focus,.woocommerce button.button[disabled]:active,.woocommerce button.button[disabled]:focus,.woocommerce button.button[disabled]:hover,.woocommerce input.button.disabled,.woocommerce input.button.disabled.active,.woocommerce input.button.disabled.focus,.woocommerce input.button.disabled:active,.woocommerce input.button.disabled:focus,.woocommerce input.button.disabled:hover,.woocommerce input.button[disabled],.woocommerce input.button[disabled].active,.woocommerce input.button[disabled].focus,.woocommerce input.button[disabled]:active,.woocommerce input.button[disabled]:focus,.woocommerce input.button[disabled]:hover,fieldset[disabled] .woocommerce #respond input#submit,fieldset[disabled] .woocommerce #respond input#submit.active,fieldset[disabled] .woocommerce #respond input#submit.focus,fieldset[disabled] .woocommerce #respond input#submit:active,fieldset[disabled] .woocommerce #respond input#submit:focus,fieldset[disabled] .woocommerce #respond input#submit:hover,fieldset[disabled] .woocommerce button.button,fieldset[disabled] .woocommerce button.button.active,fieldset[disabled] .woocommerce button.button.focus,fieldset[disabled] .woocommerce button.button:active,fieldset[disabled] .woocommerce button.button:focus,fieldset[disabled] .woocommerce button.button:hover,fieldset[disabled] .woocommerce input.button,fieldset[disabled] .woocommerce input.button.active,fieldset[disabled] .woocommerce input.button.focus,fieldset[disabled] .woocommerce input.button:active,fieldset[disabled] .woocommerce input.button:focus,fieldset[disabled] .woocommerce input.button:hover,.woocommerce #respond input#submit.alt,.woocommerce a.button.alt,.woocommerce button.button.alt,.woocommerce input.button.alt,.woocommerce #respond input#submit.alt.disabled,.woocommerce #respond input#submit.alt.disabled.active,.woocommerce #respond input#submit.alt.disabled.focus,.woocommerce #respond input#submit.alt.disabled:active,.woocommerce #respond input#submit.alt.disabled:focus,.woocommerce #respond input#submit.alt.disabled:hover,.woocommerce #respond input#submit.alt[disabled],.woocommerce #respond input#submit.alt[disabled].active,.woocommerce #respond input#submit.alt[disabled].focus,.woocommerce #respond input#submit.alt[disabled]:active,.woocommerce #respond input#submit.alt[disabled]:focus,.woocommerce #respond input#submit.alt[disabled]:hover,.woocommerce a.button.alt.disabled,.woocommerce a.button.alt.disabled.active,.woocommerce a.button.alt.disabled.focus,.woocommerce a.button.alt.disabled:active,.woocommerce a.button.alt.disabled:focus,.woocommerce a.button.alt.disabled:hover,.woocommerce a.button.alt[disabled],.woocommerce a.button.alt[disabled].active,.woocommerce a.button.alt[disabled].focus,.woocommerce a.button.alt[disabled]:active,.woocommerce a.button.alt[disabled]:focus,.woocommerce a.button.alt[disabled]:hover,.woocommerce button.button.alt.disabled,.woocommerce button.button.alt.disabled.active,.woocommerce button.button.alt.disabled.focus,.woocommerce button.button.alt.disabled:active,.woocommerce button.button.alt.disabled:focus,.woocommerce button.button.alt.disabled:hover,.woocommerce button.button.alt[disabled],.woocommerce button.button.alt[disabled].active,.woocommerce button.button.alt[disabled].focus,.woocommerce button.button.alt[disabled]:active,.woocommerce button.button.alt[disabled]:focus,.woocommerce button.button.alt[disabled]:hover,.woocommerce input.button.alt.disabled,.woocommerce input.button.alt.disabled.active,.woocommerce input.button.alt.disabled.focus,.woocommerce input.button.alt.disabled:active,.woocommerce input.button.alt.disabled:focus,.woocommerce input.button.alt.disabled:hover,.woocommerce input.button.alt[disabled],.woocommerce input.button.alt[disabled].active,.woocommerce input.button.alt[disabled].focus,.woocommerce input.button.alt[disabled]:active,.woocommerce input.button.alt[disabled]:focus,.woocommerce input.button.alt[disabled]:hover,fieldset[disabled] .woocommerce #respond input#submit.alt,fieldset[disabled] .woocommerce #respond input#submit.alt.active,fieldset[disabled] .woocommerce #respond input#submit.alt.focus,fieldset[disabled] .woocommerce #respond input#submit.alt:active,fieldset[disabled] .woocommerce #respond input#submit.alt:focus,fieldset[disabled] .woocommerce #respond input#submit.alt:hover,fieldset[disabled] .woocommerce a.button.alt,fieldset[disabled] .woocommerce a.button.alt.active,fieldset[disabled] .woocommerce a.button.alt.focus,fieldset[disabled] .woocommerce a.button.alt:active,fieldset[disabled] .woocommerce a.button.alt:focus,fieldset[disabled] .woocommerce a.button.alt:hover,fieldset[disabled] .woocommerce button.button.alt,fieldset[disabled] .woocommerce button.button.alt.active,fieldset[disabled] .woocommerce button.button.alt.focus,fieldset[disabled] .woocommerce button.button.alt:active,fieldset[disabled] .woocommerce button.button.alt:focus,fieldset[disabled] .woocommerce button.button.alt:hover,fieldset[disabled] .woocommerce input.button.alt,fieldset[disabled] .woocommerce input.button.alt.active,fieldset[disabled] .woocommerce input.button.alt.focus,fieldset[disabled] .woocommerce input.button.alt:active,fieldset[disabled] .woocommerce input.button.alt:focus,fieldset[disabled] .woocommerce input.button.alt:hover,.bg-primary,.btn-default .badge,.btn-primary,.btn-primary.disabled,.btn-primary.disabled.active,.btn-primary.disabled.focus,.btn-primary.disabled:active,.btn-primary.disabled:focus,.btn-primary.disabled:hover,.btn-primary[disabled],.btn-primary[disabled].active,.btn-primary[disabled].focus,.btn-primary[disabled]:active,.btn-primary[disabled]:focus,.btn-primary[disabled]:hover,fieldset[disabled] .btn-primary,fieldset[disabled] .btn-primary.active,fieldset[disabled] .btn-primary.focus,fieldset[disabled] .btn-primary:active,fieldset[disabled] .btn-primary:focus,fieldset[disabled] .btn-primary:hover,.dropdown-menu>.active>a,.dropdown-menu>.active>a:focus,.dropdown-menu>.active>a:hover,.nav-pills>li.active>a,.nav-pills>li.active>a:focus,.nav-pills>li.active>a:hover,.pagination>.active>a,.pagination>.active>a:focus,.pagination>.active>a:hover,.pagination>.active>span,.pagination>.active>span:focus,.pagination>.active>span:hover,.label-primary,.progress-bar,.list-group-item.active,.list-group-item.active:focus,.list-group-item.active:hover,.panel-primary>.panel-heading,.active-mobile .input-group-btn,.search-box-wrapper.style-2 .search-box .input-group-btn,.searchform .opal-search .btn-search,.widget_calendar tbody a,.widget_calendar #today,.widget_mc4wp_form_widget .input-group .btn,.navbar-mega .navbar-toggle .icon-bar,.navbar-mega .navbar-nav>.open>a,.navbar-mega .navbar-nav>li>a:focus,.navbar-mega .navbar-nav>li>a:hover,.navbar-mega .navbar-nav>li.active>a,.navbar-mega .navbar-nav>.active,.navbar-mega .text-label.text-featured,.navbar-mega-theme,.vertical-menu.navbar-collapse .navbar-nav li.dropdown,.vertical-menu.navbar-collapse .navbar-nav li .dropdown-menu,.nav-tabs .kc_tabs_nav li:hover a,.nav-tabs .kc_tabs_nav li.ui-tabs-active>a,.tag-links a,.ih-item.square.effect16 .info,.bg-primary,.btn-outline-light.active,.btn-outline-light:active,.btn-outline-light:focus,.btn-outline-light:hover,.open .btn-outline-light.dropdown-toggle,.btn-outline-dark.active,.btn-outline-dark:active,.btn-outline-dark:focus,.btn-outline-dark:hover,.open .btn-outline-dark.dropdown-toggle,.btn-inverse-light .badge,.owl-controls .owl-page span,.dropcap.dropcap-v2,.pricing.pricing-v2 .plan-price,.pricing.pricing-v2 .plan-price .plan-price-body,.pricing.pricing-v2.pricing-highlight .plan-price-body,.pricing.pricing-v2.pricing-highlight .btn-block,.pricing.pricing-v3.pricing-highlight .plan-price,.pricing.pricing-v3.pricing-highlight .plan-title,.pricing.pricing-v3.pricing-highlight .btn-block,.pricing.pricing-highlight .plan-title,.pbr-team.other-team,.feature-box-v3 .fbox-icon i,.kc-element-category-link-wrapper .items .team-header:before,.testimonial-collection.v1 .owl-carousel-play .owl-controls .owl-page.active span,.bg-primary,.btn-default .badge,.btn-primary,.btn-primary.disabled,.btn-primary.disabled.active,.btn-primary.disabled.focus,.btn-primary.disabled:active,.btn-primary.disabled:focus,.btn-primary.disabled:hover,.btn-primary[disabled],.btn-primary[disabled].active,.btn-primary[disabled].focus,.btn-primary[disabled]:active,.btn-primary[disabled]:focus,.btn-primary[disabled]:hover,fieldset[disabled] .btn-primary,fieldset[disabled] .btn-primary.active,fieldset[disabled] .btn-primary.focus,fieldset[disabled] .btn-primary:active,fieldset[disabled] .btn-primary:focus,fieldset[disabled] .btn-primary:hover,.dropdown-menu>.active>a,.dropdown-menu>.active>a:focus,.dropdown-menu>.active>a:hover,.nav-pills>li.active>a,.nav-pills>li.active>a:focus,.nav-pills>li.active>a:hover,.pagination>.active>a,.pagination>.active>a:focus,.pagination>.active>a:hover,.pagination>.active>span,.pagination>.active>span:focus,.pagination>.active>span:hover,.label-primary,.progress-bar,.list-group-item.active,.list-group-item.active:focus,.list-group-item.active:hover,.panel-primary>.panel-heading,.searchform .opal-search .btn-search,.navbar-mega .text-label.text-featured,.vertical-menu.navbar-collapse .navbar-nav li.dropdown,.vertical-menu.navbar-collapse .navbar-nav li .dropdown-menu,.bg-primary,.btn-inverse-light .badge,.dropcap.dropcap-v2,.pricing.pricing-v2 .plan-price,.pricing.pricing-v2 .plan-price .plan-price-body,.kc-element-category-link-wrapper .items .team-header:before,.widget_price_filter .ui-slider .ui-slider-handle,.product-block span.onsale,.product-block span.sale-off,.product-block .add_to_cart_button,.single-product.woocommerce div.product form.cart .button,.products-bottom-wrap nav.woocommerce-pagination ul li span.current,.products-bottom-wrap nav.woocommerce-pagination ul span.current,.products-bottom-wrap nav.woocommerce-pagination ul a:hover,.products-bottom-wrap nav.woocommerce-pagination ul li a:hover,#opal-quickview-modal .product-info a.add_to_cart_button,#opal-quickview-modal .product-info a.product_type_external,.woocommerce #respond input#submit,.woocommerce button.button,.woocommerce input.button,.woocommerce #respond input#submit.disabled,.woocommerce #respond input#submit.disabled.active,.woocommerce #respond input#submit.disabled.focus,.woocommerce #respond input#submit.disabled:active,.woocommerce #respond input#submit.disabled:focus,.woocommerce #respond input#submit.disabled:hover,.woocommerce #respond input#submit[disabled],.woocommerce #respond input#submit[disabled].active,.woocommerce #respond input#submit[disabled].focus,.woocommerce #respond input#submit[disabled]:active,.woocommerce #respond input#submit[disabled]:focus,.woocommerce #respond input#submit[disabled]:hover,.woocommerce button.button.disabled,.woocommerce button.button.disabled.active,.woocommerce button.button.disabled.focus,.woocommerce button.button.disabled:active,.woocommerce button.button.disabled:focus,.woocommerce button.button.disabled:hover,.woocommerce button.button[disabled],.woocommerce button.button[disabled].active,.woocommerce button.button[disabled].focus,.woocommerce button.button[disabled]:active,.woocommerce button.button[disabled]:focus,.woocommerce button.button[disabled]:hover,.woocommerce input.button.disabled,.woocommerce input.button.disabled.active,.woocommerce input.button.disabled.focus,.woocommerce input.button.disabled:active,.woocommerce input.button.disabled:focus,.woocommerce input.button.disabled:hover,.woocommerce input.button[disabled],.woocommerce input.button[disabled].active,.woocommerce input.button[disabled].focus,.woocommerce input.button[disabled]:active,.woocommerce input.button[disabled]:focus,.woocommerce input.button[disabled]:hover,fieldset[disabled] .woocommerce #respond input#submit,fieldset[disabled] .woocommerce #respond input#submit.active,fieldset[disabled] .woocommerce #respond input#submit.focus,fieldset[disabled] .woocommerce #respond input#submit:active,fieldset[disabled] .woocommerce #respond input#submit:focus,fieldset[disabled] .woocommerce #respond input#submit:hover,fieldset[disabled] .woocommerce button.button,fieldset[disabled] .woocommerce button.button.active,fieldset[disabled] .woocommerce button.button.focus,fieldset[disabled] .woocommerce button.button:active,fieldset[disabled] .woocommerce button.button:focus,fieldset[disabled] .woocommerce button.button:hover,fieldset[disabled] .woocommerce input.button,fieldset[disabled] .woocommerce input.button.active,fieldset[disabled] .woocommerce input.button.focus,fieldset[disabled] .woocommerce input.button:active,fieldset[disabled] .woocommerce input.button:focus,fieldset[disabled] .woocommerce input.button:hover,.woocommerce #respond input#submit.alt,.woocommerce a.button.alt,.woocommerce button.button.alt,.woocommerce input.button.alt,.woocommerce #respond input#submit.alt.disabled,.woocommerce #respond input#submit.alt.disabled.active,.woocommerce #respond input#submit.alt.disabled.focus,.woocommerce #respond input#submit.alt.disabled:active,.woocommerce #respond input#submit.alt.disabled:focus,.woocommerce #respond input#submit.alt.disabled:hover,.woocommerce #respond input#submit.alt[disabled],.woocommerce #respond input#submit.alt[disabled].active,.woocommerce #respond input#submit.alt[disabled].focus,.woocommerce #respond input#submit.alt[disabled]:active,.woocommerce #respond input#submit.alt[disabled]:focus,.woocommerce #respond input#submit.alt[disabled]:hover,.woocommerce a.button.alt.disabled,.woocommerce a.button.alt.disabled.active,.woocommerce a.button.alt.disabled.focus,.woocommerce a.button.alt.disabled:active,.woocommerce a.button.alt.disabled:focus,.woocommerce a.button.alt.disabled:hover,.woocommerce a.button.alt[disabled],.woocommerce a.button.alt[disabled].active,.woocommerce a.button.alt[disabled].focus,.woocommerce a.button.alt[disabled]:active,.woocommerce a.button.alt[disabled]:focus,.woocommerce a.button.alt[disabled]:hover,.woocommerce button.button.alt.disabled,.woocommerce button.button.alt.disabled.active,.woocommerce button.button.alt.disabled.focus,.woocommerce button.button.alt.disabled:active,.woocommerce button.button.alt.disabled:focus,.woocommerce button.button.alt.disabled:hover,.woocommerce button.button.alt[disabled],.woocommerce button.button.alt[disabled].active,.woocommerce button.button.alt[disabled].focus,.woocommerce button.button.alt[disabled]:active,.woocommerce button.button.alt[disabled]:focus,.woocommerce button.button.alt[disabled]:hover,.woocommerce input.button.alt.disabled,.woocommerce input.button.alt.disabled.active,.woocommerce input.button.alt.disabled.focus,.woocommerce input.button.alt.disabled:active,.woocommerce input.button.alt.disabled:focus,.woocommerce input.button.alt.disabled:hover,.woocommerce input.button.alt[disabled],.woocommerce input.button.alt[disabled].active,.woocommerce input.button.alt[disabled].focus,.woocommerce input.button.alt[disabled]:active,.woocommerce input.button.alt[disabled]:focus,.woocommerce input.button.alt[disabled]:hover,fieldset[disabled] .woocommerce #respond input#submit.alt,fieldset[disabled] .woocommerce #respond input#submit.alt.active,fieldset[disabled] .woocommerce #respond input#submit.alt.focus,fieldset[disabled] .woocommerce #respond input#submit.alt:active,fieldset[disabled] .woocommerce #respond input#submit.alt:focus,fieldset[disabled] .woocommerce #respond input#submit.alt:hover,fieldset[disabled] .woocommerce a.button.alt,fieldset[disabled] .woocommerce a.button.alt.active,fieldset[disabled] .woocommerce a.button.alt.focus,fieldset[disabled] .woocommerce a.button.alt:active,fieldset[disabled] .woocommerce a.button.alt:focus,fieldset[disabled] .woocommerce a.button.alt:hover,fieldset[disabled] .woocommerce button.button.alt,fieldset[disabled] .woocommerce button.button.alt.active,fieldset[disabled] .woocommerce button.button.alt.focus,fieldset[disabled] .woocommerce button.button.alt:active,fieldset[disabled] .woocommerce button.button.alt:focus,fieldset[disabled] .woocommerce button.button.alt:hover,fieldset[disabled] .woocommerce input.button.alt,fieldset[disabled] .woocommerce input.button.alt.active,fieldset[disabled] .woocommerce input.button.alt.focus,fieldset[disabled] .woocommerce input.button.alt:active,fieldset[disabled] .woocommerce input.button.alt:focus,fieldset[disabled] .woocommerce input.button.alt:hover,.bg-primary,.btn-default .badge,.btn-primary,.btn-primary.disabled,.btn-primary.disabled.active,.btn-primary.disabled.focus,.btn-primary.disabled:active,.btn-primary.disabled:focus,.btn-primary.disabled:hover,.btn-primary[disabled],.btn-primary[disabled].active,.btn-primary[disabled].focus,.btn-primary[disabled]:active,.btn-primary[disabled]:focus,.btn-primary[disabled]:hover,fieldset[disabled] .btn-primary,fieldset[disabled] .btn-primary.active,fieldset[disabled] .btn-primary.focus,fieldset[disabled] .btn-primary:active,fieldset[disabled] .btn-primary:focus,fieldset[disabled] .btn-primary:hover,.dropdown-menu>.active>a,.dropdown-menu>.active>a:focus,.dropdown-menu>.active>a:hover,.nav-pills>li.active>a,.nav-pills>li.active>a:focus,.nav-pills>li.active>a:hover,.pagination>.active>a,.pagination>.active>a:focus,.pagination>.active>a:hover,.pagination>.active>span,.pagination>.active>span:focus,.pagination>.active>span:hover,.label-primary,.progress-bar,.list-group-item.active,.list-group-item.active:focus,.list-group-item.active:hover,.panel-primary>.panel-heading,.active-mobile .input-group-btn,.search-box-wrapper.style-2 .search-box .input-group-btn,.searchform .opal-search .btn-search,.widget_calendar tbody a,.widget_calendar #today,.widget_mc4wp_form_widget .input-group .btn,.navbar-mega .navbar-toggle .icon-bar,.navbar-mega .navbar-nav>.open>a,.navbar-mega .navbar-nav>li>a:focus,.navbar-mega .navbar-nav>li>a:hover,.navbar-mega .navbar-nav>li.active>a,.navbar-mega .navbar-nav>.active,.navbar-mega .text-label.text-featured,.navbar-mega-theme,.vertical-menu.navbar-collapse .navbar-nav li.dropdown,.vertical-menu.navbar-collapse .navbar-nav li .dropdown-menu,.nav-tabs .kc_tabs_nav li:hover a,.nav-tabs .kc_tabs_nav li.ui-tabs-active>a,.tag-links a,.ih-item.square.effect16 .info,.bg-primary,.btn-outline-light.active,.btn-outline-light:active,.btn-outline-light:focus,.btn-outline-light:hover,.open .btn-outline-light.dropdown-toggle,.btn-outline-dark.active,.btn-outline-dark:active,.btn-outline-dark:focus,.btn-outline-dark:hover,.open .btn-outline-dark.dropdown-toggle,.btn-inverse-light .badge,.owl-controls .owl-page span,.dropcap.dropcap-v2,.pricing.pricing-v2 .plan-price,.pricing.pricing-v2 .plan-price .plan-price-body,.pricing.pricing-v2.pricing-highlight .plan-price-body,.pricing.pricing-v2.pricing-highlight .btn-block,.pricing.pricing-v3.pricing-highlight .plan-price,.pricing.pricing-v3.pricing-highlight .plan-title,.pricing.pricing-v3.pricing-highlight .btn-block,.pricing.pricing-highlight .plan-title,.pbr-team.other-team,.feature-box-v3 .fbox-icon i,.kc-element-category-link-wrapper .items .team-header:before,.testimonial-collection.v1 .owl-carousel-play .owl-controls .owl-page.active span,.bg-primary,.btn-default .badge,.btn-primary,.btn-primary.disabled,.btn-primary.disabled.active,.btn-primary.disabled.focus,.btn-primary.disabled:active,.btn-primary.disabled:focus,.btn-primary.disabled:hover,.btn-primary[disabled],.btn-primary[disabled].active,.btn-primary[disabled].focus,.btn-primary[disabled]:active,.btn-primary[disabled]:focus,.btn-primary[disabled]:hover,fieldset[disabled] .btn-primary,fieldset[disabled] .btn-primary.active,fieldset[disabled] .btn-primary.focus,fieldset[disabled] .btn-primary:active,fieldset[disabled] .btn-primary:focus,fieldset[disabled] .btn-primary:hover,.dropdown-menu>.active>a,.dropdown-menu>.active>a:focus,.dropdown-menu>.active>a:hover,.nav-pills>li.active>a,.nav-pills>li.active>a:focus,.nav-pills>li.active>a:hover,.pagination>.active>a,.pagination>.active>a:focus,.pagination>.active>a:hover,.pagination>.active>span,.pagination>.active>span:focus,.pagination>.active>span:hover,.label-primary,.progress-bar,.list-group-item.active,.list-group-item.active:focus,.list-group-item.active:hover,.panel-primary>.panel-heading,.searchform .opal-search .btn-search,.navbar-mega .text-label.text-featured,.vertical-menu.navbar-collapse .navbar-nav li.dropdown,.vertical-menu.navbar-collapse .navbar-nav li .dropdown-menu,.bg-primary,.btn-inverse-light .badge,.dropcap.dropcap-v2,.pricing.pricing-v2 .plan-price,.pricing.pricing-v2 .plan-price .plan-price-body,.kc-element-category-link-wrapper .items .team-header:before,.widget_price_filter .ui-slider .ui-slider-handle,.product-block span.onsale,.product-block span.sale-off,.product-block .add_to_cart_button,.single-product.woocommerce div.product form.cart .button,.products-bottom-wrap nav.woocommerce-pagination ul li span.current,.products-bottom-wrap nav.woocommerce-pagination ul span.current,.products-bottom-wrap nav.woocommerce-pagination ul a:hover,.products-bottom-wrap nav.woocommerce-pagination ul li a:hover,#opal-quickview-modal .product-info a.add_to_cart_button,#opal-quickview-modal .product-info a.product_type_external,.woocommerce #respond input#submit,.woocommerce button.button,.woocommerce input.button,.woocommerce #respond input#submit.disabled,.woocommerce #respond input#submit.disabled.active,.woocommerce #respond input#submit.disabled.focus,.woocommerce #respond input#submit.disabled:active,.woocommerce #respond input#submit.disabled:focus,.woocommerce #respond input#submit.disabled:hover,.woocommerce #respond input#submit[disabled],.woocommerce #respond input#submit[disabled].active,.woocommerce #respond input#submit[disabled].focus,.woocommerce #respond input#submit[disabled]:active,.woocommerce #respond input#submit[disabled]:focus,.woocommerce #respond input#submit[disabled]:hover,.woocommerce button.button.disabled,.woocommerce button.button.disabled.active,.woocommerce button.button.disabled.focus,.woocommerce button.button.disabled:active,.woocommerce button.button.disabled:focus,.woocommerce button.button.disabled:hover,.woocommerce button.button[disabled],.woocommerce button.button[disabled].active,.woocommerce button.button[disabled].focus,.woocommerce button.button[disabled]:active,.woocommerce button.button[disabled]:focus,.woocommerce button.button[disabled]:hover,.woocommerce input.button.disabled,.woocommerce input.button.disabled.active,.woocommerce input.button.disabled.focus,.woocommerce input.button.disabled:active,.woocommerce input.button.disabled:focus,.woocommerce input.button.disabled:hover,.woocommerce input.button[disabled],.woocommerce input.button[disabled].active,.woocommerce input.button[disabled].focus,.woocommerce input.button[disabled]:active,.woocommerce input.button[disabled]:focus,.woocommerce input.button[disabled]:hover,fieldset[disabled] .woocommerce #respond input#submit,fieldset[disabled] .woocommerce #respond input#submit.active,fieldset[disabled] .woocommerce #respond input#submit.focus,fieldset[disabled] .woocommerce #respond input#submit:active,fieldset[disabled] .woocommerce #respond input#submit:focus,fieldset[disabled] .woocommerce #respond input#submit:hover,fieldset[disabled] .woocommerce button.button,fieldset[disabled] .woocommerce button.button.active,fieldset[disabled] .woocommerce button.button.focus,fieldset[disabled] .woocommerce button.button:active,fieldset[disabled] .woocommerce button.button:focus,fieldset[disabled] .woocommerce button.button:hover,fieldset[disabled] .woocommerce input.button,fieldset[disabled] .woocommerce input.button.active,fieldset[disabled] .woocommerce input.button.focus,fieldset[disabled] .woocommerce input.button:active,fieldset[disabled] .woocommerce input.button:focus,fieldset[disabled] .woocommerce input.button:hover,.woocommerce #respond input#submit.alt,.woocommerce a.button.alt,.woocommerce button.button.alt,.woocommerce input.button.alt,.woocommerce #respond input#submit.alt.disabled,.woocommerce #respond input#submit.alt.disabled.active,.woocommerce #respond input#submit.alt.disabled.focus,.woocommerce #respond input#submit.alt.disabled:active,.woocommerce #respond input#submit.alt.disabled:focus,.woocommerce #respond input#submit.alt.disabled:hover,.woocommerce #respond input#submit.alt[disabled],.woocommerce #respond input#submit.alt[disabled].active,.woocommerce #respond input#submit.alt[disabled].focus,.woocommerce #respond input#submit.alt[disabled]:active,.woocommerce #respond input#submit.alt[disabled]:focus,.woocommerce #respond input#submit.alt[disabled]:hover,.woocommerce a.button.alt.disabled,.woocommerce a.button.alt.disabled.active,.woocommerce a.button.alt.disabled.focus,.woocommerce a.button.alt.disabled:active,.woocommerce a.button.alt.disabled:focus,.woocommerce a.button.alt.disabled:hover,.woocommerce a.button.alt[disabled],.woocommerce a.button.alt[disabled].active,.woocommerce a.button.alt[disabled].focus,.woocommerce a.button.alt[disabled]:active,.woocommerce a.button.alt[disabled]:focus,.woocommerce a.button.alt[disabled]:hover,.woocommerce button.button.alt.disabled,.woocommerce button.button.alt.disabled.active,.woocommerce button.button.alt.disabled.focus,.woocommerce button.button.alt.disabled:active,.woocommerce button.button.alt.disabled:focus,.woocommerce button.button.alt.disabled:hover,.woocommerce button.button.alt[disabled],.woocommerce button.button.alt[disabled].active,.woocommerce button.button.alt[disabled].focus,.woocommerce button.button.alt[disabled]:active,.woocommerce button.button.alt[disabled]:focus,.woocommerce button.button.alt[disabled]:hover,.woocommerce input.button.alt.disabled,.woocommerce input.button.alt.disabled.active,.woocommerce input.button.alt.disabled.focus,.woocommerce input.button.alt.disabled:active,.woocommerce input.button.alt.disabled:focus,.woocommerce input.button.alt.disabled:hover,.woocommerce input.button.alt[disabled],.woocommerce input.button.alt[disabled].active,.woocommerce input.button.alt[disabled].focus,.woocommerce input.button.alt[disabled]:active,.woocommerce input.button.alt[disabled]:focus,.woocommerce input.button.alt[disabled]:hover,fieldset[disabled] .woocommerce #respond input#submit.alt,fieldset[disabled] .woocommerce #respond input#submit.alt.active,fieldset[disabled] .woocommerce #respond input#submit.alt.focus,fieldset[disabled] .woocommerce #respond input#submit.alt:active,fieldset[disabled] .woocommerce #respond input#submit.alt:focus,fieldset[disabled] .woocommerce #respond input#submit.alt:hover,fieldset[disabled] .woocommerce a.button.alt,fieldset[disabled] .woocommerce a.button.alt.active,fieldset[disabled] .woocommerce a.button.alt.focus,fieldset[disabled] .woocommerce a.button.alt:active,fieldset[disabled] .woocommerce a.button.alt:focus,fieldset[disabled] .woocommerce a.button.alt:hover,fieldset[disabled] .woocommerce button.button.alt,fieldset[disabled] .woocommerce button.button.alt.active,fieldset[disabled] .woocommerce button.button.alt.focus,fieldset[disabled] .woocommerce button.button.alt:active,fieldset[disabled] .woocommerce button.button.alt:focus,fieldset[disabled] .woocommerce button.button.alt:hover,fieldset[disabled] .woocommerce input.button.alt,fieldset[disabled] .woocommerce input.button.alt.active,fieldset[disabled] .woocommerce input.button.alt.focus,fieldset[disabled] .woocommerce input.button.alt:active,fieldset[disabled] .woocommerce input.button.alt:focus,fieldset[disabled] .woocommerce input.button.alt:hover,.bg-primary,.btn-default .badge,.btn-primary,.btn-primary.disabled,.btn-primary.disabled.active,.btn-primary.disabled.focus,.btn-primary.disabled:active,.btn-primary.disabled:focus,.btn-primary.disabled:hover,.btn-primary[disabled],.btn-primary[disabled].active,.btn-primary[disabled].focus,.btn-primary[disabled]:active,.btn-primary[disabled]:focus,.btn-primary[disabled]:hover,fieldset[disabled] .btn-primary,fieldset[disabled] .btn-primary.active,fieldset[disabled] .btn-primary.focus,fieldset[disabled] .btn-primary:active,fieldset[disabled] .btn-primary:focus,fieldset[disabled] .btn-primary:hover,.dropdown-menu>.active>a,.dropdown-menu>.active>a:focus,.dropdown-menu>.active>a:hover,.nav-pills>li.active>a,.nav-pills>li.active>a:focus,.nav-pills>li.active>a:hover,.pagination>.active>a,.pagination>.active>a:focus,.pagination>.active>a:hover,.pagination>.active>span,.pagination>.active>span:focus,.pagination>.active>span:hover,.label-primary,.progress-bar,.list-group-item.active,.list-group-item.active:focus,.list-group-item.active:hover,.panel-primary>.panel-heading,.active-mobile .input-group-btn,.search-box-wrapper.style-2 .search-box .input-group-btn,.searchform .opal-search .btn-search,.widget_calendar tbody a,.widget_calendar #today,.widget_mc4wp_form_widget .input-group .btn,.navbar-mega .navbar-toggle .icon-bar,.navbar-mega .navbar-nav>.open>a,.navbar-mega .navbar-nav>li>a:focus,.navbar-mega .navbar-nav>li>a:hover,.navbar-mega .navbar-nav>li.active>a,.navbar-mega .navbar-nav>.active,.navbar-mega .text-label.text-featured,.navbar-mega-theme,.vertical-menu.navbar-collapse .navbar-nav li.dropdown,.vertical-menu.navbar-collapse .navbar-nav li .dropdown-menu,.nav-tabs .kc_tabs_nav li:hover a,.nav-tabs .kc_tabs_nav li.ui-tabs-active>a,.tag-links a,.ih-item.square.effect16 .info,.bg-primary,.btn-outline-light.active,.btn-outline-light:active,.btn-outline-light:focus,.btn-outline-light:hover,.open .btn-outline-light.dropdown-toggle,.btn-outline-dark.active,.btn-outline-dark:active,.btn-outline-dark:focus,.btn-outline-dark:hover,.open .btn-outline-dark.dropdown-toggle,.btn-inverse-light .badge,.owl-controls .owl-page span,.dropcap.dropcap-v2,.pricing.pricing-v2 .plan-price,.pricing.pricing-v2 .plan-price .plan-price-body,.pricing.pricing-v2.pricing-highlight .plan-price-body,.pricing.pricing-v2.pricing-highlight .btn-block,.pricing.pricing-v3.pricing-highlight .plan-price,.pricing.pricing-v3.pricing-highlight .plan-title,.pricing.pricing-v3.pricing-highlight .btn-block,.pricing.pricing-highlight .plan-title,.pbr-team.other-team,.feature-box-v3 .fbox-icon i,.kc-element-category-link-wrapper .items .team-header:before,.testimonial-collection.v1 .owl-carousel-play .owl-controls .owl-page.active span,.widget_price_filter .ui-slider .ui-slider-handle,#cart .mini-cart .mini-cart-items,.product-block span.onsale,.product-block span.sale-off,.product-block .add_to_cart_button,.product-block .add-cart a.button.added,.button-action>div.add-cart .yith-wcwl-wishlistaddedbrowse a:hover,.button-action>div.add-cart .yith-wcwl-wishlistexistsbrowse a:hover,.button-action>div.add-cart a.add_to_wishlist:hover,.button-action>div.add-cart a.button:hover,.button-action>div.add-cart a.compare:hover,.button-action>div.add-cart a.quickview:hover,.button-action>div.quick-view .yith-wcwl-wishlistaddedbrowse a:hover,.button-action>div.quick-view .yith-wcwl-wishlistexistsbrowse a:hover,.button-action>div.quick-view a.add_to_wishlist:hover,.button-action>div.quick-view a.button:hover,.button-action>div.quick-view a.compare:hover,.button-action>div.quick-view a.quickview:hover,.button-action>div.yith-compare .yith-wcwl-wishlistaddedbrowse a:hover,.button-action>div.yith-compare .yith-wcwl-wishlistexistsbrowse a:hover,.button-action>div.yith-compare a.add_to_wishlist:hover,.button-action>div.yith-compare a.button:hover,.button-action>div.yith-compare a.compare:hover,.button-action>div.yith-compare a.quickview:hover,.button-action>div.yith-wcwl-add-to-wishlist .yith-wcwl-wishlistaddedbrowse a:hover,.button-action>div.yith-wcwl-add-to-wishlist .yith-wcwl-wishlistexistsbrowse a:hover,.button-action>div.yith-wcwl-add-to-wishlist a.add_to_wishlist:hover,.button-action>div.yith-wcwl-add-to-wishlist a.button:hover,.button-action>div.yith-wcwl-add-to-wishlist a.compare:hover,.button-action>div.yith-wcwl-add-to-wishlist a.quickview:hover,.list .product-block .yith-wcwl-add-button a.add_to_wishlist:hover,.list .product-block .yith-wcwl-add-button a:hover,.list .product-block .yith-wcwl-wishlistaddedbrowse a.add_to_wishlist:hover,.list .product-block .yith-wcwl-wishlistaddedbrowse a:hover,.list .product-block .yith-wcwl-wishlistexistsbrowse a.add_to_wishlist:hover,.list .product-block .yith-wcwl-wishlistexistsbrowse a:hover,.products-list .product-block .yith-wcwl-add-button a.add_to_wishlist:hover,.products-list .product-block .yith-wcwl-add-button a:hover,.products-list .product-block .yith-wcwl-wishlistaddedbrowse a.add_to_wishlist:hover,.products-list .product-block .yith-wcwl-wishlistaddedbrowse a:hover,.products-list .product-block .yith-wcwl-wishlistexistsbrowse a.add_to_wishlist:hover,.products-list .product-block .yith-wcwl-wishlistexistsbrowse a:hover,.list .product-block a.compare:hover,.list .product-block a.quickview:hover,.products-list .product-block a.compare:hover,.products-list .product-block a.quickview:hover,.list .product-block .add-cart a.button:hover,.products-list .product-block .add-cart a.button:hover,.single-product.woocommerce div.product form.cart .button,.products-bottom-wrap nav.woocommerce-pagination ul li span.current,.products-bottom-wrap nav.woocommerce-pagination ul span.current,.products-bottom-wrap nav.woocommerce-pagination ul a:hover,.products-bottom-wrap nav.woocommerce-pagination ul li a:hover,#opal-quickview-modal .product-info a.add_to_cart_button,#opal-quickview-modal .product-info a.product_type_external,#opal-quickview-modal .product-info a.add_to_cart_button:hover,#opal-quickview-modal .product-info a.product_type_external:hover,#opal-quickview-modal .carousel-indicators .active,.woocommerce #respond input#submit,.woocommerce button.button,.woocommerce input.button,.woocommerce #respond input#submit.disabled,.woocommerce #respond input#submit.disabled.active,.woocommerce #respond input#submit.disabled.focus,.woocommerce #respond input#submit.disabled:active,.woocommerce #respond input#submit.disabled:focus,.woocommerce #respond input#submit.disabled:hover,.woocommerce #respond input#submit[disabled],.woocommerce #respond input#submit[disabled].active,.woocommerce #respond input#submit[disabled].focus,.woocommerce #respond input#submit[disabled]:active,.woocommerce #respond input#submit[disabled]:focus,.woocommerce #respond input#submit[disabled]:hover,.woocommerce button.button.disabled,.woocommerce button.button.disabled.active,.woocommerce button.button.disabled.focus,.woocommerce button.button.disabled:active,.woocommerce button.button.disabled:focus,.woocommerce button.button.disabled:hover,.woocommerce button.button[disabled],.woocommerce button.button[disabled].active,.woocommerce button.button[disabled].focus,.woocommerce button.button[disabled]:active,.woocommerce button.button[disabled]:focus,.woocommerce button.button[disabled]:hover,.woocommerce input.button.disabled,.woocommerce input.button.disabled.active,.woocommerce input.button.disabled.focus,.woocommerce input.button.disabled:active,.woocommerce input.button.disabled:focus,.woocommerce input.button.disabled:hover,.woocommerce input.button[disabled],.woocommerce input.button[disabled].active,.woocommerce input.button[disabled].focus,.woocommerce input.button[disabled]:active,.woocommerce input.button[disabled]:focus,.woocommerce input.button[disabled]:hover,fieldset[disabled] .woocommerce #respond input#submit,fieldset[disabled] .woocommerce #respond input#submit.active,fieldset[disabled] .woocommerce #respond input#submit.focus,fieldset[disabled] .woocommerce #respond input#submit:active,fieldset[disabled] .woocommerce #respond input#submit:focus,fieldset[disabled] .woocommerce #respond input#submit:hover,fieldset[disabled] .woocommerce button.button,fieldset[disabled] .woocommerce button.button.active,fieldset[disabled] .woocommerce button.button.focus,fieldset[disabled] .woocommerce button.button:active,fieldset[disabled] .woocommerce button.button:focus,fieldset[disabled] .woocommerce button.button:hover,fieldset[disabled] .woocommerce input.button,fieldset[disabled] .woocommerce input.button.active,fieldset[disabled] .woocommerce input.button.focus,fieldset[disabled] .woocommerce input.button:active,fieldset[disabled] .woocommerce input.button:focus,fieldset[disabled] .woocommerce input.button:hover,.woocommerce #respond input#submit.alt,.woocommerce a.button.alt,.woocommerce button.button.alt,.woocommerce input.button.alt,.woocommerce #respond input#submit.alt.disabled,.woocommerce #respond input#submit.alt.disabled.active,.woocommerce #respond input#submit.alt.disabled.focus,.woocommerce #respond input#submit.alt.disabled:active,.woocommerce #respond input#submit.alt.disabled:focus,.woocommerce #respond input#submit.alt.disabled:hover,.woocommerce #respond input#submit.alt[disabled],.woocommerce #respond input#submit.alt[disabled].active,.woocommerce #respond input#submit.alt[disabled].focus,.woocommerce #respond input#submit.alt[disabled]:active,.woocommerce #respond input#submit.alt[disabled]:focus,.woocommerce #respond input#submit.alt[disabled]:hover,.woocommerce a.button.alt.disabled,.woocommerce a.button.alt.disabled.active,.woocommerce a.button.alt.disabled.focus,.woocommerce a.button.alt.disabled:active,.woocommerce a.button.alt.disabled:focus,.woocommerce a.button.alt.disabled:hover,.woocommerce a.button.alt[disabled],.woocommerce a.button.alt[disabled].active,.woocommerce a.button.alt[disabled].focus,.woocommerce a.button.alt[disabled]:active,.woocommerce a.button.alt[disabled]:focus,.woocommerce a.button.alt[disabled]:hover,.woocommerce button.button.alt.disabled,.woocommerce button.button.alt.disabled.active,.woocommerce button.button.alt.disabled.focus,.woocommerce button.button.alt.disabled:active,.woocommerce button.button.alt.disabled:focus,.woocommerce button.button.alt.disabled:hover,.woocommerce button.button.alt[disabled],.woocommerce button.button.alt[disabled].active,.woocommerce button.button.alt[disabled].focus,.woocommerce button.button.alt[disabled]:active,.woocommerce button.button.alt[disabled]:focus,.woocommerce button.button.alt[disabled]:hover,.woocommerce input.button.alt.disabled,.woocommerce input.button.alt.disabled.active,.woocommerce input.button.alt.disabled.focus,.woocommerce input.button.alt.disabled:active,.woocommerce input.button.alt.disabled:focus,.woocommerce input.button.alt.disabled:hover,.woocommerce input.button.alt[disabled],.woocommerce input.button.alt[disabled].active,.woocommerce input.button.alt[disabled].focus,.woocommerce input.button.alt[disabled]:active,.woocommerce input.button.alt[disabled]:focus,.woocommerce input.button.alt[disabled]:hover,fieldset[disabled] .woocommerce #respond input#submit.alt,fieldset[disabled] .woocommerce #respond input#submit.alt.active,fieldset[disabled] .woocommerce #respond input#submit.alt.focus,fieldset[disabled] .woocommerce #respond input#submit.alt:active,fieldset[disabled] .woocommerce #respond input#submit.alt:focus,fieldset[disabled] .woocommerce #respond input#submit.alt:hover,fieldset[disabled] .woocommerce a.button.alt,fieldset[disabled] .woocommerce a.button.alt.active,fieldset[disabled] .woocommerce a.button.alt.focus,fieldset[disabled] .woocommerce a.button.alt:active,fieldset[disabled] .woocommerce a.button.alt:focus,fieldset[disabled] .woocommerce a.button.alt:hover,fieldset[disabled] .woocommerce button.button.alt,fieldset[disabled] .woocommerce button.button.alt.active,fieldset[disabled] .woocommerce button.button.alt.focus,fieldset[disabled] .woocommerce button.button.alt:active,fieldset[disabled] .woocommerce button.button.alt:focus,fieldset[disabled] .woocommerce button.button.alt:hover,fieldset[disabled] .woocommerce input.button.alt,fieldset[disabled] .woocommerce input.button.alt.active,fieldset[disabled] .woocommerce input.button.alt.focus,fieldset[disabled] .woocommerce input.button.alt:active,fieldset[disabled] .woocommerce input.button.alt:focus,fieldset[disabled] .woocommerce input.button.alt:hover,.woocommerce .wishlist_table td.product-add-to-cart a{
                background-color:<?php echo esc_html($allegro_maincolor_primary_color); ?>;
            }

    </style>
    <?php
    endif;/* OpalTool: end inject code */
}
endif; // allegro_fnc_header_style


if ( ! function_exists( 'allegro_fnc_admin_header_style' ) ) :
/**
 * Style the header image displayed on the Appearance > Header screen.
 *
 * @see allegro_fnc_custom_header_setup()
 *
 * @since allegro 1.0
 */
function allegro_fnc_admin_header_style() {  
?>
	<style type="text/css" id="allegro-admin-header-css">
	.appearance_page_custom-header #headimg {
		background-color: #000;
		border: none;
		max-width: 1260px;
		min-height: 48px;
	}
	#headimg h1 {
		font-family: Lato, sans-serif;
		font-size: 18px;
		line-height: 48px;
		margin: 0 0 0 30px;
	}
	.rtl #headimg h1  {
		margin: 0 30px 0 0;
	}
	#headimg h1 a {
		color: #fff;
		text-decoration: none;
	}
	#headimg img {
		vertical-align: middle;
	}

<?php
}
endif; // allegro_fnc_admin_header_style

if ( ! function_exists( 'allegro_fnc_admin_header_image' ) ) :
/**
 * Create the custom header image markup displayed on the Appearance > Header screen.
 *
 * @see allegro_fnc_custom_header_setup()
 *
 * @since allegro 1.0
 */
function allegro_fnc_admin_header_image() {
?>
	<div id="headimg">
		<?php if ( get_header_image() ) : ?>
		<img src="<?php header_image(); ?>" alt="">
		<?php endif; ?>
		<h1 class="displaying-header-text"><a id="name" style="<?php echo esc_attr( sprintf( 'color: #%s;', get_header_textcolor() ) ); ?>" onclick="return false;" href="<?php echo esc_url( home_url( '/' ) ); ?>" tabindex="-1"><?php bloginfo( 'name' ); ?></a></h1>
	</div>
<?php
}
endif; // allegro_fnc_admin_header_image