<?php
/**
 * The template for displaying the footer
 *
 * Contains footer content and the closing of the #main and #page div elements.
 *
 * @package WpOpal
 * @subpackage allegro
 * @since allegro 1.0
 */
 

?>
		</section><!-- #main -->
		<?php do_action( 'allegro_template_main_after' ); ?>
		<?php do_action( 'allegro_template_footer_before' ); ?>
		<footer id="opal-footer" class="opal-footer" role="contentinfo">
			<?php echo allegro_display_footer_content(); ?>
			
			<div class="container">
				<div class="row">
					<?php get_sidebar( 'mass-footer-body' );  ?>	
				</div>
			</div>
			<section class="opal-copyright clearfix">
				<div class="container">
					<a href="#" class="scrollup"><span class="fa fa-angle-up"></span></a>
					<?php do_action( 'allegro_fnc_credits' ); ?>
					<div class="copyright-link pull-right nav-menu hidden-xs"><?php dynamic_sidebar( 'copyright-link' ); ?></div>
					<div class="text-copyright text-center">
						<?php 
							allegro_display_footer_copyright();
						?>
					</div>
					
					<?php $img_link = allegro_fnc_theme_options('image-payment', ''); ?>
               <?php if(!empty($img_link)): ?>
               	<div class="payment text-center">
                  	<img src="<?php echo esc_url_raw($img_link); ?>" alt ="<?php esc_html_e('Payment logo', 'allegro');?>">
                  </div>
               <?php endif; ?>
					
				</div>	
			</section>
		</footer><!-- #colophon -->
		

		<?php do_action( 'allegro_template_footer_after' ); ?>
		<?php get_sidebar( 'offcanvas' );  ?>
	</div>
</div>
	<!-- #page -->

<?php wp_footer(); ?>
</body>
</html>