<?php
/**
 * mode Customizer support
 *
 * @package WpOpal
 * @subpackage allegro
 * @since allegro 1.0
 */
//Update logo wordpress 4.5
if (version_compare($GLOBALS['wp_version'], '4.5', '>=')) {
    function allegro_fnc_setup_logo()
    {
        add_theme_support('custom-logo');
    }

    add_action('after_setup_theme', 'allegro_fnc_setup_logo');
}
if ( ! function_exists( 'allegro_fnc_customize_register' ) ) :
function allegro_fnc_customize_register($wp_customize){
    $wp_customize->remove_section('colors');

    // Add Panel Colors
    $wp_customize->add_panel('colors', array(
        'priority' => 15,
        'capability' => 'edit_theme_options',
        'theme_supports' => '',
        'title' => esc_html__('Colors', 'allegro'),
    ));
    /* OpalTool: inject code */
    
    // Primary Color
    $wp_customize->add_section('allegro_main_color', array(
        'title'      => esc_html__('Main Color', 'allegro'),
        'transport'  => 'postMessage',
        'priority'   => 10,
        'panel'      => 'colors'
    ));
    $wp_customize->add_setting('allegro_maincolor_primary_color', array(
        'default'    => get_option('allegro_maincolor_primary_color'),
        'type'       => 'option',
        'capability' => 'manage_options',
        'transport'  => 'postMessage',
        'sanitize_callback' => 'sanitize_text_field'
    ) );

    // Add Control header_bg
    $wp_customize->add_control('allegro_maincolor_primary_color', array(
        'label'    => esc_html__('Primary Color', 'allegro'),
        'section'  => 'allegro_main_color',
        'type'      => 'color',
    ) );/* OpalTool: end inject code */
        // Add Section topbar
    $wp_customize->add_section('allegro_color_topbar', array(
        'title'      => esc_html__('Topbar', 'allegro'),
        'transport'  => 'postMessage',
        'priority'   => 10,
        'panel'      => 'colors'
    ));    // Add setting topbar_bg
    $wp_customize->add_setting('allegro_color_topbar_bg', array(
        'default'    => get_option('allegro_color_topbar_bg'),
        'type'       => 'option',
        'capability' => 'manage_options',
        'transport'  => 'postMessage',
        'sanitize_callback' => 'sanitize_text_field'
    ) );

    // Add Control topbar_bg
    $wp_customize->add_control('allegro_color_topbar_bg', array(
        'label'    => esc_html__('Topbar Background', 'allegro'),
        'section'  => 'allegro_color_topbar',
        'type'      => 'color',
    ) );
    // Add setting topbar_color
    $wp_customize->add_setting('allegro_color_topbar_color', array(
        'default'    => get_option('allegro_color_topbar_color'),
        'type'       => 'option',
        'capability' => 'manage_options',
        'transport'  => 'postMessage',
        'sanitize_callback' => 'sanitize_text_field'
    ) );

    // Add Control topbar_color
    $wp_customize->add_control('allegro_color_topbar_color', array(
        'label'    => esc_html__('Topbar color', 'allegro'),
        'section'  => 'allegro_color_topbar',
        'type'      => 'color',
    ) );
    // Add setting topbar_hover_color
    $wp_customize->add_setting('allegro_color_topbar_hover_color', array(
        'default'    => get_option('allegro_color_topbar_hover_color'),
        'type'       => 'option',
        'capability' => 'manage_options',
        'transport'  => 'postMessage',
        'sanitize_callback' => 'sanitize_text_field'
    ) );

    // Add Control topbar_hover_color
    $wp_customize->add_control('allegro_color_topbar_hover_color', array(
        'label'    => esc_html__('Topbar Link Hover', 'allegro'),
        'section'  => 'allegro_color_topbar',
        'type'      => 'color',
    ) );
    // Add Section header
    $wp_customize->add_section('allegro_color_header', array(
        'title'      => esc_html__('Header', 'allegro'),
        'transport'  => 'postMessage',
        'priority'   => 10,
        'panel'      => 'colors'
    ));    // Add setting header_bg
    $wp_customize->add_setting('allegro_color_header_bg', array(
        'default'    => get_option('allegro_color_header_bg'),
        'type'       => 'option',
        'capability' => 'manage_options',
        'transport'  => 'postMessage',
        'sanitize_callback' => 'sanitize_text_field'
    ) );

    // Add Control header_bg
    $wp_customize->add_control('allegro_color_header_bg', array(
        'label'    => esc_html__('Header Background', 'allegro'),
        'section'  => 'allegro_color_header',
        'type'      => 'color',
    ) );
    // Add setting header_color
    $wp_customize->add_setting('allegro_color_header_color', array(
        'default'    => get_option('allegro_color_header_color'),
        'type'       => 'option',
        'capability' => 'manage_options',
        'transport'  => 'postMessage',
        'sanitize_callback' => 'sanitize_text_field'
    ) );

    // Add Control header_color
    $wp_customize->add_control('allegro_color_header_color', array(
        'label'    => esc_html__('Header color', 'allegro'),
        'section'  => 'allegro_color_header',
        'type'      => 'color',
    ) );
    // Add setting btn_search_bg
    $wp_customize->add_setting('allegro_color_btn_search_bg', array(
        'default'    => get_option('allegro_color_btn_search_bg'),
        'type'       => 'option',
        'capability' => 'manage_options',
        'transport'  => 'postMessage',
        'sanitize_callback' => 'sanitize_text_field'
    ) );

    // Add Control btn_search_bg
    $wp_customize->add_control('allegro_color_btn_search_bg', array(
        'label'    => esc_html__('Button search Background', 'allegro'),
        'section'  => 'allegro_color_header',
        'type'      => 'color',
    ) );
    // Add setting keep_header_bg
    $wp_customize->add_setting('allegro_color_keep_header_bg', array(
        'default'    => get_option('allegro_color_keep_header_bg'),
        'type'       => 'option',
        'capability' => 'manage_options',
        'transport'  => 'postMessage',
        'sanitize_callback' => 'sanitize_text_field'
    ) );

    // Add Control keep_header_bg
    $wp_customize->add_control('allegro_color_keep_header_bg', array(
        'label'    => esc_html__('Header sticky Background', 'allegro'),
        'section'  => 'allegro_color_header',
        'type'      => 'color',
    ) );
    // Add Section menu
    $wp_customize->add_section('allegro_color_menu', array(
        'title'      => esc_html__('Menu', 'allegro'),
        'transport'  => 'postMessage',
        'priority'   => 10,
        'panel'      => 'colors'
    ));    // Add setting menu_bg
    $wp_customize->add_setting('allegro_color_menu_bg', array(
        'default'    => get_option('allegro_color_menu_bg'),
        'type'       => 'option',
        'capability' => 'manage_options',
        'transport'  => 'postMessage',
        'sanitize_callback' => 'sanitize_text_field'
    ) );

    // Add Control menu_bg
    $wp_customize->add_control('allegro_color_menu_bg', array(
        'label'    => esc_html__('Megamenu background', 'allegro'),
        'section'  => 'allegro_color_menu',
        'type'      => 'color',
    ) );
    // Add setting menu_color
    $wp_customize->add_setting('allegro_color_menu_color', array(
        'default'    => get_option('allegro_color_menu_color'),
        'type'       => 'option',
        'capability' => 'manage_options',
        'transport'  => 'postMessage',
        'sanitize_callback' => 'sanitize_text_field'
    ) );

    // Add Control menu_color
    $wp_customize->add_control('allegro_color_menu_color', array(
        'label'    => esc_html__('Megamenu color', 'allegro'),
        'section'  => 'allegro_color_menu',
        'type'      => 'color',
    ) );
    // Add setting menu_hover_bg
    $wp_customize->add_setting('allegro_color_menu_hover_bg', array(
        'default'    => get_option('allegro_color_menu_hover_bg'),
        'type'       => 'option',
        'capability' => 'manage_options',
        'transport'  => 'postMessage',
        'sanitize_callback' => 'sanitize_text_field'
    ) );

    // Add Control menu_hover_bg
    $wp_customize->add_control('allegro_color_menu_hover_bg', array(
        'label'    => esc_html__('Megamenu Hover Item', 'allegro'),
        'section'  => 'allegro_color_menu',
        'type'      => 'color',
    ) );
    // Add setting menu_hover_color
    $wp_customize->add_setting('allegro_color_menu_hover_color', array(
        'default'    => get_option('allegro_color_menu_hover_color'),
        'type'       => 'option',
        'capability' => 'manage_options',
        'transport'  => 'postMessage',
        'sanitize_callback' => 'sanitize_text_field'
    ) );

    // Add Control menu_hover_color
    $wp_customize->add_control('allegro_color_menu_hover_color', array(
        'label'    => esc_html__('Megamenu hover color', 'allegro'),
        'section'  => 'allegro_color_menu',
        'type'      => 'color',
    ) );
    // Add Section footer
    $wp_customize->add_section('allegro_color_footer', array(
        'title'      => esc_html__('Footer', 'allegro'),
        'transport'  => 'postMessage',
        'priority'   => 10,
        'panel'      => 'colors'
    ));    // Add setting footer_bg
    $wp_customize->add_setting('allegro_color_footer_bg', array(
        'default'    => get_option('allegro_color_footer_bg'),
        'type'       => 'option',
        'capability' => 'manage_options',
        'transport'  => 'postMessage',
        'sanitize_callback' => 'sanitize_text_field'
    ) );

    // Add Control footer_bg
    $wp_customize->add_control('allegro_color_footer_bg', array(
        'label'    => esc_html__('Footer BG', 'allegro'),
        'section'  => 'allegro_color_footer',
        'type'      => 'color',
    ) );
    // Add setting footer_color
    $wp_customize->add_setting('allegro_color_footer_color', array(
        'default'    => get_option('allegro_color_footer_color'),
        'type'       => 'option',
        'capability' => 'manage_options',
        'transport'  => 'postMessage',
        'sanitize_callback' => 'sanitize_text_field'
    ) );

    // Add Control footer_color
    $wp_customize->add_control('allegro_color_footer_color', array(
        'label'    => esc_html__('Footer Color', 'allegro'),
        'section'  => 'allegro_color_footer',
        'type'      => 'color',
    ) );
    // Add setting heading_color
    $wp_customize->add_setting('allegro_color_heading_color', array(
        'default'    => get_option('allegro_color_heading_color'),
        'type'       => 'option',
        'capability' => 'manage_options',
        'transport'  => 'postMessage',
        'sanitize_callback' => 'sanitize_text_field'
    ) );

    // Add Control heading_color
    $wp_customize->add_control('allegro_color_heading_color', array(
        'label'    => esc_html__('Heading Color', 'allegro'),
        'section'  => 'allegro_color_footer',
        'type'      => 'color',
    ) );
    // Add setting newsletter_bg
    $wp_customize->add_setting('allegro_color_newsletter_bg', array(
        'default'    => get_option('allegro_color_newsletter_bg'),
        'type'       => 'option',
        'capability' => 'manage_options',
        'transport'  => 'postMessage',
        'sanitize_callback' => 'sanitize_text_field'
    ) );

    // Add Control newsletter_bg
    $wp_customize->add_control('allegro_color_newsletter_bg', array(
        'label'    => esc_html__('Newsletter Background', 'allegro'),
        'section'  => 'allegro_color_footer',
        'type'      => 'color',
    ) );
    // Add setting copyright_bg
    $wp_customize->add_setting('allegro_color_copyright_bg', array(
        'default'    => get_option('allegro_color_copyright_bg'),
        'type'       => 'option',
        'capability' => 'manage_options',
        'transport'  => 'postMessage',
        'sanitize_callback' => 'sanitize_text_field'
    ) );

    // Add Control copyright_bg
    $wp_customize->add_control('allegro_color_copyright_bg', array(
        'label'    => esc_html__('Footer Copyright Background', 'allegro'),
        'section'  => 'allegro_color_footer',
        'type'      => 'color',
    ) );
    // Add setting copyright_color
    $wp_customize->add_setting('allegro_color_copyright_color', array(
        'default'    => get_option('allegro_color_copyright_color'),
        'type'       => 'option',
        'capability' => 'manage_options',
        'transport'  => 'postMessage',
        'sanitize_callback' => 'sanitize_text_field'
    ) );

    // Add Control copyright_color
    $wp_customize->add_control('allegro_color_copyright_color', array(
        'label'    => esc_html__('Copyright Color', 'allegro'),
        'section'  => 'allegro_color_footer',
        'type'      => 'color',
    ) );

}
endif;
add_action('customize_register', 'allegro_fnc_customize_register', 99);