<?php
/**
 * The default template for displaying content
 *
 * Used for both single and index/archive/search.
 *
 * @package WpOpal
 * @subpackage allegro
 * @since allegro 1.0
 */
?>
<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
	<?php allegro_fnc_post_thumbnail(); ?>

	<div class="bottom blogv1">
		<header class="entry-header">
			<?php if ( in_array( 'category', get_object_taxonomies( get_post_type() ) ) && allegro_fnc_categorized_blog() ) : ?>
			
			<?php
				if ( is_single() ) :
					the_title( '<h1 class="entry-title">', '</h1>' );
				else :
					the_title( '<h3 class="entry-title"><a href="' . esc_url( get_permalink() ) . '" rel="bookmark">', '</a></h3>' );
				endif;
			?>
			<div class="entry-meta">

				<div class="author"><i class="fa fa-user" aria-hidden="true"></i><?php the_author_posts_link(); ?></div>

				<?php
					if ( 'post' == get_post_type() )
						allegro_fnc_posted_on();

					if ( ! post_password_required() && ( comments_open() || get_comments_number() ) ) :
				?>

				<div class="comments-link"><i class="fa fa-comments-o" aria-hidden="true"></i><?php comments_popup_link(esc_html__( '1 Comment', 'allegro' ), esc_html__( '% Comments', 'allegro' ) ); ?></div>
			
				<?php
					endif;
					
				?>
			</div><!-- .entry-meta -->
			<?php
				endif;
			?>
		</header><!-- .entry-header -->

		<div class="entry-content">
			<?php
				/* translators: %s: Name of current post */
				echo allegro_fnc_excerpt( 25, '...' );
			?>
			<div class="readmore"><a href="<?php echo esc_url( get_permalink() );?>"> <?php esc_html_e('read more', 'allegro');?></a></div>
		</div><!-- .entry-content -->
	</div>
 
	<?php //the_tags( '<footer class="entry-meta"><span class="tag-links">', '', '</span></footer>' ); ?>
</article><!-- #post-## -->
