<?php
// Include database connection
require_once 'admin/config/database.php';

// Get video ID from URL parameter
$id = isset($_GET['id']) ? $_GET['id'] : '';

// If specific video ID is provided, fetch and display that video
if (!empty($id)) {
    try {
        $pdo = getConnection();
        
        // Get specific video by ID
        $stmt = $pdo->prepare("SELECT id, name, title, url_path, created_at FROM video WHERE id = ?");
        $stmt->execute([$id]);
        $video = $stmt->fetch();
        
        if ($video) {
            $videoTitle = htmlspecialchars($video['title']);
            $videoUrl = htmlspecialchars($video['url_path']);
            $videoName = htmlspecialchars($video['name']);
        } else {
            // Video not found, redirect to main video page
            header("Location: video");
            die();
        }
        
    } catch(PDOException $e) {
        // Database error, redirect to main video page
        header("Location: video");
        die();
    }
}
?>

<!doctype html>
<html>

    <head>
            <title>CSIAP Sri Lanka</title>
    </head>

    <?php include('includes/header.php'); ?>

    <body>

        <!-- <div class="preloader">
            <div class="lds-ripple">
                <div></div>
                <div></div>
            </div>
        </div> -->

        <?php include('includes/navbar.php'); ?>

        <div class="page-title-area">
            <div class="d-table">
                <div class="d-table-cell">
                    <div class="container">
                        <div class="page-title-content">
                            <h2><?php echo (isset($videoTitle)) ? $videoTitle : 'Videos'; ?></h2>
                            <ul>
                                <li><a href="index">Home</a></li>
                                <li>Videos</li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <section class="summary-section pt-100">
            <div class="container">
                <div class="row align-items-center">
                    <div class="col-md-12">
                        <div class="row">

<?php if (!empty($id) && isset($video)) { ?>

    <!-- Display specific video -->
    <div class="col-md-12" style="padding-bottom: 30px;">
        <div class="fun-facts-content-area-custom">
            <?php
            // Check if it's a YouTube link or direct video file
            $isYouTube = (strpos($videoUrl, 'youtube.com') !== false || strpos($videoUrl, 'youtu.be') !== false);
            
            if ($isYouTube) {
                // Extract YouTube video ID from various formats
                $videoId = '';
                
                // Handle embed URLs: https://www.youtube.com/embed/VIDEO_ID
                if (preg_match('/youtube\.com\/embed\/([a-zA-Z0-9_-]+)/', $videoUrl, $matches)) {
                    $videoId = $matches[1];
                }
                // Handle watch URLs: https://www.youtube.com/watch?v=VIDEO_ID
                elseif (preg_match('/youtube\.com\/watch\?v=([a-zA-Z0-9_-]+)/', $videoUrl, $matches)) {
                    $videoId = $matches[1];
                }
                // Handle short URLs: https://youtu.be/VIDEO_ID
                elseif (preg_match('/youtu\.be\/([a-zA-Z0-9_-]+)/', $videoUrl, $matches)) {
                    $videoId = $matches[1];
                }
                
                if ($videoId) {
                    echo '<iframe width="100%" height="500px" src="https://www.youtube.com/embed/' . $videoId . '" frameborder="0" allow="accelerometer; autoplay; encrypted-media; gyroscope; picture-in-picture" allowfullscreen></iframe>';
                }
            } else {
                // Handle direct video files (MP4, AVI, etc.)
                echo '<video controls style="width: 100%; height: 500px;">';
                echo '<source src="' . $videoUrl . '" type="video/mp4">';
                echo '<source src="' . $videoUrl . '" type="video/avi">';
                echo '<source src="' . $videoUrl . '" type="video/mov">';
                echo 'Your browser does not support the video element.';
                echo '</video>';
            }
            ?>
            <h6 class="text-center" style="padding-top: 10px;"><?php echo $videoTitle; ?></h6>
        </div>
    </div>

<?php } else { ?>

    <!-- Display all videos grid -->
    <?php
    try {
        $pdo = getConnection();
        
        // Get all videos, ordered by ID (1, 2, 3...)
        $stmt = $pdo->prepare("SELECT id, name, title, url_path, created_at FROM video ORDER BY id ASC");
        $stmt->execute();
        $videoItems = $stmt->fetchAll();
        
        if (empty($videoItems)) {
            echo '<div class="col-md-12 text-center">';
            echo '<div class="alert alert-info">';
            echo '<h4>No Videos Available</h4>';
            echo '<p>There are currently no videos in the database.</p>';
            echo '</div>';
            echo '</div>';
        } else {
            // Display each video
            foreach ($videoItems as $video) {
                $videoName = htmlspecialchars($video['name']);
                $videoTitle = htmlspecialchars($video['title']);
                $videoUrl = htmlspecialchars($video['url_path']);
                $videoId = $video['id'];
                
                // Check if video URL exists and is valid
                if (!empty($videoUrl)) {
                    echo '<div class="col-md-4" style="padding-bottom: 30px;">';
                    echo '<div class="fun-facts-content-area-custom">';
                    
                    // Check if it's a YouTube link or direct video file
                    $isYouTube = (strpos($videoUrl, 'youtube.com') !== false || strpos($videoUrl, 'youtu.be') !== false);
                    
                    if ($isYouTube) {
                        // Extract YouTube video ID from various formats
                        $youtubeId = '';
                        
                        // Handle embed URLs: https://www.youtube.com/embed/VIDEO_ID
                        if (preg_match('/youtube\.com\/embed\/([a-zA-Z0-9_-]+)/', $videoUrl, $matches)) {
                            $youtubeId = $matches[1];
                        }
                        // Handle watch URLs: https://www.youtube.com/watch?v=VIDEO_ID
                        elseif (preg_match('/youtube\.com\/watch\?v=([a-zA-Z0-9_-]+)/', $videoUrl, $matches)) {
                            $youtubeId = $matches[1];
                        }
                        // Handle short URLs: https://youtu.be/VIDEO_ID
                        elseif (preg_match('/youtu\.be\/([a-zA-Z0-9_-]+)/', $videoUrl, $matches)) {
                            $youtubeId = $matches[1];
                        }
                        
                        if ($youtubeId) {
                            echo '<iframe width="100%" height="300px" src="https://www.youtube.com/embed/' . $youtubeId . '" frameborder="0" allow="accelerometer; autoplay; encrypted-media; gyroscope; picture-in-picture" allowfullscreen></iframe>';
                        }
                    } else {
                        // Handle direct video files (MP4, AVI, etc.)
                        echo '<video controls style="width: 100%; height: 300px;">';
                        echo '<source src="' . $videoUrl . '" type="video/mp4">';
                        echo '<source src="' . $videoUrl . '" type="video/avi">';
                        echo '<source src="' . $videoUrl . '" type="video/mov">';
                        echo 'Your browser does not support the video element.';
                        echo '</video>';
                    }
                    
                    echo '<a href="video?id=' . $videoId . '"><h6 class="text-center" style="padding-top: 10px;">' . $videoTitle . '</h6></a>';
                    echo '</div>';
                    echo '</div>';
                }
            }
        }
        
    } catch(PDOException $e) {
        // Display error message if database connection fails
        echo '<div class="col-md-12 text-center">';
        echo '<div class="alert alert-danger">';
        echo '<h4>Database Error</h4>';
        echo '<p>Unable to load videos: ' . htmlspecialchars($e->getMessage()) . '</p>';
        echo '</div>';
        echo '</div>';
    }
    ?>

<?php } ?>

                        </div>
                    </div>
                </div>
            </div>
            <div class="summary-shape-image">
                <img src="assets\img\summary\shape.png" alt="image">
            </div>
        </section>

        <?php include('includes/footer.php'); ?>

        <div class="go-top">
            <i class="fas fa-chevron-up"></i>
            <i class="fas fa-chevron-up"></i>
        </div>

        <script src="assets\js\jquery.min.js"></script>
        <script src="assets\js\popper.min.js"></script>
        <script src="assets\js\bootstrap.min.js"></script>
        <script src="assets\js\owl.carousel.min.js"></script>
        <script src="assets\js\jquery.meanmenu.js"></script>
        <script src="assets\js\jquery.magnific-popup.min.js"></script>
        <script src="assets\js\jquery.appear.min.js"></script>
        <script src="assets\js\odometer.min.js"></script>
        <script src="assets\js\imagelightbox.min.js"></script>
        <script src="assets\js\jquery.nice-select.min.js"></script>
        <script src="assets\js\jquery.ajaxchimp.min.js"></script>
        <script src="assets\js\form-validator.min.js"></script>
        <script src="assets\js\contact-form-script.js"></script>
        <script src="assets\js\main.js"></script>
    </body>
</html>