<!doctype html>
<html>

    <head>
            <title>CSIAP Sri Lanka</title>
    </head>

    <?php include('includes/header.php'); ?>

    <body>

<!--         <div class="preloader">
            <div class="lds-ripple">
                <div></div>
                <div></div>
            </div>
        </div> -->

        <?php include('includes/navbar.php'); ?>

        <div class="page-title-area">
            <div class="d-table">
                <div class="d-table-cell">
                    <div class="container">
                        <div class="page-title-content">
                            <h2>Photos</h2>
                            <ul>
                                <li><a href="index">Home</a></li>
                                <li>Photos</li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <section class="summary-section pt-100">
            <div class="container">
                <div class="row align-items-center">
                    <div class="col-md-12">
                        <div class="row">

<?php
// Include database connection
require_once 'admin/config/database.php';

// Fetch photos data from database
try {
    $pdo = getConnection();
    
    // Get all active photos, ordered by created_at (newest first)
    $stmt = $pdo->prepare("SELECT id, name, image_path, status, created_at FROM photos WHERE status = 'active' ORDER BY created_at DESC");
    $stmt->execute();
    $photoItems = $stmt->fetchAll();
    
    if (empty($photoItems)) {
        echo '<div class="col-md-12 text-center">';
        echo '<div class="alert alert-info">';
        echo '<h4>No Photos Available</h4>';
        echo '<p>There are currently no photos in the database.</p>';
        echo '</div>';
        echo '</div>';
    } else {
        // Display each photo
        foreach ($photoItems as $photo) {
            $photoName = htmlspecialchars($photo['name']);
            $imagePath = htmlspecialchars($photo['image_path']);
            $photoId = $photo['id'];
            
            // Check if image path exists and is valid
            if (!empty($imagePath)) {
                echo '<div class="col-md-3" style="padding-bottom: 30px;">';
                echo '<div class="">';
                echo '<div class="single-gallery-box">';
                echo '<img src="' . $imagePath . '" alt="' . $photoName . '" style="width: 100%; height: 200px; object-fit: cover;">';
                echo '<a href="' . $imagePath . '" class="gallery-btn" data-imagelightbox="popup-btn">';
                echo '<i class="flaticon-view"></i>';
                echo '</a>';
                echo '</div>';
                echo '</div>';
                echo '</div>';
            }
        }
    }
    
} catch(PDOException $e) {
    // Display error message if database connection fails
    echo '<div class="col-md-12 text-center">';
    echo '<div class="alert alert-danger">';
    echo '<h4>Database Error</h4>';
    echo '<p>Unable to load photos: ' . htmlspecialchars($e->getMessage()) . '</p>';
    echo '</div>';
    echo '</div>';
}
?>

                        </div>
                    </div>
                </div>
            </div>
            <div class="summary-shape-image">
                <img src="assets\img\summary\shape.png" alt="image">
            </div>
        </section>

        <?php include('includes/footer.php'); ?>

        <div class="go-top">
            <i class="fas fa-chevron-up"></i>
            <i class="fas fa-chevron-up"></i>
        </div>

        <script src="assets\js\jquery.min.js"></script>
        <script src="assets\js\popper.min.js"></script>
        <script src="assets\js\bootstrap.min.js"></script>
        <script src="assets\js\owl.carousel.min.js"></script>
        <script src="assets\js\jquery.meanmenu.js"></script>
        <script src="assets\js\jquery.magnific-popup.min.js"></script>
        <script src="assets\js\jquery.appear.min.js"></script>
        <script src="assets\js\odometer.min.js"></script>
        <script src="assets\js\imagelightbox.min.js"></script>
        <script src="assets\js\jquery.nice-select.min.js"></script>
        <script src="assets\js\jquery.ajaxchimp.min.js"></script>
        <script src="assets\js\form-validator.min.js"></script>
        <script src="assets\js\contact-form-script.js"></script>
        <script src="assets\js\main.js"></script>
    </body>
</html>

