
<html>



    <head>

            <title>CSIAP Sri Lanka</title>

    </head>



    <?php include('includes/header.php'); ?>



    <style>

        .bg { background:#D6E3BC; }

        .bgcenter { text-align:center; background:#D6E3BC; }

        .verticle-middle { vertical-align: middle !important; }

        .fa-file-pdf:hover { color: #c41c1c; }

    </style>



    <body>



        <div class="preloader">

            <div class="lds-ripple">

                <div></div>

                <div></div>

            </div>

        </div>



        <?php include('includes/navbar.php'); ?>



        <div class="page-title-area">

            <div class="d-table">

                <div class="d-table-cell">

                    <div class="container">

                        <div class="page-title-content">

                            <h2>Bid Notices</h2>

                            <ul>

                                <li><a href="index">Home</a></li>

                                <li>Public Notice</li>

                            </ul>

                        </div>

                    </div>

                </div>

            </div>

        </div>



        <div class="summary-shape-image">

            <img src="assets\img\summary\shape.png" alt="image">

        </div>



        <section class="summary-section">

            <div class="container">

                <div class="section-title">

                    <h3></h3>

                </div>



                <table class="table table-bordered">

                    <tbody>

                        <tr>

                            <th width="50%" class='bg text-center'>Description</th>

                            <th width="20%" class='bg text-center'>Date of Published</th>

                            <th width="20%" class='bg text-center'>Closing Date</th>

                            <th width="50%" class='bg text-center'>Notice</th>

                        </tr>
<?php
require_once 'admin/config/database.php';

function formatDateSup($dateStr) {
    if (empty($dateStr)) return '';
    $ts = strtotime($dateStr);
    if ($ts === false) return htmlspecialchars($dateStr);
    $day = (int)date('j', $ts);
    $suffix = 'th';
    if (!in_array($day % 100, [11,12,13])) {
        $map = [1=>'st',2=>'nd',3=>'rd'];
        if (isset($map[$day % 10])) $suffix = $map[$day % 10];
    }
    return $day . '<sup>' . $suffix . '</sup> ' . date('M Y', $ts);
}

try {
    $pdo = getConnection();
    $stmt = $pdo->prepare("SELECT id, description, published_date, closing_date FROM bidnotices ORDER BY id ASC");
    $stmt->execute();
    $notices = $stmt->fetchAll();

    if (empty($notices)) {
        echo "<tr><td colspan='4' class='text-center'>No bid notices found.</td></tr>";
    } else {
        $imgStmt = $pdo->prepare("SELECT image_path FROM bidnotice_images WHERE bidnotice_id = ? ORDER BY id ASC");
        foreach ($notices as $notice) {
            $desc = htmlspecialchars($notice['description']);
            $pub  = formatDateSup($notice['published_date']);
            $clo  = formatDateSup($notice['closing_date']);

            echo "<tr>";
            echo "<td class=''>" . $desc . "</td>";
            echo "<td class='text-center'>" . $pub . "</td>";
            echo "<td class='text-center'>" . $clo . "</td>";
            echo "<td class='text-center'>";

            $imgStmt->execute([$notice['id']]);
            $images = $imgStmt->fetchAll();
            if (!empty($images)) {
                foreach ($images as $img) {
                    $path = htmlspecialchars($img['image_path']);
                    $lower = strtolower($path);
                    $isPdf = substr($lower, -4) === '.pdf';
                    $icon = $isPdf ? 'fa-file-pdf' : 'fa-file-image';
                    echo "<a href='" . $path . "' target='_blank' style='margin:0 6px;'><i class='fas " . $icon . "' style='font-size: 50px;'></i></a>";
                }
            } else {
                echo "-";
            }

            echo "</td>";
            echo "</tr>";
        }
    }
} catch (Exception $e) {
    echo "<tr><td colspan='4' class='text-center'>Unable to load bid notices.</td></tr>";
}
?>
                    </tbody>

                </table>

            </div>

        </section>



        <?php include('includes/footer.php'); ?>



        <div class="go-top">

            <i class="fas fa-chevron-up"></i>

            <i class="fas fa-chevron-up"></i>

        </div>



        <script src="assets\js\jquery.min.js"></script>

        <script src="assets\js\popper.min.js"></script>

        <script src="assets\js\bootstrap.min.js"></script>

        <script src="assets\js\owl.carousel.min.js"></script>

        <script src="assets\js\jquery.meanmenu.js"></script>

        <script src="assets\js\jquery.magnific-popup.min.js"></script>

        <script src="assets\js\jquery.appear.min.js"></script>

        <script src="assets\js\odometer.min.js"></script>

        <script src="assets\js\imagelightbox.min.js"></script>

        <script src="assets\js\jquery.nice-select.min.js"></script>

        <script src="assets\js\jquery.ajaxchimp.min.js"></script>

        <script src="assets\js\form-validator.min.js"></script>

        <script src="assets\js\contact-form-script.js"></script>

        <script src="assets\js\main.js"></script>

    </body>

</html>