<!doctype html>

<html>



    <head>

            <title>CSIAP Sri Lanka</title>

    </head>



    <?php include('includes/header.php'); ?>



    <body>



<!--         <div class="preloader">

            <div class="lds-ripple">

                <div></div>

                <div></div>

            </div>

        </div> -->



        <?php include('includes/navbar.php'); ?>



        <div class="page-title-area">

            <div class="d-table">

                <div class="d-table-cell">

                    <div class="container">

                        <div class="page-title-content">

                            <h2>Audio</h2>

                            <ul>

                                <li><a href="index">Home</a></li>

                                <li>Audio</li>

                            </ul>

                        </div>

                    </div>

                </div>

            </div>

        </div>



        <section class="summary-section pt-100">

            <div class="container">

                <div class="row align-items-center">

                    <div class="col-md-12">

                        <div class="row">

<?php
// Include database connection
require_once 'admin/config/database.php';

// Fetch audio data from database
try {
    $pdo = getConnection();
    
    // Get all active audio items, ordered by created_at (newest first)
    $stmt = $pdo->prepare("SELECT id, name, audio_link, status, created_at FROM audio WHERE status = 'active' ORDER BY created_at DESC");
    $stmt->execute();
    $audioItems = $stmt->fetchAll();
    
    if (empty($audioItems)) {
        echo '<div class="col-md-12 text-center">';
        echo '<div class="alert alert-info">';
        echo '<h4>No Audio Content Available</h4>';
        echo '<p>There are currently no audio files in the database.</p>';
        echo '</div>';
        echo '</div>';
    } else {
        // Display each audio item
        foreach ($audioItems as $audio) {
            $audioName = htmlspecialchars($audio['name']);
            $audioLink = htmlspecialchars($audio['audio_link']);
            $createdDate = date('d M Y', strtotime($audio['created_at']));
            
            // Check if it's a YouTube link or direct audio file
            $isYouTube = (strpos($audioLink, 'youtube.com') !== false || strpos($audioLink, 'youtu.be') !== false);
            
            if ($isYouTube) {
                // Extract YouTube video ID from various formats
                $videoId = '';
                
                // Handle embed URLs: https://www.youtube.com/embed/VIDEO_ID
                if (preg_match('/youtube\.com\/embed\/([a-zA-Z0-9_-]+)/', $audioLink, $matches)) {
                    $videoId = $matches[1];
                }
                // Handle watch URLs: https://www.youtube.com/watch?v=VIDEO_ID
                elseif (preg_match('/youtube\.com\/watch\?v=([a-zA-Z0-9_-]+)/', $audioLink, $matches)) {
                    $videoId = $matches[1];
                }
                // Handle short URLs: https://youtu.be/VIDEO_ID
                elseif (preg_match('/youtu\.be\/([a-zA-Z0-9_-]+)/', $audioLink, $matches)) {
                    $videoId = $matches[1];
                }
                
                if ($videoId) {
                    echo '<div class="col-md-4" style="padding-bottom: 30px;">';
                    echo '<div class="fun-facts-content-area-custom">';
                    echo '<iframe width="100%" src="https://www.youtube.com/embed/' . $videoId . '" frameborder="0" allow="accelerometer; autoplay; encrypted-media; gyroscope; picture-in-picture" allowfullscreen></iframe>';
                    echo '<h6 class="text-center" style="padding-top: 10px;">' . $audioName . '</h6>';
                    echo '</div>';
                    echo '</div>';
                }
            } else {
                // Handle direct audio files (MP3, WAV, etc.)
                echo '<div class="col-md-4" style="padding-bottom: 30px;">';
                echo '<div class="fun-facts-content-area-custom">';
                echo '<div style="background: #f8f9fa; padding: 20px; border-radius: 8px; text-align: center;">';
                echo '<i class="fas fa-music" style="font-size: 3rem; color: #007bff; margin-bottom: 15px;"></i>';
                echo '<h6 class="text-center" style="margin-bottom: 15px;">' . $audioName . '</h6>';
                echo '<audio controls style="width: 100%; margin-bottom: 10px;">';
                echo '<source src="' . $audioLink . '" type="audio/mpeg">';
                echo '<source src="' . $audioLink . '" type="audio/wav">';
                echo '<source src="' . $audioLink . '" type="audio/ogg">';
                echo 'Your browser does not support the audio element.';
                echo '</audio>';
                echo '<a href="' . $audioLink . '" class="btn btn-sm btn-outline-primary" target="_blank" download>';
                echo '<i class="fas fa-download"></i> Download Audio';
                echo '</a>';
                echo '</div>';
                echo '</div>';
                echo '</div>';
            }
        }
    }
    
} catch(PDOException $e) {
    // Display error message if database connection fails
    echo '<div class="col-md-12 text-center">';
    echo '<div class="alert alert-danger">';
    echo '<h4>Database Error</h4>';
    echo '<p>Unable to load audio content: ' . htmlspecialchars($e->getMessage()) . '</p>';
    echo '</div>';
    echo '</div>';
}
?>

                        </div>

                    </div>

                </div>

            </div>

            <div class="summary-shape-image">

                <img src="assets\img\summary\shape.png" alt="image">

            </div>

        </section>



        <?php include('includes/footer.php'); ?>



        <div class="go-top">

            <i class="fas fa-chevron-up"></i>

            <i class="fas fa-chevron-up"></i>

        </div>



        <script src="assets\js\jquery.min.js"></script>

        <script src="assets\js\popper.min.js"></script>

        <script src="assets\js\bootstrap.min.js"></script>

        <script src="assets\js\owl.carousel.min.js"></script>

        <script src="assets\js\jquery.meanmenu.js"></script>

        <script src="assets\js\jquery.magnific-popup.min.js"></script>

        <script src="assets\js\jquery.appear.min.js"></script>

        <script src="assets\js\odometer.min.js"></script>

        <script src="assets\js\imagelightbox.min.js"></script>

        <script src="assets\js\jquery.nice-select.min.js"></script>

        <script src="assets\js\jquery.ajaxchimp.min.js"></script>

        <script src="assets\js\form-validator.min.js"></script>

        <script src="assets\js\contact-form-script.js"></script>

        <script src="assets\js\main.js"></script>

    </body>

</html>
