<?php

// --- STEP 1: CONFIGURE YOUR DETAILS HERE ---

// Database Credentials
$db_host = 'localhost:4306'; // Or 'localhost'
$db_user = 'root';      // Your database username
$db_pass = '';          // Your database password
$db_name = 'csiap';     // Your database name

// New User Information
$username = 'admin';
$email = 'admin@gmail.com';
$plain_password = 'admin@csiap2025'; // The password you want to set

// --- DO NOT EDIT BELOW THIS LINE ---

// 1. Create a secure hash of the password
$hashed_password = password_hash($plain_password, PASSWORD_DEFAULT);
if ($hashed_password === false) {
    die('Error: Password hashing failed.');
}

// 2. Connect to the database
$conn = new mysqli($db_host, $db_user, $db_pass, $db_name);

// Check for connection errors
if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

// 3. Prepare the SQL query to prevent SQL injection
$sql = "INSERT INTO users (username, email, password) VALUES (?, ?, ?)";
$stmt = $conn->prepare($sql);

if ($stmt === false) {
    die("Error preparing statement: " . $conn->error);
}

// 4. Bind the parameters (s = string)
$stmt->bind_param("sss", $username, $email, $hashed_password);

// 5. Execute the query and give feedback
if ($stmt->execute()) {
    echo "✅ Success! New user '<strong>" . htmlspecialchars($username) . "</strong>' was created.";
} else {
    echo "❌ Error: Could not create user. " . $stmt->error;
}

// 6. Close the statement and connection
$stmt->close();
$conn->close();

?>