<?php
// Include database connection
require_once 'config/database.php';

// Set content type to JSON
header('Content-Type: application/json');

// Check if it's a POST request
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo json_encode(['success' => false, 'message' => 'Invalid request method']);
    exit;
}

// Get the ID from POST data
$id = $_POST['id'] ?? null;

if (!$id) {
    echo json_encode(['success' => false, 'message' => 'ID is required']);
    exit;
}

try {
    $pdo = getConnection();
    
    // First, get the image path to delete the file
    $stmt = $pdo->prepare('SELECT img_path FROM pcsiap WHERE id = ?');
    $stmt->execute([$id]);
    $item = $stmt->fetch();
    
    if (!$item) {
        echo json_encode(['success' => false, 'message' => 'Item not found']);
        exit;
    }

    // Delete the image file if it exists
    if ($item['img_path'] && file_exists('../' . $item['img_path'])) {
        unlink('../' . $item['img_path']);
    }

    // Delete the item from the database
    $stmt = $pdo->prepare('DELETE FROM pcsiap WHERE id = ?');
    $stmt->execute([$id]);

    echo json_encode(['success' => true, 'message' => 'Item deleted successfully']);

} catch(PDOException $e) {
    echo json_encode(['success' => false, 'message' => 'Database error: ' . $e->getMessage()]);
}
?>
