<?php
require_once 'config/database.php';

header('Content-Type: application/json');

$response = ['success' => false, 'message' => ''];

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $id = filter_input(INPUT_POST, 'id', FILTER_VALIDATE_INT);

    if ($id === false || $id <= 0) {
        $response['message'] = 'Invalid LCSIAP item ID.';
    } else {
        try {
            $pdo = getConnection();

            // First get the image path to delete the file
            $stmt = $pdo->prepare("SELECT img_path FROM lcsiap WHERE id = ?");
            $stmt->execute([$id]);
            $item = $stmt->fetch();

            if ($item) {
                // Delete the LCSIAP item record
                $deleteStmt = $pdo->prepare("DELETE FROM lcsiap WHERE id = ?");
                $deleteStmt->execute([$id]);

                if ($deleteStmt->rowCount() > 0) {
                    // Try to delete the image file if it exists
                    if ($item['img_path'] && !preg_match('#^(?:https?://|/)#', $item['img_path'])) {
                        $filePath = __DIR__ . '/../' . $item['img_path'];
                        if (file_exists($filePath)) {
                            @unlink($filePath);
                        }
                    }

                    $response['success'] = true;
                    $response['message'] = 'LCSIAP item deleted successfully.';
                } else {
                    $response['message'] = 'LCSIAP item not found or already deleted.';
                }
            } else {
                $response['message'] = 'LCSIAP item not found.';
            }
        } catch (PDOException $e) {
            $response['message'] = 'Database error: ' . $e->getMessage();
        }
    }
} else {
    $response['message'] = 'Invalid request method.';
}

echo json_encode($response);
?>
