<?php
// Include database connection
require_once 'config/database.php';

// Set content type to JSON
header('Content-Type: application/json');

// Check if it's a POST request
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo json_encode(['success' => false, 'message' => 'Invalid request method']);
    exit;
}

// Get the ID from POST data
$id = $_POST['id'] ?? null;

if (!$id) {
    echo json_encode(['success' => false, 'message' => 'ID is required']);
    exit;
}

try {
    $pdo = getConnection();
    
    // First, get the image path to delete the file
    $stmt = $pdo->prepare('SELECT img_path FROM lcovid19 WHERE id = ?');
    $stmt->execute([$id]);
    $item = $stmt->fetch();
    
    if (!$item) {
        echo json_encode(['success' => false, 'message' => 'Item not found']);
        exit;
    }
    
    // Delete from database
    $deleteStmt = $pdo->prepare('DELETE FROM lcovid19 WHERE id = ?');
    $result = $deleteStmt->execute([$id]);
    
    if ($result) {
        // Try to delete the image file if it exists
        if ($item['img_path']) {
            $filePath = '../' . $item['img_path'];
            if (file_exists($filePath)) {
                @unlink($filePath);
            }
        }
        
        echo json_encode(['success' => true, 'message' => 'LCOVID19 item deleted successfully']);
    } else {
        echo json_encode(['success' => false, 'message' => 'Failed to delete item from database']);
    }
    
} catch (PDOException $e) {
    echo json_encode(['success' => false, 'message' => 'Database error: ' . $e->getMessage()]);
} catch (Exception $e) {
    echo json_encode(['success' => false, 'message' => 'Error: ' . $e->getMessage()]);
}
?>
