<?php
require_once 'config/database.php';

header('Content-Type: application/json');

$response = ['success' => false, 'message' => ''];

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $id = filter_input(INPUT_POST, 'id', FILTER_VALIDATE_INT);

    if ($id === false || $id <= 0) {
        $response['message'] = 'Invalid brochure ID.';
    } else {
        try {
            $pdo = getConnection();
            
            // First get the image path to delete the file
            $stmt = $pdo->prepare("SELECT img_path FROM broachers WHERE id = ?");
            $stmt->execute([$id]);
            $brochure = $stmt->fetch();
            
            if ($brochure) {
                // Delete the brochure record
                $deleteStmt = $pdo->prepare("DELETE FROM broachers WHERE id = ?");
                $deleteStmt->execute([$id]);

                if ($deleteStmt->rowCount() > 0) {
                    // Try to delete the image file if it exists
                    if ($brochure['img_path'] && !preg_match('#^(?:https?://|/)#', $brochure['img_path'])) {
                        $filePath = __DIR__ . '/../' . $brochure['img_path'];
                        if (file_exists($filePath)) {
                            @unlink($filePath);
                        }
                    }
                    
                    $response['success'] = true;
                    $response['message'] = 'Brochure deleted successfully.';
                } else {
                    $response['message'] = 'Brochure not found or already deleted.';
                }
            } else {
                $response['message'] = 'Brochure not found.';
            }
        } catch (PDOException $e) {
            $response['message'] = 'Database error: ' . $e->getMessage();
        }
    }
} else {
    $response['message'] = 'Invalid request method.';
}

echo json_encode($response);
?>
