<?php 
if( !class_exists('TS_Importer') ){
	class TS_Importer{
		
		public $selected_import_data = array();

		function __construct(){
			add_filter( 'ocdi/plugin_page_title', array($this, 'import_notice') );
			
			add_filter( 'ocdi/plugin_page_setup', array($this, 'import_page_setup') );
			add_action( 'ocdi/before_widgets_import', array($this, 'before_widgets_import') );
			add_filter( 'ocdi/import_files', array($this, 'import_files') );
			add_filter( 'ocdi/regenerate_thumbnails_in_content_import', '__return_false' );
			add_action( 'ocdi/after_import', array($this, 'after_import_setup') );
		}
		
		function import_notice( $plugin_title ){
			$allowed_html = array(
				'a' => array( 'href' => array(), 'target' => array() )
			);
			ob_start();
			?>
			<div class="ts-ocdi-notice-info">
				<p>
					<i class="fa fas fa-exclamation-circle"></i>
					<span><?php echo wp_kses( __('If you have any problem with importer, please read this article <a href="https://ocdi.com/import-issues/" target="_blank">https://ocdi.com/import-issues/</a> and check your hosting configuration, or contact our support team here <a href="https://skygroup.ticksy.com/" target="_blank">https://skygroup.ticksy.com/</a>.', 'themesky'), $allowed_html ); ?></span>
				</p>
			</div>
			<?php
			$plugin_title .= ob_get_clean();
			return $plugin_title;
		}
		
		function import_page_setup( $default_settings ){
			$default_settings['parent_slug'] = 'themes.php';
			$default_settings['page_title']  = esc_html__( 'BoxShop - Import Demo Content' , 'themesky' );
			$default_settings['menu_title']  = esc_html__( 'BoxShop Importer' , 'themesky' );
			$default_settings['capability']  = 'import';
			$default_settings['menu_slug']   = 'boxshop-importer';
			return $default_settings;
		}
		
		function set_selected_import_data( $selected_import ){
			switch( $selected_import['import_file_name'] ){
				case 'Electronic':
					$this->selected_import_data = array(
						'folder_name' 		=> 'electronic'
						,'homepage_name' 	=> 'Home Electronic'
						,'import_url'		=> 'https://import.theme-sky.com/boxshop-electronic'
					);
				break;
				case 'Furniture':
					$this->selected_import_data = array(
						'folder_name' 		=> 'furniture'
						,'homepage_name' 	=> 'Home Furniture'
						,'import_url'		=> 'https://import.theme-sky.com/boxshop-furniture'
					);
				break;
				case 'Glasses':
					$this->selected_import_data = array(
						'folder_name' 		=> 'glasses'
						,'homepage_name' 	=> 'Home Glasses'
						,'import_url'		=> 'https://import.theme-sky.com/boxshop-glasses'
					);
				break;
				case 'Houseware':
					$this->selected_import_data = array(
						'folder_name' 		=> 'houseware'
						,'homepage_name' 	=> 'Home Houseware'
						,'import_url'		=> 'https://import.theme-sky.com/boxshop-houseware'
					);
				break;
				case 'Organic':
					$this->selected_import_data = array(
						'folder_name' 		=> 'organic'
						,'homepage_name' 	=> 'Home Organic'
						,'import_url'		=> 'https://import.theme-sky.com/boxshop-organic'
					);
				break;
				case 'Shoes':
					$this->selected_import_data = array(
						'folder_name' 		=> 'shoes'
						,'homepage_name' 	=> 'Home Shoes'
						,'import_url'		=> 'https://import.theme-sky.com/boxshop-shoes'
					);
				break;
				default:
					$this->selected_import_data = array(
						'folder_name' 		=> 'supermarket'
						,'homepage_name' 	=> 'Home'
						,'import_url'		=> 'https://import.theme-sky.com/boxshop'
					);
			}
		}
		
		function import_files(){
			$import_files = array();
			$folder_names = array(
							'supermarket'	=> 'Supermarket 1 & 2'
							,'electronic'	=> 'Electronic'
							,'furniture'	=> 'Furniture'
							,'glasses'		=> 'Glasses'
							,'houseware'	=> 'Houseware'
							,'organic'		=> 'Organic'
							,'shoes'		=> 'Shoes'
							);
							
			foreach( $folder_names as $folder => $name ){
				$import_files[] = array(
					'import_file_name'           => $name,
					'import_file_url'            => plugin_dir_url( __FILE__ ) . 'data/'.$folder.'/content.xml',
					'import_widget_file_url'     => plugin_dir_url( __FILE__ ) . 'data/'.$folder.'/widget_data.wie',
					'import_preview_image_url'   => plugin_dir_url( __FILE__ ) . 'data/'.$folder.'/preview.jpg'
				);
			}
			
			return $import_files;
		}
		
		function before_widgets_import( $selected_import ){
			$this->set_selected_import_data( $selected_import );
			global $wp_registered_sidebars;
			$file_path = dirname(__FILE__) . '/data/'.$this->selected_import_data['folder_name'].'/custom_sidebars.txt';
			if( file_exists($file_path) ){
				$file_url = plugin_dir_url(__FILE__) . 'data/'.$this->selected_import_data['folder_name'].'/custom_sidebars.txt';
				$custom_sidebars = wp_remote_get( $file_url );
				$custom_sidebars = maybe_unserialize( trim( $custom_sidebars['body'] ) );
				update_option('ts_custom_sidebars', $custom_sidebars);
				
				if( is_array($custom_sidebars) && !empty($custom_sidebars) ){
					foreach( $custom_sidebars as $name ){
						$custom_sidebar = array(
											'name' 			=> ''.$name.''
											,'id' 			=> sanitize_title($name)
											,'description' 	=> ''
											,'class'		=> 'ts-custom-sidebar'
										);
						if( !isset($wp_registered_sidebars[$custom_sidebar['id']]) ){
							$wp_registered_sidebars[$custom_sidebar['id']] = $custom_sidebar;
						}
					}
				}
			}
		}
		
		function after_import_setup( $selected_import ){
			set_time_limit(0);
			$this->set_selected_import_data( $selected_import );
			$this->import_theme_options();
			$this->woocommerce_settings();
			$this->menu_locations();
			$this->set_homepage();
			$this->import_revslider();
			$this->change_url();
			$this->update_product_category_id_in_homepage_content();
			$this->delete_transients();
			$this->update_woocommerce_lookup_table();
			$this->update_menu_term_count();
		}
		
		function get_post_by_title($post_title, $post_type = 'page'){
			$query = new WP_Query(
						array(
							'post_type'               => $post_type
							,'title'                  => $post_title
							,'post_status'            => 'publish'
							,'posts_per_page'         => 1
							,'no_found_rows'          => true
							,'ignore_sticky_posts'    => true
							,'update_post_term_cache' => false
							,'update_post_meta_cache' => false
							,'orderby'                => 'post_date ID'
							,'order'                  => 'ASC'
						)
					);
		 
			if( ! empty( $query->post ) ){
				return $query->post;
			}
			return null;
		}
		
		/* Import Theme Options */
		function import_theme_options(){
			$theme_options_path = dirname( __FILE__ ) . '/data/'.$this->selected_import_data['folder_name'].'/theme_options.txt';
			if( !file_exists($theme_options_path) ){
				return;
			}
			$theme_options_url = plugin_dir_url( __FILE__ ) . 'data/'.$this->selected_import_data['folder_name'].'/theme_options.txt';
			$theme_options_txt = wp_remote_get( $theme_options_url );
			$smof_data = json_decode( $theme_options_txt['body'], true );
			boxshop_of_save_options($smof_data);
		}
		
		/* WooCommerce Settings */
		function woocommerce_settings(){
			$woopages = array(
				'woocommerce_shop_page_id' 			=> 'Shop'
				,'woocommerce_cart_page_id' 		=> 'Shopping cart'
				,'woocommerce_checkout_page_id' 	=> 'Checkout'
				,'woocommerce_myaccount_page_id' 	=> 'My Account'
				,'yith_wcwl_wishlist_page_id' 		=> 'Wishlist'
			);
			foreach( $woopages as $woo_page_name => $woo_page_title ) {
				$woopage = $this->get_post_by_title( $woo_page_title );
				if( isset( $woopage->ID ) && $woopage->ID ) {
					update_option($woo_page_name, $woopage->ID);
				}
			}
			
			if( class_exists('YITH_Woocompare') ){
				update_option('yith_woocompare_compare_button_in_products_list', 'yes');
			}

			if( class_exists('WC_Admin_Notices') ){
				WC_Admin_Notices::remove_notice('install');
			}
			delete_transient( '_wc_activation_redirect' );
			
			flush_rewrite_rules();
		}
		
		/* Menu Locations */
		function menu_locations(){
			$locations = get_theme_mod( 'nav_menu_locations' );
			$menus = wp_get_nav_menus();

			if( $menus ) {
				foreach($menus as $menu) {
					if( $menu->name == 'Menu main' ) {
						$locations['primary'] = $menu->term_id;
					}
					if( $menu->name == 'Mobile menu' ) {
						$locations['mobile'] = $menu->term_id;
					}
					if( $menu->name == 'Shop by category' ) {
						$locations['vertical'] = $menu->term_id;
					}
				}
			}
			set_theme_mod( 'nav_menu_locations', $locations );
		}
		
		/* Set Homepage */
		function set_homepage(){
			$homepage = $this->get_post_by_title( $this->selected_import_data['homepage_name'] );
			if( is_object( $homepage ) ){
				update_option('show_on_front', 'page');
				update_option('page_on_front', $homepage->ID);
			}
		}
		
		/* Import Revolution Slider */
		function import_revslider(){
			if ( class_exists( 'RevSliderSliderImport' ) ) {
				$rev_directory = dirname(__FILE__) . '/data/'.$this->selected_import_data['folder_name'].'/revslider/';
			
				foreach( glob( $rev_directory . '*.zip' ) as $file ){
					$import = new RevSliderSliderImport();
					$import->import_slider(true, $file);  
				}
			}
		}
		
		/* Change url */
		function change_url(){
			global $wpdb;
			$wp_prefix = $wpdb->prefix;
			$import_url = $this->selected_import_data['import_url'];
			$site_url = get_option( 'siteurl', '' );
			$wpdb->query("update `{$wp_prefix}posts` set `guid` = replace(`guid`, '{$import_url}', '{$site_url}');");
			$wpdb->query("update `{$wp_prefix}posts` set `post_content` = replace(`post_content`, '{$import_url}', '{$site_url}');");
			$wpdb->query("update `{$wp_prefix}postmeta` set `meta_value` = replace(`meta_value`, '{$import_url}', '{$site_url}');");
			
			$option_names = array('ts_logo', 'ts_logo_mobile', 'ts_logo_sticky', 'ts_favicon', 'ts_bg_breadcrumbs', 'ts_prod_placeholder_img');
			foreach( $option_names as $option_name ){
				$option_value = get_theme_mod($option_name, '');
				if( $option_value ){
					$option_value = str_replace($import_url, $site_url, $option_value);
					set_theme_mod($option_name, $option_value);
				}
			}
			
			/* Update Widgets */
			$widgets = array(
				'text' => array('text')
				,'ts_single_image' => array('img_url')
				,'ts_mailchimp_subscription' => array('bg_image')
			);
			foreach( $widgets as $base => $fields ){
				$widget_instances = get_option( 'widget_' . $base, array() );
				if( is_array($widget_instances) ){
					foreach( $widget_instances as $number => $instance ){
						if( $number == '_multiwidget' ){
							continue;
						}
						foreach( $fields as $field ){
							if( isset($widget_instances[$number][$field]) ){
								$widget_instances[$number][$field] = str_replace($import_url, $site_url, $widget_instances[$number][$field]);
							}
						}
					}
					update_option( 'widget_' . $base, $widget_instances );
				}
			}
		}
		
		/* Update Product Category Id In Homepage Content */
		function update_product_category_id_in_homepage_content(){
			$loaded_categories = array();
			$pages = array();
			switch( $this->selected_import_data['folder_name'] ){
				case 'supermarket':
					$pages['Home'] = array(
							array(
								'7'
								, array( 'Apparel & Accessories' )
								, 'parent_cat'
							)
							,array(
								'161'
								, array( 'Furniture & Living' )
								, 'parent_cat'
							)
							,array(
								'232'
								, array( 'Beauty & Health' )
								, 'parent_cat'
							)
							,array(
								'70'
								, array( 'Computer & Electronics' )
								, 'parent_cat'
							)
							,array(
								'89'
								, array( 'Brand dark' )
								, 'categories'
								, 'ts_logo_cat'
							)
					);
					
					$pages['Supermarket 2'] = array(
							array(
								'220, 246, 80, 245'
								, array( 'Bag & Shoes', 'Accessories', 'T-Shirts', 'Hat' )
							)
							,array(
								'75, 225, 151, 248'
								, array( 'Smartphone', 'Laptop', 'Television', 'Fridge' )
							)
							,array(
								'241, 240, 165, 242'
								, array( 'Table', 'Chair', 'Lamp', 'Wall Sticker' )
							)
							,array(
								'89'
								, array( 'Brand dark' )
								, 'categories'
								, 'ts_logo_cat'
							)
					);
				break;
				case 'electronic':
					$pages['Home Electronic'] = array(
							array(
								'70'
								, array( 'Computer' )
								, 'parent_cat'
							)
							,array(
								'237'
								, array( 'Digital' )
								, 'parent_cat'
							)
							,array(
								'89'
								, array( 'Brand dark' )
								, 'categories'
								, 'ts_logo_cat'
							)
					);
				break;
				case 'houseware':
					$pages['Home Houseware'] = array(
							array(
								'7, 232, 70, 141, 17, 161, 158'
								, array( 'Tableware', 'Cookware', 'Glassware', 'Bakeware', 'Kitchen tools', 'Cutleries', 'Appliances' )
							)
							,array(
								'253'
								, array( 'Brand strong' )
								, 'categories'
								, 'ts_logo_cat'
							)
							,array(
								'44'
								, array( "What's New" )
								, 'categories'
								, 'category'
							)
					);
				break;
				case 'organic':
					$pages['Home Organic'] = array(
							array(
								'70'
								, array( 'Veggies' )
							)
							,array(
								'17'
								, array( 'Others' )
							)
							,array(
								'7, 232, 70, 17'
								, array( 'Fruits', 'Juices', 'Veggies', 'Others' )
							)
							,array(
								'253'
								, array( 'Brand strong' )
								, 'categories'
								, 'ts_logo_cat'
							)
							,array(
								'44'
								, array( "What's New" )
								, 'categories'
								, 'category'
							)
					);
				break;
				case 'furniture':
					$pages['Home Furniture'] = array(
							array(
								'44'
								, array( "What's New" )
								, 'categories'
								, 'category'
							)
					);
				break;
				case 'glasses':
					$pages['Home Glasses'] = array(
							array(
								'62'
								, array( 'Dress' )
							)
							,array(
								'221'
								, array( 'Sunglasses' )
							)
							,array(
								'253'
								, array( 'Brand strong' )
								, 'categories'
								, 'ts_logo_cat'
							)
					);
				break;
				case 'shoes':
					$pages['Home Shoes'] = array(
							array(
								'44'
								, array( "What's New" )
								, 'categories'
								, 'category'
							)
					);
				break;
			}
			
			foreach( $pages as $page_title => $cat_ids_names ){
				$page = $this->get_post_by_title( $page_title );
				if( is_object( $page ) ){
					foreach( $cat_ids_names as $cat_id_name ){
						$attr = isset($cat_id_name[2]) ? $cat_id_name[2] : 'product_cats';
						$taxonomy = isset($cat_id_name[3]) ? $cat_id_name[3] : 'product_cat';
						$cat_ids = array();
						foreach( $cat_id_name[1] as $cat_name ){
							$loaded_id = array_search($cat_name, $loaded_categories);
							if( $loaded_id ){
								$cat_ids[] = $loaded_id;
							}
							else{
								$cat = get_term_by('name', $cat_name, $taxonomy);
								if( isset($cat->term_id) ){
									$cat_ids[] = $cat->term_id;
									$loaded_categories[$cat->term_id] = $cat_name;
								}
							}
						}
						$cat_ids = implode(',', $cat_ids);
						$page->post_content = str_replace($attr.'="'.$cat_id_name[0].'"', $attr.'="'.$cat_ids.'"', $page->post_content);
					}
					wp_update_post( $page );
				}
			}
		}
		
		/* Delete transient */
		function delete_transients(){
			delete_transient('ts_mega_menu_custom_css');
			delete_transient('ts_product_deals_ids');
			delete_transient('wc_products_onsale');
		}
		
		/* Update WooCommerce Loolup Table */
		function update_woocommerce_lookup_table(){
			if( function_exists('wc_update_product_lookup_tables_is_running') && function_exists('wc_update_product_lookup_tables') ){
				if( !wc_update_product_lookup_tables_is_running() ){
					if( !defined('WP_CLI') ){
						define('WP_CLI', true);
					}
					wc_update_product_lookup_tables();
				}
			}
		}
		
		/* Update Menu Term Count - Keep this function until One Click Demo Import fixed */
		function update_menu_term_count(){
			$args = array(
						'taxonomy'		=> 'nav_menu'
						,'hide_empty'	=> 0
						,'fields'		=> 'ids'
					);
			$menus = get_terms( $args );
			if( is_array($menus) ){
				wp_update_term_count_now( $menus, 'nav_menu' );
			}
		}
	}
	new TS_Importer();
}
?>