<!DOCTYPE html>
<html lang="en">
<head>
    <title>Aries Horoscope - July 25, 2025</title>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <link rel="stylesheet" href="assets/css/bootstrap.css">
    
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Playfair+Display:wght@700&family=Poppins:wght@400;500;600&display=swap" rel="stylesheet">
    
    <link rel="stylesheet" type="text/css" href="assets/css/style.css">
    <link rel="stylesheet" type="text/css" href="assets/css/horoscope-single.css">

    <link rel="shortcut icon" href="assets/images/favicon.png" type="image/x-icon">
</head>
<body>
    <div class="as_loader">
        <img src="assets/images/loader.png" alt="" class="img-responsive">
    </div> 
    
    <?php include 'includes/header.php'; ?>

    <section class="as_breadcrum_wrapper">
        <div class="container">
            <div class="row">
                <div class="col-lg-12 text-center">
                    <h1>Single Horoscope</h1> 
                    <ul class="breadcrumb"> 
                        <li><a href="#">Home</a></li>
                        <li>Single Horoscope</li>
                    </ul>
                </div>
            </div>
        </div>
    </section>

    <div class="horoscope-single-wrapper">
        <div class="container">

            <div class="zodiac-header-section">
                <div class="zodiac-image-box">
                    <img src="assets/images/svg/horoscope/h1.svg" alt="Aries Symbol">
                </div>
                <div class="zodiac-text-content">
                    <h2 class="zodiac-title">Aries: The Ram</h2>
                    <p class="zodiac-description">Brave and ambitious, Aries dives headfirst into even the most challenging situations. This fire sign is known for its passionate, motivated, and confident leadership.</p>
                </div>
            </div>
            
            <hr class="top-separator">

            <div class="row">
                <main class="col-lg-8">
                    <div class="horoscope-content-area">
                        <p class="content-label">DAILY HOROSCOPE</p>
                        <h1 class="main-title">Horoscope for Aries, 25/07/2025</h1>
                        <p class="intro-paragraph">
                            Dear Aries, today brings a mix of challenges and opportunities. Your assertive nature will guide you through the day, helping you tackle any obstacles that come your way. In love, be open to new experiences and nurture existing relationships. At work, showcase your leadership skills and don’t hesitate to take charge when needed.
                        </p>

                        <div class="horoscope-category">
                            <h2 class="category-title"><span class="first-letter">L</span>OVE</h2>
                            <p>As an Aries, you’ll experience a surge of passion and excitement in your romantic life this week. Be open to new connections and cherish the moments spent with your loved one.</p>
                        </div>

                        <div class="horoscope-category">
                            <h2 class="category-title"><span class="first-letter">C</span>AREER</h2>
                            <p>In the professional sphere, you may face some challenges, but your determination and innovative ideas will help you overcome obstacles. Seize opportunities to showcase your skills and make a mark.</p>
                        </div>
                        
                        <div class="horoscope-category">
                            <h2 class="category-title"><span class="first-letter">H</span>EALTH</h2>
                            <p>Focus on maintaining a balanced diet and staying active to keep your energy levels high. Don’t neglect your mental health; take time to unwind and practice self-care.</p>
                        </div>

                        <div class="horoscope-category">
                            <h2 class="category-title"><span class="first-letter">W</span>EALTH</h2>
                            <p>This week, you might encounter financial opportunities, so be wise in your decisions and investments. Avoid impulsive spending and plan for your future financial stability.</p>
                        </div>

                        <div class="horoscope-category">
                            <h2 class="category-title"><span class="first-letter">S</span>OCIAL</h2>
                            <p>Your social life will be filled with fun and engaging events. Enjoy these moments, but remember to maintain a balance between your personal and social life. Networking can bring unexpected benefits.</p>
                        </div>
                        
                        <p class="meta-info">25/07/2025, by Kosala Edirisinghe</p>
                    </div>
                </main>

                <aside class="col-lg-4">
                    <div class="sidebar-wrapper">
                        <div class="widget author-widget">
                            <img src="assets/images/astrologo.png" alt="Kosala Edirisinghe" class="author-image">
                            <p class="author-handle">@KosalaEdirisinghe</p>
                            <h3 class="author-name">Kosala Edirisinghe</h3>
                            <p class="author-bio">Astrology is the language of Stars. An Astrologer is a person who understands the language of the Stars.</p>
                            <div class="author-social">
                                <a href="#"><img src="assets/images/svg/twitter.jpg" alt="Twitter" class="social-icon"></a>
                                <a href="#"><img src="assets/images/svg/inster.jpg" alt="Instagram" class="social-icon"></a>
                                <a href="#"><img src="assets/images/svg/face.png" alt="Facebook" class="social-icon"></a>
                            </div>
                        </div>

                        <div class="widget promo-widget" style="background-image: url('assets/images/blog/blogs.jpg');">
                            <div class="promo-overlay">
                                <h4>See All Our Blogs</h4>
                                <a href="Blog.php" class="promo-btn">View All</a>
                            </div>
                        </div>
                        
                        <div class="widget promo-widget" style="background-image: url('assets/images/service/services.jpg');">
                            <div class="promo-overlay">
                                <h4>See Our Services</h4>
                                <a href="#" class="promo-btn">View All</a>
                            </div>
                        </div>
                    </div>
                </aside>
            </div>
        </div>
    </div>

    <section class="zodiac-slider-section">
        <div class="container">
            <h3 class="slider-title">CHECK YOUR LOVER OR FRIENDS' SIGNS!</h3>
            <div class="zodiac-slider-wrapper">
                <div class="zodiac-slider">
                    <a href="#" class="slider-item"><img src="assets/images/svg/horoscope/h2.svg" alt="Taurus"><p>Taurus</p></a>
                    <a href="#" class="slider-item"><img src="assets/images/svg/horoscope/h3.svg" alt="Gemini"><p>Gemini</p></a>
                    <a href="#" class="slider-item"><img src="assets/images/svg/horoscope/h4.svg" alt="Cancer"><p>Cancer</p></a>
                    <a href="#" class="slider-item"><img src="assets/images/svg/horoscope/h5.svg" alt="Leo"><p>Leo</p></a>
                    <a href="#" class="slider-item"><img src="assets/images/svg/horoscope/h6.svg" alt="Virgo"><p>Virgo</p></a>
                    <a href="#" class="slider-item"><img src="assets/images/svg/horoscope/h7.svg" alt="Libra"><p>Libra</p></a>
                    <a href="#" class="slider-item"><img src="assets/images/svg/horoscope/h8.svg" alt="Scorpio"><p>Scorpio</p></a>
                    <a href="#" class="slider-item"><img src="assets/images/svg/horoscope/h9.svg" alt="Sagittarius"><p>Sagittarius</p></a>
                    <a href="#" class="slider-item"><img src="assets/images/svg/horoscope/h10.svg" alt="Capricorn"><p>Capricorn</p></a>
                    <a href="#" class="slider-item"><img src="assets/images/svg/horoscope/h11.svg" alt="Aquarius"><p>Aquarius</p></a>
                    <a href="#" class="slider-item"><img src="assets/images/svg/horoscope/h12.svg" alt="Pisces"><p>Pisces</p></a>
                </div>
            </div>
        </div>
    </section>

    <?php include 'includes/footer.php'; ?>

    <script src="assets/js/jquery.js"></script>
    <script src="assets/js/bootstrap.js"></script>
    <script src="assets/js/custom.js"></script>
</body>
</html>