<style>
    /* --- Scoped Styles for Services Section --- */
    .services-section {
        width: 100%;
        max-width: 1200px;
        margin: 0 auto;
        padding: 0 20px 2rem 20px;
        background-color: #fdfaf3; /* A very light cream background */
    }

    .services-section .card-grid {
        display: grid;
        grid-template-columns: repeat(auto-fit, minmax(220px, 1fr));
        gap: 1.5rem;
        width: 100%;
    }

    .services-section .card {
        background-color: #fff;
        border-radius: 16px;
        box-shadow: 0 8px 16px rgba(0, 0, 0, 0.1);
        overflow: hidden;
        text-align: center;
        transition: transform 0.3s ease, box-shadow 0.3s ease;
        display: flex;
        flex-direction: column;
    }

    .services-section .card:hover {
        transform: translateY(-5px);
        box-shadow: 0 12px 24px rgba(0, 0, 0, 0.15);
    }

    .services-section .card-image {
        width: 100%;
        height: 180px;
        object-fit: cover;
    }

    .services-section .card-content {
        padding: 1rem;
        flex-grow: 1;
        display: flex;
        flex-direction: column;
        justify-content: space-between;
    }

    .services-section .card-title {
        margin: 0 0 0.75rem 0;
        font-size: 1.1rem;
        font-weight: 600;
        color:rgb(0, 0, 0);
    }

    .services-section .view-button {
        display: inline-block;
        background: linear-gradient(45deg,rgb(211, 169, 128),rgb(201, 155, 69));

        color:rgb(15, 14, 14);
        font-weight: 500;
        padding: 0.6rem 1.5rem;
        border: none;
        border-radius: 8px;
        cursor: pointer;
        text-decoration: none;
        transition: background 0.3s ease, transform 0.2s ease;
        margin-top: 0.5rem;
    }

    .services-section .view-button:hover {
        background: linear-gradient(45deg, #e4a62d, #d8931a);
        transform: scale(1.05);
    }

    @media (max-width: 768px) {
        .services-section {
            padding: 0 5px 1rem 5px;
        }
        .services-section .card-grid {
            gap: 1rem;
        }
    }
</style>

<section class="services-section">
    <div style="text-align:center; margin-bottom: 2.2rem;">
        <h2 style="font-family: 'Poppins', 'Helvetica Neue', Arial, sans-serif; font-size:2.2rem; font-weight:700; color:#5a4327; margin-bottom:0.5rem; letter-spacing:0.01em;">Our Premium Astrology Services</h2>
        <p style="font-size:1.08rem; color:#7a6a53; max-width:600px; margin:0 auto; font-family:'Poppins', 'Helvetica Neue', Arial, sans-serif;">Explore a curated selection of our most sought-after astrology and divination services, each designed to guide you on your unique journey of self-discovery and insight.</p>
    </div>
    <div class="card-grid">
        <!-- Card 1: Match Making -->
        <div class="card">
            <img src="assets/images/service/matching1.jpg" alt="Match Making" class="card-image">
            <div class="card-content">
                <h3 class="card-title">Match Making</h3>
                <p class="card-description">Match Making is a process of finding a suitable partner for an individual based on their birth details.</p>
                <a href="service_single.php" class="view-button">View</a>
            </div>
        </div>
        <!-- Card 2: Panchang -->
        <div class="card">
            <img src="assets/images/service/panchang2.jpg" alt="Panchang" class="card-image">
            <div class="card-content">
                <h3 class="card-title">Panchang</h3>
                <p class="card-description">Panchang is a Hindu calendar that is used to determine the auspicious and inauspicious times for various activities.</p>
                <a href="#" class="view-button">View</a>
            </div>
        </div>
        <!-- Card 3: Tarot Reading -->
        <div class="card">
            <img src="assets/images/service/tarot2.jpg" alt="Tarot Reading" class="card-image">
            <div class="card-content">
                <h3 class="card-title">Tarot Reading</h3>
                <p class="card-description">Tarot Reading is a process of interpreting the cards of the Tarot deck to gain insights into a person's past, present, and future.</p>
                <a href="#" class="view-button">View</a>
            </div>
        </div>
        <!-- Card 4: Kundli -->
        <div class="card">
            <img src="assets/images/service/Kundli2.jpg" alt="Kundli" class="card-image">
            <div class="card-content">
                <h3 class="card-title">Kundli</h3>
                <p class="card-description">Kundli is a Hindu astrology chart that is used to determine the position of the planets at the time of birth.</p>
                <a href="#" class="view-button">View</a>
            </div>
        </div>
        <!-- Card 5: Love -->
        <div class="card">
            <img src="assets/images/service/love2.jpg" alt="Love" class="card-image">
            <div class="card-content">
                <h3 class="card-title">Love</h3>
                <p class="card-description">Love is a process of finding a suitable partner for an individual based on their birth details.</p>
                <a href="#" class="view-button">View</a>
            </div>
        </div>
        <!-- Card 6: Numerology -->
        <div class="card">
            <img src="assets/images/service/numerology2.jpg" alt="Numerology" class="card-image">
            <div class="card-content">
                <h3 class="card-title">Numerology</h3>
                <p class="card-description">Numerology is a process of using numbers to determine a person's personality and destiny.</p>
                <a href="#" class="view-button">View</a>
            </div>
        </div>
        <!-- Card 7: Remedies -->
        <div class="card">
            <img src="assets/images/service/remedies2.jpg" alt="Remedies" class="card-image">
            <div class="card-content">
                <h3 class="card-title">Remedies</h3>
                <p class="card-description">Remedies are a process of using natural and herbal remedies to cure various diseases and ailments.</p>
                <a href="#" class="view-button">View</a>
            </div>
        </div>
        <!-- Card 8: Planet Transits -->
        <div class="card">
            <img src="assets/images/service/planet2.jpg" alt="Planet Transits" class="card-image">
            <div class="card-content">
                <h3 class="card-title">Planet Transits</h3>
                <p class="card-description">Planet Transits are a process of using the positions of the planets at the time of birth to determine a person's personality and destiny.</p>
                <a href="#" class="view-button">View</a>
            </div>
        </div>
        <!-- Card 9: Vastu -->
        <div class="card">
            <img src="assets/images/service/vastu2.jpg" alt="Vastu" class="card-image">
            <div class="card-content">
                <h3 class="card-title">Vastu</h3>
                <p class="card-description">Vastu is a process of using the positions of the planets at the time of birth to determine a person's personality and destiny.</p>
                <a href="#" class="view-button">View</a>
            </div>
        </div>
        <!-- Card 10: Zodiac Signs -->
        <div class="card">
            <img src="assets/images/service/zodiac2.jpg" alt="Zodiac Signs" class="card-image">
            <div class="card-content">
                <h3 class="card-title">Zodiac Signs</h3>
                <p class="card-description">Zodiac Signs are a process of using the positions of the planets at the time of birth to determine a person's personality and destiny.</p>
                <a href="#" class="view-button">View</a>
            </div>
        </div>
        <!-- Card 11: Festivals -->
        <div class="card">
            <img src="assets/images/service/festivals2.jpg" alt="Festivals" class="card-image">
            <div class="card-content">
                <h3 class="card-title">Festivals</h3>
                <p class="card-description">Festivals are a process of using the positions of the planets at the time of birth to determine a person's personality and destiny.</p>
                <a href="#" class="view-button">View</a>
            </div>
        </div>
        <!-- Card 12: Spirituality -->
        <div class="card">
            <img src="assets/images/service/spirituality2.jpg" alt="Spirituality" class="card-image">
            <div class="card-content">
                <h3 class="card-title">Spirituality</h3>
                <p class="card-description">Spirituality is a process of using the positions of the planets at the time of birth to determine a person's personality and destiny.</p>
                <a href="#" class="view-button">View</a>
            </div>
        </div>
    </div>
</section>