
<style>
        /* --- General Body and Font Styles --- */
        body {
            font-family: 'Garamond', serif; /* A classic serif font for an elegant feel */
            background-color: #fdfdfd;
            margin: 0;
            padding: 0;
            display: flex;
            justify-content: center;
            align-items: center;
            min-height: 100vh;
            color: #333;
        }

        /* --- Main Container Section --- */
        .discovery-section {
            display: flex;
            max-width: 1200px;
            width: 90%;
            background-color: #fff;
            box-shadow: 0 10px 30px rgba(0,0,0,0.05);
            border-radius: 15px;
            overflow: hidden;
            position: relative;
        }

        /* --- Left Column: Image and Overlays --- */
        .image-column {
            flex: 1;
            position: relative;
            background-image: url('https://images.unsplash.com/photo-1590219253250-c3639535f657?q=80&w=1887&auto=format&fit=crop');
            background-size: cover;
            background-position: center;
            min-height: 600px;
            display: flex;
            flex-direction: column;
            justify-content: flex-end;
            padding: 40px;
            box-sizing: border-box;
        }

        .image-column::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: linear-gradient(to top, rgba(0,0,0,0.6), transparent);
        }

        .image-overlay-content {
            position: relative;
            z-index: 2;
            color: white;
        }
        
        .image-overlay-content h3 {
            font-size: 2.5rem;
            margin: 0 0 10px 0;
            font-weight: 500;
            line-height: 1.2;
        }

        .image-overlay-content p {
            font-family: 'Helvetica Neue', sans-serif;
            font-size: 1rem;
            max-width: 350px;
            line-height: 1.6;
            margin: 0;
        }

        /* --- Right Column: Text Content --- */
        .content-column {
            flex: 1;
            padding: 60px;
            position: relative;
            display: flex;
            flex-direction: column;
            justify-content: center;
        }

        .content-column .subtitle {
            font-family: 'Helvetica Neue', sans-serif;
            font-size: 0.9rem;
            color: #888;
            letter-spacing: 1px;
            text-transform: uppercase;
            margin-bottom: 15px;
        }

        .content-column h2 {
            font-size: 2.8rem;
            margin: 0 0 20px 0;
            font-weight: 500;
        }
        
        .content-column .description {
            font-family: 'Helvetica Neue', sans-serif;
            line-height: 1.7;
            color: #555;
            margin-bottom: 30px;
        }

        .expandable-item {
            display: flex;
            align-items: center;
            padding: 20px 0;
            border-bottom: 1px solid #eee;
            cursor: pointer;
            transition: background-color 0.3s;
        }
        
        .expandable-item:hover {
            background-color: #f9f9f9;
        }

        .expandable-item .arrow {
            font-size: 1.5rem;
            margin-right: 20px;
            color: #888;
        }

        .expandable-item span {
            font-family: 'Helvetica Neue', sans-serif;
            font-size: 1.1rem;
            font-weight: 500;
        }

        .more-info-btn {
            display: inline-block;
            border: 1px solid #ccc;
            padding: 12px 30px;
            margin-top: 40px;
            text-decoration: none;
            color: #555;
            font-family: 'Helvetica Neue', sans-serif;
            font-weight: bold;
            text-transform: uppercase;
            letter-spacing: 1px;
            border-radius: 5px;
            transition: all 0.3s;
            text-align: center;
            align-self: flex-start;
        }

        .more-info-btn:hover {
            background-color: #333;
            color: #fff;
            border-color: #333;
        }
        
        /* --- Background decorative element --- */
        .content-column::after {
            content: '✧'; /* Using a unicode character for the star */
            position: absolute;
            right: -20px;
            bottom: 100px;
            font-size: 200px;
            color: #f0f0f0;
            z-index: -1;
            opacity: 0.5;
            transform: rotate(15deg);
        }

        /* --- Responsive Design --- */
        @media (max-width: 992px) {
            .discovery-section {
                flex-direction: column;
                width: 100%;
                margin: 0;
                border-radius: 0;
            }

            .image-column {
                min-height: 400px;
            }

            .content-column {
                padding: 40px;
            }
            
            .content-column h2 {
                font-size: 2.2rem;
            }
        }

        @media (max-width: 576px) {
            .image-overlay-content h3 {
                font-size: 2rem;
            }
            .content-column {
                padding: 30px;
            }
             .content-column h2 {
                font-size: 1.8rem;
            }
            .more-info-btn {
                align-self: stretch;
            }
        }

    </style>

<section class="discovery-section">
        <!-- Left column with background image and text overlay -->
        <div class="image-column">
            <div class="image-overlay-content">
                <h3>Rune Readings for Guidance</h3>
                <p>Tap into ancient Norse wisdom with personalized rune readings.</p>
            </div>
        </div>

        <!-- Right column with text content -->
        <div class="content-column">
            <p class="subtitle">Embrace Cosmic Wisdom</p>
            <h2>Mystical of Self-Discovery</h2>
            <p class="description">
                Drawing upon years of study and intuitive exploration, I offer a holistic approach to divination that integrates the wisdom of the stars, the symbolism of tarot cards, and the ancient Norse runes. Each session is tailored to provide you with deep insights into your life's journey, helping you uncover hidden truths.
            </p>
            <p class="description">
                My mission is to support you on your journey of self-discovery and personal growth. Whether you are facing uncertainties, seeking clarity, or striving for spiritual enlightenment, I am here to assist you in unlocking the mysteries that shape your destiny and empowering you to live authentically and purposefully.
            </p>

            <div class="expandable-item">
                <div class="arrow">&gt;</div>
                <span>Cosmic Guidance Sessions</span>
            </div>
            <div class="expandable-item">
                <div class="arrow">&gt;</div>
                <span>Divination and Insight Services</span>
            </div>

            <a href="#" class="more-info-btn">More Info</a>
        </div>
    </section>