﻿<!DOCTYPE html>
<html lang="en">
<head>
    <title>Astrology</title>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <!-- stylesheet -->
    <link rel="stylesheet" href="assets/css/bootstrap.css">
    <link href="assets/css/font.css" rel="stylesheet">
    <link rel="stylesheet" type="text/css" href="assets/js/plugin/slick/slick.css">
    <link rel="stylesheet" type="text/css" href="assets/js/plugin/select2/select2.min.css">
    <link rel="stylesheet" type="text/css" href="assets/js/plugin/airdatepicker/datepicker.min.css">
    <link rel="stylesheet" type="text/css" href="assets/css/style.css">
    <!-- favicon -->
    <link rel="shortcut icon" href="assets/images/favicon.png" type="image/x-icon">

    <style>
        /* --- General Body and Font Styles --- */
        body {
            font-family: 'Garamond', serif;
            background-color: #fdfdfd;
            color: #333;
        }

        /* --- Main Container Section for Mystical Discovery --- */
        .discovery-section {
            display: flex;
            max-width: 1200px;
            width: 90%;
            background-color: #fff;
            box-shadow: 0 10px 30px rgba(0,0,0,0.05);
            border-radius: 15px;
            overflow: hidden;
            position: relative;
            margin: 50px auto;
        }

        /* --- Left Column: Image Slider --- */
        .image-column {
            flex: 1;
            position: relative;
            min-height: 600px;
            display: flex;
            flex-direction: column;
            justify-content: flex-end;
            box-sizing: border-box;
            overflow: hidden;
        }

        .slide {
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background-size: cover;
            background-position: center;
            opacity: 0;
            transition: opacity 1.5s ease-in-out;
            z-index: 1;
            display: flex;
            flex-direction: column;
            justify-content: flex-end;
            padding: 40px;
            box-sizing: border-box;
        }

        .slide.active {
            opacity: 1;
            z-index: 2;
        }

        .slide::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: linear-gradient(to top, rgba(0,0,0,0.6), transparent);
            z-index: 1;
        }

        .image-overlay-content {
            position: relative;
            z-index: 2;
            color: white;
        }
        
        .image-overlay-content h3 {
            font-size: 2.5rem;
            margin: 0 0 10px 0;
            font-weight: 500;
            line-height: 1.2;
        }

        .image-overlay-content p {
            font-family: 'Helvetica Neue', sans-serif;
            font-size: 1rem;
            max-width: 350px;
            line-height: 1.6;
            margin: 0;
        }

        /* --- Right Column: Text Content --- */
        .content-column {
            flex: 1;
            padding: 60px;
            position: relative;
            display: flex;
            flex-direction: column;
            justify-content: center;
        }

        .content-column .subtitle {
            font-family: 'Helvetica Neue', sans-serif;
            font-size: 0.9rem;
            color: #888;
            letter-spacing: 1px;
            text-transform: uppercase;
            margin-bottom: 15px;
        }

        .content-column h2 {
            font-size: 2.8rem;
            margin: 0 0 20px 0;
            font-weight: 500;
        }
        
        .content-column .description {
            font-family: 'Helvetica Neue', sans-serif;
            line-height: 1.7;
            color: #555;
            margin-bottom: 30px;
        }

        .expandable-item {
            display: flex;
            align-items: center;
            padding: 20px 0;
            border-bottom: 1px solid #eee;
            cursor: pointer;
            transition: background-color 0.3s;
        }
        
        .expandable-item:hover {
            background-color: #f9f9f9;
        }

        .expandable-item .arrow {
            font-size: 1.5rem;
            margin-right: 20px;
            color: #888;
        }

        .expandable-item span {
            font-family: 'Helvetica Neue', sans-serif;
            font-size: 1.1rem;
            font-weight: 500;
        }

        .more-info-btn {
            display: inline-block;
            border: 1px solid #ccc;
            padding: 12px 30px;
            margin-top: 40px;
            text-decoration: none;
            color: #555;
            font-family: 'Helvetica Neue', sans-serif;
            font-weight: bold;
            text-transform: uppercase;
            letter-spacing: 1px;
            border-radius: 5px;
            transition: all 0.3s;
            text-align: center;
            align-self: flex-start;
        }

        .more-info-btn:hover {
            background-color: #333;
            color: #fff;
            border-color: #333;
        }
        
        .content-column::after {
            content: '✧';
            position: absolute;
            right: -20px;
            bottom: 100px;
            font-size: 200px;
            color: #f0f0f0;
            z-index: -1;
            opacity: 0.5;
            transform: rotate(15deg);
        }

        /* --- Responsive Design --- */
        @media (max-width: 992px) {
            .discovery-section {
                flex-direction: column;
                width: 100%;
                margin: 0;
                border-radius: 0;
            }
            .image-column { min-height: 400px; }
            .content-column { padding: 40px; }
            .content-column h2 { font-size: 2.2rem; }
        }

        @media (max-width: 576px) {
            .image-overlay-content h3 { font-size: 2rem; }
            .content-column { padding: 30px; }
            .content-column h2 { font-size: 1.8rem; }
            .more-info-btn { align-self: stretch; }
        }
    </style>
</head>
<body>
    <div class="as_loader">
        <img src="assets/images/loader.png" alt="" class="img-responsive">
    </div> 
    
    <?php include 'includes/header.php'; ?>

    <section class="as_breadcrum_wrapper" style="margin-bottom: 32px;">
        <div class="container">
            <div class="row">
                <div class="col-lg-12 text-center">
                    <h1>Services</h1> 
                    <ul class="breadcrumb"> 
                        <li><a href="#">Home</a></li>
                        <li>Our Services</li>
                    </ul>
                </div>
            </div>
        </div>
    </section>

    

    <div class="as_service_section">
        <?php include './service/sss.php'; ?>
    </div>

    <!-- Mystical Self-Discovery Section -->
    <!-- <section class="discovery-section">
        <div class="image-column">
            <div class="slide" style="background-image: url('https://images.unsplash.com/photo-1590219253250-c3639535f657?q=80&w=1887&auto=format&fit=crop');">
                <div class="image-overlay-content">
                    <h3>Rune Readings for Guidance</h3>
                    <p>Tap into ancient Norse wisdom with personalized rune readings.</p>
                </div>
            </div>
            <div class="slide" style="background-image: url('https://images.unsplash.com/photo-1561011433-95c54c514742?q=80&w=1887&auto=format&fit=crop');">
                <div class="image-overlay-content">
                    <h3>Tarot Card Insights</h3>
                    <p>Uncover the hidden messages and guidance from the tarot cards.</p>
                </div>
            </div>
            <div class="slide" style="background-image: url('https://images.unsplash.com/photo-1600133202122-e1c5f113a899?q=80&w=1887&auto=format&fit=crop');">
                <div class="image-overlay-content">
                    <h3>Astrology Chart Analysis</h3>
                    <p>Explore your life's path through the wisdom of the stars.</p>
                </div>
            </div>
        </div>

        
        <div class="content-column">
            <p class="subtitle">Embrace Cosmic Wisdom</p>
            <h2>Mystical of Self-Discovery</h2>
            <p class="description">
                Drawing upon years of study and intuitive exploration, I offer a holistic approach to divination that integrates the wisdom of the stars, the symbolism of tarot cards, and the ancient Norse runes. Each session is tailored to provide you with deep insights into your life's journey, helping you uncover hidden truths.
            </p>
            <p class="description">
                My mission is to support you on your journey of self-discovery and personal growth. Whether you are facing uncertainties, seeking clarity, or striving for spiritual enlightenment, I am here to assist you in unlocking the mysteries that shape your destiny and empowering you to live authentically and purposefully.
            </p>

            <div class="expandable-item">
                <div class="arrow">&gt;</div>
                <span>Cosmic Guidance Sessions</span>
            </div>
            <div class="expandable-item">
                <div class="arrow">&gt;</div>
                <span>Divination and Insight Services</span>
            </div>

            <a href="#" class="more-info-btn">More Info</a>
        </div>
    </section> -->


    <section class="as_whychoose_wrapper">
        <div class="container-fluid">
            <div class="row">
                <div class="col-lg-12 col-md-12 text-center">
                    <h1 class="as_heading">Why Choose Us</h1>
                    <span><svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="240" height="15" viewbox="0 0 240 15"> <image id="Design" width="240" height="15" xlink:href="data:img/png;base64,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"></image></svg>
                    </span>   
                    <p class="as_font14 as_padderTop20 as_padderBottom50">It is a long established fact that a reader will be distracted by the readable content of a page <br>when looking at its layout. The point of using Lorem Ipsum .</p>
                </div>
                <div class="col-lg-12">
                    <ul class="as_choose_ul">
                        <li>
                            <div class="as_whychoose_box text-center">
                                <span class="as_number"><span><span data-from="0" data-to="100" data-speed="5000">100</span>+</span><img src="assets/images/svg/choose.svg" alt=""></span>
                                <h4>Trusted by Million Clients</h4>
                            </div>
                        </li>
                        <li>
                            <div class="as_whychoose_box text-center">
                                <span class="as_number"><span><span data-from="0" data-to="30" data-speed="5000">30</span>+</span><img src="assets/images/svg/choose.svg" alt=""></span>
                                <h4>Years of Experience</h4>
                            </div>
                        </li>
                        <li>
                            <div class="as_whychoose_box text-center">
                                <span class="as_number"><span><span data-from="0" data-to="55" data-speed="5000">55</span>+</span><img src="assets/images/svg/choose.svg" alt=""></span>
                                <h4>Types of Horoscopes</h4>
                            </div>
                        </li>
                        <li>
                            <div class="as_whychoose_box text-center">
                                <span class="as_number"><span><span data-from="0" data-to="90" data-speed="5000">90</span>+</span><img src="assets/images/svg/choose.svg" alt=""></span>
                                <h4>Qualified Astrologers</h4>
                            </div>
                        </li>
                        <li>
                            <div class="as_whychoose_box text-center">
                                <span class="as_number"><span><span data-from="0" data-to="99" data-speed="5000">99</span>+</span><img src="assets/images/svg/choose.svg" alt=""></span>
                                <h4>Success Horoscope</h4>
                            </div>
                        </li>
                    </ul>
                </div>
            </div>
        </div>
    </section>

    <?php include 'home/package.php'; ?>
    <?php include 'includes/footer.php'; ?>
    
    </div>
    

    <!-- Modal -->
    <div id="as_login" class="modal fade" role="dialog">
        <div class="modal-dialog">
    
            <!-- Modal content-->
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal">&times;</button>
                    <h4 class="modal-title">Login</h4>
                </div>
                <div class="modal-body">
                    <div class="as_login_box active">
                        <form action="">
                            <div class="form-group">
                                <input type="text" name="" placeholder="Enter email" class="form-control" id="">
                            </div>
                            <div class="form-group">
                                <input type="text" name="" placeholder="Enter password here" class="form-control" id="">
                            </div>
                            <div class="form-group">
                                <div class="as_login_data">
                                    <label>Remember me
                                            <input type="checkbox" name="as_remember_me" value="">
                                            <span class="checkmark"></span>
                                    </label>
                                    <a href="#">Forgot password ?</a>
                                </div>
                            </div>
                            <div class="text-center">
                                <a href="javascript:;" class="as_btn">login</a>
                            </div>
                        </form>
                        <p class="text-center as_margin0 as_padderTop20">Create An Account ? <a href="javascript:;" class="as_orange as_signup">SignUp</a></p>
                    </div>
                    <div class="as_signup_box">
                        <form action="">
                            <div class="form-group">
                                <input type="text" name="" placeholder="Enter name" class="form-control" id="">
                            </div>
                            <div class="form-group">
                                <input type="text" name="" placeholder="Enter email" class="form-control" id="">
                            </div>
                            <div class="form-group">
                                <input type="text" name="" placeholder="Enter password here" class="form-control" id="">
                            </div>
                            <div class="form-group">
                                <input type="text" name="" placeholder="Enter mobile number" class="form-control" id="">
                            </div>
                            <div class="form-group">
                                <select name="" class="form-control" id="">
                                    <option value="male">Male</option>
                                    <option value="female">Female</option>
                                </select>
                            </div>
                            <div class="text-center">
                                <a href="javascript:;" class="as_btn">Sign Up</a>
                            </div>
                        </form>
                        <p class="text-center as_margin0 as_padderTop20">Have An Account ? <a href="javascript:;" class="as_orange as_login">Login</a></p>
                    </div> 
                </div>
            </div>
    
        </div>
    </div>

    <!-- javascript -->
    <script src="assets/js/jquery.js"></script>
    <script src="assets/js/bootstrap.js"></script>
    <script src="assets/js/plugin/slick/slick.min.js"></script>
    <script src="assets/js/plugin/select2/select2.min.js"></script>
    <script src="assets/js/plugin/countto/jquery.countTo.js"></script>
    <script src="assets/js/plugin/airdatepicker/datepicker.min.js"></script>
    <script src="assets/js/plugin/airdatepicker/i18n/datepicker.en.js"></script>
    <script src="assets/js/custom.js"></script>   

    <!-- Custom Slider Script -->
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const slides = document.querySelectorAll('.discovery-section .slide');
            if (slides.length > 1) {
                let currentSlide = 0;
                
                // Show the first slide immediately
                slides[currentSlide].classList.add('active');

                setInterval(() => {
                    slides[currentSlide].classList.remove('active');
                    currentSlide = (currentSlide + 1) % slides.length;
                    slides[currentSlide].classList.add('active');
                }, 5000); // Change slide every 5 seconds
            }
        });
    </script>
<script src="/cdn-cgi/scripts/7d0fa10a/cloudflare-static/rocket-loader.min.js" data-cf-settings="c410a5ce3f1cc355f367e9dd-|49" defer=""></script>
</body>
</html>
