<?php $current_page = basename($_SERVER['PHP_SELF']); ?>
<section class="as_header_wrapper">
    <div class="container">
        <div class="row align-items-center">
            <!-- Logo Section -->
            <div class="col-lg-3 col-md-3 col-sm-4 col-4">
                <div class="as_logo">
                    <a href="index.php">
                        <img src="assets/images/astrologo.png" alt="Logo">
                    </a>
                </div>
            </div>
            
            <!-- Menu Section (Hidden on mobile) -->
            <div class="col-lg-6 col-md-6 d-none d-md-block">
                <div class="as_menu_wrapper">
                    <div class="as_menu">
                        <ul>
                            <li><a href="index.php" class="<?php echo $current_page == 'index.php' ? 'active' : ''; ?>">home</a></li>
                            <li><a href="about.php" class="<?php echo $current_page == 'about.php' ? 'active' : ''; ?>">about us</a></li>
                            <li><a href="blog.php" class="<?php echo $current_page == 'blog.php' ? 'active' : ''; ?>">Blog</a></li>
                            
                            <?php
                                // 'pages' යටතේ ඇති සියලුම sub-pages වල නම් මෙතනට ඇතුළත් කරන්න
                                $pages_submenu = ['service.php', 'service_single.php', 'horoscope.php', 'horoscope-single.php'];
                            ?>
                            
                            <li class="<?php echo in_array($current_page, $pages_submenu) ? 'active' : ''; ?>">
                                <a href="javascript:;">pages</a>
                                <ul class="as_submenu">
                                    <li><a href="service.php">service</a></li>
                                    <li><a href="service_single.php">service single</a></li>
                                    <li><a href="horoscope.php">Horoscope</a></li>
                                    <li><a href="single_horoscope.php">Horoscope Single</a></li>
                                </ul>
                            </li>

                            <li><a href="contact.php" class="<?php echo $current_page == 'contact.php' ? 'active' : ''; ?>">contact</a></li>
                        </ul>
                    </div>
                </div>
            </div>
            
            <!-- Mobile Menu Toggle and Login Section -->
            <div class="col-lg-3 col-md-3 col-sm-8 col-8">
                <div class="as_header_right">
                    <!-- Mobile Menu Toggle -->
                    <div class="as_mobile_menu_toggle d-md-none">
                        <span class="as_toggle">
                            <img src="assets/images/svg/menu.svg" alt="Menu">
                        </span>
                    </div>
                    
                    <!-- Login Button -->
                    <div class="as_user">
                        <a class="as_login_btn" href="login.php">Login</a>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <!-- Mobile Menu (Positioned outside grid) -->
    <div class="as_mobile_menu d-md-none">
        <div class="as_menu">
            <ul>
                <li><a href="index.php" class="<?php echo $current_page == 'index.php' ? 'active' : ''; ?>">home</a></li>
                <li><a href="about.php" class="<?php echo $current_page == 'about.php' ? 'active' : ''; ?>">about us</a></li>
                <li><a href="blog.php" class="<?php echo $current_page == 'blog.php' ? 'active' : ''; ?>">Blog</a></li>
                
                <li class="<?php echo in_array($current_page, $pages_submenu) ? 'active' : ''; ?>">
                    <a href="javascript:;">pages</a>
                    <ul class="as_submenu">
                        <li><a href="service.php">service</a></li>
                        <li><a href="service_single.php">service single</a></li>
                        <li><a href="horoscope.php">Horoscope</a></li>
                        <li><a href="horoscope-single.php">Horoscope Single</a></li>
                    </ul>
                </li>

                <li><a href="contact.php" class="<?php echo $current_page == 'contact.php' ? 'active' : ''; ?>">contact</a></li>
            </ul>
        </div>
    </div>
</section>