<!DOCTYPE html>
<html lang="en">
<head>
    <title>Horoscope</title>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <link rel="stylesheet" href="assets/css/bootstrap.css">
    <link href="assets/css/font.css" rel="stylesheet">
    <link rel="stylesheet" type="text/css" href="assets/js/plugin/slick/slick.css">
    <link rel="stylesheet" type="text/css" href="assets/js/plugin/select2/select2.min.css">
    <link rel="stylesheet" type="text/css" href="assets/js/plugin/airdatepicker/datepicker.min.css">
    <link rel="stylesheet" type="text/css" href="assets/css/style.css">
    
    <link rel="stylesheet" type="text/css" href="assets/css/horoscope.css">

    <link rel="shortcut icon" href="assets/images/favicon.png" type="image/x-icon">
    <style>
        .as_breadcrum_wrapper{
            background-image: url('assets/images/blog/blog2.jpg');
        }
    </style>
</head>
<body>
    <div class="as_loader">
        <img src="assets/images/loader.png" alt="" class="img-responsive">
    </div> 
    
    <?php include 'includes/header.php'; ?>

    <section class="as_breadcrum_wrapper">
        <div class="container">
            <div class="row">
                <div class="col-lg-12 text-center">
                    <h1>Horoscope</h1> 
                    <ul class="breadcrumb"> 
                        <li><a href="#">Home</a></li>
                        <li>Horoscope</li>
                    </ul>
                </div>
            </div>
        </div>
    </section>

    <section class="custom_horoscope_bg">
        <div class="container">
            <div class="row">
                <div class="col-lg-12 text-center">
                    <h2 class="as_section_heading">Horoscope Forecasts</h2>
                    <p class="as_section_description">Select your zodiac sign to reveal your daily horoscope forecast.</p>
                </div>
            </div>
            <div class="horoscope-grid">
                <a href="single_horoscope.php?zodiac=aries" class="zodiac-card">
                    <div class="zodiac-icon"><img src="assets/images/svg/horoscope/h1.svg" alt="Aries"></div>
                    <h3 class="zodiac-title">Aries</h3>
                    <p class="zodiac-date">Mar 21 - Apr 19</p>
                </a>
                <a href="#" class="zodiac-card">
                    <div class="zodiac-icon"><img src="assets/images/svg/horoscope/h2.svg" alt="Taurus"></div>
                    <h3 class="zodiac-title">Taurus</h3>
                    <p class="zodiac-date">Apr 20 - May 20</p>
                </a>
                <a href="#" class="zodiac-card">
                    <div class="zodiac-icon"><img src="assets/images/svg/horoscope/h3.svg" alt="Gemini"></div>
                    <h3 class="zodiac-title">Gemini</h3>
                    <p class="zodiac-date">May 21 - Jun 20</p>
                </a>
                <a href="#" class="zodiac-card">
                    <div class="zodiac-icon"><img src="assets/images/svg/horoscope/h4.svg" alt="Cancer"></div>
                    <h3 class="zodiac-title">Cancer</h3>
                    <p class="zodiac-date">Jun 21 - Jul 22</p>
                </a>
                <a href="#" class="zodiac-card">
                    <div class="zodiac-icon"><img src="assets/images/svg/horoscope/h5.svg" alt="Leo"></div>
                    <h3 class="zodiac-title">Leo</h3>
                    <p class="zodiac-date">Jul 23 - Aug 22</p>
                </a>
                <a href="#" class="zodiac-card">
                    <div class="zodiac-icon"><img src="assets/images/svg/horoscope/h6.svg" alt="Virgo"></div>
                    <h3 class="zodiac-title">Virgo</h3>
                    <p class="zodiac-date">Aug 23 - Sep 22</p>
                </a>
                <a href="#" class="zodiac-card">
                    <div class="zodiac-icon"><img src="assets/images/svg/horoscope/h7.svg" alt="Libra"></div>
                    <h3 class="zodiac-title">Libra</h3>
                    <p class="zodiac-date">Sep 23 - Oct 22</p>
                </a>
                <a href="#" class="zodiac-card">
                    <div class="zodiac-icon"><img src="assets/images/svg/horoscope/h8.svg" alt="Scorpio"></div>
                    <h3 class="zodiac-title">Scorpio</h3>
                    <p class="zodiac-date">Oct 23 - Nov 21</p>
                </a>
                <a href="#" class="zodiac-card">
                    <div class="zodiac-icon"><img src="assets/images/svg/horoscope/h9.svg" alt="Sagittarius"></div>
                    <h3 class="zodiac-title">Sagittarius</h3>
                    <p class="zodiac-date">Nov 22 - Dec 21</p>
                </a>
                <a href="#" class="zodiac-card">
                    <div class="zodiac-icon"><img src="assets/images/svg/horoscope/h10.svg" alt="Capricorn"></div>
                    <h3 class="zodiac-title">Capricorn</h3>
                    <p class="zodiac-date">Dec 22 - Jan 19</p>
                </a>
                <a href="#" class="zodiac-card">
                    <div class="zodiac-icon"><img src="assets/images/svg/horoscope/h11.svg" alt="Aquarius"></div>
                    <h3 class="zodiac-title">Aquarius</h3>
                    <p class="zodiac-date">Jan 20 - Feb 18</p>
                </a>
                <a href="#" class="zodiac-card">
                    <div class="zodiac-icon"><img src="assets/images/svg/horoscope/h12.svg" alt="Pisces"></div>
                    <h3 class="zodiac-title">Pisces</h3>
                    <p class="zodiac-date">Feb 19 - Mar 20</p>
                </a>
            </div>
        </div>
    </section>

    <section class="as_birth_chart_wrapper">
        <div class="container">
            <div class="row">
                <div class="col-lg-12 text-center">
                    <h2 class="as_section_heading">Get Your Free Birth Chart</h2>
                    <p class="as_section_description">Astrology has been a source of guidance for people throughout history as it helps us understand our place in the universe and the role we play in it.</p>
                </div>
                <div class="col-lg-10 offset-lg-1">
                    <div class="as_birth_chart_form">
                        <form action="">
                            <div class="row">
                                <div class="col-lg-6">
                                    <input type="text" class="form-control" placeholder="Full Name *">
                                </div>
                                <div class="col-lg-6">
                                    <input type="text" class="form-control" placeholder="Gender *">
                                </div>
                                <div class="col-lg-6">
                                    <input type="text" class="form-control" placeholder="Date of Birth (DD/MM/YYYY) *">
                                </div>
                                <div class="col-lg-6">
                                    <input type="text" class="form-control" placeholder="Time of Birth *">
                                </div>
                                <div class="col-lg-6">
                                    <input type="text" class="form-control" placeholder="Birth Location *">
                                </div>
                                <div class="col-lg-6">
                                    <input type="email" class="form-control" placeholder="Email Address *">
                                </div>
                                <div class="col-lg-12 text-center">
                                    <button type="submit" class="as_btn">Get Your Chart</button>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </section>
    
    <?php include 'includes/footer.php'; ?>
    
    <script src="assets/js/jquery.js"></script>
    <script src="assets/js/bootstrap.js"></script>
    <script src="assets/js/plugin/slick/slick.min.js"></script>
    <script src="assets/js/plugin/select2/select2.min.js"></script>
    <script src="assets/js/plugin/countto/jquery.countTo.js"></script>
    <script src="assets/js/plugin/airdatepicker/datepicker.min.js"></script>
    <script src="assets/js/plugin/airdatepicker/i18n/datepicker.en.js"></script>
    <script src="assets/js/custom.js"></script>
</body>
</html>