<style>
    /* --- General Styles --- */
    /* Note: You might want to move these font-family rules to your main stylesheet */
    .services-section-container {
        font-family: 'Garamond', serif;
        color: #333;
    }

    /* --- Services Section --- */
    .services-section {
        width: 100%;
        max-width: 1200px;
        text-align: center;
        margin: 0 auto; /* Center the component */
        padding: 1rem;
        overflow: visible; /* Allow arrows to be visible */
    }

    .services-section .subtitle {
        font-size: 0.8rem;
        letter-spacing: 0.2em;
        text-transform: uppercase;
        font-weight: bold;
        color: #666;
        position: relative;
        display: inline-block;
        margin-bottom: 1.5rem;
    }

    /* Line above the subtitle */
    .services-section .subtitle::before {
        content: '';
        position: absolute;
        top: -10px;
        left: 50%;
        transform: translateX(-50%);
        width: 30px;
        height: 1px;
        background-color: #999;
    }


    .services-section h2 {
        font-family: 'Cormorant Garamond', serif; /* An elegant, high-contrast serif */
        font-size: 2.5rem;
        font-weight: 500;
        letter-spacing: 0.1em;
        margin-bottom: 1rem;
        text-transform: uppercase;
    }

    .services-section .description {
        max-width: 600px;
        margin: 0 auto 3rem auto;
        font-size: 1rem;
        line-height: 1.6;
        color: #555;
    }

    /* --- Cards Slider --- */
    .services-slider {
        display: flex;
        align-items: center;
        justify-content: center;
        gap: 1.5rem;
        position: relative;
        width: 100%;
        max-width: 1200px;
        margin: 0 auto;
        overflow: visible;
        padding: 0 3rem; /* Increased padding for more arrow space */
    }

    .slider-arrow {
        background: none;
        border: none;
        font-size: 2rem;
        color: #888;
        cursor: pointer;
        transition: color 0.3s ease;
        padding: 0 1rem;
        position: relative;
        z-index: 10;
        min-width: 40px;
        height: 40px;
        display: flex;
        align-items: center;
        justify-content: center;
    }

    .slider-arrow:hover {
        color: #333;
    }

    .cards-container {
        display: flex;
        gap: 1rem; /* Reduced from 1.5rem to 1rem */
        overflow-x: auto; /* Allow horizontal scrolling */
        padding-bottom: 1rem; /* Space for pagination */
        width: calc(200px * 5 + 1rem * 4 + 2rem); /* Updated width for 5 cards + gaps + arrow space */
        scrollbar-width: none; /* Hide scrollbar for Firefox */
        -ms-overflow-style: none; /* Hide scrollbar for IE/Edge */
    }

    .cards-container::-webkit-scrollbar {
        display: none; /* Hide scrollbar for Chrome/Safari */
    }

    /* --- Service Card --- */
    .service-card {
        background-color: #fff;
        border-radius: 12px;
        overflow: hidden;
        box-shadow: 0 10px 20px rgba(0, 0, 0, 0.05);
        width: 200px; /* Further reduced from 220px to 200px */
        flex-shrink: 0; /* Prevents cards from shrinking */
        text-align: left;
        position: relative;
    }

    .card-image-container {
        width: 100%;
        height: 240px; /* Reduced from 280px to 240px */
        overflow: hidden;
        position: relative;
        display: flex;
        justify-content: center;
        align-items: center;
    }

    .card-image-container img {
        width: 100%;
        height: 100%;
        object-fit: cover;
        transition: transform 0.4s ease;
    }
    
    /* --- Hover Overlay and Button --- */
    .card-image-container::after {
        content: '';
        position: absolute;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
        background-color: #000;
        opacity: 0;
        transition: opacity 0.4s ease;
        z-index: 1;
    }

    .view-details-btn1 {
        position: absolute;
        border: 1px solid white;
        padding: 0.75rem 1.5rem;
        color: #ffffff !important;
        text-decoration: none;
        font-size: 0.8rem;
        font-weight: bold;
        letter-spacing: 1px;
        z-index: 2;
        opacity: 0;
        visibility: hidden;
        transform: translateY(10px);
        transition: opacity 0.4s ease, transform 0.4s ease, visibility 0.4s;
    }
    
    .service-card:hover .card-image-container::after {
        opacity: 0.6;
    }

    .service-card:hover .view-details-btn1 {
        opacity: 1;
        visibility: visible;
        transform: translateY(0);
    }

    .service-card:hover .card-image-container img {
        transform: scale(1.05);
    }

    .hot-badge {
        position: absolute;
        top: 10px;
        left: 10px;
        background-color: #ff6b6b;
        color: white;
        padding: 5px 10px;
        font-size: 0.7rem;
        font-weight: bold;
        border-radius: 5px;
        text-transform: uppercase;
        letter-spacing: 1px;
        z-index: 3; /* Ensure badge is above overlay */
    }

    .card-content {
        padding: 1.2rem; /* Reduced from 1.5rem to 1.2rem */
    }

    .card-content .category {
        font-size: 0.75rem;
        color: #888;
        text-transform: uppercase;
        letter-spacing: 1.5px;
        margin-bottom: 0.5rem;
    }

    .card-content .title {
        font-size: 1.25rem;
        font-weight: bold;
        color: #333;
        margin: 0;
    }

    /* --- Pagination Dots --- */
    .slider-pagination {
        margin-top: 2rem;
        display: flex;
        justify-content: center;
        gap: 8px;
    }

    .dot {
        width: 8px;
        height: 8px;
        background-color: #d1d1d1;
        border-radius: 50%;
        cursor: pointer;
        transition: background-color 0.3s ease;
    }

    .dot.active {
        background-color: #555;
    }

    /* --- Responsive Design --- */
    @media (max-width: 1200px) {
        .services-slider {
            padding: 0 1rem; /* Reduce padding on smaller screens */
        }
        .cards-container {
            /* On smaller screens, allow scrolling */
            overflow-x: auto;
            padding-bottom: 2rem; /* More space for scrollbar */
            justify-content: flex-start;
            width: 100%; /* Reset width for smaller screens */
        }
        .slider-arrow {
            display: none; /* Hide arrows if we use native scroll */
        }
    }

    @media (max-width: 768px) {
        .services-section h2 {
            font-size: 2rem;
        }
        .cards-container {
            /* Ensure scrolling starts from the edge */
            justify-content: flex-start;
            padding-left: 1rem;
            padding-right: 1rem;
            scroll-snap-type: x mandatory; /* Smooth snapping */
        }
         .service-card {
            scroll-snap-align: start;
        }
    }
</style>

<div class="services-section-container">
    <section class="services-section">
        <span class="subtitle">Services We Provide</span>
        <h2>EMBRACING ASTROLOGY AND ESOTERIC WISDOM FOR EVERYDAY LIFE</h2>
        <p class="description">
            Astrology has been a source of guidance for people throughout history as it helps us
            understand our place in the universe and the role we play in it.
        </p>

        <div class="services-slider">
            <button class="slider-arrow prev-arrow">&larr;</button>

            <div class="cards-container">
                <!-- Card 1 -->
                <div class="service-card">
                    <div class="card-image-container">
                        <img src="assets/images/service/Festivals2.jpg" alt="Tarot cards and herbs" onerror="this.onerror=null;this.src='https://placehold.co/260x280/e0e0e0/777?text=Moon+Magic';">
                        <a href="service_single.php?service=festivals" class="view-details-btn1">VIEW SERVICE +</a>
                    </div>
                    <div class="card-content">
                        <p class="category">Services</p>
                        <h3 class="title">Festivals & Events</h3>
                    </div>
                </div>

                <!-- Card 2 -->
                <div class="service-card">
                    <div class="card-image-container">
                         <!-- <div class="hot-badge">HOT</div> -->
                        <img src="assets/images/service/Kundli2.jpg" alt="Astrology candles" onerror="this.onerror=null;this.src='https://placehold.co/260x280/e0e0e0/777?text=Astrology';">
                        <a href="#" class="view-details-btn1">VIEW SERVICE +</a>
                    </div>
                    <div class="card-content">
                        <p class="category">Services</p>
                        <h3 class="title">Kundali Milan</h3>
                    </div>
                </div>

                <!-- Card 3 -->
                <div class="service-card">
                    <div class="card-image-container">
                        <!-- <div class="hot-badge">HOT</div> -->
                        <img src="assets/images/service/Love2.jpg" alt="Esoteric Coaching setup" onerror="this.onerror=null;this.src='https://placehold.co/260x280/e0e0e0/777?text=Tarot';">
                        <a href="#" class="view-details-btn1">VIEW SERVICE +</a>
                    </div>
                    <div class="card-content">
                        <p class="category">Services</p>
                        <h3 class="title">Love & Relationship</h3>
                    </div>
                </div>

                <!-- Card 4 -->
                <div class="service-card">
                    <div class="card-image-container">
                        <img src="assets/images/service/Matching1.jpg" alt="Woman reading by a window" onerror="this.onerror=null;this.src='https://placehold.co/260x280/e0e0e0/777?text=Astrology';">
                        <a href="#" class="view-details-btn1">VIEW SERVICE +</a>
                    </div>
                    <div class="card-content">
                        <p class="category">Services</p>
                        <h3 class="title">Matching & Compatibility</h3>
                    </div>
                </div>

                <!-- Card 5 -->
                <div class="service-card">
                    <div class="card-image-container">
                        <!-- <div class="hot-badge">HOT</div> -->
                        <img src="assets/images/service/Numerology2.jpg" alt="Spiritual meditation" onerror="this.onerror=null;this.src='https://placehold.co/260x280/e0e0e0/777?text=Spiritual';">
                        <a href="#" class="view-details-btn1">VIEW SERVICE +</a>
                    </div>
                    <div class="card-content">
                        <p class="category">Services</p>
                        <h3 class="title">Numerology</h3>
                    </div>
                </div>
            </div>

            <button class="slider-arrow next-arrow">&rarr;</button>
        </div>

        <div class="slider-pagination">
            <span class="dot active"></span>
            <span class="dot"></span>
            <span class="dot"></span>
            <span class="dot"></span>
            <span class="dot"></span>
        </div>

    </section>
</div>
