<style>
        /* --- Service Section Styles --- */
        .as_service_wrapper {
            padding: 15px 0;
            background-color: #f8f9fa;
        }

        /* --- Section Title --- */
        .as_service_wrapper .as_heading {
            font-size: 2rem;
            color: #333;
            margin-bottom: 0.3rem;
            margin-top: 1rem;
            text-align: center;
        }

        .as_service_wrapper .as_font14 {
            font-size: 14px;
            color: #666;
            margin-bottom: 3rem;
        }

        /* --- Services Grid --- */
        .services-grid {
            display: grid;
            grid-template-columns: repeat(6, 1fr);
            gap: 1.5rem;
            margin-top: 2rem;
        }

        /* --- Individual Service Card --- */
        .service-card {
            display: flex;
            flex-direction: column;
            align-items: center;
            text-decoration: none;
            color: #555;
            transition: transform 0.3s ease-in-out, box-shadow 0.3s ease-in-out;
            padding: -2rem;
            border-radius: 8px;
        }
        
        .service-card:hover {
            transform: translateY(-8px);
            text-decoration: none;
            color: #333;
        }

        .service-card img {
            width: 100%;
            height: auto;
            aspect-ratio: 1 / 1;
            object-fit: cover;
            border-radius: 1rem;
            box-shadow: 0 4px 15px rgba(0, 0, 0, 0.1);
            margin-bottom: 0.75rem;
            transition: box-shadow 0.3s ease-in-out;
        }
        
        .service-card:hover img {
             box-shadow: 0 8px 25px rgba(0, 0, 0, 0.2);
        }

        .service-card p {
            font-size: 1rem;
            font-weight: 500;
            margin: 0;
            text-align: center;
            line-height: 1.4;
        }

        /* --- Responsive Design --- */
        
        /* For Tablets (e.g., screen width <= 1024px) */
        @media (max-width: 1024px) {
            .services-grid {
                grid-template-columns: repeat(4, 1fr);
            }
        }

        /* For Smaller Tablets (e.g., screen width <= 768px) */
        @media (max-width: 768px) {
            .as_service_wrapper {
                padding: 60px 0;
            }
            .services-grid {
                grid-template-columns: repeat(3, 1fr);
                gap: 1rem;
            }
            .as_service_wrapper .as_heading {
                font-size: 2rem;
            }
        }

        /* For Mobile Phones (e.g., screen width <= 480px) */
        @media (max-width: 480px) {
            .as_service_wrapper {
                padding: 40px 0;
            }
            .services-grid {
                grid-template-columns: repeat(2, 1fr);
                gap: 1rem;
            }
            .as_service_wrapper .as_heading {
                font-size: 1.5rem;
            }
            .service-card p {
                font-size: 0.8rem;
            }
        }
    </style>

<section class="as_service_wrapper">
    <div class="container">
        <div class="row">
            <div class="col-lg-10">
                <h1 class="as_heading" style="text-align: left;">Our Services</h1>
                <span><svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="240" height="15" viewbox="0 0 240 15">
                            <image id="Vector_Smart_Object" data-name="Vector Smart Object" width="240" height="15" xlink:href="data:img/png;base64,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"></image>
                        </svg>
                </span>
            </div>
        </div>
        <div class="row">
            <div class="col-lg-12">
                <div class="services-grid">
            <!-- Row 1 -->
            <a href="#" class="service-card">
                <img src="assets/images/service/row1.jpg" alt="Match Making">
                <p>Match Making</p>
            </a>
            <a href="#" class="service-card">
                <img src="assets/images/service/panchang.jpg" alt="Panchang">
                <p>Panchang</p>
            </a>
            <a href="#" class="service-card">
                <img src="assets/images/service/tarot.jpg" alt="Tarot Reading">
                <p>Tarot Reading</p>
            </a>
            <a href="#" class="service-card">
                <img src="assets/images/service/kundli.jpg" alt="Kundli">
                <p>Kundli</p>
            </a>
            <a href="#" class="service-card">
                <img src="assets/images/service/love.jpg" alt="Love">
                <p>Love</p>
            </a>
            <a href="#" class="service-card">
                <img src="assets/images/service/numerology.jpg" alt="Numerology">
                <p>Numerology</p>
            </a>

            <!-- Row 2 -->
            <a href="#" class="service-card">
                <img src="assets/images/service/remedies.jpg" alt="Remedies">
                <p>Remedies</p>
            </a>
            <a href="#" class="service-card">
                <img src="assets/images/service/planet.jpg" alt="Planet">
                <p>Planet Transits</p>
            </a>
            <a href="#" class="service-card">
                <img src="assets/images/service/vastu.jpg" alt="Vastu">
                <p>Vastu</p>
            </a>
            <a href="#" class="service-card">
                <img src="assets/images/service/zodiac.jpg" alt="Zodiac Signs">
                <p>Zodiac Signs</p>
            </a>
            <a href="#" class="service-card">
                <img src="assets/images/service/Festivals.jpg" alt="Festivals">
                <p>Festivals</p>
            </a>
            <a href="#" class="service-card">
                <img src="assets/images/service/spirituality.jpg" alt="Spirituality">
                <p>Spirituality</p>
            </a>
                </div>
            </div>
        </div>
    </div>
</section>