<!-- You can include this file in your main page. -->
<!-- It does not contain <html>, <head>, or <body> tags. -->

<!-- Google Fonts Import -->
<link rel="preconnect" href="https://fonts.googleapis.com">
<link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
<link href="https://fonts.googleapis.com/css2?family=Playfair+Display:wght@700&family=Lato:wght@400;700&display=swap" rel="stylesheet">

<style>
    /* ========================================
    General Styling
    ========================================
    */
    :root {
        --dark-bg: #0d0d0d;
        --gold-color: #c9a877;
        --text-light: #e0e0e0;
        --text-medium: #a0a0a0;
        --card-bg: #1a1a1a;
        --border-color: #333;
        --font-heading: 'Playfair Display', serif;
        --font-body: 'Lato', sans-serif;
    }

    /* Main container for the component */
    .astrology-container {
        background-color: var(--dark-bg);
        color: var(--text-light);
        font-family: var(--font-body);
        padding: 80px 0;
        overflow-x: hidden; /* Prevents horizontal scrollbar from slider */
    }

    .astrology-section {
        max-width: 1200px;
        margin: 0 auto;
        padding: 0 20px;
    }

    /* Universal heading styles */
    .section-title_n {
        font-family: var(--font-heading);
        color: var(--text-light);
        font-size: 2.5rem;
        text-align: center;
        margin-bottom: 1rem;
        font-weight: 700;
        letter-spacing: 1px;
    }

    .section-subtitle {
        color: var(--text-medium);
        text-align: center;
        margin-bottom: 3rem;
    }
    
    .section-tag {
        text-align: center;
        color: var(--text-medium);
        font-size: 0.8rem;
        letter-spacing: 2px;
        text-transform: uppercase;
        margin-bottom: 1rem;
        position: relative;
    }

    .section-tag::before,
    .section-tag::after {
        content: '';
        display: inline-block;
        width: 30px;
        height: 1px;
        background-color: var(--border-color);
        vertical-align: middle;
        margin: 0 10px;
    }


    /* ========================================
    Horoscope Section
    ========================================
    */
    .horoscope-section {
        padding-bottom: 80px;
        border-bottom: 1px solid var(--border-color);
    }

    /* Mystical Header Image Section */
    .mystical-header-section {
        width: 100%;
        margin-bottom: 0;
    }

    .mystical-header-image {
        position: relative;
        width: 100%;
        height: 200px;
        border-radius: 0px;
        overflow: hidden;
        box-shadow: 0 20px 40px rgba(0, 0, 0, 0.3);
    }

    .mystical-bg-image {
        width: 100%;
        height: 100%;
        object-fit: cover;
        filter: brightness(0.8) contrast(1.1);
    }

    .image-overlay {
        position: absolute;
        top: 0;
        left: 0;
        right: 0;
        bottom: 0;
        background: linear-gradient(
            135deg,
            rgba(255, 215, 0, 0.15) 0%,
            rgba(255, 140, 0, 0.15) 50%,
            rgba(138, 43, 226, 0.15) 100%
        );
        pointer-events: none;
    }

    .zodiac-grid {
        display: grid;
        grid-template-columns: repeat(6, 1fr);
        gap: 2rem;
        margin-bottom: 3rem;
    }

    .zodiac-item {
        text-align: center;
        cursor: pointer;
        transition: transform 0.3s ease;
    }

    .zodiac-item:hover {
        transform: translateY(-5px);
    }

    .zodiac-item a {
        display: block;
        text-decoration: none;
        color: inherit;
        transition: transform 0.3s ease;
    }

    .zodiac-item a:hover {
        transform: translateY(-5px);
    }

    .zodiac-item svg {
        width: 60px;
        height: 60px;
        stroke: var(--gold-color);
        margin-bottom: 0.5rem;
    }

    .zodiac-item .zodiac-icon {
        width: 60px;
        height: 60px;
        margin-bottom: 0.5rem;
        object-fit: contain;
    }

    .zodiac-item p {
        color: var(--text-medium);
        text-transform: uppercase;
        letter-spacing: 1px;
        font-size: 0.8rem;
    }

    .birth-chart-btn {
        display: block;
        margin: 0 auto;
        background-color: transparent;
        border: 1px solid var(--border-color);
        color: var(--text-light);
        padding: 12px 30px;
        font-size: 0.9rem;
        cursor: pointer;
        transition: all 0.3s ease;
    }

    .birth-chart-btn:hover {
        background-color: var(--gold-color);
        color: var(--dark-bg);
        border-color: var(--gold-color);
    }

    /* ========================================
    Lunar Lore Section
    ========================================
    */
    .lunar-lore-section {
        padding-top: 80px;
    }

    .lunar-lore-header {
        margin-bottom: 4rem;
    }

    .lunar-lore-title-block {
        flex-basis: 40%;
        text-align: left;
    }
    
    .lunar-lore-title-block .section-title {
        text-align: left;
    }
    
    .lunar-lore-header .benefits-section-tag {
        text-align: center !important;
        color: var(--text-medium);
        font-size: 0.8rem;
        letter-spacing: 2px;
        text-transform: uppercase;
        margin-bottom: 1rem;
        position: relative;
        display: block !important;
        width: 100% !important;
    }
    
    .lunar-lore-header .benefits-section-tag::before,
    .lunar-lore-header .benefits-section-tag::after {
        content: '';
        display: inline-block;
        width: 30px;
        height: 1px;
        background-color: var(--border-color);
        vertical-align: middle;
        margin: 0 10px;
    }
    
    .lunar-lore-title-block .section-tag::before {
        margin-left: 0;
    }
    
    .lunar-lore-title-block .section-tag::after {
        display: none;
    }

    .lunar-lore-header .section-title_n {
        font-size: 2.2rem;
        text-align: center;
        margin-bottom: 1.5rem;
    }

    .lunar-lore-description {
        color: var(--text-medium);
        line-height: 1.8;
        text-align: center;
    }

    .lunar-slider-wrapper {
        position: relative;
    }

    .lunar-slider-container {
        overflow: hidden;
    }

    .lunar-slider-track {
        display: flex;
        transition: transform 0.5s ease-in-out;
    }

    .lunar-card {
        flex: 0 0 25%; /* Show 4 cards at a time */
        box-sizing: border-box;
        padding: 0 15px;
    }

    .lunar-card-inner {
        background-color: var(--card-bg);
        border-radius: 8px;
        padding: 2rem;
        height: 100%;
        border: 1px solid var(--border-color);
    }
    
    .lunar-card-icon {
        height: 60px;
        margin-bottom: 1.5rem;
    }

    .lunar-card-icon svg {
        width: 50px;
        height: 50px;
        fill: var(--text-light);
    }

    .lunar-card h3 {
        font-family: var(--font-heading);
        font-size: 1.4rem;
        margin-bottom: 1rem;
        color: var(--text-light);
    }

    .lunar-card p {
        color: var(--text-medium);
        font-size: 0.9rem;
        line-height: 1.6;
    }

    /* Slider Navigation */
    .slider-nav {
        position: absolute;
        top: 50%;
        transform: translateY(-50%);
        width: calc(100% + 80px); /* Extend beyond the container for positioning */
        left: -40px;
        display: flex;
        justify-content: space-between;
        pointer-events: none; /* Allows clicks to pass through */
    }

    .slider-arrow {
        width: 50px;
        height: 50px;
        border-radius: 50%;
        background-color: rgba(26, 26, 26, 0.8);
        border: 1px solid var(--border-color);
        color: var(--text-light);
        cursor: pointer;
        display: flex;
        justify-content: center;
        align-items: center;
        font-size: 1.5rem;
        pointer-events: all; /* Make arrows clickable */
        transition: all 0.3s ease;
    }

    .slider-arrow:hover {
        background-color: var(--gold-color);
        color: var(--dark-bg);
    }
    
    .slider-arrow.disabled {
        opacity: 0.5;
        cursor: not-allowed;
    }

    /* Slider Pagination */
    .slider-pagination {
        text-align: center;
        margin-top: 2rem;
    }

    .dot {
        height: 8px;
        width: 8px;
        margin: 0 5px;
        background-color: var(--border-color);
        border-radius: 50%;
        display: inline-block;
        cursor: pointer;
        transition: background-color 0.3s ease;
    }

    .dot.active {
        background-color: var(--gold-color);
    }
    
    /* ========================================
    Responsive Design
    ========================================
    */
    @media (max-width: 1024px) {
        .mystical-header-image {
            height: 300px;
        }
        .zodiac-grid {
            grid-template-columns: repeat(4, 1fr);
        }
        .lunar-lore-header {
            flex-direction: column;
            gap: 2rem;
            text-align: center;
        }
        .lunar-lore-title-block, .lunar-lore-description {
            flex-basis: 100%;
            text-align: center;
        }
        .lunar-lore-title-block .section-tag, .lunar-lore-title-block .section-title {
            text-align: center;
        }
        .lunar-lore-title-block .section-tag::before {
            margin: 0 10px;
        }
        .lunar-lore-title-block .section-tag::after {
            display: inline-block;
        }
        .lunar-card {
            flex: 0 0 50%; /* Show 2 cards */
        }
    }

    @media (max-width: 768px) {
        .mystical-header-image {
            height: 250px;
        }
        .zodiac-grid {
            grid-template-columns: repeat(3, 1fr);
        }
        .section-title {
            font-size: 2rem;
        }
        .lunar-card {
            flex: 0 0 100%; /* Show 1 card */
        }
        .slider-nav {
            display: none; /* Hide arrows on mobile, rely on swipe */
        }
    }

    @media (max-width: 480px) {
        .mystical-header-image {
            height: 200px;
        }
        .zodiac-grid {
            grid-template-columns: repeat(2, 1fr);
        }
    }

</style>

    <!-- ================================================== -->
    <!-- Mystical Header Image Section -->
    <!-- ================================================== -->
    <section class="mystical-header-section">
        <div class="mystical-header-image">
            <img src="assets/images/blog/blog3.jpg" alt="Mystical tarot cards and spiritual elements" class="mystical-bg-image">
            <div class="image-overlay"></div>
        </div>
    </section>

<main class="astrology-container">

    <!-- ================================================== -->
    <!-- Horoscope Section -->
    <!-- ================================================== -->
    <section class="astrology-section horoscope-section">
        <p class="section-tag">Horoscope</p>
        <h2 class="section-title_n">DIVINE DESTINIES: EMBRACING ASTROLOGY AND<br>ESOTERIC WISDOM FOR EVERYDAY LIFE</h2>
        <p class="section-subtitle">Choose your zodiac sign & learn your today horoscope!</p>

        <div class="zodiac-grid">
            <!-- Zodiac items will be dynamically inserted here by JS -->
        </div>

        <button class="birth-chart-btn" onclick="window.location.href='horoscope.php'">VIEW ALL +</button>
    </section>

    <!-- ================================================== -->
    <!-- Lunar Lore Section -->
    <!-- ================================================== -->
    <section class="astrology-section lunar-lore-section">
        <div class="lunar-lore-header">
            <p class="benefits-section-tag">Benefits</p>
            <h2 class="section-title_n">LUNAR LORE: DISCOVERING THE MAGIC<br>OF ASTROLOGY</h2>
            <p class="lunar-lore-description">
                Astrology has been a source of guidance for people throughout history as it helps us understand our place in the universe<br>and the role we play in it. At its core, astrology is about understanding how celestial bodies like planets, stars.
            </p>
        </div>

        <div class="lunar-slider-wrapper">
            <div class="lunar-slider-container">
                <div class="lunar-slider-track">
                    <!-- Slider cards will be dynamically inserted here by JS -->
                </div>
            </div>
            <div class="slider-nav">
                <button class="slider-arrow prev-arrow" aria-label="Previous Slide">&lt;</button>
                <button class="slider-arrow next-arrow" aria-label="Next Slide">&gt;</button>
            </div>
        </div>
        <div class="slider-pagination">
             <!-- Pagination dots will be dynamically inserted here by JS -->
        </div>

    </section>

</main>


<script>
document.addEventListener('DOMContentLoaded', function() {

    // Data for Zodiac Signs and Lunar Cards
    const zodiacSigns = [
        { name: 'Aries', image: 'assets/images/svg/horoscope/h1.svg' },
        { name: 'Taurus', image: 'assets/images/svg/horoscope/h2.svg' },
        { name: 'Gemini', image: 'assets/images/svg/horoscope/h3.svg' },
        { name: 'Cancer', image: 'assets/images/svg/horoscope/h4.svg' },
        { name: 'Leo', image: 'assets/images/svg/horoscope/h5.svg' },
        { name: 'Virgo', image: 'assets/images/svg/horoscope/h6.svg' },
        { name: 'Libra', image: 'assets/images/svg/horoscope/h7.svg' },
        { name: 'Scorpio', image: 'assets/images/svg/horoscope/h8.svg' },
        { name: 'Sagittarius', image: 'assets/images/svg/horoscope/h9.svg' },
        { name: 'Capricorn', image: 'assets/images/svg/horoscope/h10.svg' },
        { name: 'Aquarius', image: 'assets/images/svg/horoscope/h11.svg' },
        { name: 'Pisces', image: 'assets/images/svg/horoscope/h12.svg' }
    ];

    const lunarCards = [
        {
            icon: '<g fill-rule="evenodd" clip-rule="evenodd"><path d="M12 4.5C7.5 4.5 3.75 7.5 2.25 12C3.75 16.5 7.5 19.5 12 19.5C16.5 19.5 20.25 16.5 21.75 12C20.25 7.5 16.5 4.5 12 4.5ZM12 16.5C9.24 16.5 7.5 14.28 7.5 12C7.5 9.72 9.24 7.5 12 7.5C14.76 7.5 16.5 9.72 16.5 12C16.5 14.28 14.76 16.5 12 16.5Z"/><path d="M12 9C10.3431 9 9 10.3431 9 12C9 13.6569 10.3431 15 12 15C13.6569 15 15 13.6569 15 12C15 10.3431 13.6569 9 12 9Z"/></g>',
            title: 'Insight Into Personal Characteristics',
            description: 'Whether you require assistance in family law, criminal defense.'
        },
        {
            icon: '<g fill-rule="evenodd" clip-rule="evenodd"><path d="M8.25 3C8.25 2.17157 8.92157 1.5 9.75 1.5H19.5C20.3284 1.5 21 2.17157 21 3V15C21 15.8284 20.3284 16.5 19.5 16.5H18V21C18 21.8284 17.3284 22.5 16.5 22.5H4.5C3.67157 22.5 3 21.8284 3 21V9.75C3 8.92157 3.67157 8.25 4.5 8.25H6.75V3.75C6.75 3.33579 7.08579 3 7.5 3H8.25ZM9.75 3H19.5V15H9.75V3ZM4.5 9.75V21H16.5V16.5H9.75C8.92157 16.5 8.25 15.8284 8.25 15V9.75H4.5Z"/></g>',
            title: 'Guidance For Decision-Making',
            description: 'Whether you require assistance in family law, criminal defense.'
        },
        {
            icon: '<g fill-rule="evenodd" clip-rule="evenodd"><path d="M6.59629 2.12449C7.40371 1.05351 8.82823 0.737158 10.0563 1.30303L11.0113 1.7805C11.6425 2.09609 12.3575 2.09609 12.9887 1.7805L13.9437 1.30303C15.1718 0.737158 16.5963 1.05351 17.4037 2.12449L21.8755 8.40371C22.9465 9.19382 23.2628 10.5963 22.6969 11.8037L22.2195 12.7387C21.9039 13.3575 21.9039 14.0425 22.2195 14.6613L22.6969 15.5963C23.2628 16.8037 22.9465 18.2062 21.8755 18.9963L17.4037 21.2755C16.5963 22.3465 15.1718 22.6628 13.9437 22.0969L12.9887 21.6195C12.3575 21.3039 11.6425 21.3039 11.0113 21.6195L10.0563 22.0969C8.82823 22.6628 7.40371 22.3465 6.59629 21.2755L2.12449 14.9963C1.05351 14.2062 0.737158 12.8037 1.30303 11.5963L1.7805 10.6613C2.09609 10.0425 2.09609 9.35754 1.7805 8.73872L1.30303 7.80371C0.737158 6.59629 1.05351 5.19382 2.12449 4.40371L6.59629 2.12449Z"/></g>',
            title: 'Spiritual Growth And Development',
            description: 'Whether you require assistance in family law, criminal defense.'
        },
        {
            icon: '<g fill-rule="evenodd" clip-rule="evenodd"><path d="M12 2C6.47715 2 2 6.47715 2 12C2 17.5228 6.47715 22 12 22C17.5228 22 22 17.5228 22 12C22 6.47715 17.5228 2 12 2ZM12 20C7.58172 20 4 16.4183 4 12C4 7.58172 7.58172 4 12 4C16.4183 4 20 7.58172 20 12C20 16.4183 16.4183 20 12 20Z"/><path d="M12 7C9.23858 7 7 9.23858 7 12C7 14.7614 9.23858 17 12 17C14.7614 17 17 14.7614 17 12C17 9.23858 14.7614 7 12 7Z"/></g>',
            title: 'Understanding Relationships',
            description: 'Whether you require assistance in family law, criminal defense.'
        }
    ];

    // --- Populate Zodiac Grid ---
    const zodiacGrid = document.querySelector('.zodiac-grid');
    zodiacSigns.forEach(sign => {
        const item = document.createElement('div');
        item.className = 'zodiac-item';
        item.innerHTML = `
            <a href="single_horoscope.php?sign=${sign.name.toLowerCase()}" style="text-decoration: none; color: inherit;">
                <img src="${sign.image}" alt="${sign.name}" class="zodiac-icon">
                <p>${sign.name}</p>
            </a>
        `;
        zodiacGrid.appendChild(item);
    });

    // --- Populate Lunar Slider ---
    const sliderTrack = document.querySelector('.lunar-slider-track');
    const paginationContainer = document.querySelector('.slider-pagination');
    
    // Duplicate cards for infinite loop effect if needed, but for this setup we'll have a start and end.
    // Let's add more cards to demonstrate the slider better. We'll just duplicate the existing ones.
    const allCards = [...lunarCards, ...lunarCards]; // 8 cards total

    allCards.forEach(card => {
        const cardElement = document.createElement('div');
        cardElement.className = 'lunar-card';
        cardElement.innerHTML = `
            <div class="lunar-card-inner">
                <div class="lunar-card-icon">
                    <svg viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg">${card.icon}</svg>
                </div>
                <h3>${card.title}</h3>
                <p>${card.description}</p>
            </div>
        `;
        sliderTrack.appendChild(cardElement);
    });

    // --- Slider Logic ---
    const prevButton = document.querySelector('.prev-arrow');
    const nextButton = document.querySelector('.next-arrow');
    const cards = document.querySelectorAll('.lunar-card');
    
    let currentIndex = 0;
    let cardsToShow = getCardsToShow();
    let totalSlides = Math.ceil(allCards.length / cardsToShow);

    function getCardsToShow() {
        if (window.innerWidth <= 768) return 1;
        if (window.innerWidth <= 1024) return 2;
        return 4;
    }

    function updateSlider() {
        cardsToShow = getCardsToShow();
        totalSlides = Math.ceil(allCards.length / cardsToShow);
        
        const cardWidth = sliderTrack.querySelector('.lunar-card').offsetWidth;
        sliderTrack.style.transform = `translateX(-${currentIndex * cardWidth * cardsToShow}px)`;
        
        updatePagination();
        updateNavButtons();
    }
    
    function updateNavButtons() {
        prevButton.classList.toggle('disabled', currentIndex === 0);
        nextButton.classList.toggle('disabled', currentIndex >= totalSlides - 1);
    }
    
    function updatePagination() {
        paginationContainer.innerHTML = '';
        for (let i = 0; i < totalSlides; i++) {
            const dot = document.createElement('span');
            dot.className = 'dot';
            if (i === currentIndex) {
                dot.classList.add('active');
            }
            dot.addEventListener('click', () => {
                currentIndex = i;
                updateSlider();
            });
            paginationContainer.appendChild(dot);
        }
    }

    nextButton.addEventListener('click', () => {
        if (currentIndex < totalSlides - 1) {
            currentIndex++;
            updateSlider();
        }
    });

    prevButton.addEventListener('click', () => {
        if (currentIndex > 0) {
            currentIndex--;
            updateSlider();
        }
    });
    
    // Touch/Swipe functionality for mobile
    let touchstartX = 0;
    let touchendX = 0;

    sliderTrack.addEventListener('touchstart', e => {
        touchstartX = e.changedTouches[0].screenX;
    }, { passive: true });

    sliderTrack.addEventListener('touchend', e => {
        touchendX = e.changedTouches[0].screenX;
        handleSwipe();
    }, { passive: true });
    
    function handleSwipe() {
        if (touchendX < touchstartX) { // Swiped left
            if (currentIndex < totalSlides - 1) {
                currentIndex++;
                updateSlider();
            }
        }
        if (touchendX > touchstartX) { // Swiped right
            if (currentIndex > 0) {
                currentIndex--;
                updateSlider();
            }
        }
    }


    // Initial setup and responsive updates
    window.addEventListener('resize', updateSlider);
    updateSlider();

});
</script>
