<style>
    /* Celebrity Videos Section Styles */
    .celebrity-videos-wrapper {
        padding: 60px 0;
        background-color: #ffffff;
        background-image: url('assets/images/background/bg16.jpg');
        background-size: cover;
        background-position: center;
        background-repeat: no-repeat;
    }

    .celebrity-section {
        width: 100%;
        max-width: 1200px;
        margin: 0 auto;
    }

    .celebrity-section-header {
        text-align: center;
        margin-bottom: 50px;
    }

    .celebrity-section .subtitle {
        font-size: 0.8rem;
        letter-spacing: 0.2em;
        text-transform: uppercase;
        font-weight: bold;
        color: #666;
        position: relative;
        display: inline-block;
        margin-bottom: 1.5rem;
    }

    /* Line above the subtitle */
    .celebrity-section .subtitle::before {
        content: '';
        position: absolute;
        top: -10px;
        left: 50%;
        transform: translateX(-50%);
        width: 30px;
        height: 1px;
        background-color: #999;
    }

    .celebrity-section h2 {
        font-family: 'Cormorant Garamond', serif;
        font-size: 2.5rem;
        font-weight: 500;
        letter-spacing: 0.1em;
        margin-bottom: 1rem;
        text-transform: uppercase;
        color:rgb(32, 31, 31);
    }

    .celebrity-section .description {
        max-width: 600px;
        margin: 0 auto 3rem auto;
        font-size: 1rem;
        line-height: 1.6;
        color:rgb(39, 37, 37);
    }

    /* Video Grid */
    .video-grid {
        display: grid;
        grid-template-columns: repeat(3, 1fr);
        gap: 30px;
        padding: 0 15px;
    }

    /* Video Card */
    .video-card {
        background: #fff;
        border-radius: 5px;
        overflow: hidden;
        box-shadow: 0 5px 20px rgba(0,0,0,0.1);
        transition: transform 0.3s ease;
        position: relative;
    }

    .video-card:hover {
        transform: translateY(-10px);
    }

    .video-thumbnail {
        position: relative;
        width: 100%;
        padding-top: 56.25%; /* 16:9 Aspect Ratio */
        background: #f8f8f8;
        overflow: hidden;
    }

    .video-thumbnail iframe {
        position: absolute;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
        border: none;
    }

    /* Remove play button since YouTube embed has its own */
    .play-button {
        display: none;
    }

    .video-info {
        padding: 20px;
    }

    .celebrity-name {
        font-size: 18px;
        font-weight: 600;
        color: #333;
        margin: 0 0 10px;
    }

    .video-description {
        font-size: 14px;
        color: #666;
        margin: 0;
        line-height: 1.5;
    }
    
    /* View All Button Container */
    .view-all-container {
        text-align: center;
        margin-top: 50px;
    }

   /* View All Button with Dark Aesthetic */
.view-all-btn1 {
    display: inline-block;
    padding: 12px 40px;
    font-size: 15px;
    font-weight: 500;
    color:rgb(39, 36, 36);
    background: transparent;
    border: 2px solid rgb(77, 73, 73);
    border-radius: 5px;
    text-transform: uppercase;
    text-decoration: none;
    transition: all 0.3s ease;
    font-family: sans-serif;
}

.view-all-btn1:hover {
    background: #333;
    color: #fff;
    text-decoration: none;
    border-color: #999;
}


    /* Responsive Design */
    @media (max-width: 1024px) {
        .video-grid {
            grid-template-columns: repeat(2, 1fr);
        }
    }

    @media (max-width: 768px) {
        .celebrity-videos-wrapper {
            padding: 40px 0;
        }
        .section-title {
            font-size: 28px;
        }
        .video-grid {
            grid-template-columns: 1fr;
            gap: 20px;
        }
    }
</style>

<section class="celebrity-videos-wrapper">
    <div class="container">
        <div class="celebrity-section">
            <div class="celebrity-section-header">
                <span class="subtitle">Our Analysis</span>
                <h2>The Astrologer's Analysis</h2>
                <p class="description">
                    Get clarity and guidance. In this video, our astrologer breaks down the 
                    key celestial influences.
                </p>
            </div>

            <div class="video-grid">
                <div class="video-card">
                    <div class="video-thumbnail">
                        <iframe 
                            src="https://www.youtube.com/embed/yoIex90YnA0" 
                            title="Mandira Bedi Video"
                            allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture" 
                            allowfullscreen>
                        </iframe>
                    </div>
                    <div class="video-info">
                        <h3 class="celebrity-name">තුලා ලග්න හිමි ඔබට ඉදිරි මාස හය කොහොම ද?</h3>
                        <p class="video-description">@ KEDT Astrology</p>
                    </div>
                </div>

                <div class="video-card">
                    <div class="video-thumbnail">
                        <iframe 
                            src="https://www.youtube.com/embed/OZzFoo0uez0" 
                            title="Shweta Tiwari Video"
                            allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture" 
                            allowfullscreen>
                        </iframe>
                    </div>
                    <div class="video-info">
                        <h3 class="celebrity-name">කන්‍යා ලග්න හිමි ඔබට ඉදිරි මාස හය කොහොම ද?</h3>
                        <p class="video-description">@ KEDT Astrology</p>
                    </div>
                </div>

                <div class="video-card">
                    <div class="video-thumbnail">
                        <iframe 
                            src="https://www.youtube.com/embed/LXDU0tiu494" 
                            title="Bharti Singh Video"
                            allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture" 
                            allowfullscreen>
                        </iframe>
                    </div>
                    <div class="video-info">
                        <h3 class="celebrity-name">මේෂ ලග්න හිමි ඔබට ඉදිරි මාස හය කොහොම ද?</h3>
                        <p class="video-description">@ KEDT Astrology</p>
                    </div>
                </div>
            </div>

            <div class="view-all-container">
                <a href="https://www.youtube.com/@KEDTAstrology/videos" class="view-all-btn1">View All</a>
            </div>
            
        </div>
    </div>
</section>