<style>
    /* Ensure you have a font for the main title, like from Google Fonts */
    @import url('https://fonts.googleapis.com/css2?family=Cinzel+Decorative:wght@700&family=Lato&display=swap');

    /* --- Main Blog Section Container --- */
    .blog-section {
        width: 100%;
        max-width: 1200px;
        margin: 0 auto;
        padding: 1rem;
        font-family: 'Lato', sans-serif;
        background-color:rgb(255, 255, 255);
        color: #333;
    }

    /* --- Section Header Styles --- */
    .section-header {
        text-align: center;
        margin-bottom: 3rem;
    }

    .section-header .subtitle {
        font-size: 0.8rem;
        letter-spacing: 0.2em;
        text-transform: uppercase;
        font-weight: bold;
        color: #666;
        position: relative;
        display: inline-block;
        margin-bottom: 1.5rem;
    }

    /* Line above the subtitle */
    .section-header .subtitle::before {
        content: '';
        position: absolute;
        top: -10px;
        left: 50%;
        transform: translateX(-50%);
        width: 30px;
        height: 1px;
        background-color: #999;
    }

    .section-header .main-title {
        font-family: 'Cormorant Garamond', serif;
        font-size: 2.5rem;
        font-weight: 500;
        letter-spacing: 0.1em;
        margin-bottom: 1rem;
        text-transform: uppercase;
    }

    .section-header .description {
        max-width: 600px;
        margin: 0 auto 3rem auto;
        font-size: 1rem;
        line-height: 1.6;
        color: #555;
    }
    
    /* --- Posts Grid Layout --- */
    .posts-grid {
        display: grid;
        grid-template-columns: repeat(6, 1fr);
        gap: 1.5rem;
    }

    /* --- Individual Post Card Styles --- */
    .post-card {
        display: flex;
        flex-direction: column;
    }

    .post-card .post-image-container {
        width: 100%;
        overflow: hidden;
        margin-bottom: 0.8rem;
    }

    .post-card img {
        width: 100%;
        height: 100%;
        object-fit: cover;
        display: block;
        transition: transform 0.3s ease;
    }
    
    .post-card:hover img {
        transform: scale(1.05);
    }

    .post-card .post-title {
        font-size: 1.1rem;
        font-weight: 700;
        margin: 0 0 0.5rem 0;
        color: #333;
        line-height: 1.4;
    }

    .post-card .post-meta {
        margin-top: auto;
        display: flex;
        justify-content: space-between;
        align-items: center;
        font-size: 0.8rem;
        color: #888;
    }

    .post-card .post-stats {
        display: flex;
        align-items: center;
        gap: 0.5rem;
    }
    
    .post-card .post-stats svg {
        width: 16px;
        height: 16px;
        fill: #888;
    }

    /* --- Large cards span 2 columns each --- */
    .post-card.large {
        grid-column: span 2;
    }

    .post-card.large .post-image-container {
        aspect-ratio: 4 / 3;
    }

    /* --- Small cards span 1 column each --- */
    .post-card.small {
        grid-column: span 1;
    }

    .post-card.small .post-image-container {
        aspect-ratio: 1 / 1;
    }
    
    .post-card.small .post-title {
        font-size: 0.75rem;
        line-height: 1.3;
        margin-bottom: 0.4rem;
    }

    .post-card.small .post-meta {
        font-size: 0.7rem;
    }

    .post-card.small .post-stats svg {
        width: 12px;
        height: 12px;
    }

    /* --- Section Footer & Button Styles --- */
    .section-footer {
        text-align: center;
        margin-top: 3rem;
    }

    .blog-button {
        font-family: 'Lato', sans-serif;
        background-color: transparent;
        color: #333;
        border: 2px solid #333;
        padding: 0.8rem 2rem;
        font-size: 0.9rem;
        font-weight: 700;
        letter-spacing: 1px;
        cursor: pointer;
        transition: all 0.3s ease;
        text-transform: uppercase;
    }

    .blog-button:hover {
        background-color: #333;
        color: #fff;
    }
    
    /* --- Responsive Design --- */
    @media (max-width: 992px) {
        .section-header .main-title {
            font-size: 2rem;
        }
        .posts-grid {
            grid-template-columns: repeat(4, 1fr);
        }
        .post-card.large {
            grid-column: span 2;
        }
        .post-card.small {
            grid-column: span 1;
        }
    }

    @media (max-width: 768px) {
        .section-header .main-title {
            font-size: 1.5rem;
        }
        .posts-grid {
            grid-template-columns: repeat(2, 1fr);
        }
        .post-card.large {
            grid-column: span 2;
        }
        .post-card.small {
            grid-column: span 1;
        }
        
        /* Hide all blog cards except the first 3 in mobile view */
        .post-card:nth-child(n+4) {
            display: none !important;
        }
    }

    @media (max-width: 480px) {
        .posts-grid {
            grid-template-columns: 1fr;
        }
        .post-card.large,
        .post-card.small {
            grid-column: span 1;
        }
        
        /* Hide all blog cards except the first 3 in mobile view */
        .post-card:nth-child(n+4) {
            display: none !important;
        }
    }
</style>

<section class="blog-section">
    <header class="section-header">
        <span class="subtitle">Blog & News</span>
        <h1 class="main-title">CELESTIAL INSIGHTS: NAVIGATING THE WORLD OF ASTROLOGY AND ESOTERIC PRACTICES</h1>
        <p class="description">
            Read our latest articles, announcements, and updates all in one place.
        </p>
    </header>

    <main class="posts-grid">
        
        <article class="post-card large">
            <div class="post-image-container">
                <img src="assets/images/blog/blog1.jpg" alt="Woman looking out a window thoughtfully" onerror="this.onerror=null;this.src='https://placehold.co/600x450/e2dccc/777?text=Insight';">
            </div>
            <h3 class="post-title">Mercury Retrograde: A Survival Guide for Modern Times</h3>
            <div class="post-meta">
                <span class="post-date">JULY 28, 2025</span>
                <div class="post-stats">
                    <span>319</span>
                    <svg viewBox="0 0 24 24"><path d="M12 4.5C7 4.5 2.73 7.61 1 12c1.73 4.39 6 7.5 11 7.5s9.27-3.11 11-7.5c-1.73-4.39-6-7.5-11-7.5zM12 17c-2.76 0-5-2.24-5-5s2.24-5 5-5 5 2.24 5 5-2.24 5-5 5zm0-8c-1.66 0-3 1.34-3 3s1.34 3 3 3 3-1.34 3-3-1.34-3-3-3z"></path></svg>
                </div>
            </div>
        </article>

        <article class="post-card large">
            <div class="post-image-container">
                <img src="assets/images/blog/blog2.jpg" alt="Person in a white shirt, focus on hand with bracelet" onerror="this.onerror=null;this.src='https://placehold.co/600x450/f0ebe5/777?text=Clarity';">
            </div>
            <h3 class="post-title">The Power of Crystals: How to Choose, Cleanse, and Charge Your Stones</h3>
            <div class="post-meta">
                <span class="post-date">JULY 25, 2025</span>
                <div class="post-stats">
                    <span>451</span>
                    <svg viewBox="0 0 24 24"><path d="M12 4.5C7 4.5 2.73 7.61 1 12c1.73 4.39 6 7.5 11 7.5s9.27-3.11 11-7.5c-1.73-4.39-6-7.5-11-7.5zM12 17c-2.76 0-5-2.24-5-5s2.24-5 5-5 5 2.24 5 5-2.24 5-5 5zm0-8c-1.66 0-3 1.34-3 3s1.34 3 3 3 3-1.34 3-3-1.34-3-3-3z"></path></svg>
                </div>
            </div>
        </article>

        <article class="post-card large">
            <div class="post-image-container">
                <img src="assets/images/blog/blog3.jpg" alt="Candle burning in a unique ceramic holder" onerror="this.onerror=null;this.src='https://placehold.co/600x450/4a555a/eee?text=Ritual';">
            </div>
            <h3 class="post-title">Introduction to Tarot: Reading the Cards for Intuitive Guidance</h3>
            <div class="post-meta">
                <span class="post-date">JULY 22, 2025</span>
                <div class="post-stats">
                    <span>582</span>
                    <svg viewBox="0 0 24 24"><path d="M12 4.5C7 4.5 2.73 7.61 1 12c1.73 4.39 6 7.5 11 7.5s9.27-3.11 11-7.5c-1.73-4.39-6-7.5-11-7.5zM12 17c-2.76 0-5-2.24-5-5s2.24-5 5-5 5 2.24 5 5-2.24 5-5 5zm0-8c-1.66 0-3 1.34-3 3s1.34 3 3 3 3-1.34 3-3-1.34-3-3-3z"></path></svg>
                </div>
            </div>
        </article>

        <article class="post-card small">
            <div class="post-image-container">
                <img src="assets/images/blog/blog4.jpg" alt="Sparkler burning in the dark" onerror="this.onerror=null;this.src='https://placehold.co/400x400/333/eee?text=Magic';">
            </div>
            <h3 class="post-title">Understanding Your Moon Sign</h3>
            <div class="post-meta">
                <span class="post-date">JULY 20, 2025</span>
                <div class="post-stats">
                    <span>198</span>
                    <svg viewBox="0 0 24 24"><path d="M12 4.5C7 4.5 2.73 7.61 1 12c1.73 4.39 6 7.5 11 7.5s9.27-3.11 11-7.5c-1.73-4.39-6-7.5-11-7.5zM12 17c-2.76 0-5-2.24-5-5s2.24-5 5-5 5 2.24 5 5-2.24 5-5 5zm0-8c-1.66 0-3 1.34-3 3s1.34 3 3 3 3-1.34 3-3-1.34-3-3-3z"></path></svg>
                </div>
            </div>
        </article>
        
        <article class="post-card small">
            <div class="post-image-container">
                <img src="assets/images/blog/blog5.jpg" alt="Hands holding a crystal" onerror="this.onerror=null;this.src='https://placehold.co/400x400/e6e0d8/777?text=Energy';">
            </div>
            <h3 class="post-title">Simple Full Moon Rituals</h3>
            <div class="post-meta">
                <span class="post-date">JULY 18, 2025</span>
                <div class="post-stats">
                    <span>305</span>
                    <svg viewBox="0 0 24 24"><path d="M12 4.5C7 4.5 2.73 7.61 1 12c1.73 4.39 6 7.5 11 7.5s9.27-3.11 11-7.5c-1.73-4.39-6-7.5-11-7.5zM12 17c-2.76 0-5-2.24-5-5s2.24-5 5-5 5 2.24 5 5-2.24 5-5 5zm0-8c-1.66 0-3 1.34-3 3s1.34 3 3 3 3-1.34 3-3-1.34-3-3-3z"></path></svg>
                </div>
            </div>
        </article>

        <article class="post-card small">
            <div class="post-image-container">
                <img src="assets/images/blog/blog6.jpg" alt="Tarot cards spread on a table" onerror="this.onerror=null;this.src='https://placehold.co/400x400/d1c7b7/777?text=Destiny';">
            </div>
            <h3 class="post-title">The Meaning of the Major Arcana</h3>
            <div class="post-meta">
                <span class="post-date">JULY 15, 2025</span>
                <div class="post-stats">
                    <span>250</span>
                    <svg viewBox="0 0 24 24"><path d="M12 4.5C7 4.5 2.73 7.61 1 12c1.73 4.39 6 7.5 11 7.5s9.27-3.11 11-7.5c-1.73-4.39-6-7.5-11-7.5zM12 17c-2.76 0-5-2.24-5-5s2.24-5 5-5 5 2.24 5 5-2.24 5-5 5zm0-8c-1.66 0-3 1.34-3 3s1.34 3 3 3 3-1.34 3-3-1.34-3-3-3z"></path></svg>
                </div>
            </div>
        </article>

        <article class="post-card small">
            <div class="post-image-container">
                <img src="assets/images/blog/blog7.jpg" alt="Crystals and jewelry on a light background" onerror="this.onerror=null;this.src='https://placehold.co/400x400/f5f2ef/777?text=Balance';">
            </div>
            <h3 class="post-title">Finding Your Spirit Animal</h3>
            <div class="post-meta">
                <span class="post-date">JULY 12, 2025</span>
                <div class="post-stats">
                    <span>188</span>
                    <svg viewBox="0 0 24 24"><path d="M12 4.5C7 4.5 2.73 7.61 1 12c1.73 4.39 6 7.5 11 7.5s9.27-3.11 11-7.5c-1.73-4.39-6-7.5-11-7.5zM12 17c-2.76 0-5-2.24-5-5s2.24-5 5-5 5 2.24 5 5-2.24 5-5 5zm0-8c-1.66 0-3 1.34-3 3s1.34 3 3 3 3-1.34 3-3-1.34-3-3-3z"></path></svg>
                </div>
            </div>
        </article>

        <article class="post-card small">
            <div class="post-image-container">
                <img src="assets/images/blog/blog8.jpg" alt="Hands holding a crystal" onerror="this.onerror=null;this.src='https://placehold.co/400x400/e6e0d8/777?text=Energy';">
            </div>
            <h3 class="post-title">Chakra Balancing for Beginners</h3>
            <div class="post-meta">
                <span class="post-date">JULY 10, 2025</span>
                <div class="post-stats">
                    <span>412</span>
                    <svg viewBox="0 0 24 24"><path d="M12 4.5C7 4.5 2.73 7.61 1 12c1.73 4.39 6 7.5 11 7.5s9.27-3.11 11-7.5c-1.73-4.39-6-7.5-11-7.5zM12 17c-2.76 0-5-2.24-5-5s2.24-5 5-5 5 2.24 5 5-2.24 5-5 5zm0-8c-1.66 0-3 1.34-3 3s1.34 3 3 3 3-1.34 3-3-1.34-3-3-3z"></path></svg>
                </div>
            </div>
        </article>

        <article class="post-card small">
            <div class="post-image-container">
                <img src="assets/images/blog/blog9.jpg" alt="A spread of food and decorations on a table" onerror="this.onerror=null;this.src='https://placehold.co/400x400/d4cbc4/777?text=Feast';">
            </div>
            <h3 class="post-title">Numerology: Your Life Path Number</h3>
            <div class="post-meta">
                <span class="post-date">JULY 07, 2025</span>
                <div class="post-stats">
                    <span>376</span>
                    <svg viewBox="0 0 24 24"><path d="M12 4.5C7 4.5 2.73 7.61 1 12c1.73 4.39 6 7.5 11 7.5s9.27-3.11 11-7.5c-1.73-4.39-6-7.5-11-7.5zM12 17c-2.76 0-5-2.24-5-5s2.24-5 5-5 5 2.24 5 5-2.24 5-5 5zm0-8c-1.66 0-3 1.34-3 3s1.34 3 3 3 3-1.34 3-3-1.34-3-3-3z"></path></svg>
                </div>
            </div>
        </article>

    </main>

    <footer class="section-footer">
        <button class="blog-button">GO TO BLOG →</button>
    </footer>
</section>