<!-- Styles for the Astrology Section Component -->
<style>
    /* --- Google Fonts Import --- */
    @import url('https://fonts.googleapis.com/css2?family=Lora:wght@400;700&family=Montserrat:wght@400;500&display=swap');

    /* Note: Styles are scoped to avoid conflicts with main site styles */

    /* --- Main Section Container --- */
    .about2-astrology-section {
        display: flex;
        align-items: center;
        justify-content: center; /* Centered for standalone view */
        gap: 4rem; /* Space between text and image */
        max-width: 1200px;
        width: 100%;
        margin: 4rem auto; /* Added margin for spacing within a page */
        padding: 1rem;
        box-sizing: border-box;
    }

    /* --- Left Column: Text Content --- */
    .about2-astrology-content {
        flex: 1; /* Takes up available space */
        max-width: 600px;
    }

    .about2-astrology-content .pre-title {
        font-size: 0.8rem;
        font-weight: 500;
        letter-spacing: 2px;
        color: #555;
        margin-bottom: 1rem;
        display: flex;
        align-items: center;
    }
    
    /* Decorative line before "ABOUT ME" */
    .about2-astrology-content .pre-title::before {
        content: '';
        display: inline-block;
        width: 30px;
        height: 1px;
        background-color: #555;
        margin-right: 10px;
    }

    .about2-astrology-content .main-title {
        font-family: 'Lora', serif;
        font-size: 2.5rem;
        font-weight: 700;
        line-height: 1.2;
        margin-bottom: 1.5rem;
        color: #2c2c2c;
        text-transform: uppercase;
    }

    .about2-astrology-content .description {
        font-size: 1rem;
        line-height: 1.6;
        color: #666;
        margin-bottom: 2rem;
    }

    .about2-astrology-content .features-list {
        list-style: none;
        padding: 0;
        margin: 0;
    }

    .about2-astrology-content .features-list li {
        display: flex;
        align-items: flex-start;
        font-size: 1rem;
        color: #555;
        line-height: 1.6;
        margin-bottom: 1rem;
    }
    
    /* Custom '+' bullet point */
    .about2-astrology-content .features-list li::before {
        content: '+';
        font-weight: bold;
        font-size: 1.2rem;
        color: #888;
        margin-right: 1rem;
        line-height: 1.4; /* Align with text */
    }

    /* --- Right Column: Image --- */
    .about2-astrology-image-wrapper {
        flex-shrink: 0; /* Prevents image from shrinking */
        position: relative;
        width: 400px;
        height: 450px;
    }

    .about2-astrology-image-wrapper img {
        width: 100%;
        height: 100%;
        object-fit: cover;
        border-radius: 24px; /* Rounded corners */
        box-shadow: 0 10px 25px rgba(0, 0, 0, 0.1);
    }

    .about2-social-handle {
        position: absolute;
        bottom: 20px;
        left: 20px;
        background-color: rgba(255, 255, 255, 0.8);
        backdrop-filter: blur(5px);
        -webkit-backdrop-filter: blur(5px); /* For Safari */
        padding: 0.5rem 1rem;
        border-radius: 50px;
        display: flex;
        align-items: center;
        font-size: 0.9rem;
        font-weight: 500;
        color: #333;
        box-shadow: 0 2px 10px rgba(0,0,0,0.1);
    }
    
    .about2-social-handle svg {
        width: 16px;
        height: 16px;
        margin-right: 8px;
    }

    /* --- Responsive Design --- */
    @media (max-width: 992px) {
        .about2-astrology-section {
            flex-direction: column; /* Stack columns vertically */
            gap: 3rem;
            margin: 2rem auto;
        }
        .about2-astrology-content {
            max-width: 100%;
            text-align: center;
        }
        .about2-astrology-content .pre-title {
            justify-content: center;
        }
        .about2-astrology-content .features-list li {
           justify-content: flex-start;
           text-align: left;
        }
        .about2-astrology-image-wrapper {
            width: 100%;
            max-width: 400px;
        }
    }
    
    @media (max-width: 480px) {
         .about2-astrology-content .main-title {
            font-size: 2rem;
        }
    }
</style>

<!-- Astrology Section Component -->
<section class="about2-astrology-section">
    <!-- Left Column: Text Content -->
    <div class="about2-astrology-content">
        <h3 class="pre-title">ABOUT ME</h3>
        <h2 class="main-title">Navigating the world of astrology and esoteric practices</h2>
        <p class="description">
            Astrology has been a source of guidance for people throughout history as it helps us understand our place in the universe and the role we play in it. At its core, astrology is about understanding how celestial bodies like planets, stars and moons affect our lives here on Earth.
        </p>
        <ul class="features-list">
            <li>Personalized readings based on your birth chart, current planetary alignments;</li>
            <li>Guidance and support to help you connect with your inner wisdom;</li>
            <li>Our esoteric retreats offer a chance to immerse yourself in spiritual practices, meditation, and self-reflection in a peaceful and serene environment;</li>
            <li>Our astrology consultations offer insights into your relationships, career, health, and other areas of your life.</li>
        </ul>
    </div>

    <!-- Right Column: Image with Overlay -->
    <div class="about2-astrology-image-wrapper">
        <img src="assets/images/about/about1.jpg" alt="A woman in a purple top with ambient lighting." onerror="this.onerror=null;this.src='https://placehold.co/400x450/663399/FFFFFF?text=Image';">
        <div class="about2-social-handle">
            <!-- Simple SVG for the @ symbol -->
            <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor">
              <path stroke-linecap="round" stroke-linejoin="round" d="M16.5 12a4.5 4.5 0 1 1-9 0 4.5 4.5 0 0 1 9 0Zm0 0c0 1.657 1.007 3 2.25 3S21 13.657 21 12a9 9 0 1 0-2.636 6.364M16.5 12V8.25" />
            </svg>
            <span>KEDT astology</span>
        </div>
    </div>
</section>
