<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Astroly - Register</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Cinzel:wght@400;700&family=Inter:wght@400;500;600&display=swap" rel="stylesheet">
    <style>
        body {
            font-family: 'Inter', sans-serif;
        }
        .font-cinzel {
            font-family: 'Cinzel', serif;
        }
        /* Animated Background */
        .particles {
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            z-index: 0;
            overflow: hidden;
        }
        .particle {
            position: absolute;
            bottom: -150px; /* Start below the screen */
            background-color: rgba(255, 255, 255, 0.5);
            border-radius: 50%;
            animation: drift linear infinite;
            opacity: 0;
        }
        @keyframes drift {
            0% {
                transform: translateY(0) translateX(0);
                opacity: 0;
            }
            20% {
                opacity: 0.7;
            }
            80% {
                opacity: 0.7;
            }
            100% {
                transform: translateY(-120vh) translateX(20vw);
                opacity: 0;
            }
        }
    </style>
</head>
<body class="bg-white text-gray-800">
    <div class="relative min-h-screen w-full flex items-center justify-center bg-gradient-to-br from-purple-50 via-pink-50 to-blue-100 p-4 py-8">
        <!-- Animated particles container -->
        <div class="particles" id="particles-container"></div>

        <div class="relative z-10 w-full max-w-3xl bg-white bg-opacity-70 backdrop-blur-md rounded-2xl border border-gray-200 shadow-2xl shadow-pink-200/40 overflow-hidden" style="max-height: 450px;">
            <div class="flex flex-col md:flex-row">
                <!-- Left Side - Register Form -->
                <div class="w-full md:w-2/5 p-3 md:p-4">
                    <!-- Header -->
                    <div class="text-center mb-3">
                        <h1 class="font-cinzel text-lg md:text-xl font-bold tracking-wider text-transparent bg-clip-text bg-gradient-to-r from-purple-500 via-pink-500 to-orange-400">
                            Astroly
                        </h1>
                        <p class="text-gray-500 mt-1 text-xs">Create your account to begin your journey.</p>
                    </div>

                    <!-- Register Form -->
                    <form id="registerForm">
                        <div class="mb-1.5">
                            <label for="register-name" class="block mb-0.5 text-xs font-medium text-gray-600">Full Name</label>
                            <input type="text" id="register-name" class="w-full pl-2 pr-2 py-1 bg-gray-50 border border-gray-300 rounded-md focus:ring-2 focus:ring-purple-400 focus:border-purple-400 outline-none transition-all duration-300 text-sm" placeholder="John Doe" required>
                        </div>
                        <div class="mb-1.5">
                            <label for="register-email" class="block mb-0.5 text-xs font-medium text-gray-600">Email Address</label>
                            <input type="email" id="register-email" class="w-full pl-2 pr-2 py-1 bg-gray-50 border border-gray-300 rounded-md focus:ring-2 focus:ring-purple-400 focus:border-purple-400 outline-none transition-all duration-300 text-sm" placeholder="you@example.com" required>
                        </div>
                        <div class="mb-1.5">
                            <label for="register-password" class="block mb-0.5 text-xs font-medium text-gray-600">Password</label>
                            <input type="password" id="register-password" class="w-full pl-2 pr-2 py-1 bg-gray-50 border border-gray-300 rounded-md focus:ring-2 focus:ring-purple-400 focus:border-purple-400 outline-none transition-all duration-300 text-sm" placeholder="••••••••••" required>
                        </div>
                         <div class="mb-2">
                            <label for="confirm-password" class="block mb-0.5 text-xs font-medium text-gray-600">Confirm Password</label>
                            <input type="password" id="confirm-password" class="w-full pl-2 pr-2 py-1 bg-gray-50 border border-gray-300 rounded-md focus:ring-2 focus:ring-purple-400 focus:border-purple-400 outline-none transition-all duration-300 text-sm" placeholder="••••••••••" required>
                        </div>
                        <button type="submit" class="w-full py-1 px-4 bg-gradient-to-r from-pink-500 to-orange-500 hover:from-pink-600 hover:to-orange-600 rounded-md text-white font-medium tracking-wide shadow-lg shadow-pink-500/30 transform hover:scale-105 transition-all duration-300 text-sm">
                            Create Account
                        </button>
                        <div class="text-center mt-2">
                            <p class="text-xs text-gray-500">
                                Already have an account? <a href="login.html" class="font-medium text-purple-600 hover:text-purple-500 transition-colors duration-300">Login</a>
                            </p>
                        </div>
                    </form>
                    
                    <!-- Message Box for feedback -->
                    <div id="messageBox" class="hidden mt-1.5 p-1.5 text-center text-xs rounded-md"></div>
                </div>

                <!-- Right Side - Image -->
                <div class="w-full md:w-3/5 relative overflow-hidden">
                    <img src="assets/image/blog2.jpg" alt="Astrology Background" class="w-full h-full object-cover">
                    <div class="absolute inset-0 bg-black bg-opacity-30"></div>
                    <div class="relative z-10 h-full flex items-center justify-center p-4">
                        <div class="text-center text-white">
                            <div class="mb-4">
                                <svg class="w-16 h-16 mx-auto mb-2 text-white/80" fill="currentColor" viewBox="0 0 24 24">
                                    <path d="M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm-2 15l-5-5 1.41-1.41L10 14.17l7.59-7.59L19 8l-9 9z"/>
                                </svg>
                            </div>
                            <h2 class="font-cinzel text-xl md:text-2xl font-bold mb-2">Welcome to Astroly</h2>
                            <p class="text-sm text-white/90 mb-3">Discover the mysteries of the cosmos and unlock your destiny through ancient wisdom and modern insights.</p>
                            <div class="flex justify-center space-x-3">
                                <div class="text-center">
                                    <div class="text-lg font-bold">✨</div>
                                    <div class="text-xs text-white/80">Celestial Guidance</div>
                                </div>
                                <div class="text-center">
                                    <div class="text-lg font-bold">🌟</div>
                                    <div class="text-xs text-white/80">Personal Insights</div>
                                </div>
                                <div class="text-center">
                                    <div class="text-lg font-bold">🔮</div>
                                    <div class="text-xs text-white/80">Mystical Wisdom</div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- Decorative elements -->
                    <div class="absolute top-4 right-4 w-16 h-16 border-2 border-white/20 rounded-full"></div>
                    <div class="absolute bottom-8 left-8 w-12 h-12 border-2 border-white/20 rounded-full"></div>
                    <div class="absolute top-1/2 right-8 w-8 h-8 border border-white/30 rounded-full"></div>
                </div>
            </div>
        </div>
    </div>

    <script>
        // --- Animated Particles Background ---
        const particlesContainer = document.getElementById('particles-container');
        if (particlesContainer) {
            const numParticles = 30;
            const particleColors = [
                'rgba(219, 188, 255, 0.6)', // Light Purple
                'rgba(255, 192, 224, 0.6)', // Light Pink
                'rgba(173, 216, 230, 0.6)'  // Light Blue
            ];
            for (let i = 0; i < numParticles; i++) {
                const particle = document.createElement('div');
                particle.className = 'particle';
                const size = Math.random() * 80 + 20;
                particle.style.width = `${size}px`;
                particle.style.height = `${size}px`;
                particle.style.left = `${Math.random() * 100}%`;
                particle.style.backgroundColor = particleColors[Math.floor(Math.random() * particleColors.length)];
                const duration = Math.random() * 15 + 15; 
                particle.style.animationDuration = `${duration}s`;
                const delay = Math.random() * 15;
                particle.style.animationDelay = `${delay}s`;
                particlesContainer.appendChild(particle);
            }
        }

        // --- Form Submission Logic ---
        const registerForm = document.getElementById('registerForm');
        const messageBox = document.getElementById('messageBox');

        registerForm.addEventListener('submit', function(event) {
            event.preventDefault();
            const name = document.getElementById('register-name').value;
            const password = document.getElementById('register-password').value;
            const confirmPassword = document.getElementById('confirm-password').value;

            if (password !== confirmPassword) {
                showMessage('Passwords do not match. Please try again.', 'error');
                return;
            }
            
            if (name && password) {
                showMessage(`Welcome, ${name}! Your account has been created.`, 'success');
            } else {
                 showMessage('Please fill in all fields.', 'error');
            }
        });

        // --- Message Display Function ---
        function showMessage(message, type) {
            messageBox.textContent = message;
            messageBox.className = 'mt-3 p-2 text-center text-xs rounded-md'; // Reset classes
            messageBox.classList.remove('hidden');
            if (type === 'success') {
                messageBox.classList.add('bg-green-100', 'text-green-800', 'border', 'border-green-300');
            } else {
                messageBox.classList.add('bg-red-100', 'text-red-800', 'border', 'border-red-300');
            }
        }
    </script>
</body>
</html>
