<?php
session_start(); // Always start the session at the top
include 'includes/db_connect.php'; // Make sure this path is correct

// Enable error reporting for debugging
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Check if the form was submitted
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    // Check if username and password are set
    if (!isset($_POST['username'], $_POST['password'])) {
        // Could not get the data that should have been sent.
        exit('Please fill both the username and password fields!');
    }

    $username = $_POST['username'];
    $password = $_POST['password'];
    
    // Debug: Log the login attempt
    error_log("Login attempt - Username: " . $username);

    // Use prepared statements to prevent SQL injection
    $stmt = $conn->prepare("SELECT id, password, role, status FROM admins WHERE username = ?");
    $stmt->bind_param("s", $username);
    $stmt->execute();
    $stmt->store_result();

    // Debug: Log query results
    error_log("Database query executed. Found rows: " . $stmt->num_rows);

    if ($stmt->num_rows > 0) {
        $stmt->bind_result($id, $hashed_password, $role, $status);
        $stmt->fetch();
        
        // Debug: Log user data (without password)
        error_log("User found - ID: $id, Role: '$role', Status: '$status'");

        // Debug: Check password verification
        $password_verify_result = password_verify($password, $hashed_password);
        error_log("Password verification result: " . ($password_verify_result ? "TRUE" : "FALSE"));
        error_log("Account status check: " . ($status == 'Active' ? "TRUE" : "FALSE"));
        
        // Verify the password and check if the account is active
        if ($password_verify_result && $status == 'Active') {
            // Password is correct and user is active, create sessions
            session_regenerate_id(true); // Security measure

            // Store data in session variables
            $_SESSION['loggedin'] = true;
            $_SESSION['id'] = $id;
            $_SESSION['username'] = $username;
            $_SESSION['role'] = $role;

            // Update the last_login timestamp
            $update_stmt = $conn->prepare("UPDATE admins SET last_login = NOW() WHERE id = ?");
            $update_stmt->bind_param("i", $id);
            $update_stmt->execute();
            $update_stmt->close();

            // Debug: Log successful login
            error_log("Login successful! User role: '$role'");
            
            // Role-based redirection
            if (strtolower(trim($role)) == 'super admin') {
                // Redirect Super Admin to index2.php
                error_log("Redirecting Super Admin to index2.php");
                header("location: index2.php");
                exit;
            } elseif (strtolower(trim($role)) == 'admin') {
                // Redirect Admin to index.php
                error_log("Redirecting Admin to index.php");
                header("location: index.php");
                exit;
            } else {
                // For any other role, redirect to a default dashboard
                error_log("Redirecting user with role '$role' to dashboard.php");
                header("location: dashboard.php");
                exit;
            }
                 } else {
             // Incorrect password or inactive user
             header("location: login.php?error=login_failed");
             exit;
         }
     } else {
         // Incorrect username
         header("location: login.php?error=login_failed");
         exit;
     }
     $stmt->close();
 } else {
     // If not a POST request, just redirect to the main page
     header("location: login.php");
     exit;
 }
?>