<?php
session_start();
include 'includes/db_connect.php';

// Security check: Ensure user is a logged-in Super Admin and this is a POST request
if ($_SERVER["REQUEST_METHOD"] !== "POST" || !isset($_SESSION['loggedin']) || $_SESSION['role'] !== 'Super Admin') {
    // Redirect to login if not authorized
    header("location: login.php");
    exit;
}

// 1. Get data from the form
$username = trim($_POST['username']);
$password = $_POST['password'];
$confirm_password = $_POST['confirm_password'];

// 2. Validation
// Check if passwords match
if ($password !== $confirm_password) {
    header("location: add_super_admin.php?error=pwdmismatch");
    exit;
}

// Check if username already exists
$stmt = $conn->prepare("SELECT id FROM admins WHERE username = ?");
$stmt->bind_param("s", $username);
$stmt->execute();
$stmt->store_result();

if ($stmt->num_rows > 0) {
    $stmt->close();
    header("location: add_super_admin.php?error=userexists");
    exit;
}
$stmt->close();

// 3. Hash the password securely
$hashed_password = password_hash($password, PASSWORD_DEFAULT);

// 4. Insert the new user into the database
$role = 'Super Admin'; // Hardcode the role for this form
$stmt = $conn->prepare("INSERT INTO admins (username, password, role) VALUES (?, ?, ?)");
$stmt->bind_param("sss", $username, $hashed_password, $role);

if ($stmt->execute()) {
    // Success: redirect back to the form with a success message
    $stmt->close();
    $conn->close();
    header("location: add_super_admin.php?success=1");
    exit;
} else {
    // Failure: redirect back with a generic error
    $stmt->close();
    $conn->close();
    header("location: add_super_admin.php?error=stmtfailed");
    exit;
}
?>