<?php
// Secure the page
// include 'includes/session_check.php';
include 'includes/db_connect.php';

// Authorization check: Only Super Admins can access this page
if ($_SESSION['role'] !== 'Super Admin') {
    // Optionally, you can redirect to the dashboard with an error message
    // For now, we'll just show a simple "access denied" message and stop execution.
    die("Access Denied: You do not have permission to view this page.");
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Add Super Admin - Admin Panel</title>
    <link rel="stylesheet" href="assets/css/style.css">
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
</head>
<body>
    <header class="dashboard-header">
        <h1>Astrology Admin Panel</h1>
        <nav>
            <a href="dashboard.php" class="btn">← Back to Dashboard</a>
            <a href="logout.php" class="btn btn-logout">Logout</a>
        </nav>
    </header>

    <main>
        <div class="form-container">
            <h2>Create New Super Admin</h2>
            <p>Fill out the form below to add a new administrator with 'Super Admin' privileges.</p>
            <form action="add_super_admin_process.php" method="post" class="user-form">
                <div class="input-group">
                    <label for="username">Username</label>
                    <input type="text" name="username" id="username" required>
                </div>
                <div class="input-group">
                    <label for="password">Password</label>
                    <input type="password" name="password" id="password" required>
                </div>
                <div class="input-group">
                    <label for="confirm_password">Confirm Password</label>
                    <input type="password" name="confirm_password" id="confirm_password" required>
                </div>
                <button type="submit" class="btn">Create Super Admin</button>
            </form>
        </div>
    </main>

    <script>
        // Check for status messages in the URL
        const urlParams = new URLSearchParams(window.location.search);
        const success = urlParams.get('success');
        const error = urlParams.get('error');

        if (success === '1') {
            Swal.fire({
                icon: 'success',
                title: 'Success!',
                text: 'New Super Admin has been created successfully.',
                confirmButtonColor: '#5b34a1'
            });
        } else if (error) {
            let errorMessage = 'An unknown error occurred.';
            if (error === 'pwdmismatch') {
                errorMessage = 'The passwords you entered do not match.';
            } else if (error === 'userexists') {
                errorMessage = 'This username is already taken. Please choose another one.';
            } else if (error === 'stmtfailed') {
                errorMessage = 'Something went wrong. Please try again.';
            }
            
            Swal.fire({
                icon: 'error',
                title: 'Creation Failed',
                text: errorMessage,
                confirmButtonColor: '#d33'
            });
        }
    </script>
</body>
</html>