<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Elegant Admin Panel</title>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="../backend/assets/css/styles.css">
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
    <style>
        /* Basic styles for the new elements to ensure they are functional and look consistent. */
        /* You can move these to your styles.css file. */
        .sidebar-nav .submenu {
            display: none;
            list-style: none;
            padding-left: 30px; /* Indent submenu items */
        }
        .sidebar-nav li.open > .submenu {
            display: block;
        }
        .sidebar-nav .submenu a {
            padding: 10px 15px;
            font-size: 0.9em;
        }
        .sidebar-nav .has-submenu > a {
            position: relative;
        }
        /* Simple arrow for submenu */
        .sidebar-nav .has-submenu > a::after {
            content: '▼';
            position: absolute;
            right: 20px;
            font-size: 0.7em;
            transition: transform 0.3s ease;
        }
        .sidebar-nav .has-submenu.open > a::after {
            transform: rotate(180deg);
        }
        
        /* Form Styles */
        .user-form-container {
            background-color: var(--background-color, #fff);
            padding: 2rem;
            border-radius: 8px;
            box-shadow: 0 4px 12px rgba(0,0,0,0.05);
        }
        .form-group {
            margin-bottom: 1.5rem;
        }
        .form-group label {
            display: block;
            margin-bottom: 0.5rem;
            font-weight: 500;
            color: var(--text-color, #333);
        }
        .form-group input,
        .form-group select {
            width: 100%;
            padding: 0.75rem;
            border: 1px solid var(--border-color, #ddd);
            border-radius: 4px;
            background-color: var(--input-bg, #f9f9f9);
            color: var(--text-color, #333);
        }
        .form-group input:focus,
        .form-group select:focus {
            outline: none;
            border-color: #4a90e2;
        }
        .btn-submit {
            background-color: #4a90e2;
            color: white;
            padding: 0.75rem 1.5rem;
            border: none;
            border-radius: 4px;
            cursor: pointer;
            font-size: 1rem;
            font-weight: 500;
        }
        .btn-submit:hover {
            background-color: #3b73b5;
        }
        
        /* Table Styles */
        .table-container {
            background-color: var(--background-color, #fff);
            padding: 2rem;
            border-radius: 8px;
            box-shadow: 0 4px 12px rgba(0,0,0,0.05);
            overflow-x: auto;
        }
        .users-table {
            width: 100%;
            border-collapse: collapse;
        }
        .users-table th, .users-table td {
            padding: 1rem;
            text-align: left;
            border-bottom: 1px solid var(--border-color, #ddd);
            color: var(--text-color, #333);
        }
        .users-table th {
            font-weight: 600;
        }
        .users-table .action-buttons button {
            margin-right: 5px;
            padding: 5px 10px;
            border: none;
            border-radius: 4px;
            cursor: pointer;
        }
        .users-table .edit-btn { background-color: #f5a623; color: white; }
        .users-table .delete-btn { background-color: #d0021b; color: white; }
    </style>
</head>
<body class=""> <div class="container">
        <aside class="sidebar" id="sidebar">
            <div class="sidebar-header">
                <span class="logo-icon">A</span>
                <h2>Admin Panel</h2>
            </div>
            <nav class="sidebar-nav">
                <ul>
                                         <li>
                         <a href="index2.php">
                             <svg class="icon" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 12l2-2m0 0l7-7 7 7M5 10v10a1 1 0 001 1h3m10-11l2 2m-2-2v10a1 1 0 01-1 1h-3m-6 0a1 1 0 001-1v-4a1 1 0 011-1h2a1 1 0 011 1v4a1 1 0 001 1m-6 0h6"></path></svg>
                             <span>Dashboard</span>
                         </a>
                     </li>
                    <li>
                        <a href="#" data-view="analytics-view">
                            <svg class="icon" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 19v-6a2 2 0 00-2-2H5a2 2 0 00-2 2v6a2 2 0 002 2h2a2 2 0 002-2zm0 0V9a2 2 0 012-2h2a2 2 0 012 2v10m-6 0a2 2 0 002 2h2a2 2 0 002-2m0 0V5a2 2 0 012-2h2a2 2 0 012 2v14a2 2 0 01-2 2h-2a2 2 0 01-2-2z"></path></svg>
                            <span>Analytics</span>
                        </a>
                    </li>
                                         <li class="has-submenu open">
                         <a href="#">
                             <svg class="icon" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 20h5v-2a3 3 0 00-5.356-1.857M17 20H7m10 0v-2c0-.656-.126-1.283-.356-1.857M7 20H2v-2a3 3 0 015.356-1.857M7 20v-2c0-.656.126-1.283.356-1.857m0 0a5.002 5.002 0 019.288 0M15 7a3 3 0 11-6 0 3 3 0 016 0zm6 3a2 2 0 11-4 0 2 2 0 014 0zM7 10a2 2 0 11-4 0 2 2 0 014 0z"></path></svg>
                             <span>Users</span>
                         </a>
                        <ul class="submenu">
                            <li><a href="allUser.php">All Users</a></li>
                            <li><a href="#" class="active" data-view="add-user-view">Add User</a></li>
                        </ul>
                    </li>
                    <li>
                        <a href="#" data-view="products-view">
                            <svg class="icon" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 11V7a4 4 0 00-8 0v4M5 9h14l1 12H4L5 9z"></path></svg>
                            <span>Products</span>
                        </a>
                    </li>
                    <li>
                        <a href="#" data-view="settings-view">
                            <svg class="icon" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10.325 4.317c.426-1.756 2.924-1.756 3.35 0a1.724 1.724 0 002.573 1.066c1.543-.94 3.31.826 2.37 2.37a1.724 1.724 0 001.065 2.572c1.756.426 1.756 2.924 0 3.35a1.724 1.724 0 00-1.066 2.573c.94 1.543-.826 3.31-2.37 2.37a1.724 1.724 0 00-2.572 1.065c-.426 1.756-2.924 1.756-3.35 0a1.724 1.724 0 00-2.573-1.066c-1.543.94-3.31-.826-2.37-2.37a1.724 1.724 0 00-1.065-2.572c-1.756-.426-1.756-2.924 0-3.35a1.724 1.724 0 001.066-2.573c-.94-1.543.826-3.31 2.37-2.37.996.608 2.296.07 2.572-1.065z"></path><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z"></path></svg>
                            <span>Settings</span>
                        </a>
                    </li>
                </ul>
            </nav>
        </aside>

        <div class="main-content">
            <header class="header">
                <button class="menu-toggle" id="menu-toggle">
                     <svg class="icon" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 6h16M4 12h16M4 18h16"></path></svg>
                </button>
                <div class="search-bar">
                    <svg class="icon" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M21 21l-6-6m2-5a7 7 0 11-14 0 7 7 0 0114 0z"></path></svg>
                    <input type="text" placeholder="Search...">
                </div>
                <div class="header-right">
                    <div class="theme-switch-wrapper">
                        <label class="theme-switch" for="checkbox">
                            <input type="checkbox" id="checkbox" />
                            <div class="slider round"></div>
                        </label>
                    </div>
                    <button class="icon-button">
                        <svg class="icon" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 17h5l-1.405-1.405A2.032 2.032 0 0118 14.158V11a6.002 6.002 0 00-4-5.659V5a2 2 0 10-4 0v.341C7.67 6.165 6 8.388 6 11v3.159c0 .538-.214 1.055-.595 1.436L4 17h5m6 0v1a3 3 0 11-6 0v-1m6 0H9"></path></svg>
                    </button>
                    <div class="profile">
                        <img src="https://placehold.co/40x40/4a90e2/ffffff?text=U" alt="User Avatar">
                        <div class="profile-info">
                            <h4>Admin User</h4>
                            <p>Super Admin</p>
                        </div>
                    </div>
                </div>
            </header>

            <main class="page-content">
                
                <div id="dashboard-view" class="content-view" style="display: none;">
                    <div class="page-header">
                        <h1>Dashboard</h1>
                    </div>
                    <div class="widgets-grid">
                        <div class="widget revenue">
                            <div class="icon-container">
                                 <svg class="icon" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8c-1.657 0-3 .895-3 2s1.343 2 3 2 3 .895 3 2-1.343 2-3 2m0-8c1.11 0 2.08.402 2.599 1M12 8V7m0 1v.01"></path></svg>
                            </div>
                            <div class="widget-info">
                                <h3>$45,231.89</h3>
                                <p>Total Revenue</p>
                            </div>
                        </div>
                        <div class="widget subscribers">
                            <div class="icon-container">
                               <svg class="icon" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 20h5v-2a3 3 0 00-5.356-1.857M17 20H7m10 0v-2c0-.656-.126-1.283-.356-1.857M7 20H2v-2a3 3 0 015.356-1.857M7 20v-2c0-.656.126-1.283.356-1.857m0 0a5.002 5.002 0 019.288 0M15 7a3 3 0 11-6 0 3 3 0 016 0zm6 3a2 2 0 11-4 0 2 2 0 014 0zM7 10a2 2 0 11-4 0 2 2 0 014 0z"></path></svg>
                            </div>
                            <div class="widget-info">
                                <h3>+2350</h3>
                                <p>Subscribers</p>
                            </div>
                        </div>
                        <div class="widget sales">
                            <div class="icon-container">
                               <svg class="icon" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 3h2l.4 2M7 13h10l4-8H5.4M7 13L5.4 5M7 13l-2.293 2.293c-.63.63-.184 1.707.707 1.707H17m0 0a2 2 0 100 4 2 2 0 000-4zm-8 2a2 2 0 11-4 0 2 2 0 014 0z"></path></svg>
                            </div>
                            <div class="widget-info">
                                <h3>+12,345</h3>
                                <p>Sales</p>
                            </div>
                        </div>
                        <div class="widget active-users">
                            <div class="icon-container">
                                <svg class="icon" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M11 3.055A9.001 9.001 0 1020.945 13H11V3.055z"></path><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M20.488 9H15V3.512A9.025 9.025 0 0120.488 9z"></path></svg>
                            </div>
                            <div class="widget-info">
                                <h3>+500</h3>
                                <p>Active Users</p>
                            </div>
                        </div>
                    </div>
                    <div class="charts-grid">
                        <div class="chart-container">
                            <h3>Sales Overview</h3>
                            <canvas id="salesChart"></canvas>
                        </div>
                        <div class="chart-container">
                            <h3>Traffic Sources</h3>
                            <canvas id="trafficChart"></canvas>
                        </div>
                    </div>
                </div>

                <div id="add-user-view" class="content-view">
                    <div class="page-header">
                        <h1>Add New User</h1>
                    </div>
                    <div class="user-form-container">
                        <form id="addUserForm">
                            <div class="form-group">
                                <label for="firstName">First Name</label>
                                <input type="text" id="firstName" name="firstName" required>
                            </div>
                            <div class="form-group">
                                <label for="lastName">Last Name</label>
                                <input type="text" id="lastName" name="lastName" required>
                            </div>
                            <div class="form-group">
                                <label for="email">Email Address</label>
                                <input type="email" id="email" name="email" required>
                            </div>
                            <div class="form-group">
                                <label for="password">Password</label>
                                <input type="password" id="password" name="password" required>
                            </div>
                            <div class="form-group">
                                <label for="role">Role</label>
                                <select id="role" name="role">
                                    <option value="subscriber">Subscriber</option>
                                    <option value="editor">Editor</option>
                                    <option value="admin">Admin</option>
                                </select>
                            </div>
                            <div class="form-group">
                                <label for="avatar">Profile Picture</label>
                                <input type="file" id="avatar" name="avatar" accept="image/*">
                            </div>
                            <button type="submit" class="btn-submit">Add User</button>
                        </form>
                    </div>
                </div>
                
                <div id="all-users-view" class="content-view" style="display: none;">
                    <div class="page-header">
                        <h1>All Users</h1>
                    </div>
                    <div class="table-container">
                        <table class="users-table">
                            <thead>
                                <tr>
                                    <th>Name</th>
                                    <th>Email</th>
                                    <th>Role</th>
                                    <th>Joined Date</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr>
                                    <td>Admin User</td>
                                    <td>admin@example.com</td>
                                    <td>Super Admin</td>
                                    <td>2024-01-15</td>
                                    <td class="action-buttons">
                                        <button class="edit-btn">Edit</button>
                                        <button class="delete-btn">Delete</button>
                                    </td>
                                </tr>
                                <tr>
                                    <td>Jane Doe</td>
                                    <td>jane.d@example.com</td>
                                    <td>Editor</td>
                                    <td>2024-03-22</td>
                                    <td class="action-buttons">
                                        <button class="edit-btn">Edit</button>
                                        <button class="delete-btn">Delete</button>
                                    </td>
                                </tr>
                                <tr>
                                    <td>John Smith</td>
                                    <td>john.smith@example.com</td>
                                    <td>Subscriber</td>
                                    <td>2024-05-10</td>
                                    <td class="action-buttons">
                                        <button class="edit-btn">Edit</button>
                                        <button class="delete-btn">Delete</button>
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>

                <div id="analytics-view" class="content-view" style="display: none;"><div class="page-header"><h1>Analytics</h1></div><p>Analytics content goes here.</p></div>
                <div id="products-view" class="content-view" style="display: none;"><div class="page-header"><h1>Products</h1></div><p>Products content goes here.</p></div>
                <div id="settings-view" class="content-view" style="display: none;"><div class="page-header"><h1>Settings</h1></div><p>Settings content goes here.</p></div>

            </main>
        </div>
    </div>

    <script>
        document.addEventListener('DOMContentLoaded', function() {
            
            // --- Theme Switcher ---
            const themeSwitch = document.getElementById('checkbox');
            const prefersDark = window.matchMedia('(prefers-color-scheme: dark)');
            
            // Set initial theme based on system preference or saved preference
            const currentTheme = localStorage.getItem('theme');
            if (currentTheme === 'dark' || (!currentTheme && prefersDark.matches)) {
                document.body.classList.add('dark-mode');
                themeSwitch.checked = true;
            }

            themeSwitch.addEventListener('change', () => {
                if (document.body.classList.toggle('dark-mode')) {
                    localStorage.setItem('theme', 'dark');
                } else {
                    localStorage.setItem('theme', 'light');
                }
                updateChartColors();
            });
            
            // --- Chart.js Configurations ---
            let salesChart, trafficChart; // Declare chart variables

            // Function to get chart colors based on theme
            function getChartColors() {
                const isDarkMode = document.body.classList.contains('dark-mode');
                // Define colors in CSS variables in your stylesheet for better management
                const style = getComputedStyle(document.body);
                const primaryColor = '#4a90e2'; // style.getPropertyValue('--primary-color') || '#4a90e2';
                const textColor = isDarkMode ? '#e0e0e0' : '#333';
                const gridColor = isDarkMode ? 'rgba(255, 255, 255, 0.1)' : 'rgba(0, 0, 0, 0.1)';
                const bgColor = isDarkMode ? '#1e1e1e' : '#fff';
                
                return {
                    line: {
                        backgroundColor: isDarkMode ? 'rgba(74, 144, 226, 0.2)' : 'rgba(74, 144, 226, 0.1)',
                        borderColor: primaryColor,
                        pointBackgroundColor: primaryColor,
                        pointBorderColor: bgColor,
                        pointHoverBackgroundColor: bgColor,
                        pointHoverBorderColor: primaryColor,
                        gridColor: gridColor,
                        ticksColor: textColor
                    },
                    doughnut: {
                        backgroundColor: [primaryColor, '#50e3c2', '#f5a623'],
                        legendColor: textColor
                    }
                };
            }

            function initializeCharts() {
                const salesCtx = document.getElementById('salesChart').getContext('2d');
                salesChart = new Chart(salesCtx, {
                    type: 'line',
                    data: {
                        labels: ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul'],
                        datasets: [{
                            label: 'Sales',
                            data: [65, 59, 80, 81, 56, 55, 40],
                            fill: true,
                            tension: 0.4,
                        }]
                    },
                    options: {
                        responsive: true,
                        maintainAspectRatio: false,
                        scales: { y: { beginAtZero: true }, x: {} },
                        plugins: { legend: { display: false } }
                    }
                });

                const trafficCtx = document.getElementById('trafficChart').getContext('2d');
                trafficChart = new Chart(trafficCtx, {
                    type: 'doughnut',
                    data: {
                        labels: ['Direct', 'Referral', 'Social'],
                        datasets: [{
                            label: 'Traffic Source',
                            data: [300, 150, 100],
                            hoverOffset: 4
                        }]
                    },
                    options: {
                        responsive: true,
                        maintainAspectRatio: false,
                        plugins: { legend: { position: 'bottom' } }
                    }
                });
                
                updateChartColors(); // Set initial colors
            }

            function updateChartColors() {
                if (!salesChart || !trafficChart) return; // Don't run if charts not initialized
                
                const colors = getChartColors();

                // Update Sales Chart
                salesChart.data.datasets[0].backgroundColor = colors.line.backgroundColor;
                salesChart.data.datasets[0].borderColor = colors.line.borderColor;
                salesChart.data.datasets[0].pointBackgroundColor = colors.line.pointBackgroundColor;
                salesChart.data.datasets[0].pointBorderColor = colors.line.pointBorderColor;
                salesChart.data.datasets[0].pointHoverBackgroundColor = colors.line.pointHoverBackgroundColor;
                salesChart.data.datasets[0].pointHoverBorderColor = colors.line.pointHoverBorderColor;
                salesChart.options.scales.y.grid.color = colors.line.gridColor;
                salesChart.options.scales.y.ticks.color = colors.line.ticksColor;
                salesChart.options.scales.x.grid.color = colors.line.gridColor;
                salesChart.options.scales.x.ticks.color = colors.line.ticksColor;
                
                // Update Traffic Chart
                trafficChart.data.datasets[0].backgroundColor = colors.doughnut.backgroundColor;
                trafficChart.options.plugins.legend.labels.color = colors.doughnut.legendColor;

                salesChart.update();
                trafficChart.update();
            }
            
            // Initialize charts on load
            initializeCharts();

            // --- Mobile Sidebar Toggle ---
            const menuToggle = document.getElementById('menu-toggle');
            const sidebar = document.getElementById('sidebar');

            menuToggle.addEventListener('click', () => {
                sidebar.classList.toggle('show');
            });

            // Close sidebar when clicking outside on mobile
            document.addEventListener('click', function(event) {
                if (window.innerWidth <= 992) {
                    const isClickInsideSidebar = sidebar.contains(event.target);
                    const isClickOnToggle = menuToggle.contains(event.target);
                    if (!isClickInsideSidebar && !isClickOnToggle && sidebar.classList.contains('show')) {
                        sidebar.classList.remove('show');
                    }
                }
            });

            // --- NEW: Sidebar Submenu Toggle ---
            const submenuItems = document.querySelectorAll('.has-submenu');
            submenuItems.forEach(item => {
                const link = item.querySelector('a');
                link.addEventListener('click', (event) => {
                    event.preventDefault();
                    // Close other open submenus
                    submenuItems.forEach(otherItem => {
                        if(otherItem !== item) {
                            otherItem.classList.remove('open');
                        }
                    });
                    item.classList.toggle('open');
                });
            });

            // --- NEW: View Switching Logic ---
            const navLinks = document.querySelectorAll('.sidebar-nav a[data-view]');
            const contentViews = document.querySelectorAll('.content-view');
            const pageHeaderTitle = document.querySelector('.page-header h1');

            navLinks.forEach(link => {
                link.addEventListener('click', (event) => {
                    event.preventDefault();
                    const viewId = link.getAttribute('data-view');
                    
                    // Hide all views
                    contentViews.forEach(view => view.style.display = 'none');
                    
                    // Show the target view
                    const targetView = document.getElementById(viewId);
                    if (targetView) {
                        targetView.style.display = 'block';
                    }
                    
                    // Update active class on links
                    navLinks.forEach(navLink => navLink.classList.remove('active'));
                    link.classList.add('active');
                    
                    // If the link is in a submenu, keep the parent active
                    const parentLi = link.closest('.has-submenu');
                    if (parentLi) {
                        parentLi.querySelector('a').classList.add('active');
                    }
                    
                    // Close sidebar on mobile after click
                    if (window.innerWidth <= 992) {
                        sidebar.classList.remove('show');
                    }
                });
            });
            
            // Handle form submission
            const addUserForm = document.getElementById('addUserForm');
            addUserForm.addEventListener('submit', function(event) {
                event.preventDefault();
                const formData = new FormData(addUserForm);
                console.log('Form Submitted!');
                // You can process the form data here, e.g., send it to a server
                for (let [key, value] of formData.entries()) {
                    console.log(`${key}: ${value}`);
                }
                alert('New user added to the console!');
                addUserForm.reset();
            });

        });
    </script>
</body>
</html>