<section class="celestial-section">
    <div class="welcome-header">
        <!-- <span class="subtitle">About Us</span> -->
        <h1>Welcome to KEDT Astrology</h1>
        <p class="description">where we are passionate about guiding you through the mysteries of the cosmos.</p>
    </div>
    <div class="content-container">
        <div class="text-content">
            <br/>
            <p>
                Welcome to KEDT Astrology, your trusted source for celestial insights and astrological guidance. With a team of seasoned astrologers and a deep passion for the stars, we are dedicated to helping you explore the cosmos and uncover the secrets it holds. Our mission is to provide you with valuable insights that empower you to navigate life's journey with confidence and clarity.
            </p>
            <p>
                With a combined experience of over 20 years in the field of astrology, our team of expert astrologers brings a wealth of knowledge to your celestial journey. We have honed our skills through years of dedicated study and practice, allowing us to provide you with accurate, reliable, and insightful readings.
            </p>
            <p>
                Our primary achievement is the satisfaction of our clients. We have proudly served thousands of individuals, helping them gain a deeper understanding of themselves and their life's path.
            </p>
        </div>
        <div class="image-content">
            <img src="assets/images/about.jpg" alt="Astrological dice on a celestial chart">
        </div>
    </div>
</section>

<style>
    /* Welcome Header Styles - Matching service2.php */
    .welcome-header {
        text-align: center;
        margin-bottom: -1rem;
    }

    .welcome-header .subtitle {
        font-size: 0.8rem;
        letter-spacing: 0.2em;
        text-transform: uppercase;
        font-weight: bold;
        color: #666;
        position: relative;
        display: inline-block;
        margin-bottom: 1.5rem;
    }

    /* Line above the subtitle */
    .welcome-header .subtitle::before {
        content: '';
        position: absolute;
        top: -10px;
        left: 50%;
        transform: translateX(-50%);
        width: 30px;
        height: 1px;
        background-color: #999;
    }

    .welcome-header h1 {
        font-family: 'Cormorant Garamond', serif;
        font-size: 2.5rem;
        font-weight: 500;
        letter-spacing: 0.1em;
        margin-bottom: 1rem;
        text-transform: uppercase;
        color: #333;
    }

    .welcome-header .description {
        font-family: 'Lato', sans-serif;
        font-size: 1rem;
        font-weight: 400;
        line-height: 1.8;
        color: #555;
        margin-top: 1rem;
        text-transform: none;
        letter-spacing: 0.02em;
    }

    /* Image Collage Container */
.image-collage-container {
    position: relative;
    width: 100%;
    height: 500px;
}

/* Experience Box - Centered */
.experience-box {
    position: absolute;
    top: 50%;
    left: 50%;
    transform: translate(-50%, -50%);
    background: white;
    border: 3px solid #f97316;
    border-radius: 12px;
    padding: 2rem;
    width: 200px;
    box-shadow: 0 8px 25px rgba(0, 0, 0, 0.15);
    z-index: 10;
    text-align: center;
}

.experience-box h3 {
    font-size: 2.5rem;
    font-weight: 700;
    color: #1e293b;
    margin-bottom: 0.5rem;
}

.experience-box p {
    font-size: 1rem;
    font-weight: 600;
    color: #64748b;
    margin-bottom: 0;
}

/* Image Collage Grid */
.image-collage {
    display: grid;
    grid-template-columns: 1fr 1fr;
    grid-template-rows: 1fr 1fr;
    gap: 15px;
    height: 500px;
    width: 100%;
}

.collage-item-1, .collage-item-2, .collage-item-3, .collage-item-4 {
    width: 100%;
    height: 242px;
    overflow: hidden;
    border: none;
    outline: none;
    border-radius: 8px;
    background: none;
    padding: 0;
    margin: 0;
}

.collage-img {
    width: 100%;
    height: 100%;
    object-fit: cover;
    border-radius: 8px;
    display: block;
    margin: 0;
    padding: 0;
}

/* Remove any extra styling */
.collage-item-3 {
    grid-column: 1;
    grid-row: 2;
}

.collage-item-1 {
    grid-column: 1;
    grid-row: 1;
}

.collage-item-2 {
    grid-column: 2;
    grid-row: 1;
}

.collage-item-4 {
    grid-column: 2;
    grid-row: 2;
}

/* About Us Section */
.about-us-section {
    padding: 80px 0;
    background-color: #f8fafc;
}

.about-us-content .eyebrow {
    color: #f97316;
    font-weight: 600;
    font-size: 0.9rem;
    text-transform: uppercase;
    letter-spacing: 1px;
    margin-bottom: 1rem;
    display: block;
}

.about-us-content h2 {
    font-size: 2.5rem;
    font-weight: 700;
    color: #1e293b;
    margin-bottom: 1.5rem;
}

.about-us-content p {
    font-size: 1.1rem;
    line-height: 1.7;
    color: #64748b;
}

/* Expert Mobile Responsive Design */

/* Critical Mobile Fixes */
@media (max-width: 575.98px) {
    /* Hero Section Mobile Optimization */
    .hero-section {
        min-height: 250px !important;
        max-height: 250px !important;
        height: 250px !important;
        padding: 0.5rem 0 !important;
    }
    
    .hero-section h1 {
        font-size: 1.8rem !important;
        margin-bottom: 0.8rem !important;
        line-height: 1.3 !important;
    }
    
    .hero-section p {
        font-size: 0.9rem !important;
        line-height: 1.5 !important;
        margin-bottom: 0 !important;
    }
    
    /* About Us Section Mobile */
    .about-us-section {
        padding: 40px 0;
    }
    
    /* Image Collage Mobile Optimization */
    .image-collage-container {
        height: 280px;
        margin-bottom: 2rem;
    }
    
    .image-collage {
        height: 280px;
        gap: 8px;
        grid-template-columns: 1fr 1fr;
        grid-template-rows: 1fr 1fr;
    }
    
    .collage-item-1, .collage-item-2, .collage-item-3, .collage-item-4 {
        height: 136px;
    }
    
    /* Experience Box Mobile */
    .experience-box {
        width: 120px;
        padding: 0.8rem;
        border-width: 2px;
    }
    
    .experience-box h3 {
        font-size: 1.5rem;
        margin-bottom: 0.3rem;
    }
    
    .experience-box p {
        font-size: 0.7rem;
        font-weight: 500;
        line-height: 1.2;
    }
    
    /* Content Mobile */
    .about-us-content {
        text-align: center;
        padding: 0 10px;
    }
    
    .about-us-content .eyebrow {
        font-size: 0.8rem;
        margin-bottom: 0.8rem;
    }
    
    .about-us-content h2 {
        font-size: 1.8rem;
        margin-bottom: 1rem;
        line-height: 1.3;
    }
    
    .about-us-content p {
        font-size: 0.95rem;
        line-height: 1.6;
        margin-bottom: 1rem;
    }
}

/* Large Mobile / Small Tablet */
@media (min-width: 576px) and (max-width: 767.98px) {
    .hero-section {
        min-height: 300px !important;
        max-height: 300px !important;
        height: 300px !important;
    }
    
    .hero-section h1 {
        font-size: 2.2rem !important;
    }
    
    .hero-section p {
        font-size: 1rem !important;
    }
    
    .image-collage-container {
        height: 320px;
        margin-bottom: 2.5rem;
    }
    
    .image-collage {
        height: 320px;
        gap: 10px;
    }
    
    .collage-item-1, .collage-item-2, .collage-item-3, .collage-item-4 {
        height: 155px;
    }
    
    .experience-box {
        width: 140px;
        padding: 1rem;
    }
    
    .experience-box h3 {
        font-size: 1.7rem;
    }
    
    .experience-box p {
        font-size: 0.8rem;
    }
    
    .about-us-content h2 {
        font-size: 2rem;
    }
    
    .about-us-content p {
        font-size: 1rem;
    }
}

/* Tablet */
@media (min-width: 768px) and (max-width: 991.98px) {
    .image-collage-container {
        height: 380px;
        margin-bottom: 3rem;
    }
    
    .image-collage {
        height: 380px;
        gap: 12px;
    }
    
    .collage-item-1, .collage-item-2, .collage-item-3, .collage-item-4 {
        height: 184px;
    }
    
    .experience-box {
        width: 160px;
        padding: 1.3rem;
    }
    
    .experience-box h3 {
        font-size: 1.9rem;
    }
    
    .experience-box p {
        font-size: 0.85rem;
    }
}
</style>



<!-- About Us Section -->
<!-- <section class="about-us-section">
    <div class="container">
        <div class="row align-items-center"> -->
            <!-- Image Collage Column -->
            <!-- <div class="col-lg-6">
                <div class="image-collage-container"> -->
                    <!-- Experience Box - Centered in middle -->
                    <!-- <div class="experience-box">
                        <h3>20+</h3>
                        <p>Years Of Experience</p>
                    </div> -->
                    
                    <!-- Image Grid -->
                    <!-- <div class="image-collage">
                        <div class="collage-item-1">
                            <img src="assets/images/about/grid1.jpg" alt="About 1" class="collage-img">
                        </div>
                        <div class="collage-item-2">
                            <img src="assets/images/about/grid2.jpg" alt="About 2" class="collage-img">
                        </div>
                        <div class="collage-item-3">
                            <img src="assets/images/about/grid3.jpg" alt="About 3" class="collage-img">
                        </div>
                        <div class="collage-item-4">
                            <img src="assets/images/about/grid4.jpg" alt="About 4" class="collage-img">
                        </div>
                    </div>
                </div>
            </div> -->

            <!-- Content Column -->
            <!-- <div class="col-lg-6">
                <div class="about-us-content">
                    <span class="eyebrow">About Us</span>
                    <h2>Introduction</h2>
                    <p>At Kedt Astrology, we're more than just an astrology service. We're your trusted guide in navigating the complex map of your life. We understand that life's journey can be challenging, but with profound cosmic insight, we bring clarity and guidance to our discerning clients.</p>
                    <p class="mt-3">We provide continuous insight into your cosmic blueprint, supporting you from the moment you ask a question to the moment you achieve clarity. In this way, we make your journey of self-discovery a seamless and enlightening experience.</p>
                </div>
            </div>
        </div>
    </div>
</section> -->
