<?php

class wlb_woocommerce {
	var $content = array();
	var $show_ui = false;
	var $widgets_form = '';
	function __construct($args=array()){
		global $wlb_plugin;
		//------
		$defaults = array(
			'id'				=> $wlb_plugin->id.'-bra',
			'show_ui'			=> true,
			'show_in_menu'		=> 'white-label-branding',
			'menu_name'			=> __('WooCommerce','wlb')
		);
		foreach($defaults as $property => $default){
			$this->$property = isset($args[$property])?$args[$property]:$default;
		}
		//-----
		add_filter("pop-options_{$this->id}",array($this,'wlb_options'),10,1);
		add_action('admin_head', array($this,'admin_head'));
		
		add_action('init', array( $this, 'init' ) );
	}
	
	function init(){
		global $wlb_plugin;
		if(  '1' == $wlb_plugin->get_option('wc_hide_advanced_tab') ){
			if( !$wlb_plugin->is_wlb_administrator() ){
				$capability = $wlb_plugin->get_option('wc_advanced_tab_capability');

				if( empty( $capability ) ){
					$this->_remove_advanced_tab();				
				} else {
					if( !current_user_can( $capability ) ){
						$this->_remove_advanced_tab();						
					}
				}		
			}
		}
	}

	function _remove_advanced_tab(){
		add_filter('woocommerce_settings_tabs_array', array($this,'_woocommerce_settings_tabs_array'),9999999,1);
		add_filter('woocommerce_get_settings_advanced', array($this,'_woocommerce_get_settings_advanced'),999999999,1);
		add_filter('woocommerce_get_sections_advanced', array($this,'_woocommerce_get_sections_advanced'),999999999,1);
		add_action('woocommerce_before_settings_advanced', array($this,'_woocommerce_before_settings_advanced') );		
	}

	function _woocommerce_settings_tabs_array( $tabs ){
		if( isset( $tabs['advanced'] ) ){
			unset( $tabs['advanced'] );
		}

		return $tabs;
	}

	function _woocommerce_get_settings_advanced($s){
		return array();
	}

	function _woocommerce_get_sections_advanced($s){
		return array();
	}

	function _woocommerce_before_settings_advanced(){
		wp_safe_redirect( admin_url('/') );
	}	
	
	function wlb_options($t,$for_admin=true){
		global $wlb_plugin;
		//if(  '1'!=$wlb_plugin->get_option('use_branding_customization') )return $t;

		$i=intval(count($t));
		//-------
		$i = count($t);
		$t[$i]=(object)array();
		$t[$i]->id 			= 'woocommerce';
		$t[$i]->label 		= __('WooCommerce','wlb');//title on tab
		$t[$i]->right_label	= __('WooCommerce WLB options','wlb');//title on tab
		$t[$i]->page_title	= __('WooCommerce','wlb');//title on content
		$t[$i]->options = array(
			(object)array(
				'type'=>'subtitle',
				'label'=>__('Advanced Tab options','wlb')
			),


		);

		$t[$i]->options[]=(object)array(
			'id'		=> 'wc_hide_advanced_tab',
			'label'		=> __('Hide advanced tab','wlb'),
			'type'		=> 'yesno',
			'description'=>  __('Only WLB administrators will get access to the WooCommerce Advanced Tab','wlb'),
			'el_properties'	=> array(),
			'save_option'=>true,
			'load_option'=>true
			);


		$capabilities_options = array(
			'' => __('--choose--','wlb')
		);

		global $wp_roles;
		$roles = $wp_roles->roles; 
		$capabilities = array();
		foreach( $roles as $role ){
			foreach( $role['capabilities'] as $capability => $c ){
				$capabilities[] = $capability;
			}
			
		}
		// Make sure we have a unique array of caps.
		$capabilities = array_unique( $capabilities );
		foreach( $capabilities as $cap ){
			$capabilities_options[ $cap ] = $cap ;
		}

		$t[$i]->options[]=(object)array(
				'id'	=> 'wc_advanced_tab_capability',
				'type'	=> 'select',
				'label'	=> __('Advanced Tab capability','wlb'),
				'el_properties' => array(),
				'options'=>$capabilities_options,
				'description'=> sprintf( "<p>%s</p><p>%s</p>",
					__('Specify a capability that will have access to the WooCommerce advanced tab.','wlb'),
					__('This capability will be tested in addition to WooCommerce capabilities.','wlb')					
				),					
				//'value'=>'fixed',
				'save_option'=>true,
				'load_option'=>true
			);

		$t[$i]->options[]=(object)array('type'=>'clear');
		$t[$i]->options[]=(object)array('label'=>__('Save Changes','wlb'),'type'=>'submit','class'=>'button-primary', 'value'=> '' );
		//-------
		return $t;
	}	
	
	function admin_head(){
	
	}
}