<?php


class replace_gutenberg_wp_logo {
	function __construct(){
		add_action( 'init', array( $this, 'init' ) );
	}

	function init(){
		global $wlb_plugin;

		if(  '1'!=$wlb_plugin->get_option('use_branding_customization') )return true;

		$url = $wlb_plugin->get_option('gutenberg_wp_logo');

		if( strlen($url) > 7 ){
			wp_enqueue_script(
				'wlb-replace-gutenberg-wp-logo',
				WLB_URL . 'includes/js/replace-gutenberg-wp-logo.js',
				array( 'jquery', 'wp-blocks', 'wp-element', 'wp-editor', 'wp-i18n' ),
				'1.1.5.3'
			);

			wp_localize_script( 'wlb-replace-gutenberg-wp-logo', 'WLB_GUTENBERG_LOGO', array(
				'url'	=> $url
			) );

			add_filter('wlb-branding-style',array($this,'replace_gutenberg_logo_css'));
		}
	}

	function replace_gutenberg_logo_css(){
		global $wlb_plugin;
		$padding = $wlb_plugin->get_option('gutenberg_wp_logo_padding');
		$padding = empty($padding)?'0':$padding.'px';
		$bg_color = $wlb_plugin->get_option('gutenberg_wp_logo_bg_color');
		$bg_color = strlen($bg_color)>1 ? $bg_color : 'transparent';
		$h_bg_color = $wlb_plugin->get_option('gutenberg_wp_logo_bg_color_hover');
		$h_bg_color = strlen($h_bg_color)>1 ? $h_bg_color : 'transparent';
?>
.edit-post-fullscreen-mode-close.has-icon {
background-color: <?php echo $bg_color ?>;
padding: <?php echo $padding ?> !important;
}
.edit-post-header .edit-post-fullscreen-mode-close.has-icon:hover {
	background-color: <?php echo $h_bg_color ?> !important;

}
.edit-post-fullscreen-mode-close.has-icon img:not:first-child,
.edit-post-fullscreen-mode-close.has-icon svg {
display:none !important;
}
<?php
	}
}