<?php include 'includes/header.php'; ?>
<link rel="stylesheet" href="assets/css/index.css">
<section class="hero-section">

    <video autoplay muted loop playsinline class="hero-video">
        <source src="assets/video/hero4.mp4" type="video/mp4">
        Your browser does not support the video tag.
    </video>

    <div class="hero-overlay"></div>

    <div class="hero-content container">
        <div class="text-wrapper">
            <h1 id="hero-typewriter">
                <span class="type-line" id="type-line-1"></span><br>
                <span class="type-line highlight" id="type-line-2"></span>
            </h1>

            <p class="hero-description">
                Protecting global trade through credit insurance, guarantees, and trusted financial support.
            </p>

            <a href="#" class="btn-explore">Explore More</a>

            <div class="hero-logos">
                <div class="logo-card">
                    <img src="assets/images/logo/1.png" alt="ECIC Logo">
                </div>
                <div class="logo-card">
                    <img src="assets/images/logo/2.png" alt="ICIEC Logo">
                </div>
                <div class="logo-card">
                    <img src="assets/images/logo/3.png" alt="SLECIC Logo">
                </div>
                <div class="logo-card">
                    <img src="assets/images/logo/4.png" alt="LCI Logo">
                </div>
            </div>
        </div>
    </div>
</section>

<section class="about-section" data-aos="fade-up" data-aos-duration="1200">
    <div class="container">
        <div class="about-card">
            <!-- <span class="subtitle">About Us</span> -->
            <h2>Welcome to Sri Lanka Export Credit Insurance Corporation</h2>
            <p>Sri Lanka Export Credit Insurance Corporation (SLECIC) is the leading provider of trade-related credit insurance solutions in Sri Lanka with more than three decades of robust presence. SLECIC is committed to provide attractive and innovative Export Credit Insurance and Guarantee support services for the development of exports of Sri Lanka.</p>
        </div>
    </div>
</section>

<section class="services-section" data-aos="fade-up" data-aos-duration="1200">
    <div class="container">
        <h2 class="section-title">Our Services</h2>

        <div class="services-grid">
            <div class="service-card">
                <img src="assets/images/service/s1.png" alt="Export Credit Insurance">
                <h3>Export Credit Insurance</h3>
                <p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.</p>
                <a href="#" class="btn-read-more">Read more</a>
            </div>

            <div class="service-card">
                <img src="assets/images/service/s2.png" alt="Pre-Shipment Credit Guarantee">
                <h3>Pre-Shipment Credit Guarantee</h3>
                <p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.</p>
                <a href="#" class="btn-read-more">Read more</a>
            </div>

            <div class="service-card">
                <img src="assets/images/service/s3.png" alt="Post-Shipment Credit Guarantee">
                <h3>Post-Shipment Credit Guarantee</h3>
                <p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.</p>
                <a href="#" class="btn-read-more">Read more</a>
            </div>

            <div class="service-card">
                <img src="assets/images/service/s4.png" alt="Export Performance Guarantee">
                <h3>Export Performance Guarantee</h3>
                <p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.</p>
                <a href="#" class="btn-read-more">Read more</a>
            </div>
        </div>
    </div>
</section>

<section class="feature-section">
    <div class="feature-bg-image"></div>

    <div class="feature-overlay"></div>

    <div class="container">
        <div class="feature-content">
            <img src="assets/images/main-logo.png" alt="SLECIC Logo" class="feature-logo">

            <h2>Backing the People Behind<br> Sri Lanka’s Global Trade</h2>

            <p>
                We provide you flexible credit insurance solutions; which are tailored to fit to your size, sector and business ambitions
            </p>
            <p>
                Nothing is static or sure.. Risks are imminent & inbuilt in Trade.. We diffuse them..
            </p>

            <a href="#" class="btn-pay-now">Pay Now</a>
        </div>
    </div>
</section>

<section class="news-section" data-aos="fade-up" data-aos-duration="1200">
    <div class="container">
        <h2 class="section-title">Recent News</h2>
        <div class="news-grid">
            <div class="news-card">
                <div class="news-image"><img src="assets/images/news/n2.png" alt="News"></div>
                <div class="news-content">
                    <div class="news-info">
                        <span class="news-date">21st Jul 2025</span>
                        <h3>Local Government Bodies Commence Term</h3>
                        <p>Lorem ipsum dolor sit amet, consectetur adipiscing elit.</p>
                    </div>
                    <a href="#" class="news-arrow">&gt;</a>
                </div>
            </div>
            <div class="news-card">
                <div class="news-image"><img src="assets/images/news/n3.png" alt="News"></div>
                <div class="news-content">
                    <div class="news-info">
                        <span class="news-date">23rd Jul 2025</span>
                        <h3>Independent Leadership</h3>
                        <p>Lorem ipsum dolor sit amet, consectetur adipiscing elit.</p>
                    </div>
                    <a href="#" class="news-arrow">&gt;</a>
                </div>
            </div>
            <div class="news-card">
                <div class="news-image"><img src="assets/images/news/n5.png" alt="News"></div>
                <div class="news-content">
                    <div class="news-info">
                        <span class="news-date">23rd Jul 2025</span>
                        <h3>Corruption Arrests</h3>
                        <p>Lorem ipsum dolor sit amet, consectetur adipiscing elit.</p>
                    </div>
                    <a href="#" class="news-arrow">&gt;</a>
                </div>
            </div>
            <div class="news-card">
                <div class="news-image"><img src="assets/images/news/n4.png" alt="News"></div>
                <div class="news-content">
                    <div class="news-info">
                        <span class="news-date">21st Jul 2025</span>
                        <h3>Local Government Bodies</h3>
                        <p>Lorem ipsum dolor sit amet, consectetur adipiscing elit.</p>
                    </div>
                    <a href="#" class="news-arrow">&gt;</a>
                </div>
            </div>
            <div class="news-card">
                <div class="news-image"><img src="assets/images/news/n1.png" alt="News"></div>
                <div class="news-content">
                    <div class="news-info">
                        <span class="news-date">23rd Jul 2025</span>
                        <h3>Independent Leadership</h3>
                        <p>Lorem ipsum dolor sit amet, consectetur adipiscing elit.</p>
                    </div>
                    <a href="#" class="news-arrow">&gt;</a>
                </div>
            </div>
            <div class="news-card">
                <div class="news-image"><img src="assets/images/news/n6.png" alt="News"></div>
                <div class="news-content">
                    <div class="news-info">
                        <span class="news-date">23rd Jul 2025</span>
                        <h3>Corruption Arrests</h3>
                        <p>Lorem ipsum dolor sit amet, consectetur adipiscing elit.</p>
                    </div>
                    <a href="#" class="news-arrow">&gt;</a>
                </div>
            </div>
        </div>
    </div>
</section>

<section class="contact-section" data-aos="fade-up" data-aos-duration="1200">
    <div class="container">
        <div class="contact-grid">

            <div class="contact-form-wrapper">
                <h2 class="section-title">Get in Touch With Us</h2>
                <p class="contact-intro">
                    Lorem Ipsum has been the industry's standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book.
                </p>

                <form action="#" method="POST" class="contact-form">
                    <div class="form-row">
                        <input type="text" placeholder="First Name" class="form-control" required>
                        <input type="text" placeholder="Last Name" class="form-control" required>
                    </div>

                    <div class="form-row">
                        <input type="email" placeholder="Email" class="form-control" required>
                        <input type="tel" placeholder="Contact Number" class="form-control">
                    </div>

                    <textarea placeholder="Description" class="form-control form-textarea" rows="5"></textarea>

                    <button type="submit" class="btn-submit">Submit</button>
                </form>

                <!-- <p class="form-footer-text">
                    Lorem Ipsum has been the industry's standard dummy text ever since the 1500s, when an unknown printer.
                </p> -->
            </div>

            <div class="contact-map-wrapper">
                <iframe
                    src="https://www.google.com/maps/embed?pb=!1m14!1m8!1m3!1d15843.05905029555!2d79.850627!3d6.918702!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x3ae2594012ba8b6b%3A0x75f0a1629996235e!2sSri%20Lanka%20Export%20Credit%20Insurance%20Corporation!5e0!3m2!1sen!2sus!4v1770615950690!5m2!1sen!2sus"
                    width="100%"
                    height="100%"
                    style="border:0;"
                    allowfullscreen=""
                    loading="lazy"
                    referrerpolicy="no-referrer-when-downgrade">
                </iframe>
            </div>

        </div>
    </div>
</section>

<?php include 'includes/footer.php'; ?>

<script>
// Simple typewriter effect using Anime.js for two lines
function typeWriterAnime(target, text, delay = 0, speed = 45, callback) {
    let obj = { count: 0 };
    anime({
        targets: obj,
        count: text.length,
        round: 1,
        duration: text.length * speed,
        delay: delay,
        easing: 'linear',
        update: function() {
            document.getElementById(target).textContent = text.substring(0, obj.count);
        },
        complete: function() {
            if (callback) callback();
        }
    });
}
document.addEventListener('DOMContentLoaded', function() {
    typeWriterAnime('type-line-1', "Building Sri Lanka’s Exports", 0, 45, function() {
        setTimeout(function() {
            typeWriterAnime('type-line-2', "With Confidence", 0, 45);
        }, 400);
    });
});
</script>