<?php
include 'includes/header.php';
?>

<link rel="stylesheet" href="assets/css/ourRole.css">

<section class="page-hero">
    <div class="overlay"></div>
    <div class="container">
        <h1>Our Role</h1>
        <nav class="breadcrumb">
            <a href="index.php">Home</a>
            <span>&gt;</span>
            <span style="color: #d1b24a;">Our Role</span>
        </nav>
    </div>
</section>

<!-- Role Intro Section -->
<section class="role-intro">
    <div class="container" data-aos="fade-up" data-aos-duration="1000">
        <div class="role-intro-grid">
            <div class="role-intro-content">
                <h4 class="section-subtitle">Role of</h4>
                <h2 class="section-title">Sri Lanka Export Credit Insurance Corporation (SLECIC)</h2>
                <div class="gold-divider"></div>
                <p class="intro-text">
                    In this modern era of economic uncertainty and turbulence, SLECIC's policies enable exporters to penetrate and develop new export markets in hitherto unchartered territories with confidence and assurance. Many exporters hesitate to do business with previously unknown customers on credit terms due to uncertainty and insecurity. However, with SLECIC's insurance policies exporters can grant credit to foreign buyers to attract new businesses without having any fear about the payments.
                </p>
                <p class="intro-text">
                    Natural calamities and unexpected economic recessions can affect payments even from well known, long standing customers. The solution for such events is to have an insurance from SLECIC. Our insurance policies enable the exporters to borrow at attractive terms from banks.
                </p>
            </div>
            <div class="role-intro-image">
                <img src="assets/images/about/role-image.jpg" alt="SLECIC Role">
            </div>
        </div>
    </div>
</section>

<!-- Stats Section -->
<section class="stats-section">
    <div class="container">
        <div class="stats-grid">
            <div class="stat-item" data-aos="zoom-in" data-aos-duration="1000">
                <div class="stat-icon">
                    <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round" d="M12 6v12m-3-2.818.879.659c1.171.879 3.07.879 4.242 0 1.172-.879 1.172-2.303 0-3.182C13.536 12.219 12.768 12 12 12c-.725 0-1.45-.22-2.003-.659-1.106-.879-1.106-2.303 0-3.182s2.9-.879 4.006 0l.415.33M21 12a9 9 0 1 1-18 0 9 9 0 0 1 18 0Z" />
                    </svg>
                </div>
                <h3>Rs. 1.4 Billion</h3>
                <p>Equity Base</p>
            </div>
            <div class="stat-item" data-aos="zoom-in" data-aos-duration="1000">
                <div class="stat-icon">
                    <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round" d="M9 12.75 11.25 15 15 9.75m-3-7.036A11.959 11.959 0 0 1 3.598 6 11.99 11.99 0 0 0 3 9.749c0 5.592 3.824 10.29 9 11.623 5.176-1.332 9-6.03 9-11.622 0-1.31-.21-2.571-.598-3.751h-.152c-3.196 0-6.1-1.248-8.25-3.285Z" />
                    </svg>
                </div>
                <h3>Rs. 1 Billion</h3>
                <p>Government Guarantee</p>
            </div>
            <div class="stat-item" data-aos="zoom-in" data-aos-duration="1000">
                <div class="stat-icon">
                    <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round" d="M12 21a9.004 9.004 0 0 0 8.716-6.747M12 21a9.004 9.004 0 0 1-8.716-6.747M12 21c2.485 0 4.5-4.03 4.5-9S14.485 3 12 3m0 18c-2.485 0-4.5-4.03-4.5-9S9.515 3 12 3m0 0a8.997 8.997 0 0 1 7.843 4.582M12 3a8.997 8.997 0 0 0-7.843 4.582m15.686 0A11.953 11.953 0 0 1 12 10.5c-2.998 0-5.74-1.1-7.843-2.918m15.686 0A8.959 8.959 0 0 1 21 12c0 .778-.099 1.533-.284 2.253m0 0A17.919 17.919 0 0 1 12 16.5c-3.162 0-6.133-.815-8.716-2.247m0 0A9.015 9.015 0 0 1 3 12c0-1.605.42-3.113 1.157-4.418" />
                    </svg>
                </div>
                <h3>79 Members</h3>
                <p>Berne Union Worldwide</p>
            </div>
            <div class="stat-item" data-aos="zoom-in" data-aos-duration="1000">
                <div class="stat-icon">
                    <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round" d="M6.75 3v2.25M17.25 3v2.25M3 18.75V7.5a2.25 2.25 0 0 1 2.25-2.25h13.5A2.25 2.25 0 0 1 21 7.5v11.25m-18 0A2.25 2.25 0 0 0 5.25 21h13.5A2.25 2.25 0 0 0 21 18.75m-18 0v-7.5A2.25 2.25 0 0 1 5.25 9h13.5A2.25 2.25 0 0 1 21 11.25v7.5" />
                    </svg>
                </div>
                <h3>Since 1934</h3>
                <p>Berne Union Established</p>
            </div>
        </div>
    </div>
</section>

<!-- Berne Union Section -->
<section class="berne-section">
    <div class="container">
        <div class="berne-content">
            <h3>Member of the Prestigious Berne Union</h3>
            <p>SLECIC is a member of the prestigious Berne Union, a worldwide alliance of credit and investment insurers, established in 1934, which has a membership of 79 companies from around the world with headquarters in London, United Kingdom.</p>
        </div>
    </div>
</section>

<!-- Credit Importance Section -->
<section class="credit-section" data-aos="fade-up" data-aos-duration="1000">
    <div class="container">
        <div class="credit-grid reverse">
            <div class="credit-image" data-aos="fade-right" data-aos-duration="1000">
                <img src="assets/images/about/credit-business.jpg" alt="Business Credit">
            </div>
            <div class="credit-content" data-aos="fade-left" data-aos-duration="1000">
                <div class="quote-icon">
                    <svg xmlns="http://www.w3.org/2000/svg" fill="currentColor" viewBox="0 0 24 24">
                        <path d="M14.017 21v-7.391c0-5.704 3.731-9.57 8.983-10.609l.995 2.151c-2.432.917-3.995 3.638-3.995 5.849h4v10h-9.983zm-14.017 0v-7.391c0-5.704 3.748-9.57 9-10.609l.996 2.151c-2.433.917-3.996 3.638-3.996 5.849h3.983v10h-9.983z" />
                    </svg>
                </div>
                <h2>Credit has been described as "The lifeblood of business"..</h2>
                <div class="gold-divider"></div>
                <p>A large proportion of a company's assets are often tied up in credit. Indeed it is estimated that, on average, around <strong>40% of a company's assets</strong> are owed by debtors.</p>
                <p>The granting of credit to customers is a vital tool for trading companies when competing with others in the market. Competition takes places as much on the basis of credit as it does on price.</p>
            </div>
        </div>
    </div>
</section>

<!-- Cash Flow Section -->
<section class="cashflow-section" data-aos="fade-up" data-aos-duration="1000">
    <div class="container">
        <div class="cashflow-grid">
            <div class="cashflow-content" data-aos="fade-right" data-aos-duration="1000">
                <h4 class="section-subtitle">Why It Matters</h4>
                <h2 class="section-title">Cash Flow is Crucial</h2>
                <div class="gold-divider center"></div>
                <p>Money goes out of a company when a purchase is made and money does not come back into the company until a sale is made or a service rendered. As a result a company will always look for a period of credit from its suppliers to assist to improve their cash flow.</p>
                <p>Credit is therefore simply a necessary part of business. However the problem is when the payment does not come by the due date. If payments are late or never made, the company will suffer and also could go out of business.</p>
            </div>
            <div class="cashflow-image" data-aos="fade-left" data-aos-duration="1000">
                <img src="assets/images/about/cashflow.jpg" alt="Cash Flow">
            </div>
        </div>
    </div>
</section>

<!-- Risk Highlight Cards -->
<section class="risks-section" data-aos="fade-up" data-aos-duration="1000">
    <div class="container">
        <!-- <h4 class="section-subtitle">Why It Matters</h4> -->
        <h2 class="section-title" style="text-align: center;">Understanding Business Risks</h2>
        <div class="gold-divider center"></div>
        <div class="accordion-wrapper">
            <div class="accordion-item">
                <button class="accordion-header">
                    Late Payment Risk
                    <span class="accordion-icon">+</span>
                </button>
                <div class="accordion-content">
                    <div class="content-inner">
                        <p>Late payment is a growing business risk. Not only does it affect the company's finances and balance sheet, it also eats into the time and resources of the company which could have otherwise been allocated for meaningful activities.</p>
                        <p>When customers delay payments, businesses face cash flow problems, difficulty meeting their own obligations, and increased administrative costs in chasing overdue invoices.</p>
                    </div>
                </div>
            </div>
            <div class="accordion-item">
                <button class="accordion-header">
                    Buyer Insolvency
                    <span class="accordion-icon">+</span>
                </button>
                <div class="accordion-content">
                    <div class="content-inner">
                        <p>Insolvency of a buyer is even more devastating for companies. In such an event it may be impossible to recover any of the debt or a substantial part of it and the debt will have to be written off.</p>
                        <p>The ripple effect of a major buyer's insolvency can threaten the financial stability of supplying companies, potentially leading to a chain of business failures.</p>
                    </div>
                </div>
            </div>
            <div class="accordion-item">
                <button class="accordion-header">
                    Bad Debt Impact
                    <span class="accordion-icon">+</span>
                </button>
                <div class="accordion-content">
                    <div class="content-inner">
                        <p>The effect of a bad debt can be devastating when it involves a major supplier. The effect can also grow out of all proportion to its size. The problem becomes worse when a company has only a small number of buyers.</p>
                        <p>Bad debts directly reduce profits and can require significant additional sales just to recover the lost revenue, putting immense pressure on business operations.</p>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Accordion JS for risks-section -->
<script>
    document.addEventListener("DOMContentLoaded", function() {
        const accordions = document.querySelectorAll(".accordion-header");

        // Open first accordion by default
        if (accordions.length > 0) {
            const firstAccordion = accordions[0];
            const firstPanel = firstAccordion.nextElementSibling;
            firstAccordion.classList.add("active");
            firstPanel.classList.add("open");
            firstPanel.style.maxHeight = firstPanel.scrollHeight + "px";
        }

        accordions.forEach(acc => {
            acc.addEventListener("click", function() {
                // Close all panels
                accordions.forEach(otherAcc => {
                    if (otherAcc !== this) {
                        otherAcc.classList.remove("active");
                        const otherPanel = otherAcc.nextElementSibling;
                        otherPanel.style.maxHeight = null;
                        otherPanel.classList.remove("open");
                    }
                });

                // Toggle current
                this.classList.toggle("active");
                const panel = this.nextElementSibling;
                if (panel.style.maxHeight) {
                    panel.style.maxHeight = null;
                    panel.classList.remove("open");
                } else {
                    panel.style.maxHeight = panel.scrollHeight + "px";
                    panel.classList.add("open");
                }
            });
        });
    });
</script>

<!-- Myth Buster Section -->
<section class="myth-section">
    <div class="container">
        <div class="myth-grid">
            <div class="myth-content" data-aos="fade-right" data-aos-duration="1000">
                <h3>Breaking the Myth</h3>
                <div class="gold-divider center"></div>
                <p>It is not easy for companies to learn everything about a potential buyer. A Company that appears to be financially healthy according to its accounts and appears to have good management team can nevertheless become insolvent. Companies today are much more adept at hiding problems from suppliers.</p>
                <div class="myth-highlight">
                    <p><strong>Many companies believe that they will not be affected by insolvencies due to mismanagement as all their trading partners are situated in developed Countries and regions, such as USA and EU.</strong></p>
                    <p class="myth-truth">It is a myth that only those who trade with developing nations face payment defaults.</p>
                </div>
            </div>
            <div class="myth-image" data-aos="fade-left" data-aos-duration="1000">
                <img src="assets/images/about/myth-buster.jpg" alt="Myth Buster">
            </div>
        </div>
    </div>
</section>

<?php include 'includes/footer.php'; ?>