<?php
include 'includes/header.php';
?>

<link rel="stylesheet" href="assets/css/CreditInsurance.css">

<section class="page-hero">
    <div class="overlay"></div>
    <div class="container">
        <h1>Credit Insurance</h1>
        <nav class="breadcrumb">
            <a href="index.php">Home</a>
            <span>&gt;</span>
            <span style="color: #d1b24a;">Credit Insurance</span>
        </nav>
    </div>
</section>

<section class="risk-section">
    <div class="container" data-aos="fade-up" data-aos-duration="1000">

        <h2 class="risk-main-title">Credit Insurance (Seller's Risk)</h2>
        <div class="title-line"></div>
        <div class="risk-grid">
            <div class="risk-image-wrapper">
                <img src="assets/images/cr_insurance.jpg" alt="Seller's Risk Logo">
            </div>

            <div class="risk-content-wrapper">
                <h3 class="risk-subtitle">
                    SLECIC Export credit insurance policy gives you peace of mind and confidence to grow your business
                </h3>
                <p>
                    SLECIC provides customized export credit insurance policies for small, medium and large companies in all industries. Export credit insurance from SLECIC can help you to trade with confidence in overseas markets. Our Export credit insurance Scheme (Seller's Risk Policy) provides protection to exporters against commercial risk such as Non-receipt delayed-receipt of payments, insolvency, non acceptance (repudiation of contract) due to Commercial & Political risks associated with dispatching goods or rending services to their foreign buyers.
                </p>
                <p>
                    Our insurance policies provide the exporters the option of insuring a portion of their debtors or their entire portfolio of debtors. Our policies give the choice of insuring shipments to a selected group of countries. The flexibility of our insurance policies grants the much needed convenience to our clients. Our underwriting staff provides in-depth credit analysis to provide early warning of potential credit risks before they become a loss.
                </p>
            </div>
        </div>

        <div class="risk-accordion-area" data-aos="fade-up" data-aos-duration="1200">
            <div class="accordion-wrapper">

                <div class="accordion-item">
                    <button class="accordion-header">
                        Benefits of Credit Insurance
                        <span class="accordion-icon">+</span>
                    </button>
                    <div class="accordion-content">
                        <div class="content-inner">
                            <p><strong>Financial Protection:</strong> The most obvious benefit is financial protection. Credit insurance covers the unpaid debt of insolvent companies, therefore protecting a company's cash flow.</p>

                            <p><strong>Credit Information Services:</strong> The value of credit insurance goes beyond simple payment of claims. We offer credit information services that act as a credit management department for a company, providing information on trading partners. With this information, companies can decide whether or not to trade with a company and whether to offer credit. This invaluable service provides up-to-date financial information on companies worldwide.</p>

                            <p>Credit insurance helps prevent bad debt in the first place by providing an early credit warning system to identify whether customers are experiencing financial problems. This not only prevents bad debt but enables a company to avoid buyers that may become insolvent and reduces the risk of delayed payment.</p>

                            <p>Credit insurance is becoming a much more sophisticated product due to a wider variety of reasons beyond simple cash flow protection. These include:</p>

                            <div class="benefits-list">
                                <h4>1. Balance Sheet Protection</h4>
                                <p>Many companies today are concerned with balance sheet protection. There is a concern about the possibility that a major incident could cause an impact on the balance sheet which would have to be explained to the parent company or shareholders. Credit insurance protects the company against catastrophic bad debt losses, ensuring its continuity and survival.</p>

                                <h4>2. Better Credit Control</h4>
                                <p>Many companies see credit control as an integrated management function and often part of risk management. The value of a credit insurance policy, where it has a credit limit service, is that it provides invaluable assistance to the credit manager of the company to make decisions on new markets, distribution routes, or new clients.</p>

                                <h4>3. Increased Sales</h4>
                                <p>Credit insurance can increase the volume of trade by enabling exporters to offer better credit terms and thereby acquire new businesses. When a company has credit insurance, it can offer open credit to a buyer rather than having to demand letters of credit or other secured terms.</p>
                            </div>

                            <p style="margin-top: 20px;"><strong>Collateral Security:</strong> SLECIC Insurance is considered as a good collateral security as the policy gives easy access to post shipment finance from banks.</p>
                        </div>
                    </div>
                </div>

                <div class="accordion-item">
                    <button class="accordion-header">
                        SLECIC Credit Insurance Solutions
                        <span class="accordion-icon">+</span>
                    </button>
                    <div class="accordion-content">
                        <div class="content-inner">
                            <ul class="solutions-list">
                                <li>
                                    <strong>Seller's Risk Insurance Policy - Whole Turnover - All Buyers</strong>
                                    <p>Insurance to protect the exporter from commercial/ political risks. Under this we will cover the total shipments on deferred payment terms.</p>
                                </li>
                                <li>
                                    <strong>Seller's Risk Insurance Policy - Buyer Specific</strong>
                                    <p>Insurance to protect the exporter from commercial/ political risks of one or more specific buyers.</p>
                                </li>
                                <li>
                                    <strong>Seller's Risk Insurance Policy - Country Specific</strong>
                                    <p>Insurance to protect the exporter from commercial/ political risks risks of buyers of a specific country.</p>
                                </li>
                                <li>
                                    <strong>Seller's Risk Insurance Policy - Political Risk</strong>
                                    <p>Insurance to protect the exporter from the political risks of a specific country.</p>
                                </li>
                                <li>
                                    <strong>Seller's Risk Insurance Policy - Global Cover</strong>
                                    <p>Insurance is provided for off-shore export companies domiciled in Sri Lanka.</p>
                                </li>
                                <li>
                                    <strong>Seller's Risk Insurance Policy - Subsidiary Risk</strong>
                                    <p>Covers the risks of the exporters of a subsidiary company domiciled in another country where the parent company is in Sri Lanka.</p>
                                </li>
                                <li>
                                    <strong>Seller's Risk Insurance Policy - Covering Ultimate Buyers</strong>
                                    <p>Insurance to protect Sri Lankan exporters, covering commercial/ political risks of ultimate buyers where shipments have been effected to a fully owned subsidiary in the buyer's country.</p>
                                </li>
                                <li>
                                    <strong>Seller's Risk Insurance Policy - Consignment Of Stocks</strong>
                                    <p>Covers the Sri Lankan exporter on commercial/ political risks of consignment of stocks.</p>
                                </li>
                                <li>
                                    <strong>Seller's Risk Insurance Policy - Entrepot Trade</strong>
                                    <p>Covers the commercial/ political risks of a Sri Lankan exporter arising from entrepot trade.</p>
                                </li>
                                <li>
                                    <strong>Seller's Risk Insurance Policy - Seller's Risk Comprehensive Service Policy</strong>
                                    <p>Insurance to protect the service sector exporters from the commercial/ political risks.</p>
                                </li>
                                <li>
                                    <strong>Seller's Risk Insurance Policy - Domestic Credit Insurance</strong>
                                    <p>Insurance to protect the policy holder from commercial risks associated with dispatching goods & rending services to their buyers in Sri Lanka.</p>
                                </li>
                            </ul>
                        </div>
                    </div>
                </div>

                <div class="accordion-item">
                    <button class="accordion-header">
                        Risks Covered
                        <span class="accordion-icon">+</span>
                    </button>
                    <div class="accordion-content">
                        <div class="content-inner">
                            <p>Under Seller's Risk Insurance Policy, We provide protection to exporters receipt unclear commercial and Non Commercial Risks associated with dispatching goods or rending services.</p>

                            <div class="risks-section">
                                <h4>Commercial Risks (Buyer Risks)</h4>
                                <p class="section-subtitle">Risks covered under Commercial risks</p>

                                <ul class="risks-detail-list">
                                    <li>
                                        <strong>Protracted default</strong>
                                        <p>Failure or refusal of buyer to pay the Gross Invoice Value or part of it within 4 months of the due date.</p>
                                    </li>
                                    <li>
                                        <strong>Insolvency of the buyer</strong>
                                    </li>
                                    <li>
                                        <strong>Repudiation of contract (Non Acceptance by the buyer)</strong>
                                        <p>Refusal or failure of buyer to accept the goods or services in terms of the Contract of Sales.</p>
                                    </li>
                                </ul>
                            </div>

                            <div class="risks-section">
                                <h4>Non Commercial Risks (Political Risks/ Country Risks)</h4>
                                <p class="section-subtitle">Risks covered under Non Commercial risks</p>

                                <ul class="risks-detail-list">
                                    <li>
                                        <p>Occurrence of hostilities, wars, insurrections, civil or political disturbances, terrorist actions, natural disasters in the buyer's country.</p>
                                    </li>
                                    <li>
                                        <p>Outbreak of war between buyer's country & Sri Lanka.</p>
                                    </li>
                                    <li>
                                        <p>General moratorium declared by the government of the buyer's country or by a third country through which the payment must be effected.</p>
                                    </li>
                                    <li>
                                        <p>Changes of the laws of the buyer's country and/or an import ban.</p>
                                    </li>
                                    <li>
                                        <p>Political events or economic difficulties arising in the buyer's country or a third country through which the payment must be effected which prevent or delay the transfer of payment to Sri Lanka.</p>
                                    </li>
                                    <li>
                                        <p>Failure or refusal to fulfil the terms of contract by the buyer provided that the buyer is a foreign government or the performance is guaranteed by a foreign government.</p>
                                    </li>
                                    <li>
                                        <p>The cost incurred in respect of goods shipped from Sri Lanka as a result of any handling, transport or insurance chargers by interruption or diversion of voyage outside Sri Lanka & which is not recoverable from the buyer.</p>
                                    </li>
                                    <li>
                                        <p>Any Other cause, not being inherent to the nature of the goods or services and not within your control or that of your buyer which arises from an event occurring outside Sri Lanka.</p>
                                    </li>
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="accordion-item">
                    <button class="accordion-header">
                        Maximum Coverage
                        <span class="accordion-icon">+</span>
                    </button>
                    <div class="accordion-content">
                        <div class="content-inner">
                            <p>You can select required coverage from a range of 60% to 90% depending on your requirement, size and business ambitions.</p>
                        </div>
                    </div>
                </div>

                <div class="accordion-item">
                    <button class="accordion-header">
                        Countries Covered
                        <span class="accordion-icon">+</span>
                    </button>
                    <div class="accordion-content">
                        <div class="content-inner">
                            <ul class="country-list">
                                <li>Western Europe</li>
                                <li>Eastern Europe</li>
                                <li>Middle East</li>
                                <li>Asia</li>
                                <li>Africa</li>
                                <li>Pacific</li>
                                <li>North America & Caribbean</li>
                                <li>Central & South America</li>
                            </ul>
                            <div class="accordion-note">
                                <p><strong>Note:</strong> Upon your request, after an evaluation, we can consider providing coverage for a buyer not mentioned in the above list of countries.</p>
                            </div>
                        </div>
                    </div>
                </div>

            </div>
        </div>

    </div>
</section>

<?php include 'includes/footer.php'; ?>

<script>
    document.addEventListener("DOMContentLoaded", function() {
        const accordions = document.querySelectorAll(".accordion-header");

        // Open first accordion by default
        if (accordions.length > 0) {
            const firstAccordion = accordions[0];
            const firstPanel = firstAccordion.nextElementSibling;
            firstAccordion.classList.add("active");
            firstPanel.classList.add("open");
            firstPanel.style.maxHeight = firstPanel.scrollHeight + "px";
        }

        accordions.forEach(acc => {
            acc.addEventListener("click", function() {
                // Close all panels
                accordions.forEach(otherAcc => {
                    if (otherAcc !== this) {
                        otherAcc.classList.remove("active");
                        const otherPanel = otherAcc.nextElementSibling;
                        otherPanel.style.maxHeight = null;
                        otherPanel.classList.remove("open");
                    }
                });

                // Toggle current
                this.classList.toggle("active");
                const panel = this.nextElementSibling;
                if (panel.style.maxHeight) {
                    panel.style.maxHeight = null;
                    panel.classList.remove("open");
                } else {
                    panel.style.maxHeight = panel.scrollHeight + "px";
                    panel.classList.add("open");
                }
            });
        });
    });
</script>