<?php 
    include 'includes/header.php'; 
?>

<link rel="stylesheet" href="assets/css/who-we-are.css">

<section class="page-hero">
    <div class="overlay"></div>
    <div class="container">
        <h1>Who We Are</h1>
        <nav class="breadcrumb">
            <a href="index.php">Home</a>
            <span>&gt;</span>
            <span style="color: #d1b24a;">Who We Are</span>
        </nav>
    </div>
</section>

<!-- Welcome Section -->
<section class="welcome-section"  data-aos="fade-up"  data-aos-duration="1000">
    <div class="container">
        <div class="welcome-content">
            <h4>Who We Are</h4>
            <h2>Sri Lanka Export Credit Insurance Corporation (SLECIC)</h2>
            <div class="gold-divider"></div>
            <p>SLECIC is an enterprise established by the Sri Lanka Export Credit Insurance Act No: 15 of 1978 and commenced operations on 08th February 1979.</p>
            <p>The Corporation is a statutory body that falls under the purview of Ministry of Finance, Planning and Economic Development.</p>
            <p>SLECIC is a member of the International Union of Credit & Investment Insurers (The Berne Union).</p>
            <!-- <a href="#" class="btn-gold">Learn More</a> -->
        </div>
        <div class="welcome-image">
            <img src="assets/images/about/logo-inner.jpg" alt="SLECIC Team">
        </div>
    </div>
</section>

<!-- Vision Section -->
<section class="vision-section" data-aos="fade-right" data-aos-duration="1000">
    <div class="container">
        <div>
            <h2>Our Vision</h2>
            <p>Strive to fuel economic growth through International Trade by promoting and protection in the global market</p>
        </div>
        <div>
            <img src="assets/images/about/vision.png" alt="Our Vision">
        </div>
    </div>
</section>

<!-- Mission Section -->
<section class="mission-section" data-aos="fade-left" data-aos-duration="1000">
    <div class="container">
        <div class="mission-image">
            <img src="assets/images/about/mission.png" alt="Our Mission">
        </div>
        <div class="mission-content">
            <h2>Our Mission</h2>
            <p>We are in the business of providing protection, support and information for exporters, banks and other financial institutions and importers. In search of excellence in offering – personalized customer services</p>
        </div>
    </div>
</section>

<!-- Objectives Section -->
<section class="objectives-section">
    <div class="container" data-aos="fade-up" data-aos-duration="1000">
        <h2>Our Main Objectives</h2>
        <div class="objectives-grid">
            <div class="objective-item" data-aos="flip-left" data-aos-duration="1000">
                <div class="objective-icon">
                    <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round" d="M9 12h3.75M9 15h3.75M9 18h3.75m3 .75H18a2.25 2.25 0 0 0 2.25-2.25V6.108c0-1.135-.845-2.098-1.976-2.192a48.424 48.424 0 0 0-1.123-.08m-5.801 0c-.065.21-.1.433-.1.664 0 .414.336.75.75.75h4.5a.75.75 0 0 0 .75-.75 2.25 2.25 0 0 0-.1-.664m-5.8 0A2.251 2.251 0 0 1 13.5 2.25H15c1.012 0 1.867.668 2.15 1.586m-5.8 0c-.376.023-.75.05-1.124.08C9.095 4.01 8.25 4.973 8.25 6.108V8.25m0 0H4.875c-.621 0-1.125.504-1.125 1.125v11.25c0 .621.504 1.125 1.125 1.125h9.75c.621 0 1.125-.504 1.125-1.125V9.375c0-.621-.504-1.125-1.125-1.125H8.25ZM6.75 12h.008v.008H6.75V12Zm0 3h.008v.008H6.75V15Zm0 3h.008v.008H6.75V18Z" />
                    </svg>
                </div>
                <p>To issue insurance policies to exporters of goods and services against non-receipt or delayed receipt of payments resulting from commercial and non-commercial risks</p>
            </div>
            <div class="objective-item" data-aos="flip-left" data-aos-duration="1000">
                <div class="objective-icon">
                    <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round" d="M12 21v-8.25M15.75 21v-8.25M8.25 21v-8.25M3 9l9-6 9 6m-1.5 12V10.332A48.36 48.36 0 0 0 12 9.75c-2.551 0-5.056.2-7.5.582V21M3 21h18M12 6.75h.008v.008H12V6.75Z" />
                    </svg>
                </div>
                <p>To issue guarantees to banks and other financial institutions to facilitate the granting of pre-shipment and post-shipment finance</p>
            </div>
            <div class="objective-item" data-aos="flip-left" data-aos-duration="1000">
                <div class="objective-icon">
                    <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round" d="M12 21a9.004 9.004 0 0 0 8.716-6.747M12 21a9.004 9.004 0 0 1-8.716-6.747M12 21c2.485 0 4.5-4.03 4.5-9S14.485 3 12 3m0 18c-2.485 0-4.5-4.03-4.5-9S9.515 3 12 3m0 0a8.997 8.997 0 0 1 7.843 4.582M12 3a8.997 8.997 0 0 0-7.843 4.582m15.686 0A11.953 11.953 0 0 1 12 10.5c-2.998 0-5.74-1.1-7.843-2.918m15.686 0A8.959 8.959 0 0 1 21 12c0 .778-.099 1.533-.284 2.253m0 0A17.919 17.919 0 0 1 12 16.5c-3.162 0-6.133-.815-8.716-2.247m0 0A9.015 9.015 0 0 1 3 12c0-1.605.42-3.113 1.157-4.418" />
                    </svg>
                </div>
                <p>To issue guarantees to persons or institutions abroad in connection with goods exported by any person or institution from Sri Lanka or for the due performance of any services to be rendered to such persons or institutions within or outside Sri Lanka</p>
            </div>
        </div>
    </div>
</section>

<?php include 'includes/footer.php'; ?>