<?php 
    include 'includes/header.php'; 
?>

<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
<link rel="stylesheet" href="assets/css/video.css">

<section class="page-hero">
    <div class="overlay"></div>
    <div class="container">
        <h1>Media Gallery</h1>
        <nav class="breadcrumb">
            <a href="index.php">Home</a>
            <span>&gt;</span>
            <span style="color: #d1b24a;">Videos</span>
        </nav>
    </div>
</section>

<section class="media-section">
    <div class="container">
        <div class="section-header">
            <h2 class="section-title">Latest Videos</h2>
            <div class="title-line"></div>
        </div>

        <div class="video-grid" id="videoGrid">
            
            <div class="video-card" data-title="SLECIC Corporate Journey 2024">
                <div class="video-wrapper">
                    <iframe width="560" height="315" src="https://www.youtube.com/embed/OmoCvnJJ0CI?si=TQCPBtgJPyt9laj_" title="SLECIC Corporate Journey 2024" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share" referrerpolicy="strict-origin-when-cross-origin" allowfullscreen></iframe>
                </div>
                <div class="video-body">
                    <span class="video-category">News</span>
                    <h3 class="video-title">රටේ ඉදිරි ආර්ථික තත්ත්වය | දවස | Dawasa | 15.08.2025</h3>
                    <div class="video-meta">
                        <span><i class="fa-regular fa-calendar"></i> 15.08.2025</span>
                        <span><i class="fa-regular fa-clock"></i> 25:40 mins</span>
                    </div>
                </div>
            </div>

            <div class="video-card" data-title="Export Performance & Credit Insurance">
                <div class="video-wrapper">
                <iframe width="560" height="315" src="https://www.youtube.com/embed/S-O6l97qg5M?si=9_CUmYZ_SOb_4fo8" title="YouTube video player" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share" referrerpolicy="strict-origin-when-cross-origin" allowfullscreen></iframe>
                </div>
                <div class="video-body">
                    <span class="video-category">News</span>
                    <h3 class="video-title">Rupavahini Sinhala News 08.00 pm | රූපවාහිනී 08.00 සිංහල ප්‍රවෘත්ති</h3>
                    <div class="video-meta">
                        <span><i class="fa-regular fa-calendar"></i> 2024-12-21</span>
                        <span><i class="fa-regular fa-clock"></i> 32:36 mins</span>
                    </div>
                </div>
            </div>

            <div class="video-card" data-title="Rupavahini News Feature">
                <div class="video-wrapper">
                <iframe width="560" height="315" src="https://www.youtube.com/embed/3SrLcWYiqcU?si=G0kvSlxdB8JLnuZm" title="YouTube video player" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share" referrerpolicy="strict-origin-when-cross-origin" allowfullscreen></iframe>
                </div>
                <div class="video-body">
                    <span class="video-category">News</span>
                    <h3 class="video-title">කරට කර | Karata Kara | 2024 -12 -09 | Rupavahini Live | Sri Lanka Rupavahini</h3>
                    <div class="video-meta">
                        <span><i class="fa-regular fa-calendar"></i> 2024 -12 -09</span>
                        <span><i class="fa-regular fa-clock"></i> 2:11:23 mins</span>
                    </div>
                </div>
            </div>

            <div class="video-card" data-title="Boost Your Sri Lankan Export">
                <div class="video-wrapper">
                    <iframe width="560" height="315" src="https://www.youtube.com/embed/b7HJ4W5J82s?si=iJRV9bGURXn6zMOI" title="YouTube video player" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share" referrerpolicy="strict-origin-when-cross-origin" allowfullscreen></iframe>
                </div>
                <div class="video-body">
                    <span class="video-category">News</span>
                    <h3 class="video-title">රට ගොඩනැංවීමට අලුත් කැබිනට් මණ්ඩලය සමත් වෙයිද? |Prof. Aruna Shanthaarchchi | Artha Tharka</h3>
                    <div class="video-meta">
                        <span><i class="fa-regular fa-calendar"></i> 05 Sep 2024</span>
                        <span><i class="fa-regular fa-clock"></i> 27:56 mins</span>
                    </div>
                </div>
            </div>

            <div class="video-card" data-title="Boost Your Sri Lankan Export">
                <div class="video-wrapper">
                <iframe width="560" height="315" src="https://www.youtube.com/embed/GR9PnGF94vI?si=EyvHiPRTEUDjvydt" title="YouTube video player" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share" referrerpolicy="strict-origin-when-cross-origin" allowfullscreen></iframe>
                </div>
                <div class="video-body">
                    <span class="video-category">News</span>
                    <h3 class="video-title">Boost Your Sri Lankan Exports with Confidence! SLECIC: Your Export Credit Insurance Partner</h3>
                    <div class="video-meta">
                        <span><i class="fa-regular fa-calendar"></i> 05 Sep 2024</span>
                        <span><i class="fa-regular fa-clock"></i> 1:26 mins</span>
                    </div>
                </div>
            </div>

            <div class="video-card" data-title="Boost Your Sri Lankan Export">
                <div class="video-wrapper">
                  <iframe width="560" height="315" src="https://www.youtube.com/embed/ZQbwhsrGZAE?si=lWW7ic_Govs1mVDj" title="YouTube video player" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share" referrerpolicy="strict-origin-when-cross-origin" allowfullscreen></iframe>
                </div>
                <div class="video-body">
                    <span class="video-category">News</span>
                    <h3 class="video-title"> SLECIC - Export Performance Guarantee</h3>
                    <div class="video-meta">
                        <span><i class="fa-regular fa-calendar"></i> 05 Sep 2024</span>
                        <span><i class="fa-regular fa-clock"></i> 5:19 mins</span>
                    </div>
                </div>
            </div>

            <div class="video-card" data-title="Boost Your Sri Lankan Export">
                <div class="video-wrapper">
                <iframe width="560" height="315" src="https://www.youtube.com/embed/Mj0l2gwZ28Y?si=RjcLThAomq11KoAi" title="YouTube video player" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share" referrerpolicy="strict-origin-when-cross-origin" allowfullscreen></iframe>
                </div>
                <div class="video-body">
                    <span class="video-category">News</span>
                    <h3 class="video-title"> SLECIC APARA </h3>
                    <div class="video-meta">
                        <span><i class="fa-regular fa-calendar"></i> 05 Sep 2024</span>
                        <span><i class="fa-regular fa-clock"></i> 0:30 mins</span>
                    </div>
                </div>
            </div>

            <div class="video-card" data-title="Boost Your Sri Lankan Export">
                <div class="video-wrapper">
                <iframe width="560" height="315" src="https://www.youtube.com/embed/pXiOwpGcJow?si=A80HPC3VnMNzjXvM" title="YouTube video player" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share" referrerpolicy="strict-origin-when-cross-origin" allowfullscreen></iframe>
                </div>
                <div class="video-body">
                    <span class="video-category">News</span>
                    <h3 class="video-title">Sri Lanka Export Credit Insurance Corporation </h3>
                    <div class="video-meta">
                        <span><i class="fa-regular fa-calendar"></i> 05 Sep 2024</span>
                        <span><i class="fa-regular fa-clock"></i> 1:57 mins</span>
                    </div>
                </div>
            </div>

        </div>

        <div class="video-pagination" id="videoPagination"></div>

    </div>
</section>

<script>
document.addEventListener('DOMContentLoaded', function () {
    const ITEMS_PER_PAGE = 8;
    const grid = document.getElementById('videoGrid');
    const cards = Array.from(grid.querySelectorAll('.video-card'));
    const paginationContainer = document.getElementById('videoPagination');
    if (!grid || cards.length === 0 || !paginationContainer) return;

    const totalPages = Math.ceil(cards.length / ITEMS_PER_PAGE);
    let currentPage = 1;

    function renderPage(page) {
        if (page < 1) page = 1;
        if (page > totalPages) page = totalPages;
        currentPage = page;

        const start = (currentPage - 1) * ITEMS_PER_PAGE;
        const end = start + ITEMS_PER_PAGE;

        cards.forEach((card, index) => {
            card.style.display = (index >= start && index < end) ? '' : 'none';
        });

        updatePaginationUI();
    }

    function updatePaginationUI() {
        const buttons = paginationContainer.querySelectorAll('.video-page-btn');
        buttons.forEach(btn => {
            const page = parseInt(btn.dataset.page, 10);
            if (page === currentPage) {
                btn.classList.add('active');
            } else {
                btn.classList.remove('active');
            }
        });

        const prevBtn = paginationContainer.querySelector('.video-page-prev');
        const nextBtn = paginationContainer.querySelector('.video-page-next');
        if (prevBtn) prevBtn.disabled = currentPage === 1;
        if (nextBtn) nextBtn.disabled = currentPage === totalPages;
    }

    function buildPagination() {
        const frag = document.createDocumentFragment();

        const prev = document.createElement('button');
        prev.type = 'button';
        prev.textContent = 'Prev';
        prev.className = 'video-page-btn video-page-prev';
        prev.addEventListener('click', () => renderPage(currentPage - 1));
        frag.appendChild(prev);

        for (let i = 1; i <= totalPages; i++) {
            const btn = document.createElement('button');
            btn.type = 'button';
            btn.textContent = String(i);
            btn.className = 'video-page-btn';
            btn.dataset.page = String(i);
            btn.addEventListener('click', () => renderPage(i));
            frag.appendChild(btn);
        }

        const next = document.createElement('button');
        next.type = 'button';
        next.textContent = 'Next';
        next.className = 'video-page-btn video-page-next';
        next.addEventListener('click', () => renderPage(currentPage + 1));
        frag.appendChild(next);

        paginationContainer.innerHTML = '';
        paginationContainer.appendChild(frag);
    }

    buildPagination();
    renderPage(1);
});
</script>

<?php include 'includes/footer.php'; ?>