<?php
include 'includes/header.php';
?>

<link rel="stylesheet" href="assets/css/faq.css">

<section class="page-hero">
    <div class="overlay"></div>
    <div class="container">
        <h1>Frequently Asked Questions</h1>
        <nav class="breadcrumb">
            <a href="index.php">Home</a>
            <span>&gt;</span>
            <span style="color: #d1b24a;">FAQ</span>
        </nav>
    </div>
</section>

<section class="faq-section">
    <div class="container">
        
        <div class="section-header" data-aos="fade-up" data-aos-duration="1000">
            <p class="section-subtitle">Help Center</p>
            <h2>Common Questions</h2>
        </div>

        <div class="faq-container">
            
            <!-- FAQ Item 1 -->
            <div class="faq-item" data-aos="fade-up" data-aos-duration="1200">
                <button class="faq-question">
                    <span>What is Credit Insurance?</span>
                    <i class="fas fa-chevron-down"></i>
                </button>
                <div class="faq-answer">
                    <p>It is an insurance cover which provides protection to your business against Non-receipt or delayed-receipt of payments due to Commercial & Political risks associated with dispatching goods or rending services.</p>
                </div>
            </div>

            <!-- FAQ Item 2 -->
            <div class="faq-item" data-aos="fade-up" data-aos-duration="1200">
                <button class="faq-question">
                    <span>I have a Seller’s Risk Insurance Policy plus a valid Credit Limit for the buyer to whom I am planning to send the shipment. Am I protected?</span>
                    <i class="fas fa-chevron-down"></i>
                </button>
                <div class="faq-answer">
                    <p>Yes, provided you have sent the relevant premium on time along with the declaration on each shipment.</p>
                </div>
            </div>

            <!-- FAQ Item 3 -->
            <div class="faq-item" data-aos="fade-up" data-aos-duration="1200">
                <button class="faq-question">
                    <span>If the payment is not received on or before the due date what can I do?</span>
                    <i class="fas fa-chevron-down"></i>
                </button>
                <div class="faq-answer">
                    <p>You may at your own discretion grant extensions up to 30 days of the Due Date at or immediately prior to the Due Date and shall inform us of such extension in writing within 14 days thereof. Any extension beyond 30 days need our approval.</p>
                </div>
            </div>

            <!-- FAQ Item 4 -->
            <div class="faq-item" data-aos="fade-up" data-aos-duration="1200">
                <button class="faq-question">
                    <span>When should I submit Overdue Notification?</span>
                    <i class="fas fa-chevron-down"></i>
                </button>
                <div class="faq-answer">
                    <p>In the event the buyer fails to pay the Gross Invoice Value on or before the due date, the exporter can submit us a Declaration of Overdue Payments (in the prescribed form) within 30 days of the due date.</p>
                </div>
            </div>

            <!-- FAQ Item 5 -->
            <div class="faq-item" data-aos="fade-up" data-aos-duration="1200">
                <button class="faq-question">
                    <span>When can I make a claim?</span>
                    <i class="fas fa-chevron-down"></i>
                </button>
                <div class="faq-answer">
                    <p>A policy pays an agreed percentage of any invoice or outstanding balance that remains unpaid as a result of Non-receipt or delayed receipt of payments due to Commercial or Non-commercial risks.</p>
                    <p>Within 12 months of the Due Date you can make a claim in the prescribed form. Such claims should be lodged in the following manner. Where the loss is due to:</p>
                    <ul>
                        <li>Insolvency of the Buyer: <br>Immediately after the date of Insolvency or Four months after the Due Date whichever is earlier.</li>
                        <li>Protracted Default: <br>After four months from the Due Date.</li>
                        <li>Non Acceptance (Repudiation of Contract): <br>Immediately after the resale or after one month of the Due Date.</li>
                        <li>Non Commercial Risks: <br>After four months of the Due Date.</li>
                    </ul>
                </div>
            </div>

            <!-- FAQ Item 6 -->
            <div class="faq-item" data-aos="fade-up" data-aos-duration="1200">
                <button class="faq-question">
                    <span>Is there anything I can do that would "spoil" a claim?</span>
                    <i class="fas fa-chevron-down"></i>
                </button>
                <div class="faq-answer">
                    <p>The most common reasons for claims being unsuccessful is the failure to inform the Insurer of the non-payment within the specified timescale. As with any insurance, you are expected to be honest and disclose all relevant information.</p>
                </div>
            </div>

            <!-- FAQ Item 7 -->
            <div class="faq-item" data-aos="fade-up" data-aos-duration="1200">
                <button class="faq-question">
                    <span>What is the level of indemnity?</span>
                    <i class="fas fa-chevron-down"></i>
                </button>
                <div class="faq-answer">
                    <p>The level of indemnity typically ranges from 60%-90%; however, the level varies depending on the policy you select, your credit management experience, your accounts receivable portfolio, terms of payment and your premium target.</p>
                </div>
            </div>

            <!-- FAQ Item 8 -->
            <div class="faq-item" data-aos="fade-up" data-aos-duration="1200">
                <button class="faq-question">
                    <span>If I incur a loss, how soon a claim will be paid?</span>
                    <i class="fas fa-chevron-down"></i>
                </button>
                <div class="faq-answer">
                    <p>Generally, the claim will be paid within 4 to 6 weeks provided all the required documents are submitted.</p>
                </div>
            </div>

            <!-- FAQ Item 9 -->
            <div class="faq-item" data-aos="fade-up" data-aos-duration="1200">
                <button class="faq-question">
                    <span>Can exporters of services obtain credit risk cover under the Seller's Risk?</span>
                    <i class="fas fa-chevron-down"></i>
                </button>
                <div class="faq-answer">
                    <p>Yes. Under the Seller's Risk for Services, exporters of services such as software, construction etc. can cover the credit risks of the services provided.</p>
                </div>
            </div>

            <!-- FAQ Item 10 -->
            <div class="faq-item" data-aos="fade-up" data-aos-duration="1200">
                <button class="faq-question">
                    <span>What are the main benefits of credit insurance?</span>
                    <i class="fas fa-chevron-down"></i>
                </button>
                <div class="faq-answer">
                    <p>The main benefit is your right to lodge a claim and reduce the risk involved in Export transactions. SLECIC credit insurance can reduce the burden of bad debts whilst retaining profitability & providing the cornerstone to secure growth. SLECIC often works to create a comfort zone by choosing to secure the degree of uncertainty present in everything including financial wellbeing of your buyer.</p>
                    <p>Followings are the other benefits:</p>
                    <ul>
                        <li>Higher coverage.</li>
                        <li>Policy is treated as a collateral security by commercial banks.</li>
                        <li>You are able to enter into new markets and find new buyers abroad.</li>
                        <li>We evaluate and monitor the financial situation of your buyer.</li>
                        <li>The credit rating of your business is enhanced in the eyes of bankers, suppliers and other business partners.</li>
                        <li>It is affordable.</li>
                        <li>It is customized for your needs.</li>
                    </ul>
                </div>
            </div>

            <!-- FAQ Item 11 -->
            <div class="faq-item" data-aos="fade-up" data-aos-duration="1200">
                <button class="faq-question">
                    <span>Is Credit Insurance for large corporates only?</span>
                    <i class="fas fa-chevron-down"></i>
                </button>
                <div class="faq-answer">
                    <p>Regardless of the size or sector of the business, all business entities are facing Commercial and Political risks when they are dealing with their buyers on Credit terms. Whether the payment term is O/A, D/A, D/P, CAD, Copy Documents or even L/C the risk is there. Therefore Companies of all sizes, from SMEs to the largest multinational companies use SLECIC Credit Insurance.</p>
                </div>
            </div>

            <!-- FAQ Item 12 -->
            <div class="faq-item" data-aos="fade-up" data-aos-duration="1200">
                <button class="faq-question">
                    <span>What are the terms of payment in international trade and how does it relate to the risks?</span>
                    <i class="fas fa-chevron-down"></i>
                </button>
                <div class="faq-answer">
                    <p><strong>Letters of Credit (L/C)</strong><br>
                    An undertaking by a bank issuing the Letter of Credit (the Issuing Bank) to pay the beneficiary of the Credit a stated amount on submission of stipulated documents in conformity with the terms and conditions of the Letter of Credit.</p>
                    
                    <p><strong>Documents against Payment (D/P)</strong><br>
                    The process of delivering documents required by a buyer to take possession of the goods after receiving payment for drafts by the bank who is authorized to handle the documents.</p>
                    
                    <p><strong>Cash against Documents (CAD)</strong><br>
                    A process similar to D/P with payment being made for documents without the involvement of a draft.</p>
                    
                    <p><strong>Documents against Acceptance (D/A)</strong><br>
                    The process of delivering documents required by a buyer to take possession of the goods after obtaining the acceptance of drafts by the Bank who is authorized to handle the documents.</p>
                    
                    <p><strong>Open Account (O/A)</strong><br>
                    The procedure where a seller extends a period of credit to a buyer to make payment for goods not supported by any specific document of indebtedness other than the contract of sale.</p>
                </div>
            </div>

            <!-- FAQ Item 13 -->
            <div class="faq-item" data-aos="fade-up" data-aos-duration="1200">
                <button class="faq-question">
                    <span>Why should I consider export credit insurance?</span>
                    <i class="fas fa-chevron-down"></i>
                </button>
                <div class="faq-answer">
                    <p>Around 80% of international trade transactions occur on credit terms. On average, 40% of a company's assets are in the form of trade debts. Sometimes the figure is far higher. It is very difficult for a company to predict which client will default on payment. Close to 50% of all payment defaults arise from buyers with whom stable and long-term trade relationships have been established.</p>
                    <p>The cost to a business of non-payment can be considerable. For example, if a company's profit margin is 5% and one of its customer defaults on a debt of Rs.200,000, the company will have to achieve additional sales of Rs.4,000,000 to make up for the lost profits. More importantly, the lost cash flow could be devastating. Non-payment weakens your company and lowers its investment capacity. An export credit insurance policy helps in the management of your accounts receivables and compensates you in the event of non-payment.</p>
                </div>
            </div>

            <!-- FAQ Item 14 -->
            <div class="faq-item" data-aos="fade-up" data-aos-duration="1200">
                <button class="faq-question">
                    <span>What is a Credit Limit?</span>
                    <i class="fas fa-chevron-down"></i>
                </button>
                <div class="faq-answer">
                    <p>Maximum amount upto which SLECIC accepts liability on a buyer. Without a Credit Limit, losses on account of protracted default, non acceptance of goods and insolvency of the buyer will not be covered.</p>
                </div>
            </div>

            <!-- FAQ Item 15 -->
            <div class="faq-item" data-aos="fade-up" data-aos-duration="1200">
                <button class="faq-question">
                    <span>How to get a Credit Limit?</span>
                    <i class="fas fa-chevron-down"></i>
                </button>
                <div class="faq-answer">
                    <p>Apply in Form 502 along with applicable Credit Limit Evaluation Fees. It takes 04-14 working days (excluding all public holidays and weekends) to do the buyer evaluation.</p>
                    <p>You are advised to make the Credit Limit application at the time of negotiation with the buyer. Please provide us with any additional information that you have on the buyer in order to expedite the process.</p>
                </div>
            </div>

            <!-- FAQ Item 16 -->
            <div class="faq-item" data-aos="fade-up" data-aos-duration="1200">
                <button class="faq-question">
                    <span>What to do if a Credit Limit is insufficient?</span>
                    <i class="fas fa-chevron-down"></i>
                </button>
                <div class="faq-answer">
                    <p>Apply for an enhancement in Form No. 502A giving us the buyer reference.</p>
                </div>
            </div>

            <!-- FAQ Item 17 -->
            <div class="faq-item" data-aos="fade-up" data-aos-duration="1200">
                <button class="faq-question">
                    <span>How long is a Credit Limit valid?</span>
                    <i class="fas fa-chevron-down"></i>
                </button>
                <div class="faq-answer">
                    <p>Credit Limit is a revolving limit and hence it is valid as long as your policy is in force provided you continuously declare shipments. If shipments are not declared for a consecutive period of 12 months, the Credit Limit automatically gets cancelled.</p>
                </div>
            </div>

        </div>
    </div>
</section>

<script>
    // FAQ Accordion Toggle
    document.querySelectorAll('.faq-question').forEach(button => {
        button.addEventListener('click', () => {
            const faqItem = button.parentElement;
            const isActive = faqItem.classList.contains('active');
            
            // Close all other items
            document.querySelectorAll('.faq-item').forEach(item => {
                item.classList.remove('active');
            });
            
            // Toggle current item
            if (!isActive) {
                faqItem.classList.add('active');
            }
        });
    });
</script>

<?php include 'includes/footer.php'; ?>