<?php 
    include 'db_connect.php'; 
    include 'header.php'; 
?>

<section class="page-hero" style="height: 40vh; background: linear-gradient(rgba(42, 10, 46, 0.185), rgba(42, 10, 46, 0.185)), url('images/judge-s-gavel-table-court-room-closeup-concept-justice-law-generative-ai.jpg') no-repeat center center/cover;">
    <div class="container">
        <h1>Ceremonial Speeches</h1>
        <p>Addresses and orations delivered at ceremonial sittings of the High Court.</p>
    </div>
</section>

<section class="speech-section reveal">
    <div class="speech-container">
        
        <div class="speech-header">
            <h2 class="speech-title">Ceremonial speech of the <span class="fancy-text">Judges</span></h2>
            <div class="gold-divider center-divider"></div>
            
            <p class="speech-meta">
                <strong>Ceremonial Sitting Speech By:</strong> Hon. President of the Bar Association of Sri Lanka<br>
                <strong>Venue:</strong> Superior Courts Complex, Colombo 12<br>
                <strong>Date:</strong> 12th January 2025
            </p>
        </div>

        <div class="speech-body">
            <p><strong>Hon. Attorney General, President of the Bar Association of Sri Lanka,</strong></p>

            <p>I thank you for the kind words of appreciation and recognition spoken about me. I am truly honored and encouraged by your sentiments.</p>

            <p>My ascent to one of the most exalted positions in the judicial hierarchy was not predestined but was woven primarily by my strong desire to continue to serve the beloved motherland which I hold so much.</p>
            
            <p>On this solemn occasion, in the presence of a gathering of legal luminaries, I wish to pledge that I will serve our country to the best of my ability and judicial conscience.</p>

            <p>Being a member of a degree of an institution with the seal of justice is a rare privilege, and as such, I pledge to extend fullest, selflessly, and without reserve to contribute back to our constitutional democracy. In that spirit, I share a few reflections on the moral and institutional framework within which we serve.</p>

            <p>Let me begin with a hallmark of the very foundation of judicial ethics: the <strong>Independence of the Judiciary</strong>.</p>

            <p>In a constitutional democracy such as ours, the courts act as the final bulwark of the rule of law. The strength of the judiciary lies in public confidence. Public confidence is not bestowed; it must be earned. And it is earned when justice is not only done but is manifestly and undoubtedly seen to be done.</p>

            <blockquote>
                "Justice is not a cloistered virtue: she must be allowed to suffer the scrutiny and respectful, even though outspoken, comments of ordinary men."
            </blockquote>

            <p>As we navigate the complexities of the modern legal landscape, let us remember that our duty is not merely to interpret the law, but to uphold the values of fairness, equity, and integrity that form the bedrock of our society. The High Court, as a court of first instance for serious crimes and an appellate court for civil matters, plays a pivotal role in this endeavor.</p>

            <p>I wish to express my sincere gratitude to my family, my teachers, and my colleagues who have supported me throughout this journey. It is their unwavering belief in me that has brought me to this seat today.</p>

            <p>Thank you.</p>
        </div>

        <div style="text-align: center; margin-top: 50px;">
            <a href="#" class="btn-gold"><i class="fas fa-file-pdf"></i> Download Full Speech (PDF)</a>
        </div>

    </div>
</section>

<script>
    window.addEventListener('scroll', function() {
        var reveals = document.querySelectorAll('.reveal');
        for(var i = 0; i < reveals.length; i++){
            var windowheight = window.innerHeight;
            var revealtop = reveals[i].getBoundingClientRect().top;
            var revealpoint = 150;
            if(revealtop < windowheight - revealpoint){
                reveals[i].classList.add('active');
            }
        }
    });
</script>

<?php include 'footer.php'; ?>